/*
 * Copyright (C) 2019 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.eap;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class EapSessionConfig {

EapSessionConfig() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public byte[] getEapIdentity() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.net.eap.EapSessionConfig.EapSimConfig getEapSimConfig() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.net.eap.EapSessionConfig.EapAkaConfig getEapAkaConfig() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.net.eap.EapSessionConfig.EapAkaPrimeConfig getEapAkaPrimeConfig() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.net.eap.EapSessionConfig.EapMsChapV2Config getEapMsChapV2onfig() { throw new RuntimeException("Stub!"); }
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.eap.EapSessionConfig.Builder setEapIdentity(@android.annotation.NonNull byte[] eapIdentity) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.eap.EapSessionConfig.Builder setEapSimConfig(int subId, int apptype) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.eap.EapSessionConfig.Builder setEapAkaConfig(int subId, int apptype) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.eap.EapSessionConfig.Builder setEapAkaPrimeConfig(int subId, int apptype, @android.annotation.NonNull java.lang.String networkName, boolean allowMismatchedNetworkNames) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.eap.EapSessionConfig.Builder setEapMsChapV2Config(@android.annotation.NonNull java.lang.String username, @android.annotation.NonNull java.lang.String password) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.eap.EapSessionConfig build() { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class EapAkaConfig extends android.net.eap.EapSessionConfig.EapUiccConfig {

EapAkaConfig() { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class EapAkaPrimeConfig extends android.net.eap.EapSessionConfig.EapAkaConfig {

EapAkaPrimeConfig() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String getNetworkName() { throw new RuntimeException("Stub!"); }

public boolean allowsMismatchedNetworkNames() { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract static class EapMethodConfig {

EapMethodConfig() { throw new RuntimeException("Stub!"); }

public int getMethodType() { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class EapMsChapV2Config extends android.net.eap.EapSessionConfig.EapMethodConfig {

EapMsChapV2Config() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String getUsername() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String getPassword() { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class EapSimConfig extends android.net.eap.EapSessionConfig.EapUiccConfig {

EapSimConfig() { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract static class EapUiccConfig extends android.net.eap.EapSessionConfig.EapMethodConfig {

private EapUiccConfig() { throw new RuntimeException("Stub!"); }

public int getSubId() { throw new RuntimeException("Stub!"); }

public int getAppType() { throw new RuntimeException("Stub!"); }
}

}

