/*
 * Copyright (C) 2019 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.ipsec.ike;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class IkeSessionParams {

private IkeSessionParams() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String getServerHostname() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.Network getNetwork() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.net.ipsec.ike.IkeSaProposal> getSaProposals() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.ipsec.ike.IkeIdentification getLocalIdentification() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.ipsec.ike.IkeIdentification getRemoteIdentification() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.ipsec.ike.IkeSessionParams.IkeAuthConfig getLocalAuthConfig() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.ipsec.ike.IkeSessionParams.IkeAuthConfig getRemoteAuthConfig() { throw new RuntimeException("Stub!"); }

public int getHardLifetimeSeconds() { throw new RuntimeException("Stub!"); }

public int getSoftLifetimeSeconds() { throw new RuntimeException("Stub!"); }

public int getDpdDelaySeconds() { throw new RuntimeException("Stub!"); }

public int[] getRetransmissionTimeoutsMillis() { throw new RuntimeException("Stub!"); }

public boolean hasIkeOption(int ikeOption) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.net.ipsec.ike.IkeSessionParams.IkeConfigRequest> getConfigurationRequests() { throw new RuntimeException("Stub!"); }

public static final int IKE_OPTION_ACCEPT_ANY_REMOTE_ID = 0; // 0x0

public static final int IKE_OPTION_EAP_ONLY_AUTH = 1; // 0x1
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder(@android.annotation.NonNull android.content.Context context) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.ipsec.ike.IkeSessionParams.Builder setServerHostname(@android.annotation.NonNull java.lang.String serverHostname) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.ipsec.ike.IkeSessionParams.Builder setNetwork(@android.annotation.NonNull android.net.Network network) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.ipsec.ike.IkeSessionParams.Builder setLocalIdentification(@android.annotation.NonNull android.net.ipsec.ike.IkeIdentification identification) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.ipsec.ike.IkeSessionParams.Builder setRemoteIdentification(@android.annotation.NonNull android.net.ipsec.ike.IkeIdentification identification) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.ipsec.ike.IkeSessionParams.Builder addSaProposal(@android.annotation.NonNull android.net.ipsec.ike.IkeSaProposal proposal) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.ipsec.ike.IkeSessionParams.Builder setAuthPsk(@android.annotation.NonNull byte[] sharedKey) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.ipsec.ike.IkeSessionParams.Builder setAuthEap(@android.annotation.Nullable java.security.cert.X509Certificate serverCaCert, @android.annotation.NonNull android.net.eap.EapSessionConfig eapConfig) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.ipsec.ike.IkeSessionParams.Builder setAuthDigitalSignature(@android.annotation.Nullable java.security.cert.X509Certificate serverCaCert, @android.annotation.NonNull java.security.cert.X509Certificate clientEndCert, @android.annotation.NonNull java.security.PrivateKey clientPrivateKey) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.ipsec.ike.IkeSessionParams.Builder setAuthDigitalSignature(@android.annotation.Nullable java.security.cert.X509Certificate serverCaCert, @android.annotation.NonNull java.security.cert.X509Certificate clientEndCert, @android.annotation.NonNull java.util.List<java.security.cert.X509Certificate> clientIntermediateCerts, @android.annotation.NonNull java.security.PrivateKey clientPrivateKey) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.ipsec.ike.IkeSessionParams.Builder addPcscfServerRequest(@android.annotation.NonNull java.net.InetAddress address) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.ipsec.ike.IkeSessionParams.Builder addPcscfServerRequest(int addressFamily) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.ipsec.ike.IkeSessionParams.Builder setLifetimeSeconds(int hardLifetimeSeconds, int softLifetimeSeconds) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.ipsec.ike.IkeSessionParams.Builder setDpdDelaySeconds(int dpdDelaySeconds) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.ipsec.ike.IkeSessionParams.Builder setRetransmissionTimeoutsMillis(@android.annotation.NonNull int[] retransTimeoutMillisList) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.ipsec.ike.IkeSessionParams.Builder addIkeOption(int ikeOption) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.ipsec.ike.IkeSessionParams.Builder removeIkeOption(int ikeOption) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.ipsec.ike.IkeSessionParams build() { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface ConfigRequestIpv4PcscfServer extends android.net.ipsec.ike.IkeSessionParams.IkeConfigRequest {

@android.annotation.Nullable
public java.net.Inet4Address getAddress();
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface ConfigRequestIpv6PcscfServer extends android.net.ipsec.ike.IkeSessionParams.IkeConfigRequest {

@android.annotation.Nullable
public java.net.Inet6Address getAddress();
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract static class IkeAuthConfig {

IkeAuthConfig() { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class IkeAuthDigitalSignLocalConfig extends android.net.ipsec.ike.IkeSessionParams.IkeAuthConfig {

private IkeAuthDigitalSignLocalConfig() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.security.cert.X509Certificate getClientEndCertificate() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<java.security.cert.X509Certificate> getIntermediateCertificates() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.security.PrivateKey getPrivateKey() { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class IkeAuthDigitalSignRemoteConfig extends android.net.ipsec.ike.IkeSessionParams.IkeAuthConfig {

private IkeAuthDigitalSignRemoteConfig() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.security.cert.X509Certificate getRemoteCaCert() { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class IkeAuthEapConfig extends android.net.ipsec.ike.IkeSessionParams.IkeAuthConfig {

private IkeAuthEapConfig() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.eap.EapSessionConfig getEapConfig() { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class IkeAuthPskConfig extends android.net.ipsec.ike.IkeSessionParams.IkeAuthConfig {

private IkeAuthPskConfig() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public byte[] getPsk() { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface IkeConfigRequest {
}

}

