/*
 * Copyright (C) 2019 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.ipsec.ike;


/**
 * IkeSaProposal represents a proposed configuration to negotiate an IKE SA.
 *
 * <p>IkeSaProposal will contain cryptograhic algorithms and key generation materials for the
 * negotiation of an IKE SA.
 *
 * <p>User must provide at least one valid IkeSaProposal when they are creating a new IKE SA.
 *
 * @see <a href="https://tools.ietf.org/html/rfc7296#section-3.3">RFC 7296, Internet Key Exchange
 *     Protocol Version 2 (IKEv2)</a>
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class IkeSaProposal extends android.net.ipsec.ike.SaProposal {

IkeSaProposal() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * Gets all proposed Pseudorandom Functions
 *
 * @return A list of the IANA-defined IDs for the proposed Pseudorandom Functions

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<java.lang.Integer> getPseudorandomFunctions() { throw new RuntimeException("Stub!"); }

/**
 * Returns supported encryption algorithms for IKE SA proposal negotiation.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public static java.util.Set<java.lang.Integer> getSupportedEncryptionAlgorithms() { throw new RuntimeException("Stub!"); }

/**
 * Returns supported integrity algorithms for IKE SA proposal negotiation.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public static java.util.Set<java.lang.Integer> getSupportedIntegrityAlgorithms() { throw new RuntimeException("Stub!"); }

/**
 * Returns supported pseudorandom functions for IKE SA proposal negotiation.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public static java.util.Set<java.lang.Integer> getSupportedPseudorandomFunctions() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }
/**
 * This class is used to incrementally construct a IkeSaProposal. IkeSaProposal instances are
 * immutable once built.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Adds a Diffie-Hellman Group to the SA proposal being built.
 *
 * @param dhGroup to add to IkeSaProposal.
 * Value is {@link android.net.ipsec.ike.SaProposal#DH_GROUP_NONE}, {@link android.net.ipsec.ike.SaProposal#DH_GROUP_1024_BIT_MODP}, {@link android.net.ipsec.ike.SaProposal#DH_GROUP_1536_BIT_MODP}, {@link android.net.ipsec.ike.SaProposal#DH_GROUP_2048_BIT_MODP}, {@link android.net.ipsec.ike.SaProposal#DH_GROUP_3072_BIT_MODP}, {@link android.net.ipsec.ike.SaProposal#DH_GROUP_4096_BIT_MODP}, or {@link android.net.ipsec.ike.SaProposal#DH_GROUP_CURVE_25519}
 * @return Builder of IkeSaProposal.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.ipsec.ike.IkeSaProposal.Builder addDhGroup(int dhGroup) { throw new RuntimeException("Stub!"); }

/**
 * Adds an encryption algorithm with a specific key length to the SA proposal being built.
 *
 * @param algorithm encryption algorithm to add to IkeSaProposal.
 * Value is {@link android.net.ipsec.ike.SaProposal#ENCRYPTION_ALGORITHM_3DES}, {@link android.net.ipsec.ike.SaProposal#ENCRYPTION_ALGORITHM_AES_CBC}, {@link android.net.ipsec.ike.SaProposal#ENCRYPTION_ALGORITHM_AES_CTR}, {@link android.net.ipsec.ike.SaProposal#ENCRYPTION_ALGORITHM_AES_GCM_8}, {@link android.net.ipsec.ike.SaProposal#ENCRYPTION_ALGORITHM_AES_GCM_12}, {@link android.net.ipsec.ike.SaProposal#ENCRYPTION_ALGORITHM_AES_GCM_16}, or {@link android.net.ipsec.ike.SaProposal#ENCRYPTION_ALGORITHM_CHACHA20_POLY1305}
 * @param keyLength key length of algorithm. For algorithms that have fixed key length (e.g.
 *     3DES) only {@link android.net.ipsec.ike.SaProposal#KEY_LEN_UNUSED SaProposal.KEY_LEN_UNUSED} is allowed.
 * @return Builder of IkeSaProposal.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.ipsec.ike.IkeSaProposal.Builder addEncryptionAlgorithm(int algorithm, int keyLength) { throw new RuntimeException("Stub!"); }

/**
 * Adds an integrity algorithm to the SA proposal being built.
 *
 * @param algorithm integrity algorithm to add to IkeSaProposal.
 * Value is {@link android.net.ipsec.ike.SaProposal#INTEGRITY_ALGORITHM_NONE}, {@link android.net.ipsec.ike.SaProposal#INTEGRITY_ALGORITHM_HMAC_SHA1_96}, {@link android.net.ipsec.ike.SaProposal#INTEGRITY_ALGORITHM_AES_XCBC_96}, {@link android.net.ipsec.ike.SaProposal#INTEGRITY_ALGORITHM_AES_CMAC_96}, {@link android.net.ipsec.ike.SaProposal#INTEGRITY_ALGORITHM_HMAC_SHA2_256_128}, {@link android.net.ipsec.ike.SaProposal#INTEGRITY_ALGORITHM_HMAC_SHA2_384_192}, or {@link android.net.ipsec.ike.SaProposal#INTEGRITY_ALGORITHM_HMAC_SHA2_512_256}
 * @return Builder of IkeSaProposal.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.ipsec.ike.IkeSaProposal.Builder addIntegrityAlgorithm(int algorithm) { throw new RuntimeException("Stub!"); }

/**
 * Adds a pseudorandom function to the SA proposal being built.
 *
 * @param algorithm pseudorandom function to add to IkeSaProposal.
 * Value is {@link android.net.ipsec.ike.SaProposal#PSEUDORANDOM_FUNCTION_HMAC_SHA1}, {@link android.net.ipsec.ike.SaProposal#PSEUDORANDOM_FUNCTION_AES128_XCBC}, {@link android.net.ipsec.ike.SaProposal#PSEUDORANDOM_FUNCTION_SHA2_256}, {@link android.net.ipsec.ike.SaProposal#PSEUDORANDOM_FUNCTION_SHA2_384}, {@link android.net.ipsec.ike.SaProposal#PSEUDORANDOM_FUNCTION_SHA2_512}, or {@link android.net.ipsec.ike.SaProposal#PSEUDORANDOM_FUNCTION_AES128_CMAC}
 * @return Builder of IkeSaProposal.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.ipsec.ike.IkeSaProposal.Builder addPseudorandomFunction(int algorithm) { throw new RuntimeException("Stub!"); }

/**
 * Validates and builds the IkeSaProposal.
 *
 * @return the validated IkeSaProposal.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.ipsec.ike.IkeSaProposal build() { throw new RuntimeException("Stub!"); }
}

}

