/*
 * Copyright (C) 2019 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.ipsec.ike;


/**
 * TunnelModeChildSessionParams represents proposed configurations for negotiating a tunnel mode
 * Child Session.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class TunnelModeChildSessionParams extends android.net.ipsec.ike.ChildSessionParams {

TunnelModeChildSessionParams() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * Retrieves the list of Configuration Requests
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.net.ipsec.ike.TunnelModeChildSessionParams.TunnelModeChildConfigRequest> getConfigurationRequests() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }
/** This class can be used to incrementally construct a {@link android.net.ipsec.ike.TunnelModeChildSessionParams TunnelModeChildSessionParams}. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/** Create a Builder for negotiating a tunnel mode Child Session. */

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Construct Builder from the {@link android.net.ipsec.ike.TunnelModeChildSessionParams TunnelModeChildSessionParams} object.
 *
 * @param childParams the object this Builder will be constructed with.

 * This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull android.net.ipsec.ike.TunnelModeChildSessionParams childParams) { throw new RuntimeException("Stub!"); }

/**
 * Adds an Child SA proposal to the {@link android.net.ipsec.ike.TunnelModeChildSessionParams TunnelModeChildSessionParams} being built.
 *
 * @param proposal Child SA proposal.
 * This value cannot be {@code null}.
 * @return Builder this, to facilitate chaining.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.ipsec.ike.TunnelModeChildSessionParams.Builder addChildSaProposal(@android.annotation.NonNull android.net.ipsec.ike.ChildSaProposal proposal) { throw new RuntimeException("Stub!"); }

/**
 * Adds an inbound {@link android.net.ipsec.ike.IkeTrafficSelector IkeTrafficSelector} to the {@link android.net.ipsec.ike.TunnelModeChildSessionParams TunnelModeChildSessionParams}
 * being built.
 *
 * <p>This method allows callers to limit the inbound traffic transmitted over the Child
 * Session to the given range. The IKE server may further narrow the range. Callers should
 * refer to {@link android.net.ipsec.ike.ChildSessionConfiguration ChildSessionConfiguration} for the negotiated traffic selectors.
 *
 * <p>If no inbound {@link android.net.ipsec.ike.IkeTrafficSelector IkeTrafficSelector} is provided, a default value will be used
 * that covers all IP addresses and ports.
 *
 * @param trafficSelector the inbound {@link android.net.ipsec.ike.IkeTrafficSelector IkeTrafficSelector}.
 * This value cannot be {@code null}.
 * @return Builder this, to facilitate chaining.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.ipsec.ike.TunnelModeChildSessionParams.Builder addInboundTrafficSelectors(@android.annotation.NonNull android.net.ipsec.ike.IkeTrafficSelector trafficSelector) { throw new RuntimeException("Stub!"); }

/**
 * Adds an internal IP address request to the {@link android.net.ipsec.ike.TunnelModeChildSessionParams TunnelModeChildSessionParams} being
 * built.
 *
 * @param addressFamily the address family. Only {@code AF_INET} and {@code AF_INET6} are
 *     allowed
 * @return Builder this, to facilitate chaining.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.ipsec.ike.TunnelModeChildSessionParams.Builder addInternalAddressRequest(int addressFamily) { throw new RuntimeException("Stub!"); }

/**
 * Adds a specific internal IPv4 address request to the {@link android.net.ipsec.ike.TunnelModeChildSessionParams TunnelModeChildSessionParams}
 * being built.
 *
 * @param address the requested IPv4 address.
 * This value cannot be {@code null}.
 * @return Builder this, to facilitate chaining.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.ipsec.ike.TunnelModeChildSessionParams.Builder addInternalAddressRequest(@android.annotation.NonNull java.net.Inet4Address address) { throw new RuntimeException("Stub!"); }

/**
 * Adds a specific internal IPv6 address request to the {@link android.net.ipsec.ike.TunnelModeChildSessionParams TunnelModeChildSessionParams}
 * being built.
 *
 * @param address the requested IPv6 address.
 * This value cannot be {@code null}.
 * @param prefixLen length of the IPv6 address prefix length.
 * @return Builder this, to facilitate chaining.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.ipsec.ike.TunnelModeChildSessionParams.Builder addInternalAddressRequest(@android.annotation.NonNull java.net.Inet6Address address, int prefixLen) { throw new RuntimeException("Stub!"); }

/**
 * Adds an internal DHCP server request to the {@link android.net.ipsec.ike.TunnelModeChildSessionParams TunnelModeChildSessionParams} being
 * built.
 *
 * <p>Only DHCPv4 server requests are supported.
 *
 * @param addressFamily the address family. Only {@code AF_INET} is allowed
 * @return Builder this, to facilitate chaining.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.ipsec.ike.TunnelModeChildSessionParams.Builder addInternalDhcpServerRequest(int addressFamily) { throw new RuntimeException("Stub!"); }

/**
 * Adds an internal DNS server request to the {@link android.net.ipsec.ike.TunnelModeChildSessionParams TunnelModeChildSessionParams} being
 * built.
 *
 * @param addressFamily the address family. Only {@code AF_INET} and {@code AF_INET6} are
 *     allowed
 * @return Builder this, to facilitate chaining.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.ipsec.ike.TunnelModeChildSessionParams.Builder addInternalDnsServerRequest(int addressFamily) { throw new RuntimeException("Stub!"); }

/**
 * Adds an outbound {@link android.net.ipsec.ike.IkeTrafficSelector IkeTrafficSelector} to the {@link android.net.ipsec.ike.TunnelModeChildSessionParams TunnelModeChildSessionParams}
 * being built.
 *
 * <p>This method allows callers to limit the outbound traffic transmitted over the Child
 * Session to the given range. The IKE server may further narrow the range. Callers should
 * refer to {@link android.net.ipsec.ike.ChildSessionConfiguration ChildSessionConfiguration} for the negotiated traffic selectors.
 *
 * <p>If no outbound {@link android.net.ipsec.ike.IkeTrafficSelector IkeTrafficSelector} is provided, a default value will be used
 * that covers all IP addresses and ports.
 *
 * @param trafficSelector the outbound {@link android.net.ipsec.ike.IkeTrafficSelector IkeTrafficSelector}.
 * This value cannot be {@code null}.
 * @return Builder this, to facilitate chaining.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.ipsec.ike.TunnelModeChildSessionParams.Builder addOutboundTrafficSelectors(@android.annotation.NonNull android.net.ipsec.ike.IkeTrafficSelector trafficSelector) { throw new RuntimeException("Stub!"); }

/**
 * Validates and builds the {@link android.net.ipsec.ike.TunnelModeChildSessionParams TunnelModeChildSessionParams}.
 *
 * @return the validated {@link android.net.ipsec.ike.TunnelModeChildSessionParams TunnelModeChildSessionParams}.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.ipsec.ike.TunnelModeChildSessionParams build() { throw new RuntimeException("Stub!"); }

/**
 * Sets hard and soft lifetimes.
 *
 * <p>Lifetimes will not be negotiated with the remote IKE server.
 *
 * @param hardLifetimeSeconds number of seconds after which Child SA will expire. Defaults
 *     to 7200 seconds (2 hours). Considering IPsec packet lifetime, IKE library requires
 *     hard lifetime to be a value from 300 seconds (5 minutes) to 14400 seconds (4 hours),
 *     inclusive.
 * Value is between CHILD_HARD_LIFETIME_SEC_MINIMUM and CHILD_HARD_LIFETIME_SEC_MAXIMUM inclusive
 * @param softLifetimeSeconds number of seconds after which Child SA will request rekey.
 *     Defaults to 3600 seconds (1 hour). MUST be at least 120 seconds (2 minutes), and at
 *     least 60 seconds (1 minute) shorter than the hard lifetime.
 
 * Value is between CHILD_SOFT_LIFETIME_SEC_MINIMUM and CHILD_HARD_LIFETIME_SEC_MAXIMUM inclusive
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.ipsec.ike.TunnelModeChildSessionParams.Builder setLifetimeSeconds(int hardLifetimeSeconds, int softLifetimeSeconds) { throw new RuntimeException("Stub!"); }
}

/** Represents an IPv4 Internal Address request */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface ConfigRequestIpv4Address extends android.net.ipsec.ike.TunnelModeChildSessionParams.TunnelModeChildConfigRequest {

/**
 * Retrieves the requested internal IPv4 address
 *
 * @return The requested IPv4 address, or null if no specific internal address was requested
 */

@android.annotation.Nullable
public java.net.Inet4Address getAddress();
}

/** Represents an IPv4 DHCP server request */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface ConfigRequestIpv4DhcpServer extends android.net.ipsec.ike.TunnelModeChildSessionParams.TunnelModeChildConfigRequest {
}

/** Represents an IPv4 DNS Server request */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface ConfigRequestIpv4DnsServer extends android.net.ipsec.ike.TunnelModeChildSessionParams.TunnelModeChildConfigRequest {
}

/** Represents an IPv4 Netmask request */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface ConfigRequestIpv4Netmask extends android.net.ipsec.ike.TunnelModeChildSessionParams.TunnelModeChildConfigRequest {
}

/** Represents an IPv6 Internal Address request */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface ConfigRequestIpv6Address extends android.net.ipsec.ike.TunnelModeChildSessionParams.TunnelModeChildConfigRequest {

/**
 * Retrieves the requested internal IPv6 address
 *
 * @return The requested IPv6 address, or null if no specific internal address was requested
 */

@android.annotation.Nullable
public java.net.Inet6Address getAddress();

/**
 * Retrieves the prefix length
 *
 * @return The requested prefix length, or -1 if no specific IPv6 address was requested
 */

public int getPrefixLength();
}

/** Represents an IPv6 DNS Server request */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface ConfigRequestIpv6DnsServer extends android.net.ipsec.ike.TunnelModeChildSessionParams.TunnelModeChildConfigRequest {
}

/** Represents a tunnel mode child session configuration request type */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface TunnelModeChildConfigRequest {
}

}

