/*
 * Copyright (C) 2019 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.media;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class MediaParser {

private MediaParser() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.media.MediaParser createByName(@android.annotation.NonNull java.lang.String name, @android.annotation.NonNull android.media.MediaParser.OutputConsumer outputConsumer) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.media.MediaParser create(@android.annotation.NonNull android.media.MediaParser.OutputConsumer outputConsumer, @android.annotation.NonNull java.lang.String... parserNames) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static java.util.List<java.lang.String> getParserNames(@android.annotation.NonNull android.media.MediaFormat mediaFormat) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.MediaParser setParameter(@android.annotation.NonNull java.lang.String parameterName, @android.annotation.NonNull java.lang.Object value) { throw new RuntimeException("Stub!"); }

public boolean supportsParameter(@android.annotation.NonNull java.lang.String parameterName) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String getParserName() { throw new RuntimeException("Stub!"); }

public boolean advance(@android.annotation.NonNull android.media.MediaParser.SeekableInputReader seekableInputReader) throws java.io.IOException { throw new RuntimeException("Stub!"); }

public void seek(@android.annotation.NonNull android.media.MediaParser.SeekPoint seekPoint) { throw new RuntimeException("Stub!"); }

public void release() { throw new RuntimeException("Stub!"); }

public void setLogSessionId(@android.annotation.NonNull android.media.metrics.LogSessionId logSessionId) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.metrics.LogSessionId getLogSessionId() { throw new RuntimeException("Stub!"); }

public static final java.lang.String PARAMETER_ADTS_ENABLE_CBR_SEEKING = "android.media.mediaparser.adts.enableCbrSeeking";

public static final java.lang.String PARAMETER_AMR_ENABLE_CBR_SEEKING = "android.media.mediaparser.amr.enableCbrSeeking";

public static final java.lang.String PARAMETER_FLAC_DISABLE_ID3 = "android.media.mediaparser.flac.disableId3";

public static final java.lang.String PARAMETER_MATROSKA_DISABLE_CUES_SEEKING = "android.media.mediaparser.matroska.disableCuesSeeking";

public static final java.lang.String PARAMETER_MP3_DISABLE_ID3 = "android.media.mediaparser.mp3.disableId3";

public static final java.lang.String PARAMETER_MP3_ENABLE_CBR_SEEKING = "android.media.mediaparser.mp3.enableCbrSeeking";

public static final java.lang.String PARAMETER_MP3_ENABLE_INDEX_SEEKING = "android.media.mediaparser.mp3.enableIndexSeeking";

public static final java.lang.String PARAMETER_MP4_IGNORE_EDIT_LISTS = "android.media.mediaparser.mp4.ignoreEditLists";

public static final java.lang.String PARAMETER_MP4_IGNORE_TFDT_BOX = "android.media.mediaparser.mp4.ignoreTfdtBox";

public static final java.lang.String PARAMETER_MP4_TREAT_VIDEO_FRAMES_AS_KEYFRAMES = "android.media.mediaparser.mp4.treatVideoFramesAsKeyframes";

public static final java.lang.String PARAMETER_TS_ALLOW_NON_IDR_AVC_KEYFRAMES = "android.media.mediaparser.ts.allowNonIdrAvcKeyframes";

public static final java.lang.String PARAMETER_TS_DETECT_ACCESS_UNITS = "android.media.mediaparser.ts.ignoreDetectAccessUnits";

public static final java.lang.String PARAMETER_TS_ENABLE_HDMV_DTS_AUDIO_STREAMS = "android.media.mediaparser.ts.enableHdmvDtsAudioStreams";

public static final java.lang.String PARAMETER_TS_IGNORE_AAC_STREAM = "android.media.mediaparser.ts.ignoreAacStream";

public static final java.lang.String PARAMETER_TS_IGNORE_AVC_STREAM = "android.media.mediaparser.ts.ignoreAvcStream";

public static final java.lang.String PARAMETER_TS_IGNORE_SPLICE_INFO_STREAM = "android.media.mediaparser.ts.ignoreSpliceInfoStream";

public static final java.lang.String PARAMETER_TS_MODE = "android.media.mediaparser.ts.mode";

public static final java.lang.String PARSER_NAME_AC3 = "android.media.mediaparser.Ac3Parser";

public static final java.lang.String PARSER_NAME_AC4 = "android.media.mediaparser.Ac4Parser";

public static final java.lang.String PARSER_NAME_ADTS = "android.media.mediaparser.AdtsParser";

public static final java.lang.String PARSER_NAME_AMR = "android.media.mediaparser.AmrParser";

public static final java.lang.String PARSER_NAME_FLAC = "android.media.mediaparser.FlacParser";

public static final java.lang.String PARSER_NAME_FLV = "android.media.mediaparser.FlvParser";

public static final java.lang.String PARSER_NAME_FMP4 = "android.media.mediaparser.FragmentedMp4Parser";

public static final java.lang.String PARSER_NAME_MATROSKA = "android.media.mediaparser.MatroskaParser";

public static final java.lang.String PARSER_NAME_MP3 = "android.media.mediaparser.Mp3Parser";

public static final java.lang.String PARSER_NAME_MP4 = "android.media.mediaparser.Mp4Parser";

public static final java.lang.String PARSER_NAME_OGG = "android.media.mediaparser.OggParser";

public static final java.lang.String PARSER_NAME_PS = "android.media.mediaparser.PsParser";

public static final java.lang.String PARSER_NAME_TS = "android.media.mediaparser.TsParser";

public static final java.lang.String PARSER_NAME_UNKNOWN = "android.media.mediaparser.UNKNOWN";

public static final java.lang.String PARSER_NAME_WAV = "android.media.mediaparser.WavParser";

public static final int SAMPLE_FLAG_DECODE_ONLY = -2147483648; // 0x80000000

public static final int SAMPLE_FLAG_ENCRYPTED = 1073741824; // 0x40000000

public static final int SAMPLE_FLAG_HAS_SUPPLEMENTAL_DATA = 268435456; // 0x10000000

public static final int SAMPLE_FLAG_KEY_FRAME = 1; // 0x1

public static final int SAMPLE_FLAG_LAST_SAMPLE = 536870912; // 0x20000000
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface InputReader {

public int read(@android.annotation.NonNull byte[] buffer, int offset, int readLength) throws java.io.IOException;

public long getPosition();

public long getLength();
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface OutputConsumer {

public void onSeekMapFound(@android.annotation.NonNull android.media.MediaParser.SeekMap seekMap);

public void onTrackCountFound(int numberOfTracks);

public void onTrackDataFound(int trackIndex, @android.annotation.NonNull android.media.MediaParser.TrackData trackData);

public void onSampleDataFound(int trackIndex, @android.annotation.NonNull android.media.MediaParser.InputReader inputReader) throws java.io.IOException;

public void onSampleCompleted(int trackIndex, long timeMicros, int flags, int size, int offset, @android.annotation.Nullable android.media.MediaCodec.CryptoInfo cryptoInfo);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class ParsingException extends java.io.IOException {

private ParsingException() { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class SeekMap {

private SeekMap() { throw new RuntimeException("Stub!"); }

public boolean isSeekable() { throw new RuntimeException("Stub!"); }

public long getDurationMicros() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.util.Pair<android.media.MediaParser.SeekPoint,android.media.MediaParser.SeekPoint> getSeekPoints(long timeMicros) { throw new RuntimeException("Stub!"); }

public static final int UNKNOWN_DURATION = -2147483648; // 0x80000000
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class SeekPoint {

private SeekPoint() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public boolean equals(@android.annotation.Nullable java.lang.Object obj) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.media.MediaParser.SeekPoint START;
static { START = null; }

public final long position;
{ position = 0; }

public final long timeMicros;
{ timeMicros = 0; }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface SeekableInputReader extends android.media.MediaParser.InputReader {

public void seekToPosition(long position);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class TrackData {

private TrackData() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable public final android.media.DrmInitData drmInitData;
{ drmInitData = null; }

@android.annotation.NonNull public final android.media.MediaFormat mediaFormat;
{ mediaFormat = null; }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class UnrecognizedInputFormatException extends java.io.IOException {

private UnrecognizedInputFormatException() { throw new RuntimeException("Stub!"); }
}

}

