/*
 * Copyright (C) 2019 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.media;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class MediaTranscodingManager {

MediaTranscodingManager() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.media.MediaTranscodingManager.TranscodingSession enqueueRequest(@android.annotation.NonNull android.media.MediaTranscodingManager.TranscodingRequest transcodingRequest, @android.annotation.NonNull java.util.concurrent.Executor listenerExecutor, @android.annotation.NonNull android.media.MediaTranscodingManager.OnTranscodingFinishedListener listener) { throw new RuntimeException("Stub!"); }
@SuppressWarnings({"unchecked", "deprecation", "all"})
@java.lang.FunctionalInterface
public static interface OnTranscodingFinishedListener {

public void onTranscodingFinished(@android.annotation.NonNull android.media.MediaTranscodingManager.TranscodingSession session);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract static class TranscodingRequest {

TranscodingRequest() { throw new RuntimeException("Stub!"); }

public int getClientPid() { throw new RuntimeException("Stub!"); }

public int getClientUid() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.os.ParcelFileDescriptor getDestinationFileDescriptor() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.Uri getDestinationUri() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.os.ParcelFileDescriptor getSourceFileDescriptor() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.Uri getSourceUri() { throw new RuntimeException("Stub!"); }
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class VideoFormatResolver {

public VideoFormatResolver(@android.annotation.NonNull android.media.ApplicationMediaCapabilities clientCaps, @android.annotation.NonNull android.media.MediaFormat srcVideoFormatHint) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.media.MediaFormat resolveVideoFormat() { throw new RuntimeException("Stub!"); }

public boolean shouldTranscode() { throw new RuntimeException("Stub!"); }
}

}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class TranscodingSession {

TranscodingSession() { throw new RuntimeException("Stub!"); }

public boolean addClientUid(int uid) { throw new RuntimeException("Stub!"); }

public void cancel() { throw new RuntimeException("Stub!"); }

public void clearOnProgressUpdateListener() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<java.lang.Integer> getClientUids() { throw new RuntimeException("Stub!"); }

public int getErrorCode() { throw new RuntimeException("Stub!"); }

public int getProgress() { throw new RuntimeException("Stub!"); }

public int getResult() { throw new RuntimeException("Stub!"); }

public int getSessionId() { throw new RuntimeException("Stub!"); }

public int getStatus() { throw new RuntimeException("Stub!"); }

public void setOnProgressUpdateListener(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.media.MediaTranscodingManager.TranscodingSession.OnProgressUpdateListener listener) { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public static final int ERROR_DROPPED_BY_SERVICE = 1; // 0x1

public static final int ERROR_NONE = 0; // 0x0

public static final int ERROR_SERVICE_DIED = 2; // 0x2

public static final int RESULT_CANCELED = 4; // 0x4

public static final int RESULT_ERROR = 3; // 0x3

public static final int RESULT_NONE = 1; // 0x1

public static final int RESULT_SUCCESS = 2; // 0x2

public static final int STATUS_FINISHED = 3; // 0x3

public static final int STATUS_PAUSED = 4; // 0x4

public static final int STATUS_PENDING = 1; // 0x1

public static final int STATUS_RUNNING = 2; // 0x2
@SuppressWarnings({"unchecked", "deprecation", "all"})
@java.lang.FunctionalInterface
public static interface OnProgressUpdateListener {

public void onProgressUpdate(@android.annotation.NonNull android.media.MediaTranscodingManager.TranscodingSession session, int progress);
}

}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class VideoTranscodingRequest extends android.media.MediaTranscodingManager.TranscodingRequest {

VideoTranscodingRequest() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.MediaFormat getVideoTrackFormat() { throw new RuntimeException("Stub!"); }
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder(@android.annotation.NonNull android.net.Uri sourceUri, @android.annotation.NonNull android.net.Uri destinationUri, @android.annotation.NonNull android.media.MediaFormat videoFormat) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.MediaTranscodingManager.VideoTranscodingRequest build() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.MediaTranscodingManager.VideoTranscodingRequest.Builder setClientPid(int pid) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.MediaTranscodingManager.VideoTranscodingRequest.Builder setClientUid(int uid) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.MediaTranscodingManager.VideoTranscodingRequest.Builder setDestinationFileDescriptor(@android.annotation.NonNull android.os.ParcelFileDescriptor fd) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.MediaTranscodingManager.VideoTranscodingRequest.Builder setSourceFileDescriptor(@android.annotation.NonNull android.os.ParcelFileDescriptor fd) { throw new RuntimeException("Stub!"); }
}

}

}

