/*
 * Copyright (C) 2014 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.graphics.pdf;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class PdfRenderer implements java.lang.AutoCloseable {

public PdfRenderer(@android.annotation.NonNull android.os.ParcelFileDescriptor fileDescriptor) throws java.io.IOException { throw new RuntimeException("Stub!"); }

public PdfRenderer(@android.annotation.NonNull android.os.ParcelFileDescriptor fileDescriptor, @android.annotation.NonNull android.graphics.pdf.LoadParams params) throws java.io.IOException { throw new RuntimeException("Stub!"); }

public void close() { throw new RuntimeException("Stub!"); }

public int getPageCount() { throw new RuntimeException("Stub!"); }

public boolean shouldScaleForPrinting() { throw new RuntimeException("Stub!"); }

public int getDocumentLinearizationType() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.graphics.pdf.PdfRenderer.Page openPage(int index) { throw new RuntimeException("Stub!"); }

public int getPdfFormType() { throw new RuntimeException("Stub!"); }

public void write(@android.annotation.NonNull android.os.ParcelFileDescriptor destination, boolean removePasswordProtection) throws java.io.IOException { throw new RuntimeException("Stub!"); }

protected void finalize() throws java.lang.Throwable { throw new RuntimeException("Stub!"); }

public static final int DOCUMENT_LINEARIZED_TYPE_LINEARIZED = 1; // 0x1

public static final int DOCUMENT_LINEARIZED_TYPE_NON_LINEARIZED = 0; // 0x0

public static final int PDF_FORM_TYPE_ACRO_FORM = 1; // 0x1

public static final int PDF_FORM_TYPE_NONE = 0; // 0x0

public static final int PDF_FORM_TYPE_XFA_FOREGROUND = 3; // 0x3

public static final int PDF_FORM_TYPE_XFA_FULL = 2; // 0x2
@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class Page implements java.lang.AutoCloseable {

Page() { throw new RuntimeException("Stub!"); }

public int getIndex() { throw new RuntimeException("Stub!"); }

public int getWidth() { throw new RuntimeException("Stub!"); }

public int getHeight() { throw new RuntimeException("Stub!"); }

public void render(@android.annotation.NonNull android.graphics.Bitmap destination, @android.annotation.Nullable android.graphics.Rect destClip, @android.annotation.Nullable android.graphics.Matrix transform, int renderMode) { throw new RuntimeException("Stub!"); }

public void render(@android.annotation.NonNull android.graphics.Bitmap destination, @android.annotation.Nullable android.graphics.Rect destClip, @android.annotation.Nullable android.graphics.Matrix transform, @android.annotation.NonNull android.graphics.pdf.RenderParams params) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.graphics.pdf.content.PdfPageTextContent> getTextContents() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.graphics.pdf.content.PdfPageImageContent> getImageContents() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.graphics.pdf.models.PageMatchBounds> searchText(@android.annotation.NonNull java.lang.String query) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.graphics.pdf.models.selection.PageSelection selectContent(@android.annotation.NonNull android.graphics.pdf.models.selection.SelectionBoundary start, @android.annotation.NonNull android.graphics.pdf.models.selection.SelectionBoundary stop) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.graphics.pdf.content.PdfPageLinkContent> getLinkContents() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.graphics.pdf.content.PdfPageGotoLinkContent> getGotoLinks() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.graphics.pdf.models.FormWidgetInfo> getFormWidgetInfos() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.graphics.pdf.models.FormWidgetInfo> getFormWidgetInfos(@android.annotation.NonNull int[] types) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.graphics.pdf.models.FormWidgetInfo getFormWidgetInfoAtIndex(int widgetIndex) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.graphics.pdf.models.FormWidgetInfo getFormWidgetInfoAtPosition(int x, int y) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.graphics.Rect> applyEdit(@android.annotation.NonNull android.graphics.pdf.models.FormEditRecord editRecord) { throw new RuntimeException("Stub!"); }

public void close() { throw new RuntimeException("Stub!"); }

protected void finalize() throws java.lang.Throwable { throw new RuntimeException("Stub!"); }

public static final int RENDER_MODE_FOR_DISPLAY = 1; // 0x1

public static final int RENDER_MODE_FOR_PRINT = 2; // 0x2
}

}

