/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.graphics.pdf;


/**
 * Represents a set of parameters to load the PDF document.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class LoadParams {

LoadParams() { throw new RuntimeException("Stub!"); }

/**
 * Gets the password for the loaded document. Returns {@code null} if not set.
 *
 * @return the password for the document.
 */

@android.annotation.Nullable
public java.lang.String getPassword() { throw new RuntimeException("Stub!"); }
/**
 * Builder for constructing {@link android.graphics.pdf.LoadParams LoadParams}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/** Constructor for builder to create {@link android.graphics.pdf.LoadParams LoadParams}. */

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Sets the optional password for a protected PDF document. A {@code null} value will be
 * treated as no password supplied or document is unprotected.
 *
 * @param password Password for the protected PDF document.

 * This value may be {@code null}.
 */

@android.annotation.NonNull
public android.graphics.pdf.LoadParams.Builder setPassword(@android.annotation.Nullable java.lang.String password) { throw new RuntimeException("Stub!"); }

/**
 * Builds the {@link android.graphics.pdf.LoadParams LoadParams} after the optional values has been set.
 *
 * @return new instance of {@link android.graphics.pdf.LoadParams LoadParams}

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.graphics.pdf.LoadParams build() { throw new RuntimeException("Stub!"); }
}

}

