/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.graphics.pdf.content;

import android.graphics.RectF;
import android.net.Uri;

/**
 * <p>
 * Represents the bounds and link on a page of the PDF document. Weblinks are those links implicitly
 * embedded in PDF pages.
 * <strong>Note:</strong> Only weblinks that are embedded will be supported. Links encoded as
 * plain text will be returned as part of {@link android.graphics.pdf.content.PdfPageTextContent PdfPageTextContent}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class PdfPageLinkContent implements android.os.Parcelable {

/**
 * Creates a new instance of {@link android.graphics.pdf.content.PdfPageLinkContent PdfPageLinkContent} using the embedded {@link android.net.Uri Uri} and the
 * bounds of the uri.
 *
 * @param bounds Bounds which envelop the URI.
 * This value cannot be {@code null}.
 * @param uri    Uri embedded in the PDF document.
 * This value cannot be {@code null}.
 * @throws java.lang.NullPointerException     If bounds or uri is null.
 * @throws java.lang.IllegalArgumentException If the bounds list is empty.
 */

public PdfPageLinkContent(@android.annotation.NonNull java.util.List<android.graphics.RectF> bounds, @android.annotation.NonNull android.net.Uri uri) { throw new RuntimeException("Stub!"); }

/**
 * <p>
 * Gets the bounds of the embedded weblink represented as a list of {@link android.graphics.RectF RectF}. Links which
 * are spread across multiple lines will be surrounded by multiple {@link android.graphics.RectF RectF} in order of
 * viewing.
 * <p><strong>Note:</strong> Each {@link android.graphics.RectF RectF} represents a bound of the weblink in a single
 * line and defines the coordinates of its 4 edges (left, top, right and bottom) in
 * points (1/72"). The developer will need to render the highlighter as well as intercept the
 * touch events for functionalities such as clicking the link.
 *
 * @return The bounds of the link.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.graphics.RectF> getBounds() { throw new RuntimeException("Stub!"); }

/**
 * <p>
 * Gets the weblink on the page of the PDF document. Weblinks are those links implicitly
 * embedded in PDF pages.
 * <strong>Note:</strong> Only weblinks that are embedded will be supported. Links encoded as
 * plain text will be returned as part of {@link android.graphics.pdf.content.PdfPageTextContent PdfPageTextContent}.
 *
 * @return The weblink embedded on the page.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.Uri getUri() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.graphics.pdf.content.PdfPageLinkContent> CREATOR;
static { CREATOR = null; }
}

