/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.graphics.pdf.content;

import android.graphics.RectF;

/**
 * <p>
 * Represents a continuous stream of text in a page of a PDF document in the order of viewing.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class PdfPageTextContent implements android.os.Parcelable {

/**
 * Creates a new instance of {@link android.graphics.pdf.content.PdfPageTextContent PdfPageTextContent} using the raw text on the page of the
 * document. By default, the bounds will be an empty list.
 *
 * @param text Text content on the page.
 * This value cannot be {@code null}.
 * @throws java.lang.NullPointerException If text is null.
 */

public PdfPageTextContent(@android.annotation.NonNull java.lang.String text) { throw new RuntimeException("Stub!"); }

/**
 * Creates a new instance of {@link android.graphics.pdf.content.PdfPageTextContent PdfPageTextContent} to represent text content within defined
 * bounds represented by a non-empty list of {@link android.graphics.RectF RectF} on the page of the document.
 *
 * @param text   Text content within the bounds.
 * This value cannot be {@code null}.
 * @param bounds Bounds for the text content
 * This value cannot be {@code null}.
 * @throws java.lang.NullPointerException If text or bounds is null.
 */

public PdfPageTextContent(@android.annotation.NonNull java.lang.String text, @android.annotation.NonNull java.util.List<android.graphics.RectF> bounds) { throw new RuntimeException("Stub!"); }

/**
 * Gets the text content on the document.
 *
 * @return The text content on the page.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getText() { throw new RuntimeException("Stub!"); }

/**
 * Gets the bounds for the text content represented as a list of {@link android.graphics.RectF RectF}. Each
 * {@link android.graphics.RectF RectF} represents text content in a single line defined in points (1/72") for its 4
 * corners. Content spread across multiple lines is represented by list of {@link android.graphics.RectF RectF} in the
 * order of viewing (left to right and top to bottom). If the text content is unbounded then the
 * list will be empty.
 *
 * @return The bounds of the text content.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.graphics.RectF> getBounds() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.graphics.pdf.content.PdfPageTextContent> CREATOR;
static { CREATOR = null; }
}

