/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.widget.photopicker;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public interface EmbeddedPhotoPickerSession {

public void close();

@android.annotation.NonNull
public android.view.SurfaceControlViewHost.SurfacePackage getSurfacePackage();

public void notifyConfigurationChanged(@android.annotation.NonNull android.content.res.Configuration configuration);

public void notifyPhotoPickerExpanded(boolean isExpanded);

public void notifyResized(int width, int height);

public void notifyVisibilityChanged(boolean isVisible);

public void requestRevokeUriPermission(@android.annotation.NonNull java.util.List<android.net.Uri> uris);
}

