/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.graphics.pdf;


/**
 * Represents a set of parameters that will be used to render a page of the PDF document.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class RenderParams {

RenderParams() { throw new RuntimeException("Stub!"); }

/**
 * Returns the bitmask of the render flags.

 * @return Value is either <code>0</code> or a combination of {@link android.graphics.pdf.RenderParams#FLAG_RENDER_TEXT_ANNOTATIONS}, {@link android.graphics.pdf.RenderParams#FLAG_RENDER_HIGHLIGHT_ANNOTATIONS}, android.graphics.pdf.RenderParams.FLAG_RENDER_STAMP_ANNOTATIONS, and android.graphics.pdf.RenderParams.FLAG_RENDER_FREETEXT_ANNOTATIONS
 */

public int getRenderFlags() { throw new RuntimeException("Stub!"); }

/**
 * Returns the render mode.

 * @return Value is {@link android.graphics.pdf.RenderParams#RENDER_MODE_FOR_DISPLAY}, or {@link android.graphics.pdf.RenderParams#RENDER_MODE_FOR_PRINT}
 */

public int getRenderMode() { throw new RuntimeException("Stub!"); }

/**
 * Flag to enable rendering of highlight annotation on the page.
 *
 * @see android.graphics.pdf.RenderParams#getRenderFlags()
 * @see android.graphics.pdf.RenderParams.Builder#setRenderFlags(int)
 */

public static final int FLAG_RENDER_HIGHLIGHT_ANNOTATIONS = 4; // 0x4

/**
 * Flag to enable rendering of text annotation on the page.
 *
 * @see android.graphics.pdf.RenderParams#getRenderFlags()
 * @see android.graphics.pdf.RenderParams.Builder#setRenderFlags(int)
 */

public static final int FLAG_RENDER_TEXT_ANNOTATIONS = 2; // 0x2

/**
 * Mode to render the content for display on a screen.
 */

public static final int RENDER_MODE_FOR_DISPLAY = 1; // 0x1

/**
 * Mode to render the content for printing.
 */

public static final int RENDER_MODE_FOR_PRINT = 2; // 0x2
/**
 * Builder for constructing {@link android.graphics.pdf.RenderParams RenderParams}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * Create a builder for constructing a {@link android.graphics.pdf.RenderParams RenderParams} object with the render mode.
 *
 * @param renderMode render mode for the content.

 * Value is {@link android.graphics.pdf.RenderParams#RENDER_MODE_FOR_DISPLAY}, or {@link android.graphics.pdf.RenderParams#RENDER_MODE_FOR_PRINT}
 */

public Builder(int renderMode) { throw new RuntimeException("Stub!"); }

/**
 * Builds the {@link android.graphics.pdf.RenderParams RenderParams} after the optional values has been set.
 *
 * @return the newly constructed {@link android.graphics.pdf.RenderParams RenderParams} object

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.graphics.pdf.RenderParams build() { throw new RuntimeException("Stub!"); }

/**
 * Sets the state of the render flag.
 * See {@link #setRenderFlags(int,int)} for usage information.
 *
 * @param renderFlags the bitmask of the render flag should be enabled, or {@code 0} to
 *                    disable all flags.
 * Value is either <code>0</code> or a combination of {@link android.graphics.pdf.RenderParams#FLAG_RENDER_TEXT_ANNOTATIONS}, {@link android.graphics.pdf.RenderParams#FLAG_RENDER_HIGHLIGHT_ANNOTATIONS}, android.graphics.pdf.RenderParams.FLAG_RENDER_STAMP_ANNOTATIONS, and android.graphics.pdf.RenderParams.FLAG_RENDER_FREETEXT_ANNOTATIONS
 * @see #setRenderFlags(int, int)
 * @see #getRenderFlags()
 
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.graphics.pdf.RenderParams.Builder setRenderFlags(int renderFlags) { throw new RuntimeException("Stub!"); }

/**
 * Sets the state of the render flag specified by the mask. To change all render flags at
 * once, see {@link #setRenderFlags(int)}.
 * <p>
 * When a render flag is enabled, it will be displayed on the updated
 * {@link android.graphics.Bitmap} of the renderer.
 * <p>
 * Multiple indicator types may be enabled or disabled by passing the logical OR of the
 * desired flags. If multiple flags are specified, they
 * will all be set to the same enabled state.
 * <p>
 * For example, to enable the render text annotations flag:
 * {@code setRenderFlags(FLAG_RENDER_TEXT_ANNOTATIONS, FLAG_RENDER_TEXT_ANNOTATIONS)}
 * <p>
 * To disable the render text annotations flag:
 * {@code setRenderFlags(0, FLAG_RENDER_TEXT_ANNOTATIONS)}
 *
 * @param renderFlags the render flag, or the logical OR of multiple
 *                    render flags. One or more of:
 *                    <ul>
 *                      <li>{@link #FLAG_RENDER_TEXT_ANNOTATIONS}</li>
 *                      <li>{@link #FLAG_RENDER_HIGHLIGHT_ANNOTATIONS}</li>
 *                    </ul>
 * Value is either <code>0</code> or a combination of {@link android.graphics.pdf.RenderParams#FLAG_RENDER_TEXT_ANNOTATIONS}, {@link android.graphics.pdf.RenderParams#FLAG_RENDER_HIGHLIGHT_ANNOTATIONS}, android.graphics.pdf.RenderParams.FLAG_RENDER_STAMP_ANNOTATIONS, and android.graphics.pdf.RenderParams.FLAG_RENDER_FREETEXT_ANNOTATIONS
 * @see #setRenderFlags(int)
 * @see #getRenderFlags()
 
 * @param mask Value is either <code>0</code> or a combination of {@link android.graphics.pdf.RenderParams#FLAG_RENDER_TEXT_ANNOTATIONS}, {@link android.graphics.pdf.RenderParams#FLAG_RENDER_HIGHLIGHT_ANNOTATIONS}, android.graphics.pdf.RenderParams.FLAG_RENDER_STAMP_ANNOTATIONS, and android.graphics.pdf.RenderParams.FLAG_RENDER_FREETEXT_ANNOTATIONS
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.graphics.pdf.RenderParams.Builder setRenderFlags(int renderFlags, int mask) { throw new RuntimeException("Stub!"); }
}

}

