/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.graphics.pdf.models;


/**
 * Record of a form filling operation that has been executed on a single form field in a PDF.
 * Contains the minimum amount of data required to replicate the action on the form.
 *
 * @see <a
 * href="https://opensource.adobe.com/dc-acrobat-sdk-docs/pdfstandards/PDF32000_2008.pdf">PDF
 * 32000-1:2008</a>
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class FormEditRecord implements android.os.Parcelable {

FormEditRecord() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object obj) { throw new RuntimeException("Stub!"); }

/**
 * @return the point on which the user tapped, if this record is of type {@link
 * #EDIT_TYPE_CLICK}, else null
 */

@android.annotation.Nullable
public android.graphics.Point getClickPoint() { throw new RuntimeException("Stub!"); }

/**
 * @return the page on which the edit occurred

 * Value is 0 or greater
 */

public int getPageNumber() { throw new RuntimeException("Stub!"); }

/**
 * @return the selected indices in the choice widget, if this record is of type {@link
 * #EDIT_TYPE_SET_INDICES}, else an empty array

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public int[] getSelectedIndices() { throw new RuntimeException("Stub!"); }

/**
 * @return the text input by the user, if this record is of type {@link #EDIT_TYPE_SET_TEXT},
 * else null
 */

@android.annotation.Nullable
public java.lang.String getText() { throw new RuntimeException("Stub!"); }

/**
 * @return the type of the edit
 * Value is {@link android.graphics.pdf.models.FormEditRecord#EDIT_TYPE_CLICK}, {@link android.graphics.pdf.models.FormEditRecord#EDIT_TYPE_SET_INDICES}, or {@link android.graphics.pdf.models.FormEditRecord#EDIT_TYPE_SET_TEXT}
 */

public int getType() { throw new RuntimeException("Stub!"); }

/**
 * @return the index of the widget within the page's "Annot" array in the PDF document

 * Value is 0 or greater
 */

public int getWidgetIndex() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.graphics.pdf.models.FormEditRecord> CREATOR;
static { CREATOR = null; }

/** Indicates a click on a clickable form widget */

public static final int EDIT_TYPE_CLICK = 0; // 0x0

/** Represents setting indices on a combobox or listbox form widget */

public static final int EDIT_TYPE_SET_INDICES = 1; // 0x1

/** Represents setting text on a text field or editable combobox form widget */

public static final int EDIT_TYPE_SET_TEXT = 2; // 0x2
/** Builder for {@link android.graphics.pdf.models.FormEditRecord FormEditRecord} */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * Creates a new instance.
 *
 * @param type        the type of {@link android.graphics.pdf.models.FormEditRecord FormEditRecord} to create
 * Value is {@link android.graphics.pdf.models.FormEditRecord#EDIT_TYPE_CLICK}, {@link android.graphics.pdf.models.FormEditRecord#EDIT_TYPE_SET_INDICES}, or {@link android.graphics.pdf.models.FormEditRecord#EDIT_TYPE_SET_TEXT}
 * @param pageNumber  the page number of which the record is
 * Value is 0 or greater
 * @param widgetIndex the index of the widget within the page's "Annot" array in the PDF
 * Value is 0 or greater
 * @throws java.lang.IllegalArgumentException if a negative page number or widget index is provided
 */

public Builder(int type, int pageNumber, int widgetIndex) { throw new RuntimeException("Stub!"); }

/**
 * Builds this record
 *
 * @throws java.lang.NullPointerException if the click point is not provided for a click type record,
 *                              if the selected indices are not provided for a set indices
 *                              type record, or if the text is
 *                              not provided for a set text type record

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.graphics.pdf.models.FormEditRecord build() { throw new RuntimeException("Stub!"); }

/**
 * Sets the click point for this record
 *
 * @throws java.lang.IllegalArgumentException if this is not a click type record
 
 * @param clickPoint This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.graphics.pdf.models.FormEditRecord.Builder setClickPoint(@android.annotation.Nullable android.graphics.Point clickPoint) { throw new RuntimeException("Stub!"); }

/**
 * Sets the selected indices for this record
 *
 * @throws java.lang.IllegalArgumentException if this is not a set indices type record
 
 * @param selectedIndices This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.graphics.pdf.models.FormEditRecord.Builder setSelectedIndices(@android.annotation.Nullable int[] selectedIndices) { throw new RuntimeException("Stub!"); }

/**
 * Sets the text for this record
 *
 * @throws java.lang.IllegalArgumentException if this is not a set text type record
 
 * @param text This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.graphics.pdf.models.FormEditRecord.Builder setText(@android.annotation.Nullable java.lang.String text) { throw new RuntimeException("Stub!"); }
}

}

