/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.widget.photopicker;

import android.content.res.Configuration;
import android.os.Build;
import java.util.List;

/**
 * An immutable parcel to carry information regarding desired features of caller for
 * a given session.
 *
 * <p> Below features are currently supported in embedded photopicker.
 *
 * <ul>
 * <li> Mime type to filter media
 * <li> Accent color to change color of primary picker element
 * <li> Ordered selection of media items
 * <li> Max selection media count restriction
 * <li> Pre-selected uris
 * <li> Theme night mode
 * </ul>
 *
 * <p> Callers should use {@link android.widget.photopicker.EmbeddedPhotoPickerFeatureInfo.Builder Builder} to set the desired features.
 *
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class EmbeddedPhotoPickerFeatureInfo implements android.os.Parcelable {

EmbeddedPhotoPickerFeatureInfo() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public long getAccentColor() { throw new RuntimeException("Stub!"); }

public int getMaxSelectionLimit() { throw new RuntimeException("Stub!"); }

/**
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<java.lang.String> getMimeTypes() { throw new RuntimeException("Stub!"); }

/**
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.net.Uri> getPreSelectedUris() { throw new RuntimeException("Stub!"); }

public int getThemeNightMode() { throw new RuntimeException("Stub!"); }

public boolean isOrderedSelection() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.widget.photopicker.EmbeddedPhotoPickerFeatureInfo> CREATOR;
static { CREATOR = null; }
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Build the class for desired feature info arguments

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.widget.photopicker.EmbeddedPhotoPickerFeatureInfo build() { throw new RuntimeException("Stub!"); }

/**
 * Sets accent color which will change color of primary picker elements like Done button,
 * selected media icon colors, tab color etc.
 *
 * <p> The value of this intent-extra must be a string specifying the hex code of the
 * accent color that is to be used within the picker.
 *
 * <p> This param is same as {@link MediaStore#EXTRA_PICK_IMAGES_ACCENT_COLOR}. See {@link
 * MediaStore#EXTRA_PICK_IMAGES_ACCENT_COLOR} for more details on accepted colors.
 *
 * @param accentColor Hex code of desired accent color. By default, the color of elements
 * will reflect based on device theme

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.widget.photopicker.EmbeddedPhotoPickerFeatureInfo.Builder setAccentColor(long accentColor) { throw new RuntimeException("Stub!"); }

/**
 * Sets maximum number of items that can be selected by the user
 *
 * <p> The value of this intent-extra should be a positive integer greater than
 * or equal to 1 and less than or equal to {@link MediaStore#getPickImagesMaxLimit}
 *
 * @param maxSelectionLimit Max selection count restriction. Pass limit as 1 to open
 * PhotoPicker in single-select mode. Default is multi select mode with limit as
 * {@link MediaStore#getPickImagesMaxLimit()}
 
 * Value is 1 or greater
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.widget.photopicker.EmbeddedPhotoPickerFeatureInfo.Builder setMaxSelectionLimit(int maxSelectionLimit) { throw new RuntimeException("Stub!"); }

/**
 * Sets the mime type to filter media items on.
 *
 * <p> Values may be a combination of concrete MIME types (such as "image/png")
 * and/or partial MIME types (such as "image/*").
 *
 * @param mimeTypes List of mime types to filter. By default, all media items
 *                  will be returned
 
 * This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.widget.photopicker.EmbeddedPhotoPickerFeatureInfo.Builder setMimeTypes(@android.annotation.NonNull java.util.List<java.lang.String> mimeTypes) { throw new RuntimeException("Stub!"); }

/**
 * Sets ordered selection of media items i.e. this allows user to view/receive items in
 * their selected order
 *
 * @param orderedSelection Pass true to set ordered selection. Default is false

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.widget.photopicker.EmbeddedPhotoPickerFeatureInfo.Builder setOrderedSelection(boolean orderedSelection) { throw new RuntimeException("Stub!"); }

/**
 * Sets list of uris to be pre-selected when embedded picker is opened.
 *
 * <p> This is same as {@link MediaStore#EXTRA_PICKER_PRE_SELECTION_URIS}.
 * See {@link MediaStore#EXTRA_PICKER_PRE_SELECTION_URIS} for more details
 * on restrictions and filter criteria.
 *
 * @param preSelectedUris list of uris to be pre-selected
 
 * This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.widget.photopicker.EmbeddedPhotoPickerFeatureInfo.Builder setPreSelectedUris(@android.annotation.NonNull java.util.List<android.net.Uri> preSelectedUris) { throw new RuntimeException("Stub!"); }

/**
 * Sets the embedded photo picker theme to light or dark irrespective of the device theme.
 *
 * @param themeNightMode hex code of the desired {@link android.content.res.Configuration#UI_MODE_NIGHT_MASK Configuration.UI_MODE_NIGHT_MASK}
 *                       value.
 *
 * <p> The default value is {@link android.content.res.Configuration#UI_MODE_NIGHT_UNDEFINED Configuration.UI_MODE_NIGHT_UNDEFINED} to apply the
 * system (device) theme.
 *
 * <p> Supported values are -</p>
 * <li> {@link android.content.res.Configuration#UI_MODE_NIGHT_UNDEFINED Configuration.UI_MODE_NIGHT_UNDEFINED} -> system theme
 * <li> {@link android.content.res.Configuration#UI_MODE_NIGHT_YES Configuration.UI_MODE_NIGHT_YES} -> dark theme
 * <li> {@link android.content.res.Configuration#UI_MODE_NIGHT_NO Configuration.UI_MODE_NIGHT_NO} -> light theme

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.widget.photopicker.EmbeddedPhotoPickerFeatureInfo.Builder setThemeNightMode(int themeNightMode) { throw new RuntimeException("Stub!"); }
}

}

