/*
 * Copyright (C) 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.provider;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract class CloudMediaProvider extends android.content.ContentProvider {

public CloudMediaProvider() { throw new RuntimeException("Stub!"); }

public final void attachInfo(@android.annotation.NonNull android.content.Context context, @android.annotation.NonNull android.content.pm.ProviderInfo info) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public abstract android.os.Bundle onGetMediaCollectionInfo(@android.annotation.NonNull android.os.Bundle extras);

@android.annotation.NonNull
public abstract android.database.Cursor onQueryMedia(@android.annotation.NonNull android.os.Bundle extras);

@android.annotation.NonNull
public abstract android.database.Cursor onQueryDeletedMedia(@android.annotation.NonNull android.os.Bundle extras);

@android.annotation.NonNull
public android.database.Cursor onQueryAlbums(@android.annotation.NonNull android.os.Bundle extras) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public abstract android.content.res.AssetFileDescriptor onOpenPreview(@android.annotation.NonNull java.lang.String mediaId, @android.annotation.NonNull android.graphics.Point size, @android.annotation.Nullable android.os.Bundle extras, @android.annotation.Nullable android.os.CancellationSignal signal) throws java.io.FileNotFoundException;

@android.annotation.NonNull
public abstract android.os.ParcelFileDescriptor onOpenMedia(@android.annotation.NonNull java.lang.String mediaId, @android.annotation.Nullable android.os.Bundle extras, @android.annotation.Nullable android.os.CancellationSignal signal) throws java.io.FileNotFoundException;

@android.annotation.Nullable
public android.provider.CloudMediaProvider.CloudMediaSurfaceController onCreateCloudMediaSurfaceController(@android.annotation.NonNull android.os.Bundle config, @android.annotation.NonNull android.provider.CloudMediaProvider.CloudMediaSurfaceStateChangedCallback callback) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public final android.os.Bundle call(@android.annotation.NonNull java.lang.String method, @android.annotation.Nullable java.lang.String arg, @android.annotation.Nullable android.os.Bundle extras) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public final android.os.ParcelFileDescriptor openFile(@android.annotation.NonNull android.net.Uri uri, @android.annotation.NonNull java.lang.String mode) throws java.io.FileNotFoundException { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public final android.os.ParcelFileDescriptor openFile(@android.annotation.NonNull android.net.Uri uri, @android.annotation.NonNull java.lang.String mode, @android.annotation.Nullable android.os.CancellationSignal signal) throws java.io.FileNotFoundException { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public final android.content.res.AssetFileDescriptor openTypedAssetFile(@android.annotation.NonNull android.net.Uri uri, @android.annotation.NonNull java.lang.String mimeTypeFilter, @android.annotation.Nullable android.os.Bundle opts) throws java.io.FileNotFoundException { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public final android.content.res.AssetFileDescriptor openTypedAssetFile(@android.annotation.NonNull android.net.Uri uri, @android.annotation.NonNull java.lang.String mimeTypeFilter, @android.annotation.Nullable android.os.Bundle opts, @android.annotation.Nullable android.os.CancellationSignal signal) throws java.io.FileNotFoundException { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public final android.database.Cursor query(@android.annotation.NonNull android.net.Uri uri, @android.annotation.Nullable java.lang.String[] projection, @android.annotation.Nullable android.os.Bundle queryArgs, @android.annotation.Nullable android.os.CancellationSignal cancellationSignal) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public final java.lang.String getType(@android.annotation.NonNull android.net.Uri uri) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public final android.net.Uri canonicalize(@android.annotation.NonNull android.net.Uri uri) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public final android.database.Cursor query(@android.annotation.NonNull android.net.Uri uri, @android.annotation.Nullable java.lang.String[] projection, @android.annotation.Nullable java.lang.String selection, @android.annotation.Nullable java.lang.String[] selectionArgs, @android.annotation.Nullable java.lang.String sortOrder) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public final android.database.Cursor query(@android.annotation.NonNull android.net.Uri uri, @android.annotation.Nullable java.lang.String[] projection, @android.annotation.Nullable java.lang.String selection, @android.annotation.Nullable java.lang.String[] selectionArgs, @android.annotation.Nullable java.lang.String sortOrder, @android.annotation.Nullable android.os.CancellationSignal cancellationSignal) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public final android.net.Uri insert(@android.annotation.NonNull android.net.Uri uri, @android.annotation.NonNull android.content.ContentValues values) { throw new RuntimeException("Stub!"); }

public final int delete(@android.annotation.NonNull android.net.Uri uri, @android.annotation.Nullable java.lang.String selection, @android.annotation.Nullable java.lang.String[] selectionArgs) { throw new RuntimeException("Stub!"); }

public final int update(@android.annotation.NonNull android.net.Uri uri, @android.annotation.NonNull android.content.ContentValues values, @android.annotation.Nullable java.lang.String selection, @android.annotation.Nullable java.lang.String[] selectionArgs) { throw new RuntimeException("Stub!"); }
@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract static class CloudMediaSurfaceController {

public CloudMediaSurfaceController() { throw new RuntimeException("Stub!"); }

public abstract void onPlayerCreate();

public abstract void onPlayerRelease();

public abstract void onSurfaceCreated(int surfaceId, @android.annotation.NonNull android.view.Surface surface, @android.annotation.NonNull java.lang.String mediaId);

public abstract void onSurfaceChanged(int surfaceId, int format, int width, int height);

public abstract void onSurfaceDestroyed(int surfaceId);

public abstract void onMediaPlay(int surfaceId);

public abstract void onMediaPause(int surfaceId);

public abstract void onMediaSeekTo(int surfaceId, long timestampMillis);

public abstract void onConfigChange(@android.annotation.NonNull android.os.Bundle config);

public abstract void onDestroy();
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class CloudMediaSurfaceStateChangedCallback {

CloudMediaSurfaceStateChangedCallback() { throw new RuntimeException("Stub!"); }

public void setPlaybackState(int surfaceId, int playbackState, @android.annotation.Nullable android.os.Bundle playbackStateInfo) { throw new RuntimeException("Stub!"); }

public static final int PLAYBACK_STATE_BUFFERING = 1; // 0x1

public static final int PLAYBACK_STATE_COMPLETED = 5; // 0x5

public static final int PLAYBACK_STATE_ERROR_PERMANENT_FAILURE = 7; // 0x7

public static final int PLAYBACK_STATE_ERROR_RETRIABLE_FAILURE = 6; // 0x6

public static final int PLAYBACK_STATE_MEDIA_SIZE_CHANGED = 8; // 0x8

public static final int PLAYBACK_STATE_PAUSED = 4; // 0x4

public static final int PLAYBACK_STATE_READY = 2; // 0x2

public static final int PLAYBACK_STATE_STARTED = 3; // 0x3
}

}

