/*
 * Copyright (C) 2007 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.provider;

import android.os.Bundle;
import android.net.Uri;
import android.content.ContentResolver;
import android.os.CancellationSignal;
import java.io.IOException;
import android.os.ParcelFileDescriptor;
import android.content.Context;
import android.app.PendingIntent;
import java.util.List;
import java.util.Collection;
import android.graphics.Bitmap;
import android.content.ContentValues;
import android.content.ContentProvider;
import android.database.Cursor;
import android.util.Size;

/**
 * The contract between the media provider and applications. Contains
 * definitions for the supported URIs and columns.
 * <p>
 * The media provider provides an indexed collection of common media types, such
 * as {@link android.provider.MediaStore.Audio Audio}, {@link android.provider.MediaStore.Video Video}, and {@link android.provider.MediaStore.Images Images}, from any attached
 * storage devices. Each collection is organized based on the primary MIME type
 * of the underlying content; for example, {@code image/*} content is indexed
 * under {@link android.provider.MediaStore.Images Images}. The {@link android.provider.MediaStore.Files Files} collection provides a broad view
 * across all collections, and does not filter by MIME type.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class MediaStore {

public MediaStore() { throw new RuntimeException("Stub!"); }

/**
 * The maximum limit for the number of items that can be selected using
 * {@link android.provider.MediaStore#ACTION_PICK_IMAGES MediaStore#ACTION_PICK_IMAGES} when launched in multiple selection mode.
 * This can be used as a constant value for {@link android.provider.MediaStore#EXTRA_PICK_IMAGES_MAX MediaStore#EXTRA_PICK_IMAGES_MAX}.
 */

public static int getPickImagesMaxLimit() { throw new RuntimeException("Stub!"); }

/**
 * Update the given {@link android.net.Uri Uri} to also include any pending media items from
 * calls such as
 * {@link android.content.ContentResolver#query(android.net.Uri,java.lang.String[],android.os.Bundle,android.os.CancellationSignal) ContentResolver#query(Uri, String[], Bundle, CancellationSignal)}.
 * By default no pending items are returned.
 *
 * @see android.provider.MediaStore.MediaColumns#IS_PENDING
 * @deprecated consider migrating to {@link #QUERY_ARG_MATCH_PENDING} which
 *             is more expressive.
 
 * @param uri This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@Deprecated
@android.annotation.NonNull
public static android.net.Uri setIncludePending(@android.annotation.NonNull android.net.Uri uri) { throw new RuntimeException("Stub!"); }

/**
 * Update the given {@link android.net.Uri Uri} to indicate that the caller requires the
 * original file contents when calling
 * {@link android.content.ContentResolver#openFileDescriptor(android.net.Uri,java.lang.String) ContentResolver#openFileDescriptor(Uri, String)}.
 * <p>
 * This can be useful when the caller wants to ensure they're backing up the
 * exact bytes of the underlying media, without any Exif redaction being
 * performed.
 * <p>
 * If the original file contents cannot be provided, a
 * {@link java.lang.UnsupportedOperationException UnsupportedOperationException} will be thrown when the returned
 * {@link android.net.Uri Uri} is used, such as when the caller doesn't hold
 * {@link android.Manifest.permission#ACCESS_MEDIA_LOCATION}.
 *
 * @see android.provider.MediaStore#getRequireOriginal(Uri)
 
 * @param uri This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public static android.net.Uri setRequireOriginal(@android.annotation.NonNull android.net.Uri uri) { throw new RuntimeException("Stub!"); }

/**
 * Return if the caller requires the original file contents when calling
 * {@link android.content.ContentResolver#openFileDescriptor(android.net.Uri,java.lang.String) ContentResolver#openFileDescriptor(Uri, String)}.
 *
 * @see android.provider.MediaStore#setRequireOriginal(Uri)

 * @param uri This value cannot be {@code null}.
 */

public static boolean getRequireOriginal(@android.annotation.NonNull android.net.Uri uri) { throw new RuntimeException("Stub!"); }

/**
 * Returns {@link android.os.ParcelFileDescriptor ParcelFileDescriptor} representing the original media file format for
 * {@code fileDescriptor}.
 *
 * <p>Media files may get transcoded based on an application's media capabilities requirements.
 * However, in various cases, when the application needs access to the original media file, or
 * doesn't attempt to parse the actual byte contents of media files, such as playback using
 * {@link android.media.MediaPlayer MediaPlayer} or for off-device backup, this method can be useful.
 *
 * <p>This method is applicable only for media files managed by {@link android.provider.MediaStore MediaStore}.
 *
 * <p>The method returns the original file descriptor with the same permission that the caller
 * has for the input file descriptor.
 *
 * @throws java.io.IOException if the given {@link android.os.ParcelFileDescriptor ParcelFileDescriptor} could not be converted
 *
 * @see android.provider.MediaStore#EXTRA_ACCEPT_ORIGINAL_MEDIA_FORMAT
 
 * @param context This value cannot be {@code null}.
 * @param fileDescriptor This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public static android.os.ParcelFileDescriptor getOriginalMediaFormatFileDescriptor(@android.annotation.NonNull android.content.Context context, @android.annotation.NonNull android.os.ParcelFileDescriptor fileDescriptor) throws java.io.IOException { throw new RuntimeException("Stub!"); }

/**
 * Create a {@link android.app.PendingIntent PendingIntent} that will prompt the user to grant your
 * app write access for the requested media items.
 * <p>
 * This call only generates the request for a prompt; to display the prompt,
 * call {@link android.app.Activity#startIntentSenderForResult Activity#startIntentSenderForResult} with
 * {@link android.app.PendingIntent#getIntentSender() PendingIntent#getIntentSender()}. You can then determine if the
 * user granted your request by testing for {@link android.app.Activity#RESULT_OK Activity#RESULT_OK} in
 * {@link android.app.Activity#onActivityResult Activity#onActivityResult}. The requested operation will have
 * completely finished before this activity result is delivered.
 * <p>
 * Permissions granted through this mechanism are tied to the lifecycle of
 * the {@link android.app.Activity Activity} that requests them. If you need to retain
 * longer-term access for background actions, you can place items into a
 * {@link android.content.ClipData ClipData} or {@link android.content.Intent Intent} which can then be passed to
 * {@link android.content.Context#startService Context#startService} or
 * {@link android.app.job.JobInfo.Builder#setClipData}. Be sure to include
 * any relevant access modes you want to retain, such as
 * {@link android.content.Intent#FLAG_GRANT_WRITE_URI_PERMISSION Intent#FLAG_GRANT_WRITE_URI_PERMISSION}.
 * <p>
 * The displayed prompt will reflect all the media items you're requesting,
 * including those for which you already hold write access. If you want to
 * determine if you already hold write access before requesting access, use
 * {@link android.content.Context#checkUriPermission(android.net.Uri,int,int,int) Context#checkUriPermission(Uri, int, int, int)} with
 * {@link android.content.Intent#FLAG_GRANT_WRITE_URI_PERMISSION Intent#FLAG_GRANT_WRITE_URI_PERMISSION}.
 * <p>
 * For security and performance reasons this method does not support
 * {@link android.content.Intent#FLAG_GRANT_PERSISTABLE_URI_PERMISSION Intent#FLAG_GRANT_PERSISTABLE_URI_PERMISSION} or
 * {@link android.content.Intent#FLAG_GRANT_PREFIX_URI_PERMISSION Intent#FLAG_GRANT_PREFIX_URI_PERMISSION}.
 * <p>
 * The write access granted through this request is general-purpose, and
 * once obtained you can directly {@link android.content.ContentResolver#update ContentResolver#update} columns
 * like {@link android.provider.MediaStore.MediaColumns#IS_FAVORITE MediaColumns#IS_FAVORITE}, {@link android.provider.MediaStore.MediaColumns#IS_TRASHED MediaColumns#IS_TRASHED},
 * or {@link android.content.ContentResolver#delete ContentResolver#delete}.
 *
 * @param resolver Used to connect with {@link android.provider.MediaStore#AUTHORITY MediaStore#AUTHORITY}.
 *            Typically this value is {@link android.content.Context#getContentResolver() Context#getContentResolver()},
 *            but if you need more explicit lifecycle controls, you can
 *            obtain a {@link android.content.ContentProviderClient ContentProviderClient} and wrap it using
 *            {@link android.content.ContentResolver#wrap(android.content.ContentProviderClient) ContentResolver#wrap(ContentProviderClient)}.
 * This value cannot be {@code null}.
 * @param uris The set of media items to include in this request. Each item
 *            must be hosted by {@link android.provider.MediaStore#AUTHORITY MediaStore#AUTHORITY} and must
 *            reference a specific media item by {@link android.provider.BaseColumns#_ID BaseColumns#_ID}.
 
 * This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public static android.app.PendingIntent createWriteRequest(@android.annotation.NonNull android.content.ContentResolver resolver, @android.annotation.NonNull java.util.Collection<android.net.Uri> uris) { throw new RuntimeException("Stub!"); }

/**
 * Create a {@link android.app.PendingIntent PendingIntent} that will prompt the user to trash the
 * requested media items. When the user approves this request,
 * {@link android.provider.MediaStore.MediaColumns#IS_TRASHED MediaColumns#IS_TRASHED} is set on these items.
 * <p>
 * This call only generates the request for a prompt; to display the prompt,
 * call {@link android.app.Activity#startIntentSenderForResult Activity#startIntentSenderForResult} with
 * {@link android.app.PendingIntent#getIntentSender() PendingIntent#getIntentSender()}. You can then determine if the
 * user granted your request by testing for {@link android.app.Activity#RESULT_OK Activity#RESULT_OK} in
 * {@link android.app.Activity#onActivityResult Activity#onActivityResult}. The requested operation will have
 * completely finished before this activity result is delivered.
 * <p>
 * The displayed prompt will reflect all the media items you're requesting,
 * including those for which you already hold write access. If you want to
 * determine if you already hold write access before requesting access, use
 * {@link android.content.Context#checkUriPermission(android.net.Uri,int,int,int) Context#checkUriPermission(Uri, int, int, int)} with
 * {@link android.content.Intent#FLAG_GRANT_WRITE_URI_PERMISSION Intent#FLAG_GRANT_WRITE_URI_PERMISSION}.
 *
 * @param resolver Used to connect with {@link android.provider.MediaStore#AUTHORITY MediaStore#AUTHORITY}.
 *            Typically this value is {@link android.content.Context#getContentResolver() Context#getContentResolver()},
 *            but if you need more explicit lifecycle controls, you can
 *            obtain a {@link android.content.ContentProviderClient ContentProviderClient} and wrap it using
 *            {@link android.content.ContentResolver#wrap(android.content.ContentProviderClient) ContentResolver#wrap(ContentProviderClient)}.
 * This value cannot be {@code null}.
 * @param uris The set of media items to include in this request. Each item
 *            must be hosted by {@link android.provider.MediaStore#AUTHORITY MediaStore#AUTHORITY} and must
 *            reference a specific media item by {@link android.provider.BaseColumns#_ID BaseColumns#_ID}.
 * This value cannot be {@code null}.
 * @param value The {@link android.provider.MediaStore.MediaColumns#IS_TRASHED MediaColumns#IS_TRASHED} value to apply.
 * @see android.provider.MediaStore.MediaColumns#IS_TRASHED
 * @see android.provider.MediaStore#QUERY_ARG_MATCH_TRASHED
 
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public static android.app.PendingIntent createTrashRequest(@android.annotation.NonNull android.content.ContentResolver resolver, @android.annotation.NonNull java.util.Collection<android.net.Uri> uris, boolean value) { throw new RuntimeException("Stub!"); }

/**
 * Create a {@link android.app.PendingIntent PendingIntent} that will prompt the user to favorite the
 * requested media items. When the user approves this request,
 * {@link android.provider.MediaStore.MediaColumns#IS_FAVORITE MediaColumns#IS_FAVORITE} is set on these items.
 * <p>
 * This call only generates the request for a prompt; to display the prompt,
 * call {@link android.app.Activity#startIntentSenderForResult Activity#startIntentSenderForResult} with
 * {@link android.app.PendingIntent#getIntentSender() PendingIntent#getIntentSender()}. You can then determine if the
 * user granted your request by testing for {@link android.app.Activity#RESULT_OK Activity#RESULT_OK} in
 * {@link android.app.Activity#onActivityResult Activity#onActivityResult}. The requested operation will have
 * completely finished before this activity result is delivered.
 * <p>
 * The displayed prompt will reflect all the media items you're requesting,
 * including those for which you already hold write access. If you want to
 * determine if you already hold write access before requesting access, use
 * {@link android.content.Context#checkUriPermission(android.net.Uri,int,int,int) Context#checkUriPermission(Uri, int, int, int)} with
 * {@link android.content.Intent#FLAG_GRANT_WRITE_URI_PERMISSION Intent#FLAG_GRANT_WRITE_URI_PERMISSION}.
 *
 * @param resolver Used to connect with {@link android.provider.MediaStore#AUTHORITY MediaStore#AUTHORITY}.
 *            Typically this value is {@link android.content.Context#getContentResolver() Context#getContentResolver()},
 *            but if you need more explicit lifecycle controls, you can
 *            obtain a {@link android.content.ContentProviderClient ContentProviderClient} and wrap it using
 *            {@link android.content.ContentResolver#wrap(android.content.ContentProviderClient) ContentResolver#wrap(ContentProviderClient)}.
 * This value cannot be {@code null}.
 * @param uris The set of media items to include in this request. Each item
 *            must be hosted by {@link android.provider.MediaStore#AUTHORITY MediaStore#AUTHORITY} and must
 *            reference a specific media item by {@link android.provider.BaseColumns#_ID BaseColumns#_ID}.
 * This value cannot be {@code null}.
 * @param value The {@link android.provider.MediaStore.MediaColumns#IS_FAVORITE MediaColumns#IS_FAVORITE} value to apply.
 * @see android.provider.MediaStore.MediaColumns#IS_FAVORITE
 * @see android.provider.MediaStore#QUERY_ARG_MATCH_FAVORITE
 
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public static android.app.PendingIntent createFavoriteRequest(@android.annotation.NonNull android.content.ContentResolver resolver, @android.annotation.NonNull java.util.Collection<android.net.Uri> uris, boolean value) { throw new RuntimeException("Stub!"); }

/**
 * Create a {@link android.app.PendingIntent PendingIntent} that will prompt the user to permanently
 * delete the requested media items. When the user approves this request,
 * {@link android.content.ContentResolver#delete ContentResolver#delete} will be called on these items.
 * <p>
 * This call only generates the request for a prompt; to display the prompt,
 * call {@link android.app.Activity#startIntentSenderForResult Activity#startIntentSenderForResult} with
 * {@link android.app.PendingIntent#getIntentSender() PendingIntent#getIntentSender()}. You can then determine if the
 * user granted your request by testing for {@link android.app.Activity#RESULT_OK Activity#RESULT_OK} in
 * {@link android.app.Activity#onActivityResult Activity#onActivityResult}. The requested operation will have
 * completely finished before this activity result is delivered.
 * <p>
 * The displayed prompt will reflect all the media items you're requesting,
 * including those for which you already hold write access. If you want to
 * determine if you already hold write access before requesting access, use
 * {@link android.content.Context#checkUriPermission(android.net.Uri,int,int,int) Context#checkUriPermission(Uri, int, int, int)} with
 * {@link android.content.Intent#FLAG_GRANT_WRITE_URI_PERMISSION Intent#FLAG_GRANT_WRITE_URI_PERMISSION}.
 *
 * @param resolver Used to connect with {@link android.provider.MediaStore#AUTHORITY MediaStore#AUTHORITY}.
 *            Typically this value is {@link android.content.Context#getContentResolver() Context#getContentResolver()},
 *            but if you need more explicit lifecycle controls, you can
 *            obtain a {@link android.content.ContentProviderClient ContentProviderClient} and wrap it using
 *            {@link android.content.ContentResolver#wrap(android.content.ContentProviderClient) ContentResolver#wrap(ContentProviderClient)}.
 * This value cannot be {@code null}.
 * @param uris The set of media items to include in this request. Each item
 *            must be hosted by {@link android.provider.MediaStore#AUTHORITY MediaStore#AUTHORITY} and must
 *            reference a specific media item by {@link android.provider.BaseColumns#_ID BaseColumns#_ID}.
 
 * This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public static android.app.PendingIntent createDeleteRequest(@android.annotation.NonNull android.content.ContentResolver resolver, @android.annotation.NonNull java.util.Collection<android.net.Uri> uris) { throw new RuntimeException("Stub!"); }

/**
 * Return list of all specific volume names that make up
 * {@link #VOLUME_EXTERNAL}. This includes a unique volume name for each
 * shared storage device that is currently attached, which typically
 * includes {@link android.provider.MediaStore#VOLUME_EXTERNAL_PRIMARY MediaStore#VOLUME_EXTERNAL_PRIMARY}.
 * <p>
 * Each specific volume name can be passed to APIs like
 * {@link android.provider.MediaStore.Images.Media#getContentUri(java.lang.String) MediaStore.Images.Media#getContentUri(String)} to interact with
 * media on that storage device.
 
 * @param context This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public static java.util.Set<java.lang.String> getExternalVolumeNames(@android.annotation.NonNull android.content.Context context) { throw new RuntimeException("Stub!"); }

/**
 * Return list of all recent volume names that have been part of
 * {@link #VOLUME_EXTERNAL}.
 * <p>
 * These volume names are not currently mounted, but they're likely to
 * reappear in the future, so apps are encouraged to preserve any indexed
 * metadata related to these volumes to optimize user experiences.
 * <p>
 * Each specific volume name can be passed to APIs like
 * {@link android.provider.MediaStore.Images.Media#getContentUri(java.lang.String) MediaStore.Images.Media#getContentUri(String)} to interact with
 * media on that storage device.
 
 * @param context This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public static java.util.Set<java.lang.String> getRecentExternalVolumeNames(@android.annotation.NonNull android.content.Context context) { throw new RuntimeException("Stub!"); }

/**
 * Return the volume name that the given {@link android.net.Uri Uri} references.
 
 * @param uri This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public static java.lang.String getVolumeName(@android.annotation.NonNull android.net.Uri uri) { throw new RuntimeException("Stub!"); }

/**
 * Uri for querying the state of the media scanner.
 */

public static android.net.Uri getMediaScannerUri() { throw new RuntimeException("Stub!"); }

/**
 * Return an opaque version string describing the {@link android.provider.MediaStore MediaStore} state.
 * <p>
 * Applications that import data from {@link android.provider.MediaStore MediaStore} into their own
 * caches can use this to detect that {@link android.provider.MediaStore MediaStore} has undergone
 * substantial changes, and that data should be rescanned.
 * <p>
 * No other assumptions should be made about the meaning of the version.
 * <p>
 * This method returns the version for
 * {@link android.provider.MediaStore#VOLUME_EXTERNAL_PRIMARY MediaStore#VOLUME_EXTERNAL_PRIMARY}; to obtain a version for a
 * different volume, use {@link #getVersion(android.content.Context,java.lang.String)}.
 
 * @param context This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public static java.lang.String getVersion(@android.annotation.NonNull android.content.Context context) { throw new RuntimeException("Stub!"); }

/**
 * Return an opaque version string describing the {@link android.provider.MediaStore MediaStore} state.
 * <p>
 * Applications that import data from {@link android.provider.MediaStore MediaStore} into their own
 * caches can use this to detect that {@link android.provider.MediaStore MediaStore} has undergone
 * substantial changes, and that data should be rescanned.
 * <p>
 * No other assumptions should be made about the meaning of the version.
 *
 * @param volumeName specific volume to obtain an opaque version string for.
 *            Must be one of the values returned from
 *            {@link #getExternalVolumeNames(android.content.Context)}.
 
 * This value cannot be {@code null}.
 * @param context This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public static java.lang.String getVersion(@android.annotation.NonNull android.content.Context context, @android.annotation.NonNull java.lang.String volumeName) { throw new RuntimeException("Stub!"); }

/**
 * Return the latest generation value for the given volume.
 * <p>
 * Generation numbers are useful for apps that are attempting to quickly
 * identify exactly which media items have been added or changed since a
 * previous point in time. Generation numbers are monotonically increasing
 * over time, and can be safely arithmetically compared.
 * <p>
 * Detecting media changes using generation numbers is more robust than
 * using {@link android.provider.MediaStore.MediaColumns#DATE_ADDED MediaColumns#DATE_ADDED} or
 * {@link android.provider.MediaStore.MediaColumns#DATE_MODIFIED MediaColumns#DATE_MODIFIED}, since those values may change in
 * unexpected ways when apps use {@link java.io.File#setLastModified(long) File#setLastModified(long)} or when
 * the system clock is set incorrectly.
 * <p>
 * Note that before comparing these detailed generation values, you should
 * first confirm that the overall version hasn't changed by checking
 * {@link android.provider.MediaStore#getVersion(android.content.Context,java.lang.String) MediaStore#getVersion(Context, String)}, since that indicates when
 * a more radical change has occurred. If the overall version changes, you
 * should assume that generation numbers have been reset and perform a full
 * synchronization pass.
 *
 * @param volumeName specific volume to obtain an generation value for. Must
 *            be one of the values returned from
 *            {@link #getExternalVolumeNames(android.content.Context)}.
 * This value cannot be {@code null}.
 * @see android.provider.MediaStore.MediaColumns#GENERATION_ADDED
 * @see android.provider.MediaStore.MediaColumns#GENERATION_MODIFIED
 
 * @param context This value cannot be {@code null}.
 */

public static long getGeneration(@android.annotation.NonNull android.content.Context context, @android.annotation.NonNull java.lang.String volumeName) { throw new RuntimeException("Stub!"); }

/**
 * Return a {@link android.provider.DocumentsProvider DocumentsProvider} Uri that is an equivalent to the given
 * {@link android.provider.MediaStore MediaStore} Uri.
 * <p>
 * This allows apps with Storage Access Framework permissions to convert
 * between {@link android.provider.MediaStore MediaStore} and {@link android.provider.DocumentsProvider DocumentsProvider} Uris that refer
 * to the same underlying item. Note that this method doesn't grant any new
 * permissions; callers must already hold permissions obtained with
 * {@link android.content.Intent#ACTION_OPEN_DOCUMENT Intent#ACTION_OPEN_DOCUMENT} or related APIs.
 *
 * @param mediaUri The {@link android.provider.MediaStore MediaStore} Uri to convert.
 * This value cannot be {@code null}.
 * @param context This value cannot be {@code null}.
 * @return An equivalent {@link android.provider.DocumentsProvider DocumentsProvider} Uri. Returns {@code null}
 *         if no equivalent was found.
 * @see #getMediaUri(Context, Uri)
 */

@android.annotation.Nullable
public static android.net.Uri getDocumentUri(@android.annotation.NonNull android.content.Context context, @android.annotation.NonNull android.net.Uri mediaUri) { throw new RuntimeException("Stub!"); }

/**
 * Return a {@link android.provider.MediaStore MediaStore} Uri that is an equivalent to the given
 * {@link android.provider.DocumentsProvider DocumentsProvider} Uri. This only supports {@code ExternalStorageProvider}
 * and {@code MediaDocumentsProvider} Uris.
 * <p>
 * This allows apps with Storage Access Framework permissions to convert
 * between {@link android.provider.MediaStore MediaStore} and {@link android.provider.DocumentsProvider DocumentsProvider} Uris that refer
 * to the same underlying item.
 * Note that this method doesn't grant any new permissions, but it grants the same access to
 * the Media Store Uri as the caller has to the given DocumentsProvider Uri; callers must
 * already hold permissions for documentUri obtained with {@link android.content.Intent#ACTION_OPEN_DOCUMENT Intent#ACTION_OPEN_DOCUMENT}
 * or related APIs.
 *
 * @param documentUri The {@link android.provider.DocumentsProvider DocumentsProvider} Uri to convert.
 * This value cannot be {@code null}.
 * @param context This value cannot be {@code null}.
 * @return An equivalent {@link android.provider.MediaStore MediaStore} Uri. Returns {@code null} if no
 *         equivalent was found.
 * @see #getDocumentUri(Context, Uri)
 */

@android.annotation.Nullable
public static android.net.Uri getMediaUri(@android.annotation.NonNull android.content.Context context, @android.annotation.NonNull android.net.Uri documentUri) { throw new RuntimeException("Stub!"); }

/**
 * Returns true if the given application is the current system gallery of the device.
 * <p>
 * The system gallery is one app chosen by the OEM that has read & write access to all photos
 * and videos on the device and control over folders in media collections.
 *
 * @param resolver The {@link android.content.ContentResolver ContentResolver} used to connect with
 * {@link android.provider.MediaStore#AUTHORITY MediaStore#AUTHORITY}. Typically this value is {@link android.content.Context#getContentResolver() Context#getContentResolver()}.
 * This value cannot be {@code null}.
 * @param uid The uid to be checked if it is the current system gallery.
 * @param packageName The package name to be checked if it is the current system gallery.

 * This value cannot be {@code null}.
 */

public static boolean isCurrentSystemGallery(@android.annotation.NonNull android.content.ContentResolver resolver, int uid, @android.annotation.NonNull java.lang.String packageName) { throw new RuntimeException("Stub!"); }

/**
 * Returns an EXIF redacted version of {@code uri} i.e. a {@link android.net.Uri Uri} with metadata such as
 * location, GPS datestamp etc. redacted from the EXIF headers.
 * <p>
 * A redacted Uri can be used to share a file with another application wherein exposing
 * sensitive information in EXIF headers is not desirable.
 * Note:
 * 1. Redacted uris cannot be granted write access and can neither be used to perform any kind
 * of write operations.
 * 2. To get a redacted uri the caller must hold read permission to {@code uri}.
 *
 * @param resolver The {@link android.content.ContentResolver ContentResolver} used to connect with
 * {@link android.provider.MediaStore#AUTHORITY MediaStore#AUTHORITY}. Typically this value is gotten from
 * {@link android.content.Context#getContentResolver() Context#getContentResolver()}
 * This value cannot be {@code null}.
 * @param uri the {@link android.net.Uri Uri} Uri to convert
 * This value cannot be {@code null}.
 * @return redacted version of the {@code uri}. Returns {@code null} when the given
 * {@link android.net.Uri Uri} could not be found or is unsupported
 * @throws java.lang.SecurityException if the caller doesn't have the read access to {@code uri}
 * @see #getRedactedUri(ContentResolver, List)
 */

@android.annotation.Nullable
public static android.net.Uri getRedactedUri(@android.annotation.NonNull android.content.ContentResolver resolver, @android.annotation.NonNull android.net.Uri uri) { throw new RuntimeException("Stub!"); }

/**
 * Returns a list of EXIF redacted version of {@code uris} i.e. a {@link android.net.Uri Uri} with metadata
 * such as location, GPS datestamp etc. redacted from the EXIF headers.
 * <p>
 * A redacted Uri can be used to share a file with another application wherein exposing
 * sensitive information in EXIF headers is not desirable.
 * Note:
 * 1. Order of the returned uris follow the order of the {@code uris}.
 * 2. Redacted uris cannot be granted write access and can neither be used to perform any kind
 * of write operations.
 * 3. To get a redacted uri the caller must hold read permission to its corresponding uri.
 *
 * @param resolver The {@link android.content.ContentResolver ContentResolver} used to connect with
 * {@link android.provider.MediaStore#AUTHORITY MediaStore#AUTHORITY}. Typically this value is gotten from
 * {@link android.content.Context#getContentResolver() Context#getContentResolver()}
 * This value cannot be {@code null}.
 * @param uris the list of {@link android.net.Uri Uri} Uri to convert
 * This value cannot be {@code null}.
 * @return a list with redacted version of {@code uris}, in the same order. Returns {@code null}
 * when the corresponding {@link android.net.Uri Uri} could not be found or is unsupported
 * @throws java.lang.SecurityException if the caller doesn't have the read access to all the elements
 * in {@code uris}
 * @throws java.lang.IllegalArgumentException if all the uris in {@code uris} don't belong to same user id
 * @see #getRedactedUri(ContentResolver, Uri)
 */

@android.annotation.NonNull
public static java.util.List<android.net.Uri> getRedactedUri(@android.annotation.NonNull android.content.ContentResolver resolver, @android.annotation.NonNull java.util.List<android.net.Uri> uris) { throw new RuntimeException("Stub!"); }

/**
 * Returns whether the calling app is granted {@link android.Manifest.permission#MANAGE_MEDIA}
 * or not.
 * <p>Declaring the permission {@link android.Manifest.permission#MANAGE_MEDIA} isn't
 * enough to gain the access.
 * <p>To request access, use {@link android.provider.Settings#ACTION_REQUEST_MANAGE_MEDIA}.
 *
 * @param context the request context
 * This value cannot be {@code null}.
 * @return true, the calling app is granted the permission. Otherwise, false
 *
 * @see android.Manifest.permission#MANAGE_MEDIA
 * @see android.provider.Settings#ACTION_REQUEST_MANAGE_MEDIA
 * @see #createDeleteRequest(ContentResolver, Collection)
 * @see #createTrashRequest(ContentResolver, Collection, boolean)
 * @see #createWriteRequest(ContentResolver, Collection)
 */

public static boolean canManageMedia(@android.annotation.NonNull android.content.Context context) { throw new RuntimeException("Stub!"); }

/**
 * Returns {@code true} if and only if the caller with {@code authority} is the currently
 * enabled {@link android.provider.CloudMediaProvider CloudMediaProvider}. More specifically, {@code false} is also returned
 * if the calling uid doesn't match the uid of the {@code authority}.
 *
 * @see android.provider.CloudMediaProvider
 * @see #isSupportedCloudMediaProviderAuthority(ContentResolver, String)
 
 * @param resolver This value cannot be {@code null}.

 * @param authority This value cannot be {@code null}.
 */

public static boolean isCurrentCloudMediaProviderAuthority(@android.annotation.NonNull android.content.ContentResolver resolver, @android.annotation.NonNull java.lang.String authority) { throw new RuntimeException("Stub!"); }

/**
 * Returns {@code true} if and only if the caller with {@code authority} is a supported
 * {@link android.provider.CloudMediaProvider CloudMediaProvider}. More specifically, {@code false} is also returned
 * if the calling uid doesn't match the uid of the {@code authority}.
 *
 * @see android.provider.CloudMediaProvider
 * @see #isCurrentCloudMediaProviderAuthority(ContentResolver, String)
 
 * @param resolver This value cannot be {@code null}.

 * @param authority This value cannot be {@code null}.
 */

public static boolean isSupportedCloudMediaProviderAuthority(@android.annotation.NonNull android.content.ContentResolver resolver, @android.annotation.NonNull java.lang.String authority) { throw new RuntimeException("Stub!"); }

/**
 * Notifies the OS about a cloud media event requiring a full or incremental media collection
 * sync for the currently enabled cloud provider, {@code authority}.
 *
 * The OS will schedule the sync in the background and will attempt to batch frequent
 * notifications into a single sync event.
 *
 * If the caller is not the currently enabled cloud provider as returned by
 * {@link #isCurrentCloudMediaProviderAuthority(android.content.ContentResolver,java.lang.String)}, the request will be
 * unsuccessful.
 *
 * @throws java.lang.SecurityException if the request was unsuccessful.

 * @param resolver This value cannot be {@code null}.
 
 * @param authority This value cannot be {@code null}.

 * @param currentMediaCollectionId This value cannot be {@code null}.
 */

public static void notifyCloudMediaChangedEvent(@android.annotation.NonNull android.content.ContentResolver resolver, @android.annotation.NonNull java.lang.String authority, @android.annotation.NonNull java.lang.String currentMediaCollectionId) throws java.lang.SecurityException { throw new RuntimeException("Stub!"); }

/**
 * Standard Intent action that can be sent to have the camera application
 * capture an image and return it.
 * <p>
 * The caller may pass an extra EXTRA_OUTPUT to control where this image will be written.
 * If the EXTRA_OUTPUT is not present, then a small sized image is returned as a Bitmap
 * object in the extra field. This is useful for applications that only need a small image.
 * If the EXTRA_OUTPUT is present, then the full-sized image will be written to the Uri
 * value of EXTRA_OUTPUT.
 * As of {@link android.os.Build.VERSION_CODES#LOLLIPOP}, this uri can also be supplied through
 * {@link android.content.Intent#setClipData(ClipData)}. If using this approach, you still must
 * supply the uri through the EXTRA_OUTPUT field for compatibility with old applications.
 * If you don't set a ClipData, it will be copied there for you when calling
 * {@link android.content.Context#startActivity(android.content.Intent) Context#startActivity(Intent)}.
 * <p>
 * Regardless of whether or not EXTRA_OUTPUT is present, when an image is captured via this
 * intent, {@link android.hardware.Camera#ACTION_NEW_PICTURE} won't be broadcasted.
 * <p>
 * Note: if you app targets {@link android.os.Build.VERSION_CODES#M M} and above
 * and declares as using the {@link android.Manifest.permission#CAMERA} permission which
 * is not granted, then attempting to use this action will result in a {@link
 * java.lang.SecurityException}.
 *
 *  @see #EXTRA_OUTPUT
 *  @see android.hardware.Camera#ACTION_NEW_PICTURE
 */

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String ACTION_IMAGE_CAPTURE = "android.media.action.IMAGE_CAPTURE";

/**
 * Intent action that can be sent to have the camera application capture an image and return
 * it when the device is secured (e.g.&nbsp;with a pin, password, pattern, or face unlock).
 * Applications responding to this intent must not expose any personal content like existing
 * photos or videos on the device. The applications should be careful not to share any photo
 * or video with other applications or Internet. The activity should use {@link android.app.Activity#setShowWhenLocked  } to display on top of the
 * lock screen while secured. There is no activity stack when this flag is used, so
 * launching more than one activity is strongly discouraged.
 * <p>
 * The caller may pass an extra EXTRA_OUTPUT to control where this image will be written.
 * If the EXTRA_OUTPUT is not present, then a small sized image is returned as a Bitmap
 * object in the extra field. This is useful for applications that only need a small image.
 * If the EXTRA_OUTPUT is present, then the full-sized image will be written to the Uri
 * value of EXTRA_OUTPUT.
 * As of {@link android.os.Build.VERSION_CODES#LOLLIPOP}, this uri can also be supplied through
 * {@link android.content.Intent#setClipData(ClipData)}. If using this approach, you still must
 * supply the uri through the EXTRA_OUTPUT field for compatibility with old applications.
 * If you don't set a ClipData, it will be copied there for you when calling
 * {@link android.content.Context#startActivity(android.content.Intent) Context#startActivity(Intent)}.
 * <p>
 * Regardless of whether or not EXTRA_OUTPUT is present, when an image is captured via this
 * intent, {@link android.hardware.Camera#ACTION_NEW_PICTURE} won't be broadcasted.
 *
 * @see #ACTION_IMAGE_CAPTURE
 * @see #EXTRA_OUTPUT
 * @see android.hardware.Camera#ACTION_NEW_PICTURE
 */

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String ACTION_IMAGE_CAPTURE_SECURE = "android.media.action.IMAGE_CAPTURE_SECURE";

/**
 * Activity Action: Allow the user to select images or videos provided by
 * system and return it. This is different than {@link android.content.Intent#ACTION_PICK Intent#ACTION_PICK}
 * and {@link android.content.Intent#ACTION_GET_CONTENT Intent#ACTION_GET_CONTENT} in that
 * <ul>
 * <li> the data for this action is provided by the system
 * <li> this action is only used for picking images and videos
 * <li> caller gets read access to user picked items even without storage
 * permissions
 * </ul>
 * <p>
 * Callers can optionally specify MIME type (such as {@code image/*} or
 * {@code video/*}), resulting in a range of content selection that the
 * caller is interested in. The optional MIME type can be requested with
 * {@link android.content.Intent#setType(java.lang.String) Intent#setType(String)}.
 * <p>
 * If the caller needs multiple returned items (or caller wants to allow
 * multiple selection), then it can specify
 * {@link android.provider.MediaStore#EXTRA_PICK_IMAGES_MAX MediaStore#EXTRA_PICK_IMAGES_MAX} to indicate this.
 * <p>
 * When the caller requests multiple selection, the value of
 * {@link android.provider.MediaStore#EXTRA_PICK_IMAGES_MAX MediaStore#EXTRA_PICK_IMAGES_MAX} must be a positive integer
 * greater than 1 and less than or equal to
 * {@link android.provider.MediaStore#getPickImagesMaxLimit MediaStore#getPickImagesMaxLimit}, otherwise
 * {@link android.app.Activity#RESULT_CANCELED Activity#RESULT_CANCELED} is returned.
 * <p>
 * Callers may use {@link android.content.Intent#EXTRA_LOCAL_ONLY Intent#EXTRA_LOCAL_ONLY} to limit content
 * selection to local data.
 * <p>
 * Output: MediaStore content URI(s) of the item(s) that was picked.
 * Unlike other MediaStore URIs, these are referred to as 'picker' URIs and
 * expose a limited set of read-only operations. Specifically, picker URIs
 * can only be opened for read and queried for columns in {@link android.provider.MediaStore.PickerMediaColumns PickerMediaColumns}.
 * <p>
 * Before this API, apps could use {@link android.content.Intent#ACTION_GET_CONTENT Intent#ACTION_GET_CONTENT}. However,
 * {@link #ACTION_PICK_IMAGES} is now the recommended option for images and videos,
 * since it offers a better user experience.
 */

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String ACTION_PICK_IMAGES = "android.provider.action.PICK_IMAGES";

/**
 * Activity Action: Launch settings controlling images or videos selection with
 * {@link #ACTION_PICK_IMAGES}.
 *
 * The settings page allows a user to change the enabled {@link android.provider.CloudMediaProvider CloudMediaProvider} on the
 * device and other media selection configurations.
 *
 * @see #ACTION_PICK_IMAGES
 * @see #isCurrentCloudMediaProviderAuthority(ContentResolver, String)
 */

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String ACTION_PICK_IMAGES_SETTINGS = "android.provider.action.PICK_IMAGES_SETTINGS";

/**
 * Standard action that can be sent to review the given media file.
 * <p>
 * The launched application is expected to provide a large-scale view of the
 * given media file, while allowing the user to quickly access other
 * recently captured media files.
 * <p>
 * Input: {@link android.content.Intent#getData Intent#getData} is URI of the primary media item to
 * initially display.
 *
 * @see #ACTION_REVIEW_SECURE
 * @see #EXTRA_BRIGHTNESS
 */

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String ACTION_REVIEW = "android.provider.action.REVIEW";

/**
 * Standard action that can be sent to review the given media file when the
 * device is secured (e.g.&nbsp;with a pin, password, pattern, or face unlock).
 * The applications should be careful not to share any media with other
 * applications or Internet. The activity should use
 * {@link android.app.Activity#setShowWhenLocked Activity#setShowWhenLocked} to display on top of the lock screen
 * while secured. There is no activity stack when this flag is used, so
 * launching more than one activity is strongly discouraged.
 * <p>
 * The launched application is expected to provide a large-scale view of the
 * given primary media file, while only allowing the user to quickly access
 * other media from an explicit secondary list.
 * <p>
 * Input: {@link android.content.Intent#getData Intent#getData} is URI of the primary media item to
 * initially display. {@link android.content.Intent#getClipData Intent#getClipData} is the limited list of
 * secondary media items that the user is allowed to review. If
 * {@link android.content.Intent#getClipData Intent#getClipData} is undefined, then no other media access
 * should be allowed.
 *
 * @see #EXTRA_BRIGHTNESS
 */

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String ACTION_REVIEW_SECURE = "android.provider.action.REVIEW_SECURE";

/**
 * Standard Intent action that can be sent to have the camera application
 * capture a video and return it.
 * <p>
 * The caller may pass in an extra EXTRA_VIDEO_QUALITY to control the video quality.
 * <p>
 * The caller may pass in an extra EXTRA_OUTPUT to control
 * where the video is written.
 * <ul>
 * <li>If EXTRA_OUTPUT is not present, the video will be written to the standard location
 * for videos, and the Uri of that location will be returned in the data field of the Uri.
 * {@link android.hardware.Camera#ACTION_NEW_VIDEO} will also be broadcasted when the video
 * is recorded.
 * <li>If EXTRA_OUTPUT is assigned a Uri value, no
 * {@link android.hardware.Camera#ACTION_NEW_VIDEO} will be broadcasted. As of
 * {@link android.os.Build.VERSION_CODES#LOLLIPOP}, this uri can also be
 * supplied through {@link android.content.Intent#setClipData(ClipData)}.  If using this
 * approach, you still must supply the uri through the EXTRA_OUTPUT field for compatibility
 * with old applications. If you don't set a ClipData, it will be copied there for you when
 * calling {@link android.content.Context#startActivity(android.content.Intent) Context#startActivity(Intent)}.
 * </ul>
 *
 * <p>Note: if you app targets {@link android.os.Build.VERSION_CODES#M M} and above
 * and declares as using the {@link android.Manifest.permission#CAMERA} permission which
 * is not granted, then atempting to use this action will result in a {@link
 * java.lang.SecurityException}.
 *
 * @see #EXTRA_OUTPUT
 * @see #EXTRA_VIDEO_QUALITY
 * @see #EXTRA_SIZE_LIMIT
 * @see #EXTRA_DURATION_LIMIT
 * @see android.hardware.Camera#ACTION_NEW_VIDEO
 */

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String ACTION_VIDEO_CAPTURE = "android.media.action.VIDEO_CAPTURE";

/** The authority for the media provider */

public static final java.lang.String AUTHORITY = "media";

/** A content:// style uri to the authority for the media provider */

@android.annotation.NonNull public static final android.net.Uri AUTHORITY_URI;
static { AUTHORITY_URI = null; }

/**
 * Specify that the caller wants to receive the original media format without transcoding.
 *
 * <b>Caution: using this flag can cause app
 * compatibility issues whenever Android adds support for new media formats.</b>
 * Clients should instead specify their supported media capabilities explicitly
 * in their manifest or with the {@link #EXTRA_MEDIA_CAPABILITIES} {@code open} flag.
 *
 * This option is useful for apps that don't attempt to parse the actual byte contents of media
 * files, such as playback using {@link android.media.MediaPlayer MediaPlayer} or for off-device backup. Note that the
 * {@link android.Manifest.permission#ACCESS_MEDIA_LOCATION} permission will still be required
 * to avoid sensitive metadata redaction, similar to {@link #setRequireOriginal(android.net.Uri)}.
 * </ul>
 *
 * Note that this flag overrides any explicitly declared {@code media_capabilities.xml} or
 * {@link android.media.ApplicationMediaCapabilities ApplicationMediaCapabilities} extras specified in the same {@code open} request.
 *
 * <p>This option can be added to the {@code opts} {@link android.os.Bundle Bundle} in various
 * {@link android.content.ContentResolver ContentResolver} {@code open} methods.
 *
 * @see android.content.ContentResolver#openTypedAssetFileDescriptor(Uri, String, Bundle)
 * @see android.content.ContentResolver#openTypedAssetFile(Uri, String, Bundle, CancellationSignal)
 * @see #setRequireOriginal(Uri)
 * @see android.provider.MediaStore#getOriginalMediaFormatFileDescriptor(Context, ParcelFileDescriptor)
 */

public static final java.lang.String EXTRA_ACCEPT_ORIGINAL_MEDIA_FORMAT = "android.provider.extra.ACCEPT_ORIGINAL_MEDIA_FORMAT";

/**
 * When defined, the launched application is requested to set the given
 * brightness value via
 * {@link android.view.WindowManager.LayoutParams#screenBrightness} to help
 * ensure a smooth transition when launching {@link #ACTION_REVIEW} or
 * {@link #ACTION_REVIEW_SECURE} intents.
 */

public static final java.lang.String EXTRA_BRIGHTNESS = "android.provider.extra.BRIGHTNESS";

/**
 * Specify the maximum allowed recording duration in seconds.
 */

public static final java.lang.String EXTRA_DURATION_LIMIT = "android.intent.extra.durationLimit";

/**
 * The name of the Intent-extra used to control the onCompletion behavior of a MovieView.
 * This is a boolean property that specifies whether or not to finish the MovieView activity
 * when the movie completes playing. The default value is true, which means to automatically
 * exit the movie player activity when the movie completes playing.
 */

public static final java.lang.String EXTRA_FINISH_ON_COMPLETION = "android.intent.extra.finishOnCompletion";

/**
 * The name of an Intent-extra used to control the UI of a ViewImage.
 * This is a boolean property that overrides the activity's default fullscreen state.
 */

public static final java.lang.String EXTRA_FULL_SCREEN = "android.intent.extra.fullScreen";

/**
 * The name of the Intent-extra used to define the album
 */

public static final java.lang.String EXTRA_MEDIA_ALBUM = "android.intent.extra.album";

/**
 * The name of the Intent-extra used to define the artist
 */

public static final java.lang.String EXTRA_MEDIA_ARTIST = "android.intent.extra.artist";

/**
 * Specify the {@link android.media.ApplicationMediaCapabilities ApplicationMediaCapabilities} that should be used while opening a media.
 *
 * If the capabilities specified matches the format of the original file, the app will receive
 * the original file, otherwise, it will get transcoded to a default supported format.
 *
 * This flag takes higher precedence over the applications declared
 * {@code media_capabilities.xml} and is useful for apps that want to have more granular control
 * over their supported media capabilities.
 *
 * <p>This option can be added to the {@code opts} {@link android.os.Bundle Bundle} in various
 * {@link android.content.ContentResolver ContentResolver} {@code open} methods.
 *
 * @see android.content.ContentResolver#openTypedAssetFileDescriptor(Uri, String, Bundle)
 * @see android.content.ContentResolver#openTypedAssetFile(Uri, String, Bundle, CancellationSignal)
 */

public static final java.lang.String EXTRA_MEDIA_CAPABILITIES = "android.provider.extra.MEDIA_CAPABILITIES";

/**
 * Specify the UID of the app that should be used to determine supported media capabilities
 * while opening a media.
 *
 * If this specified UID is found to be capable of handling the original media file format, the
 * app will receive the original file, otherwise, the file will get transcoded to a default
 * format supported by the specified UID.
 */

public static final java.lang.String EXTRA_MEDIA_CAPABILITIES_UID = "android.provider.extra.MEDIA_CAPABILITIES_UID";

/**
 * The name of the Intent-extra used to define the search focus. The search focus
 * indicates whether the search should be for things related to the artist, album
 * or song that is identified by the other extras.
 */

public static final java.lang.String EXTRA_MEDIA_FOCUS = "android.intent.extra.focus";

/**
 * The name of the Intent-extra used to define the genre.
 */

public static final java.lang.String EXTRA_MEDIA_GENRE = "android.intent.extra.genre";

/**
 * The name of the Intent-extra used to define the playlist.
 *
 * @deprecated Android playlists are now deprecated. We will keep the current
 *             functionality for compatibility resons, but we will no longer take feature
 *             request. We do not advise adding new usages of Android Playlists. M3U files can
 *             be used as an alternative.
 */

@Deprecated public static final java.lang.String EXTRA_MEDIA_PLAYLIST = "android.intent.extra.playlist";

/**
 * The name of the Intent-extra used to define the radio channel.
 */

public static final java.lang.String EXTRA_MEDIA_RADIO_CHANNEL = "android.intent.extra.radio_channel";

/**
 * The name of the Intent-extra used to define the song title
 */

public static final java.lang.String EXTRA_MEDIA_TITLE = "android.intent.extra.title";

/**
 * The name of the Intent-extra used to indicate a content resolver Uri to be used to
 * store the requested image or video.
 */

public static final java.lang.String EXTRA_OUTPUT = "output";

/**
 * The name of an optional intent-extra used to allow multiple selection of
 * items and constrain maximum number of items that can be returned by
 * {@link android.provider.MediaStore#ACTION_PICK_IMAGES MediaStore#ACTION_PICK_IMAGES}, action may still return nothing
 * (0 items) if the user chooses to cancel.
 * <p>
 * The value of this intent-extra should be a positive integer greater
 * than 1 and less than or equal to
 * {@link android.provider.MediaStore#getPickImagesMaxLimit MediaStore#getPickImagesMaxLimit}, otherwise
 * {@link android.app.Activity#RESULT_CANCELED Activity#RESULT_CANCELED} is returned.
 */

public static final java.lang.String EXTRA_PICK_IMAGES_MAX = "android.provider.extra.PICK_IMAGES_MAX";

/**
 * The name of the Intent-extra used to control the orientation of a ViewImage or a MovieView.
 * This is an int property that overrides the activity's requestedOrientation.
 * @see android.content.pm.ActivityInfo#SCREEN_ORIENTATION_UNSPECIFIED
 */

public static final java.lang.String EXTRA_SCREEN_ORIENTATION = "android.intent.extra.screenOrientation";

/**
 * The name of an Intent-extra used to control the UI of a ViewImage.
 * This is a boolean property that specifies whether or not to show action icons.
 */

public static final java.lang.String EXTRA_SHOW_ACTION_ICONS = "android.intent.extra.showActionIcons";

/**
 * Specify the maximum allowed size.
 */

public static final java.lang.String EXTRA_SIZE_LIMIT = "android.intent.extra.sizeLimit";

/**
 * The name of the Intent-extra used to control the quality of a recorded video. This is an
 * integer property. Currently value 0 means low quality, suitable for MMS messages, and
 * value 1 means high quality. In the future other quality levels may be added.
 */

public static final java.lang.String EXTRA_VIDEO_QUALITY = "android.intent.extra.videoQuality";

/**
 * An intent to perform a search for music media and automatically play content from the
 * result when possible. This can be fired, for example, by the result of a voice recognition
 * command to listen to music.
 * <p>This intent always includes the {@link android.provider.MediaStore#EXTRA_MEDIA_FOCUS}
 * and {@link android.app.SearchManager#QUERY} extras. The
 * {@link android.provider.MediaStore#EXTRA_MEDIA_FOCUS} extra determines the search mode, and
 * the value of the {@link android.app.SearchManager#QUERY} extra depends on the search mode.
 * For more information about the search modes for this intent, see
 * <a href="{@docRoot}guide/components/intents-common.html#PlaySearch">Play music based
 * on a search query</a> in <a href="{@docRoot}guide/components/intents-common.html">Common
 * Intents</a>.</p>
 *
 * <p>This intent makes the most sense for apps that can support large-scale search of music,
 * such as services connected to an online database of music which can be streamed and played
 * on the device.</p>
 */

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String INTENT_ACTION_MEDIA_PLAY_FROM_SEARCH = "android.media.action.MEDIA_PLAY_FROM_SEARCH";

/**
 * Activity Action: Perform a search for media.
 * Contains at least the {@link android.app.SearchManager#QUERY} extra.
 * May also contain any combination of the following extras:
 * EXTRA_MEDIA_ARTIST, EXTRA_MEDIA_ALBUM, EXTRA_MEDIA_TITLE, EXTRA_MEDIA_FOCUS
 *
 * @see android.provider.MediaStore#EXTRA_MEDIA_ARTIST
 * @see android.provider.MediaStore#EXTRA_MEDIA_ALBUM
 * @see android.provider.MediaStore#EXTRA_MEDIA_TITLE
 * @see android.provider.MediaStore#EXTRA_MEDIA_FOCUS
 */

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String INTENT_ACTION_MEDIA_SEARCH = "android.intent.action.MEDIA_SEARCH";

/**
 * Activity Action: Launch a music player.
 * The activity should be able to play, browse, or manipulate music files stored on the device.
 *
 * @deprecated Use {@link android.content.Intent#CATEGORY_APP_MUSIC} instead.
 */

@Deprecated @android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String INTENT_ACTION_MUSIC_PLAYER = "android.intent.action.MUSIC_PLAYER";

/**
 * The name of the Intent action used to launch a camera in still image mode.
 */

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String INTENT_ACTION_STILL_IMAGE_CAMERA = "android.media.action.STILL_IMAGE_CAMERA";

/**
 * The name of the Intent action used to launch a camera in still image mode
 * for use when the device is secured (e.g.&nbsp;with a pin, password, pattern,
 * or face unlock). Applications responding to this intent must not expose
 * any personal content like existing photos or videos on the device. The
 * applications should be careful not to share any photo or video with other
 * applications or internet. The activity should use {@link android.app.Activity#setShowWhenLocked  } to display
 * on top of the lock screen while secured. There is no activity stack when
 * this flag is used, so launching more than one activity is strongly
 * discouraged.
 */

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String INTENT_ACTION_STILL_IMAGE_CAMERA_SECURE = "android.media.action.STILL_IMAGE_CAMERA_SECURE";

/**
 * An intent to perform a search for readable media and automatically play content from the
 * result when possible. This can be fired, for example, by the result of a voice recognition
 * command to read a book or magazine.
 * <p>
 * Contains the {@link android.app.SearchManager#QUERY} extra, which is a string that can
 * contain any type of unstructured text search, like the name of a book or magazine, an author
 * a genre, a publisher, or any combination of these.
 * <p>
 * Because this intent includes an open-ended unstructured search string, it makes the most
 * sense for apps that can support large-scale search of text media, such as services connected
 * to an online database of books and/or magazines which can be read on the device.
 */

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String INTENT_ACTION_TEXT_OPEN_FROM_SEARCH = "android.media.action.TEXT_OPEN_FROM_SEARCH";

/**
 * The name of the Intent action used to launch a camera in video mode.
 */

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String INTENT_ACTION_VIDEO_CAMERA = "android.media.action.VIDEO_CAMERA";

/**
 * An intent to perform a search for video media and automatically play content from the
 * result when possible. This can be fired, for example, by the result of a voice recognition
 * command to play movies.
 * <p>
 * Contains the {@link android.app.SearchManager#QUERY} extra, which is a string that can
 * contain any type of unstructured video search, like the name of a movie, one or more actors,
 * a genre, or any combination of these.
 * <p>
 * Because this intent includes an open-ended unstructured search string, it makes the most
 * sense for apps that can support large-scale search of video, such as services connected to an
 * online database of videos which can be streamed and played on the device.
 */

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String INTENT_ACTION_VIDEO_PLAY_FROM_SEARCH = "android.media.action.VIDEO_PLAY_FROM_SEARCH";

/**
 * Value indicating that the default matching behavior should be used, as
 * defined by the key documentation.
 */

public static final int MATCH_DEFAULT = 0; // 0x0

/**
 * Value indicating that operations should exclude items matching the
 * criteria defined by this key.
 */

public static final int MATCH_EXCLUDE = 2; // 0x2

/**
 * Value indicating that operations should include items matching the
 * criteria defined by this key.
 * <p>
 * Note that items <em>not</em> matching the criteria <em>may</em> also be
 * included depending on the default behavior documented by the key. If you
 * want to operate exclusively on matching items, use {@link #MATCH_ONLY}.
 */

public static final int MATCH_INCLUDE = 1; // 0x1

/**
 * Value indicating that operations should only operate on items explicitly
 * matching the criteria defined by this key.
 */

public static final int MATCH_ONLY = 3; // 0x3

/**
 * Name of the file signaling the media scanner to ignore media in the containing directory
 * and its subdirectories. Developers should use this to avoid application graphics showing
 * up in the Gallery and likewise prevent application sounds and music from showing up in
 * the Music app.
 */

public static final java.lang.String MEDIA_IGNORE_FILENAME = ".nomedia";

/**
 * Name of current volume being scanned by the media scanner.
 */

public static final java.lang.String MEDIA_SCANNER_VOLUME = "volume";

/**
 * Name under which an activity handling {@link #ACTION_REVIEW} or
 * {@link #ACTION_REVIEW_SECURE} publishes the service name for its prewarm
 * service.
 * <p>
 * This meta-data should reference the fully qualified class name of the prewarm service
 * <p>
 * The prewarm service can be bound before starting {@link #ACTION_REVIEW} or
 * {@link #ACTION_REVIEW_SECURE}.
 * An application implementing this prewarm service should do the absolute minimum amount of
 * work to initialize its resources to efficiently handle an {@link #ACTION_REVIEW} or
 * {@link #ACTION_REVIEW_SECURE} in the near future.
 */

public static final java.lang.String META_DATA_REVIEW_GALLERY_PREWARM_SERVICE = "android.media.review_gallery_prewarm_service";

/**
 * Name under which an activity handling {@link #INTENT_ACTION_STILL_IMAGE_CAMERA} or
 * {@link #INTENT_ACTION_STILL_IMAGE_CAMERA_SECURE} publishes the service name for its prewarm
 * service.
 * <p>
 * This meta-data should reference the fully qualified class name of the prewarm service
 * extending {@code CameraPrewarmService}.
 * <p>
 * The prewarm service will get bound and receive a prewarm signal
 * {@code CameraPrewarmService#onPrewarm()} when a camera launch intent fire might be imminent.
 * An application implementing a prewarm service should do the absolute minimum amount of work
 * to initialize the camera in order to reduce startup time in likely case that shortly after a
 * camera launch intent would be sent.
 */

public static final java.lang.String META_DATA_STILL_IMAGE_CAMERA_PREWARM_SERVICE = "android.media.still_image_camera_preview_service";

/**
 * Flag that requests {@link android.content.ContentResolver#query ContentResolver#query} to include content from
 * recently unmounted volumes.
 * <p>
 * When the flag is set, {@link android.content.ContentResolver#query ContentResolver#query} will return content
 * from all volumes(i.e., both mounted and recently unmounted volume whose
 * content is still held by MediaProvider).
 * <p>
 * Note that the query result doesn't provide any hint for content from
 * unmounted volume. It's strongly recommended to use default query to
 * avoid accessing/operating on the content that are not available on the
 * device.
 * <p>
 * The flag is useful for apps which manage their own database and
 * query MediaStore in order to synchronize between MediaStore database
 * and their own database.
 */

public static final java.lang.String QUERY_ARG_INCLUDE_RECENTLY_UNMOUNTED_VOLUMES = "android:query-arg-recently-unmounted-volumes";

/**
 * Specify how {@link android.provider.MediaStore.MediaColumns#IS_FAVORITE MediaColumns#IS_FAVORITE} items should be filtered
 * when performing a {@link android.provider.MediaStore MediaStore} operation.
 * <p>
 * This key can be placed in a {@link android.os.Bundle Bundle} of extras and passed to
 * {@link android.content.ContentResolver#query ContentResolver#query}, {@link android.content.ContentResolver#update ContentResolver#update}, or
 * {@link android.content.ContentResolver#delete ContentResolver#delete}.
 * <p>
 * By default, favorite items are <em>not</em> filtered away from
 * operations.
 *
 * <br>
 * Value is either <code>0</code> or a combination of {@link android.provider.MediaStore#MATCH_DEFAULT}, {@link android.provider.MediaStore#MATCH_INCLUDE}, {@link android.provider.MediaStore#MATCH_EXCLUDE}, and {@link android.provider.MediaStore#MATCH_ONLY}
 * @see android.provider.MediaStore.MediaColumns#IS_FAVORITE
 * @see android.provider.MediaStore#QUERY_ARG_MATCH_FAVORITE
 * @see android.provider.MediaStore#createFavoriteRequest
 */

public static final java.lang.String QUERY_ARG_MATCH_FAVORITE = "android:query-arg-match-favorite";

/**
 * Specify how {@link android.provider.MediaStore.MediaColumns#IS_PENDING MediaColumns#IS_PENDING} items should be filtered when
 * performing a {@link android.provider.MediaStore MediaStore} operation.
 * <p>
 * This key can be placed in a {@link android.os.Bundle Bundle} of extras and passed to
 * {@link android.content.ContentResolver#query ContentResolver#query}, {@link android.content.ContentResolver#update ContentResolver#update}, or
 * {@link android.content.ContentResolver#delete ContentResolver#delete}.
 * <p>
 * By default, pending items are filtered away from operations.

 * <br>
 * Value is either <code>0</code> or a combination of {@link android.provider.MediaStore#MATCH_DEFAULT}, {@link android.provider.MediaStore#MATCH_INCLUDE}, {@link android.provider.MediaStore#MATCH_EXCLUDE}, and {@link android.provider.MediaStore#MATCH_ONLY}
 */

public static final java.lang.String QUERY_ARG_MATCH_PENDING = "android:query-arg-match-pending";

/**
 * Specify how {@link android.provider.MediaStore.MediaColumns#IS_TRASHED MediaColumns#IS_TRASHED} items should be filtered when
 * performing a {@link android.provider.MediaStore MediaStore} operation.
 * <p>
 * This key can be placed in a {@link android.os.Bundle Bundle} of extras and passed to
 * {@link android.content.ContentResolver#query ContentResolver#query}, {@link android.content.ContentResolver#update ContentResolver#update}, or
 * {@link android.content.ContentResolver#delete ContentResolver#delete}.
 * <p>
 * By default, trashed items are filtered away from operations.
 *
 * <br>
 * Value is either <code>0</code> or a combination of {@link android.provider.MediaStore#MATCH_DEFAULT}, {@link android.provider.MediaStore#MATCH_INCLUDE}, {@link android.provider.MediaStore#MATCH_EXCLUDE}, and {@link android.provider.MediaStore#MATCH_ONLY}
 * @see android.provider.MediaStore.MediaColumns#IS_TRASHED
 * @see android.provider.MediaStore#QUERY_ARG_MATCH_TRASHED
 * @see android.provider.MediaStore#createTrashRequest
 */

public static final java.lang.String QUERY_ARG_MATCH_TRASHED = "android:query-arg-match-trashed";

/**
 * Specify a {@link android.net.Uri Uri} that is "related" to the current operation being
 * performed.
 * <p>
 * This is typically used to allow an operation that may normally be
 * rejected, such as making a copy of a pre-existing image located under a
 * {@link android.provider.MediaStore.MediaColumns#RELATIVE_PATH MediaColumns#RELATIVE_PATH} where new images are not allowed.
 * <p>
 * It's strongly recommended that when making a copy of pre-existing content
 * that you define the "original document ID" GUID as defined by the <em>XMP
 * Media Management</em> standard.
 * <p>
 * This key can be placed in a {@link android.os.Bundle Bundle} of extras and passed to
 * {@link android.content.ContentResolver#insert ContentResolver#insert}.
 */

public static final java.lang.String QUERY_ARG_RELATED_URI = "android:query-arg-related-uri";

/**
 * The string that is used when a media attribute is not known. For example,
 * if an audio file does not have any meta data, the artist and album columns
 * will be set to this value.
 */

public static final java.lang.String UNKNOWN_STRING = "<unknown>";

/**
 * Synthetic volume name that provides a view of all content across the
 * "external" storage of the device.
 * <p>
 * This synthetic volume provides a merged view of all media across all
 * currently attached external storage devices.
 * <p>
 * Because this is a synthetic volume, you can't insert new content into
 * this volume. Instead, you can insert content into a specific storage
 * volume obtained from {@link #getExternalVolumeNames(android.content.Context)}.
 */

public static final java.lang.String VOLUME_EXTERNAL = "external";

/**
 * Specific volume name that represents the primary external storage device
 * at {@link android.os.Environment#getExternalStorageDirectory() Environment#getExternalStorageDirectory()}.
 * <p>
 * This volume may not always be available, such as when the user has
 * ejected the device. You can find a list of all specific volume names
 * using {@link #getExternalVolumeNames(android.content.Context)}.
 */

public static final java.lang.String VOLUME_EXTERNAL_PRIMARY = "external_primary";

/**
 * Synthetic volume name that provides a view of all content across the
 * "internal" storage of the device.
 * <p>
 * This synthetic volume provides a merged view of all media distributed
 * with the device, such as built-in ringtones and wallpapers.
 * <p>
 * Because this is a synthetic volume, you can't insert new content into
 * this volume.
 */

public static final java.lang.String VOLUME_INTERNAL = "internal";
/**
 * Collection of all media with MIME type of {@code audio/*}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Audio {

public Audio() { throw new RuntimeException("Stub!"); }

/**
 * Converts a user-visible string into a "key" that can be used for
 * grouping, sorting, and searching.
 *
 * @param name This value may be {@code null}.
 * @return Opaque token that should not be parsed or displayed to users.
 * This value may be {@code null}.
 * @deprecated These keys are generated using
 *             {@link java.util.Locale#ROOT}, which means they don't
 *             reflect locale-specific sorting preferences. To apply
 *             locale-specific sorting preferences, use
 *             {@link android.content.ContentResolver#QUERY_ARG_SQL_SORT_ORDER ContentResolver#QUERY_ARG_SQL_SORT_ORDER} with
 *             {@code COLLATE LOCALIZED}, or
 *             {@link android.content.ContentResolver#QUERY_ARG_SORT_LOCALE ContentResolver#QUERY_ARG_SORT_LOCALE}.
 */

@Deprecated
@android.annotation.Nullable
public static java.lang.String keyFor(@android.annotation.Nullable java.lang.String name) { throw new RuntimeException("Stub!"); }
/**
 * Audio album metadata columns.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface AlbumColumns {

/**
 * The album on which the audio file appears, if any

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_STRING Cursor#FIELD_TYPE_STRING} , and are read-only and cannot be mutated.
 */

public static final java.lang.String ALBUM = "album";

/**
 * Cached album art.
 *
 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_STRING Cursor#FIELD_TYPE_STRING} .
 * @deprecated Apps may not have filesystem permissions to directly
 *             access this path. Instead of trying to open this path
 *             directly, apps should use
 *             {@link android.content.ContentResolver#loadThumbnail ContentResolver#loadThumbnail}
 *             to gain access.
 */

@Deprecated public static final java.lang.String ALBUM_ART = "album_art";

/**
 * The id for the album

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} , and are read-only and cannot be mutated.
 */

public static final java.lang.String ALBUM_ID = "album_id";

/**
 * A non human readable key calculated from the ALBUM, used for
 * searching, sorting and grouping
 *
 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_STRING Cursor#FIELD_TYPE_STRING} , and are read-only and cannot be mutated.
 * @see android.provider.MediaStore.Audio#keyFor(String)
 * @deprecated These keys are generated using
 *             {@link java.util.Locale#ROOT}, which means they don't
 *             reflect locale-specific sorting preferences. To apply
 *             locale-specific sorting preferences, use
 *             {@link android.content.ContentResolver#QUERY_ARG_SQL_SORT_ORDER ContentResolver#QUERY_ARG_SQL_SORT_ORDER} with
 *             {@code COLLATE LOCALIZED}, or
 *             {@link android.content.ContentResolver#QUERY_ARG_SORT_LOCALE ContentResolver#QUERY_ARG_SORT_LOCALE}.
 */

@Deprecated public static final java.lang.String ALBUM_KEY = "album_key";

/**
 * The name of the artist whose songs appear on this album.

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_STRING Cursor#FIELD_TYPE_STRING} , and are read-only and cannot be mutated.
 */

public static final java.lang.String ARTIST = "artist";

/**
 * The ID of the artist whose songs appear on this album.

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} , and are read-only and cannot be mutated.
 */

public static final java.lang.String ARTIST_ID = "artist_id";

/**
 * A non human readable key calculated from the ARTIST, used for
 * searching, sorting and grouping
 *
 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_STRING Cursor#FIELD_TYPE_STRING} , and are read-only and cannot be mutated.
 * @see android.provider.MediaStore.Audio#keyFor(String)
 * @deprecated These keys are generated using
 *             {@link java.util.Locale#ROOT}, which means they don't
 *             reflect locale-specific sorting preferences. To apply
 *             locale-specific sorting preferences, use
 *             {@link android.content.ContentResolver#QUERY_ARG_SQL_SORT_ORDER ContentResolver#QUERY_ARG_SQL_SORT_ORDER} with
 *             {@code COLLATE LOCALIZED}, or
 *             {@link android.content.ContentResolver#QUERY_ARG_SORT_LOCALE ContentResolver#QUERY_ARG_SORT_LOCALE}.
 */

@Deprecated public static final java.lang.String ARTIST_KEY = "artist_key";

/**
 * The year in which the earliest songs
 * on this album were released. This will often
 * be the same as {@link #LAST_YEAR}, but for compilation albums
 * they might differ.

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} , and are read-only and cannot be mutated.
 */

public static final java.lang.String FIRST_YEAR = "minyear";

/**
 * The year in which the latest songs
 * on this album were released. This will often
 * be the same as {@link #FIRST_YEAR}, but for compilation albums
 * they might differ.

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} , and are read-only and cannot be mutated.
 */

public static final java.lang.String LAST_YEAR = "maxyear";

/**
 * The number of songs on this album

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} , and are read-only and cannot be mutated.
 */

public static final java.lang.String NUMBER_OF_SONGS = "numsongs";

/**
 * This column is available when getting album info via artist,
 * and indicates the number of songs on the album by the given
 * artist.

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} , and are read-only and cannot be mutated.
 */

public static final java.lang.String NUMBER_OF_SONGS_FOR_ARTIST = "numsongs_by_artist";
}

/**
 * Contains artists for audio files
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Albums implements android.provider.BaseColumns, android.provider.MediaStore.Audio.AlbumColumns {

public Albums() { throw new RuntimeException("Stub!"); }

/**
 * Get the content:// style URI for the albums table on the
 * given volume.
 *
 * @param volumeName the name of the volume to get the URI for
 * @return the URI to the audio albums table on the given volume
 */

public static android.net.Uri getContentUri(java.lang.String volumeName) { throw new RuntimeException("Stub!"); }

/**
 * The MIME type for this table.
 */

public static final java.lang.String CONTENT_TYPE = "vnd.android.cursor.dir/albums";

/**
 * The default sort order for this table
 */

public static final java.lang.String DEFAULT_SORT_ORDER = "album_key";

/**
 * The MIME type for entries in this table.
 */

public static final java.lang.String ENTRY_CONTENT_TYPE = "vnd.android.cursor.item/album";

/**
 * The content:// style URI for the "primary" external storage
 * volume.
 */

public static final android.net.Uri EXTERNAL_CONTENT_URI;
static { EXTERNAL_CONTENT_URI = null; }

/**
 * The content:// style URI for the internal storage.
 */

public static final android.net.Uri INTERNAL_CONTENT_URI;
static { INTERNAL_CONTENT_URI = null; }
}

/**
 * Audio artist metadata columns.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface ArtistColumns {

/**
 * The artist who created the audio file, if any

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_STRING Cursor#FIELD_TYPE_STRING} , and are read-only and cannot be mutated.
 */

public static final java.lang.String ARTIST = "artist";

/**
 * A non human readable key calculated from the ARTIST, used for
 * searching, sorting and grouping
 *
 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_STRING Cursor#FIELD_TYPE_STRING} , and are read-only and cannot be mutated.
 * @see android.provider.MediaStore.Audio#keyFor(String)
 * @deprecated These keys are generated using
 *             {@link java.util.Locale#ROOT}, which means they don't
 *             reflect locale-specific sorting preferences. To apply
 *             locale-specific sorting preferences, use
 *             {@link android.content.ContentResolver#QUERY_ARG_SQL_SORT_ORDER ContentResolver#QUERY_ARG_SQL_SORT_ORDER} with
 *             {@code COLLATE LOCALIZED}, or
 *             {@link android.content.ContentResolver#QUERY_ARG_SORT_LOCALE ContentResolver#QUERY_ARG_SORT_LOCALE}.
 */

@Deprecated public static final java.lang.String ARTIST_KEY = "artist_key";

/**
 * The number of albums in the database for this artist

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} , and are read-only and cannot be mutated.
 */

public static final java.lang.String NUMBER_OF_ALBUMS = "number_of_albums";

/**
 * The number of albums in the database for this artist

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} , and are read-only and cannot be mutated.
 */

public static final java.lang.String NUMBER_OF_TRACKS = "number_of_tracks";
}

/**
 * Contains artists for audio files
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Artists implements android.provider.BaseColumns, android.provider.MediaStore.Audio.ArtistColumns {

public Artists() { throw new RuntimeException("Stub!"); }

/**
 * Get the content:// style URI for the artists table on the
 * given volume.
 *
 * @param volumeName the name of the volume to get the URI for
 * @return the URI to the audio artists table on the given volume
 */

public static android.net.Uri getContentUri(java.lang.String volumeName) { throw new RuntimeException("Stub!"); }

/**
 * The MIME type for this table.
 */

public static final java.lang.String CONTENT_TYPE = "vnd.android.cursor.dir/artists";

/**
 * The default sort order for this table
 */

public static final java.lang.String DEFAULT_SORT_ORDER = "artist_key";

/**
 * The MIME type for entries in this table.
 */

public static final java.lang.String ENTRY_CONTENT_TYPE = "vnd.android.cursor.item/artist";

/**
 * The content:// style URI for the "primary" external storage
 * volume.
 */

public static final android.net.Uri EXTERNAL_CONTENT_URI;
static { EXTERNAL_CONTENT_URI = null; }

/**
 * The content:// style URI for the internal storage.
 */

public static final android.net.Uri INTERNAL_CONTENT_URI;
static { INTERNAL_CONTENT_URI = null; }
/**
 * Sub-directory of each artist containing all albums on which
 * a song by the artist appears.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Albums implements android.provider.BaseColumns, android.provider.MediaStore.Audio.AlbumColumns {

public Albums() { throw new RuntimeException("Stub!"); }

public static android.net.Uri getContentUri(java.lang.String volumeName, long artistId) { throw new RuntimeException("Stub!"); }
}

}

/**
 * Audio metadata columns.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface AudioColumns extends android.provider.MediaStore.MediaColumns {

/**
 * The id of the album the audio file is from, if any

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} , and are read-only and cannot be mutated.
 */

public static final java.lang.String ALBUM_ID = "album_id";

/**
 * A non human readable key calculated from the ALBUM, used for
 * searching, sorting and grouping
 *
 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_STRING Cursor#FIELD_TYPE_STRING} , and are read-only and cannot be mutated.
 * @see android.provider.MediaStore.Audio#keyFor(String)
 * @deprecated These keys are generated using
 *             {@link java.util.Locale#ROOT}, which means they don't
 *             reflect locale-specific sorting preferences. To apply
 *             locale-specific sorting preferences, use
 *             {@link android.content.ContentResolver#QUERY_ARG_SQL_SORT_ORDER ContentResolver#QUERY_ARG_SQL_SORT_ORDER} with
 *             {@code COLLATE LOCALIZED}, or
 *             {@link android.content.ContentResolver#QUERY_ARG_SORT_LOCALE ContentResolver#QUERY_ARG_SORT_LOCALE}.
 */

@Deprecated public static final java.lang.String ALBUM_KEY = "album_key";

/**
 * The id of the artist who created the audio file, if any

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} , and are read-only and cannot be mutated.
 */

public static final java.lang.String ARTIST_ID = "artist_id";

/**
 * A non human readable key calculated from the ARTIST, used for
 * searching, sorting and grouping
 *
 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_STRING Cursor#FIELD_TYPE_STRING} , and are read-only and cannot be mutated.
 * @see android.provider.MediaStore.Audio#keyFor(String)
 * @deprecated These keys are generated using
 *             {@link java.util.Locale#ROOT}, which means they don't
 *             reflect locale-specific sorting preferences. To apply
 *             locale-specific sorting preferences, use
 *             {@link android.content.ContentResolver#QUERY_ARG_SQL_SORT_ORDER ContentResolver#QUERY_ARG_SQL_SORT_ORDER} with
 *             {@code COLLATE LOCALIZED}, or
 *             {@link android.content.ContentResolver#QUERY_ARG_SORT_LOCALE ContentResolver#QUERY_ARG_SORT_LOCALE}.
 */

@Deprecated public static final java.lang.String ARTIST_KEY = "artist_key";

/**
 * The position within the audio item at which playback should be
 * resumed.
 
 * <br>
 * Value is a non-negative duration in milliseconds.

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} .
 */

public static final java.lang.String BOOKMARK = "bookmark";

/**
 * The genre of the audio file, if any.

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_STRING Cursor#FIELD_TYPE_STRING} , and are read-only and cannot be mutated.
 */

public static final java.lang.String GENRE = "genre";

/**
 * The id of the genre the audio file is from, if any

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} , and are read-only and cannot be mutated.
 */

public static final java.lang.String GENRE_ID = "genre_id";

/**
 * A non human readable key calculated from the GENRE, used for
 * searching, sorting and grouping
 *
 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_STRING Cursor#FIELD_TYPE_STRING} , and are read-only and cannot be mutated.
 * @see android.provider.MediaStore.Audio#keyFor(String)
 * @deprecated These keys are generated using
 *             {@link java.util.Locale#ROOT}, which means they don't
 *             reflect locale-specific sorting preferences. To apply
 *             locale-specific sorting preferences, use
 *             {@link android.content.ContentResolver#QUERY_ARG_SQL_SORT_ORDER ContentResolver#QUERY_ARG_SQL_SORT_ORDER} with
 *             {@code COLLATE LOCALIZED}, or
 *             {@link android.content.ContentResolver#QUERY_ARG_SORT_LOCALE ContentResolver#QUERY_ARG_SORT_LOCALE}.
 */

@Deprecated public static final java.lang.String GENRE_KEY = "genre_key";

/**
 * Non-zero if the audio file may be an alarm

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} , and are read-only and cannot be mutated.
 */

public static final java.lang.String IS_ALARM = "is_alarm";

/**
 * Non-zero if the audio file is an audiobook

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} , and are read-only and cannot be mutated.
 */

public static final java.lang.String IS_AUDIOBOOK = "is_audiobook";

/**
 * Non-zero if the audio file is music

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} , and are read-only and cannot be mutated.
 */

public static final java.lang.String IS_MUSIC = "is_music";

/**
 * Non-zero if the audio file may be a notification sound

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} , and are read-only and cannot be mutated.
 */

public static final java.lang.String IS_NOTIFICATION = "is_notification";

/**
 * Non-zero if the audio file is a podcast

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} , and are read-only and cannot be mutated.
 */

public static final java.lang.String IS_PODCAST = "is_podcast";

/**
 * Non-zero if the audio file is a voice recording recorded
 * by voice recorder apps

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} , and are read-only and cannot be mutated.
 */

public static final java.lang.String IS_RECORDING = "is_recording";

/**
 * Non-zero if the audio file may be a ringtone

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} , and are read-only and cannot be mutated.
 */

public static final java.lang.String IS_RINGTONE = "is_ringtone";

/**
 * A non human readable key calculated from the TITLE, used for
 * searching, sorting and grouping
 *
 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_STRING Cursor#FIELD_TYPE_STRING} , and are read-only and cannot be mutated.
 * @see android.provider.MediaStore.Audio#keyFor(String)
 * @deprecated These keys are generated using
 *             {@link java.util.Locale#ROOT}, which means they don't
 *             reflect locale-specific sorting preferences. To apply
 *             locale-specific sorting preferences, use
 *             {@link android.content.ContentResolver#QUERY_ARG_SQL_SORT_ORDER ContentResolver#QUERY_ARG_SQL_SORT_ORDER} with
 *             {@code COLLATE LOCALIZED}, or
 *             {@link android.content.ContentResolver#QUERY_ARG_SORT_LOCALE ContentResolver#QUERY_ARG_SORT_LOCALE}.
 */

@Deprecated public static final java.lang.String TITLE_KEY = "title_key";

/**
 * The resource URI of a localized title, if any.
 * <p>
 * Conforms to this pattern:
 * <ul>
 * <li>Scheme: {@link android.content.ContentResolver#SCHEME_ANDROID_RESOURCE ContentResolver#SCHEME_ANDROID_RESOURCE}
 * <li>Authority: Package Name of ringtone title provider
 * <li>First Path Segment: Type of resource (must be "string")
 * <li>Second Path Segment: Resource ID of title
 * </ul>

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_STRING Cursor#FIELD_TYPE_STRING} , and are read-only and cannot be mutated.
 */

public static final java.lang.String TITLE_RESOURCE_URI = "title_resource_uri";

/**
 * The track number of this song on the album, if any.
 * This number encodes both the track number and the
 * disc number. For multi-disc sets, this number will
 * be 1xxx for tracks on the first disc, 2xxx for tracks
 * on the second disc, etc.

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} , and are read-only and cannot be mutated.
 */

public static final java.lang.String TRACK = "track";

/**
 * The year the audio file was recorded, if any

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} , and are read-only and cannot be mutated.
 */

public static final java.lang.String YEAR = "year";
}

/**
 * Contains all genres for audio files
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Genres implements android.provider.BaseColumns, android.provider.MediaStore.Audio.GenresColumns {

public Genres() { throw new RuntimeException("Stub!"); }

/**
 * Get the content:// style URI for the audio genres table on the
 * given volume.
 *
 * @param volumeName the name of the volume to get the URI for
 * @return the URI to the audio genres table on the given volume
 */

public static android.net.Uri getContentUri(java.lang.String volumeName) { throw new RuntimeException("Stub!"); }

/**
 * Get the content:// style URI for querying the genres of an audio file.
 *
 * @param volumeName the name of the volume to get the URI for
 * @param audioId the ID of the audio file for which to retrieve the genres
 * @return the URI to for querying the genres for the audio file
 * with the given the volume and audioID
 */

public static android.net.Uri getContentUriForAudioId(java.lang.String volumeName, int audioId) { throw new RuntimeException("Stub!"); }

/**
 * The MIME type for this table.
 */

public static final java.lang.String CONTENT_TYPE = "vnd.android.cursor.dir/genre";

/**
 * The default sort order for this table
 */

public static final java.lang.String DEFAULT_SORT_ORDER = "name";

/**
 * The MIME type for entries in this table.
 */

public static final java.lang.String ENTRY_CONTENT_TYPE = "vnd.android.cursor.item/genre";

/**
 * The content:// style URI for the "primary" external storage
 * volume.
 */

public static final android.net.Uri EXTERNAL_CONTENT_URI;
static { EXTERNAL_CONTENT_URI = null; }

/**
 * The content:// style URI for the internal storage.
 */

public static final android.net.Uri INTERNAL_CONTENT_URI;
static { INTERNAL_CONTENT_URI = null; }
/**
 * Sub-directory of each genre containing all members.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Members implements android.provider.MediaStore.Audio.AudioColumns {

public Members() { throw new RuntimeException("Stub!"); }

public static android.net.Uri getContentUri(java.lang.String volumeName, long genreId) { throw new RuntimeException("Stub!"); }

/**
 * The ID of the audio file

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} .
 */

public static final java.lang.String AUDIO_ID = "audio_id";

/**
 * A subdirectory of each genre containing all member audio files.
 */

public static final java.lang.String CONTENT_DIRECTORY = "members";

/**
 * The default sort order for this table
 */

public static final java.lang.String DEFAULT_SORT_ORDER = "title_key";

/**
 * The ID of the genre

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} .
 */

public static final java.lang.String GENRE_ID = "genre_id";
}

}

/**
 * Audio genre metadata columns.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface GenresColumns {

/**
 * The name of the genre

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_STRING Cursor#FIELD_TYPE_STRING} .
 */

public static final java.lang.String NAME = "name";
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Media implements android.provider.MediaStore.Audio.AudioColumns {

public Media() { throw new RuntimeException("Stub!"); }

/**
 * Get the content:// style URI for the audio media table on the
 * given volume.
 *
 * @param volumeName the name of the volume to get the URI for
 * @return the URI to the audio media table on the given volume
 */

public static android.net.Uri getContentUri(java.lang.String volumeName) { throw new RuntimeException("Stub!"); }

/**
 * Get the content:// style URI for a single row in the audio table
 * on the given volume.
 *
 * @param volumeName the name of the volume to get the URI for
 * This value cannot be {@code null}.
 * @param id the audio to get the URI for
 * @return the URI to the audio table on the given volume
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public static android.net.Uri getContentUri(@android.annotation.NonNull java.lang.String volumeName, long id) { throw new RuntimeException("Stub!"); }

/**
 * Get the content:// style URI for the given audio media file.
 *
 * @deprecated Apps may not have filesystem permissions to directly
 *             access this path.
 
 * @param path This value cannot be {@code null}.
 * @return This value may be {@code null}.
 */

@Deprecated
@android.annotation.Nullable
public static android.net.Uri getContentUriForPath(@android.annotation.NonNull java.lang.String path) { throw new RuntimeException("Stub!"); }

/**
 * The MIME type for this table.
 */

public static final java.lang.String CONTENT_TYPE = "vnd.android.cursor.dir/audio";

/**
 * The default sort order for this table
 */

public static final java.lang.String DEFAULT_SORT_ORDER = "title_key";

/**
 * The MIME type for an audio track.
 */

public static final java.lang.String ENTRY_CONTENT_TYPE = "vnd.android.cursor.item/audio";

/**
 * The content:// style URI for the "primary" external storage
 * volume.
 */

public static final android.net.Uri EXTERNAL_CONTENT_URI;
static { EXTERNAL_CONTENT_URI = null; }

/**
 * The name of the Intent-extra used to define a maximum file size for
 * a recording made by the SoundRecorder application.
 *
 * @see #RECORD_SOUND_ACTION
 */

public static final java.lang.String EXTRA_MAX_BYTES = "android.provider.MediaStore.extra.MAX_BYTES";

/**
 * The content:// style URI for the internal storage.
 */

public static final android.net.Uri INTERNAL_CONTENT_URI;
static { INTERNAL_CONTENT_URI = null; }

/**
 * Activity Action: Start SoundRecorder application.
 * <p>Input: nothing.
 * <p>Output: An uri to the recorded sound stored in the Media Library
 * if the recording was successful.
 * May also contain the extra EXTRA_MAX_BYTES.
 * @see #EXTRA_MAX_BYTES
 */

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String RECORD_SOUND_ACTION = "android.provider.MediaStore.RECORD_SOUND";
}

/**
 * Contains playlists for audio files
 *
 * @deprecated Android playlists are now deprecated. We will keep the current
 *             functionality for compatibility resons, but we will no longer take
 *             feature request. We do not advise adding new usages of Android Playlists.
 *             M3U files can be used as an alternative.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
@Deprecated
public static final class Playlists implements android.provider.BaseColumns, android.provider.MediaStore.Audio.PlaylistsColumns {

@Deprecated
public Playlists() { throw new RuntimeException("Stub!"); }

/**
 * Get the content:// style URI for the audio playlists table on the
 * given volume.
 *
 * @param volumeName the name of the volume to get the URI for
 * @return the URI to the audio playlists table on the given volume
 */

@Deprecated
public static android.net.Uri getContentUri(java.lang.String volumeName) { throw new RuntimeException("Stub!"); }

/**
 * The MIME type for this table.
 */

@Deprecated public static final java.lang.String CONTENT_TYPE = "vnd.android.cursor.dir/playlist";

/**
 * The default sort order for this table
 */

@Deprecated public static final java.lang.String DEFAULT_SORT_ORDER = "name";

/**
 * The MIME type for entries in this table.
 */

@Deprecated public static final java.lang.String ENTRY_CONTENT_TYPE = "vnd.android.cursor.item/playlist";

/**
 * The content:// style URI for the "primary" external storage
 * volume.
 */

@Deprecated public static final android.net.Uri EXTERNAL_CONTENT_URI;
static { EXTERNAL_CONTENT_URI = null; }

/**
 * The content:// style URI for the internal storage.
 */

@Deprecated public static final android.net.Uri INTERNAL_CONTENT_URI;
static { INTERNAL_CONTENT_URI = null; }
/**
 * Sub-directory of each playlist containing all members.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
@Deprecated
public static final class Members implements android.provider.MediaStore.Audio.AudioColumns {

@Deprecated
public Members() { throw new RuntimeException("Stub!"); }

@Deprecated
public static android.net.Uri getContentUri(java.lang.String volumeName, long playlistId) { throw new RuntimeException("Stub!"); }

/**
 * Convenience method to move a playlist item to a new location
 * @param res The content resolver to use
 * @param playlistId The numeric id of the playlist
 * @param from The position of the item to move
 * @param to The position to move the item to
 * @return true on success
 */

@Deprecated
public static boolean moveItem(android.content.ContentResolver res, long playlistId, int from, int to) { throw new RuntimeException("Stub!"); }

/**
 * The ID of the audio file

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} .
 */

@Deprecated public static final java.lang.String AUDIO_ID = "audio_id";

/**
 * A subdirectory of each playlist containing all member audio
 * files.
 */

@Deprecated public static final java.lang.String CONTENT_DIRECTORY = "members";

/**
 * The default sort order for this table
 */

@Deprecated public static final java.lang.String DEFAULT_SORT_ORDER = "play_order";

/**
 * The ID of the playlist

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} .
 */

@Deprecated public static final java.lang.String PLAYLIST_ID = "playlist_id";

/**
 * The order of the songs in the playlist

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} .
 */

@Deprecated public static final java.lang.String PLAY_ORDER = "play_order";

/**
 * The ID within the playlist.

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} .
 */

@Deprecated public static final java.lang.String _ID = "_id";
}

}

/**
 * Audio playlist metadata columns.
 *
 * @deprecated Android playlists are now deprecated. We will keep the current
 *             functionality for compatibility reasons, but we will no longer take
 *             feature request. We do not advise adding new usages of Android Playlists.
 *             M3U files can be used as an alternative.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
@Deprecated
public static interface PlaylistsColumns extends android.provider.MediaStore.MediaColumns {

/**
 * Path to the playlist file on disk.

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_STRING Cursor#FIELD_TYPE_STRING} .
 */

@Deprecated public static final java.lang.String DATA = "_data";

/**
 * The time the media item was first added.

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} , and are read-only and cannot be mutated.
 */

@Deprecated public static final java.lang.String DATE_ADDED = "date_added";

/**
 * The time the media item was last modified.

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} , and are read-only and cannot be mutated.
 */

@Deprecated public static final java.lang.String DATE_MODIFIED = "date_modified";

/**
 * The name of the playlist

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_STRING Cursor#FIELD_TYPE_STRING} .
 */

@Deprecated public static final java.lang.String NAME = "name";
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Radio {

Radio() { throw new RuntimeException("Stub!"); }

/**
 * The MIME type for entries in this table.
 */

public static final java.lang.String ENTRY_CONTENT_TYPE = "vnd.android.cursor.item/radio";
}

}

/**
 * Download metadata columns.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface DownloadColumns extends android.provider.MediaStore.MediaColumns {

/**
 * Uri indicating where the item has been downloaded from.

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_STRING Cursor#FIELD_TYPE_STRING} .
 */

public static final java.lang.String DOWNLOAD_URI = "download_uri";

/**
 * Uri indicating HTTP referer of {@link #DOWNLOAD_URI}.

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_STRING Cursor#FIELD_TYPE_STRING} .
 */

public static final java.lang.String REFERER_URI = "referer_uri";
}

/**
 * Collection of downloaded items.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Downloads implements android.provider.MediaStore.DownloadColumns {

Downloads() { throw new RuntimeException("Stub!"); }

/**
 * Get the content:// style URI for the downloads table on the
 * given volume.
 *
 * @param volumeName the name of the volume to get the URI for
 * This value cannot be {@code null}.
 * @return the URI to the image media table on the given volume
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public static android.net.Uri getContentUri(@android.annotation.NonNull java.lang.String volumeName) { throw new RuntimeException("Stub!"); }

/**
 * Get the content:// style URI for a single row in the downloads table
 * on the given volume.
 *
 * @param volumeName the name of the volume to get the URI for
 * This value cannot be {@code null}.
 * @param id the download to get the URI for
 * @return the URI to the downloads table on the given volume
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public static android.net.Uri getContentUri(@android.annotation.NonNull java.lang.String volumeName, long id) { throw new RuntimeException("Stub!"); }

/**
 * The MIME type for this table.
 */

public static final java.lang.String CONTENT_TYPE = "vnd.android.cursor.dir/download";

/**
 * The content:// style URI for the "primary" external storage
 * volume.
 */

@android.annotation.NonNull public static final android.net.Uri EXTERNAL_CONTENT_URI;
static { EXTERNAL_CONTENT_URI = null; }

/**
 * The content:// style URI for the internal storage.
 */

@android.annotation.NonNull public static final android.net.Uri INTERNAL_CONTENT_URI;
static { INTERNAL_CONTENT_URI = null; }
}

/**
 * Media provider table containing an index of all files in the media storage,
 * including non-media files.  This should be used by applications that work with
 * non-media file types (text, HTML, PDF, etc) as well as applications that need to
 * work with multiple media file types in a single query.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Files {

public Files() { throw new RuntimeException("Stub!"); }

/**
 * Get the content:// style URI for the files table on the
 * given volume.
 *
 * @param volumeName the name of the volume to get the URI for
 * @return the URI to the files table on the given volume
 */

public static android.net.Uri getContentUri(java.lang.String volumeName) { throw new RuntimeException("Stub!"); }

/**
 * Get the content:// style URI for a single row in the files table on the
 * given volume.
 *
 * @param volumeName the name of the volume to get the URI for
 * @param rowId the file to get the URI for
 * @return the URI to the files table on the given volume
 */

public static android.net.Uri getContentUri(java.lang.String volumeName, long rowId) { throw new RuntimeException("Stub!"); }
/**
 * File metadata columns.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface FileColumns extends android.provider.MediaStore.MediaColumns {

/**
 * The media type (audio, video, image, document, playlist or subtitle)
 * of the file, or 0 for not a media file

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} .
 */

public static final java.lang.String MEDIA_TYPE = "media_type";

/**
 * Constant for the {@link #MEDIA_TYPE} column indicating that file
 * is an audio file.
 */

public static final int MEDIA_TYPE_AUDIO = 2; // 0x2

/**
 * Constant for the {@link #MEDIA_TYPE} column indicating that file is a document file.
 */

public static final int MEDIA_TYPE_DOCUMENT = 6; // 0x6

/**
 * Constant for the {@link #MEDIA_TYPE} column indicating that file
 * is an image file.
 */

public static final int MEDIA_TYPE_IMAGE = 1; // 0x1

/**
 * Constant for the {@link #MEDIA_TYPE} column indicating that file
 * is not an audio, image, video, document, playlist, or subtitles file.
 */

public static final int MEDIA_TYPE_NONE = 0; // 0x0

/**
 * Constant for the {@link #MEDIA_TYPE} column indicating that file
 * is a playlist file.
 *
 * @deprecated Android playlists are now deprecated. We will keep the current
 *             functionality for compatibility reasons, but we will no longer take
 *             feature request. We do not advise adding new usages of Android Playlists.
 *             M3U files can be used as an alternative.
 */

@Deprecated public static final int MEDIA_TYPE_PLAYLIST = 4; // 0x4

/**
 * Constant for the {@link #MEDIA_TYPE} column indicating that file
 * is a subtitles or lyrics file.
 */

public static final int MEDIA_TYPE_SUBTITLE = 5; // 0x5

/**
 * Constant for the {@link #MEDIA_TYPE} column indicating that file
 * is a video file.
 */

public static final int MEDIA_TYPE_VIDEO = 3; // 0x3

/**
 * The MIME type of the media item.
 * <p>
 * This is typically defined based on the file extension of the media
 * item. However, it may be the value of the {@code format} attribute
 * defined by the <em>Dublin Core Media Initiative</em> standard,
 * extracted from any XMP metadata contained within this media item.
 * <p class="note">
 * Note: the {@code format} attribute may be ignored if the top-level
 * MIME type disagrees with the file extension. For example, it's
 * reasonable for an {@code image/jpeg} file to declare a {@code format}
 * of {@code image/vnd.google.panorama360+jpg}, but declaring a
 * {@code format} of {@code audio/ogg} would be ignored.
 * <p>
 * This is a read-only column that is automatically computed.

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_STRING Cursor#FIELD_TYPE_STRING} .
 */

public static final java.lang.String MIME_TYPE = "mime_type";

/**
 * The index of the parent directory of the file

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} , and are read-only and cannot be mutated.
 */

public static final java.lang.String PARENT = "parent";
}

}

/**
 * Collection of all media with MIME type of {@code image/*}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Images {

public Images() { throw new RuntimeException("Stub!"); }
/**
 * Image metadata columns.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface ImageColumns extends android.provider.MediaStore.MediaColumns {

/**
 * Indexed value of {@link android.media.ExifInterface#TAG_IMAGE_DESCRIPTION ExifInterface#TAG_IMAGE_DESCRIPTION}
 * extracted from this media item.

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_STRING Cursor#FIELD_TYPE_STRING} , and are read-only and cannot be mutated.
 */

public static final java.lang.String DESCRIPTION = "description";

/**
 * Indexed value of {@link android.media.ExifInterface#TAG_EXPOSURE_TIME ExifInterface#TAG_EXPOSURE_TIME}
 * extracted from this media item.

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_STRING Cursor#FIELD_TYPE_STRING} , and are read-only and cannot be mutated.
 */

public static final java.lang.String EXPOSURE_TIME = "exposure_time";

/**
 * Indexed value of {@link android.media.ExifInterface#TAG_F_NUMBER ExifInterface#TAG_F_NUMBER}
 * extracted from this media item.

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_STRING Cursor#FIELD_TYPE_STRING} , and are read-only and cannot be mutated.
 */

public static final java.lang.String F_NUMBER = "f_number";

/**
 * Indexed value of {@link android.media.ExifInterface#TAG_ISO_SPEED_RATINGS ExifInterface#TAG_ISO_SPEED_RATINGS}
 * extracted from this media item.

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} , and are read-only and cannot be mutated.
 */

public static final java.lang.String ISO = "iso";

/**
 * Whether the image should be published as public or private

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} .
 */

public static final java.lang.String IS_PRIVATE = "isprivate";

/**
 * The latitude where the image was captured.
 *
 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_FLOAT Cursor#FIELD_TYPE_FLOAT} , and are read-only and cannot be mutated.
 * @deprecated location details are no longer indexed for privacy
 *             reasons, and this value is now always {@code null}.
 *             You can still manually obtain location metadata using
 *             {@link android.media.ExifInterface#getLatLong(float[]) ExifInterface#getLatLong(float[])}.
 */

@Deprecated public static final java.lang.String LATITUDE = "latitude";

/**
 * The longitude where the image was captured.
 *
 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_FLOAT Cursor#FIELD_TYPE_FLOAT} , and are read-only and cannot be mutated.
 * @deprecated location details are no longer indexed for privacy
 *             reasons, and this value is now always {@code null}.
 *             You can still manually obtain location metadata using
 *             {@link android.media.ExifInterface#getLatLong(float[]) ExifInterface#getLatLong(float[])}.
 */

@Deprecated public static final java.lang.String LONGITUDE = "longitude";

/**
 * The mini thumb id.
 *
 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} .
 * @deprecated all thumbnails should be obtained via
 *             {@link android.provider.MediaStore.Images.Thumbnails#getThumbnail MediaStore.Images.Thumbnails#getThumbnail}, as this
 *             value is no longer supported.
 */

@Deprecated public static final java.lang.String MINI_THUMB_MAGIC = "mini_thumb_magic";

/**
 * The picasa id of the image
 *
 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_STRING Cursor#FIELD_TYPE_STRING} .
 * @deprecated this value was only relevant for images hosted on
 *             Picasa, which are no longer supported.
 */

@Deprecated public static final java.lang.String PICASA_ID = "picasa_id";

/**
 * Indexed value of {@link android.media.ExifInterface#TAG_SCENE_CAPTURE_TYPE ExifInterface#TAG_SCENE_CAPTURE_TYPE}
 * extracted from this media item.

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} , and are read-only and cannot be mutated.
 */

public static final java.lang.String SCENE_CAPTURE_TYPE = "scene_capture_type";
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Media implements android.provider.MediaStore.Images.ImageColumns {

public Media() { throw new RuntimeException("Stub!"); }

/**
 * @deprecated all queries should be performed through
 *             {@link android.content.ContentResolver ContentResolver} directly, which offers modern
 *             features like {@link android.os.CancellationSignal CancellationSignal}.
 */

@Deprecated
public static android.database.Cursor query(android.content.ContentResolver cr, android.net.Uri uri, java.lang.String[] projection) { throw new RuntimeException("Stub!"); }

/**
 * @deprecated all queries should be performed through
 *             {@link android.content.ContentResolver ContentResolver} directly, which offers modern
 *             features like {@link android.os.CancellationSignal CancellationSignal}.
 */

@Deprecated
public static android.database.Cursor query(android.content.ContentResolver cr, android.net.Uri uri, java.lang.String[] projection, java.lang.String where, java.lang.String orderBy) { throw new RuntimeException("Stub!"); }

/**
 * @deprecated all queries should be performed through
 *             {@link android.content.ContentResolver ContentResolver} directly, which offers modern
 *             features like {@link android.os.CancellationSignal CancellationSignal}.
 */

@Deprecated
public static android.database.Cursor query(android.content.ContentResolver cr, android.net.Uri uri, java.lang.String[] projection, java.lang.String selection, java.lang.String[] selectionArgs, java.lang.String orderBy) { throw new RuntimeException("Stub!"); }

/**
 * Retrieves an image for the given url as a {@link android.graphics.Bitmap Bitmap}.
 *
 * @param cr The content resolver to use
 * @param url The url of the image
 * @deprecated loading of images should be performed through
 *             {@link android.graphics.ImageDecoder#createSource(android.content.ContentResolver,android.net.Uri) ImageDecoder#createSource(ContentResolver, Uri)},
 *             which offers modern features like
 *             {@link android.graphics.PostProcessor PostProcessor}.
 */

@Deprecated
public static android.graphics.Bitmap getBitmap(android.content.ContentResolver cr, android.net.Uri url) throws java.io.FileNotFoundException, java.io.IOException { throw new RuntimeException("Stub!"); }

/**
 * Insert an image and create a thumbnail for it.
 *
 * @param cr The content resolver to use
 * @param imagePath The path to the image to insert
 * @param name The name of the image
 * @param description The description of the image
 * @return The URL to the newly created image
 * @deprecated inserting of images should be performed using
 *             {@link android.provider.MediaStore.MediaColumns#IS_PENDING MediaColumns#IS_PENDING}, which offers richer
 *             control over lifecycle.
 */

@Deprecated
public static java.lang.String insertImage(android.content.ContentResolver cr, java.lang.String imagePath, java.lang.String name, java.lang.String description) throws java.io.FileNotFoundException { throw new RuntimeException("Stub!"); }

/**
 * Insert an image and create a thumbnail for it.
 *
 * @param cr The content resolver to use
 * @param source The stream to use for the image
 * @param title The name of the image
 * @param description The description of the image
 * @return The URL to the newly created image, or <code>null</code> if the image failed to be stored
 *              for any reason.
 * @deprecated inserting of images should be performed using
 *             {@link android.provider.MediaStore.MediaColumns#IS_PENDING MediaColumns#IS_PENDING}, which offers richer
 *             control over lifecycle.
 */

@Deprecated
public static java.lang.String insertImage(android.content.ContentResolver cr, android.graphics.Bitmap source, java.lang.String title, java.lang.String description) { throw new RuntimeException("Stub!"); }

/**
 * Get the content:// style URI for the image media table on the
 * given volume.
 *
 * @param volumeName the name of the volume to get the URI for
 * @return the URI to the image media table on the given volume
 */

public static android.net.Uri getContentUri(java.lang.String volumeName) { throw new RuntimeException("Stub!"); }

/**
 * Get the content:// style URI for a single row in the images table
 * on the given volume.
 *
 * @param volumeName the name of the volume to get the URI for
 * This value cannot be {@code null}.
 * @param id the image to get the URI for
 * @return the URI to the images table on the given volume
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public static android.net.Uri getContentUri(@android.annotation.NonNull java.lang.String volumeName, long id) { throw new RuntimeException("Stub!"); }

/**
 * The MIME type of this directory of
 * images.  Note that each entry in this directory will have a standard
 * image MIME type as appropriate -- for example, image/jpeg.
 */

public static final java.lang.String CONTENT_TYPE = "vnd.android.cursor.dir/image";

/**
 * The default sort order for this table
 */

public static final java.lang.String DEFAULT_SORT_ORDER = "bucket_display_name";

/**
 * The content:// style URI for the "primary" external storage
 * volume.
 */

public static final android.net.Uri EXTERNAL_CONTENT_URI;
static { EXTERNAL_CONTENT_URI = null; }

/**
 * The content:// style URI for the internal storage.
 */

public static final android.net.Uri INTERNAL_CONTENT_URI;
static { INTERNAL_CONTENT_URI = null; }
}

/**
 * This class provides utility methods to obtain thumbnails for various
 * {@link android.provider.MediaStore.Images Images} items.
 *
 * @deprecated Callers should migrate to using
 *             {@link android.content.ContentResolver#loadThumbnail ContentResolver#loadThumbnail}, since it offers
 *             richer control over requested thumbnail sizes and
 *             cancellation behavior.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
@Deprecated
public static class Thumbnails implements android.provider.BaseColumns {

@Deprecated
public Thumbnails() { throw new RuntimeException("Stub!"); }

/**
 * @deprecated all queries should be performed through
 *             {@link android.content.ContentResolver ContentResolver} directly, which offers modern
 *             features like {@link android.os.CancellationSignal CancellationSignal}.
 */

@Deprecated
public static final android.database.Cursor query(android.content.ContentResolver cr, android.net.Uri uri, java.lang.String[] projection) { throw new RuntimeException("Stub!"); }

/**
 * @deprecated all queries should be performed through
 *             {@link android.content.ContentResolver ContentResolver} directly, which offers modern
 *             features like {@link android.os.CancellationSignal CancellationSignal}.
 */

@Deprecated
public static final android.database.Cursor queryMiniThumbnails(android.content.ContentResolver cr, android.net.Uri uri, int kind, java.lang.String[] projection) { throw new RuntimeException("Stub!"); }

/**
 * @deprecated all queries should be performed through
 *             {@link android.content.ContentResolver ContentResolver} directly, which offers modern
 *             features like {@link android.os.CancellationSignal CancellationSignal}.
 */

@Deprecated
public static final android.database.Cursor queryMiniThumbnail(android.content.ContentResolver cr, long origId, int kind, java.lang.String[] projection) { throw new RuntimeException("Stub!"); }

/**
 * Cancel any outstanding {@link #getThumbnail} requests, causing
 * them to return by throwing a {@link android.os.OperationCanceledException OperationCanceledException}.
 * <p>
 * This method has no effect on
 * {@link android.content.ContentResolver#loadThumbnail ContentResolver#loadThumbnail} calls, since they provide
 * their own {@link android.os.CancellationSignal CancellationSignal}.
 *
 * @deprecated Callers should migrate to using
 *             {@link android.content.ContentResolver#loadThumbnail ContentResolver#loadThumbnail}, since it
 *             offers richer control over requested thumbnail sizes
 *             and cancellation behavior.
 */

@Deprecated
public static void cancelThumbnailRequest(android.content.ContentResolver cr, long origId) { throw new RuntimeException("Stub!"); }

/**
 * Return thumbnail representing a specific image item. If a
 * thumbnail doesn't exist, this method will block until it's
 * generated. Callers are responsible for their own in-memory
 * caching of returned values.
 *
 * As of {@link android.os.Build.VERSION_CODES#Q}, this output
 * of the thumbnail has correct rotation, don't need to rotate
 * it again.
 *
 * @param imageId the image item to obtain a thumbnail for.
 * @param kind optimal thumbnail size desired.
 * @return decoded thumbnail, or {@code null} if problem was
 *         encountered.
 * @deprecated Callers should migrate to using
 *             {@link android.content.ContentResolver#loadThumbnail ContentResolver#loadThumbnail}, since it
 *             offers richer control over requested thumbnail sizes
 *             and cancellation behavior.
 */

@Deprecated
public static android.graphics.Bitmap getThumbnail(android.content.ContentResolver cr, long imageId, int kind, android.graphics.BitmapFactory.Options options) { throw new RuntimeException("Stub!"); }

/**
 * Cancel any outstanding {@link #getThumbnail} requests, causing
 * them to return by throwing a {@link android.os.OperationCanceledException OperationCanceledException}.
 * <p>
 * This method has no effect on
 * {@link android.content.ContentResolver#loadThumbnail ContentResolver#loadThumbnail} calls, since they provide
 * their own {@link android.os.CancellationSignal CancellationSignal}.
 *
 * @deprecated Callers should migrate to using
 *             {@link android.content.ContentResolver#loadThumbnail ContentResolver#loadThumbnail}, since it
 *             offers richer control over requested thumbnail sizes
 *             and cancellation behavior.
 */

@Deprecated
public static void cancelThumbnailRequest(android.content.ContentResolver cr, long origId, long groupId) { throw new RuntimeException("Stub!"); }

/**
 * Return thumbnail representing a specific image item. If a
 * thumbnail doesn't exist, this method will block until it's
 * generated. Callers are responsible for their own in-memory
 * caching of returned values.
 *
 * As of {@link android.os.Build.VERSION_CODES#Q}, this output
 * of the thumbnail has correct rotation, don't need to rotate
 * it again.
 *
 * @param imageId the image item to obtain a thumbnail for.
 * @param kind optimal thumbnail size desired.
 * @return decoded thumbnail, or {@code null} if problem was
 *         encountered.
 * @deprecated Callers should migrate to using
 *             {@link android.content.ContentResolver#loadThumbnail ContentResolver#loadThumbnail}, since it
 *             offers richer control over requested thumbnail sizes
 *             and cancellation behavior.
 */

@Deprecated
public static android.graphics.Bitmap getThumbnail(android.content.ContentResolver cr, long imageId, long groupId, int kind, android.graphics.BitmapFactory.Options options) { throw new RuntimeException("Stub!"); }

/**
 * Get the content:// style URI for the image media table on the
 * given volume.
 *
 * @param volumeName the name of the volume to get the URI for
 * @return the URI to the image media table on the given volume
 */

@Deprecated
public static android.net.Uri getContentUri(java.lang.String volumeName) { throw new RuntimeException("Stub!"); }

/**
 * Return the typical {@link android.util.Size Size} (in pixels) used internally when
 * the given thumbnail kind is requested.
 *
 * @deprecated Callers should migrate to using
 *             {@link android.content.ContentResolver#loadThumbnail ContentResolver#loadThumbnail}, since it
 *             offers richer control over requested thumbnail sizes
 *             and cancellation behavior.

 * @return This value cannot be {@code null}.
 */

@Deprecated
@android.annotation.NonNull
public static android.util.Size getKindSize(int kind) { throw new RuntimeException("Stub!"); }

/**
 * Path to the thumbnail file on disk.
 *
 * As of {@link android.os.Build.VERSION_CODES#Q}, this thumbnail
 * has correct rotation, don't need to rotate it again.

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_STRING Cursor#FIELD_TYPE_STRING} .
 */

@Deprecated public static final java.lang.String DATA = "_data";

/**
 * The default sort order for this table
 */

@Deprecated public static final java.lang.String DEFAULT_SORT_ORDER = "image_id ASC";

/**
 * The content:// style URI for the "primary" external storage
 * volume.
 */

@Deprecated public static final android.net.Uri EXTERNAL_CONTENT_URI;
static { EXTERNAL_CONTENT_URI = null; }

@Deprecated public static final int FULL_SCREEN_KIND = 2; // 0x2

/**
 * The height of the thumbnail

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} , and are read-only and cannot be mutated.
 */

@Deprecated public static final java.lang.String HEIGHT = "height";

/**
 * The original image for the thumbnal

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} .
 */

@Deprecated public static final java.lang.String IMAGE_ID = "image_id";

/**
 * The content:// style URI for the internal storage.
 */

@Deprecated public static final android.net.Uri INTERNAL_CONTENT_URI;
static { INTERNAL_CONTENT_URI = null; }

/**
 * The kind of the thumbnail

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} .
 */

@Deprecated public static final java.lang.String KIND = "kind";

@Deprecated public static final int MICRO_KIND = 3; // 0x3

@Deprecated public static final int MINI_KIND = 1; // 0x1

/**
 * The blob raw data of thumbnail
 *
 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_BLOB Cursor#FIELD_TYPE_BLOB} .
 * @deprecated this column never existed internally, and could never
 *             have returned valid data.
 */

@Deprecated public static final java.lang.String THUMB_DATA = "thumb_data";

/**
 * The width of the thumbnal

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} , and are read-only and cannot be mutated.
 */

@Deprecated public static final java.lang.String WIDTH = "width";
}

}

/**
 * Common media metadata columns.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface MediaColumns extends android.provider.BaseColumns {

/**
 * Indexed value of {@link android.media.MediaMetadataRetriever#METADATA_KEY_ALBUM MediaMetadataRetriever#METADATA_KEY_ALBUM}
 * extracted from this media item.

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_STRING Cursor#FIELD_TYPE_STRING} , and are read-only and cannot be mutated.
 */

public static final java.lang.String ALBUM = "album";

/**
 * Indexed value of {@link android.media.MediaMetadataRetriever#METADATA_KEY_ALBUMARTIST MediaMetadataRetriever#METADATA_KEY_ALBUMARTIST}
 * extracted from this media item.

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_STRING Cursor#FIELD_TYPE_STRING} , and are read-only and cannot be mutated.
 */

public static final java.lang.String ALBUM_ARTIST = "album_artist";

/**
 * Indexed value of {@link android.media.MediaMetadataRetriever#METADATA_KEY_ARTIST MediaMetadataRetriever#METADATA_KEY_ARTIST}
 * or {@link android.media.ExifInterface#TAG_ARTIST ExifInterface#TAG_ARTIST} extracted from this media item.

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_STRING Cursor#FIELD_TYPE_STRING} , and are read-only and cannot be mutated.
 */

public static final java.lang.String ARTIST = "artist";

/**
 * Indexed value of {@link android.media.MediaMetadataRetriever#METADATA_KEY_AUTHOR MediaMetadataRetriever#METADATA_KEY_AUTHOR}
 * extracted from this media item.

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_STRING Cursor#FIELD_TYPE_STRING} , and are read-only and cannot be mutated.
 */

public static final java.lang.String AUTHOR = "author";

/**
 * Indexed value of {@link android.media.MediaMetadataRetriever#METADATA_KEY_BITRATE MediaMetadataRetriever#METADATA_KEY_BITRATE}
 * extracted from this media item.

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} , and are read-only and cannot be mutated.
 */

public static final java.lang.String BITRATE = "bitrate";

/**
 * The primary bucket display name of this media item. This can be
 * useful to present the user a first-level clustering of related
 * media items. This is a read-only column that is automatically
 * computed.

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_STRING Cursor#FIELD_TYPE_STRING} , and are read-only and cannot be mutated.
 */

public static final java.lang.String BUCKET_DISPLAY_NAME = "bucket_display_name";

/**
 * The primary bucket ID of this media item. This can be useful to
 * present the user a first-level clustering of related media items.
 * This is a read-only column that is automatically computed.

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} , and are read-only and cannot be mutated.
 */

public static final java.lang.String BUCKET_ID = "bucket_id";

/**
 * Indexed value of
 * {@link android.media.MediaMetadataRetriever#METADATA_KEY_CAPTURE_FRAMERATE MediaMetadataRetriever#METADATA_KEY_CAPTURE_FRAMERATE}
 * extracted from this media item.

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_FLOAT Cursor#FIELD_TYPE_FLOAT} , and are read-only and cannot be mutated.
 */

public static final java.lang.String CAPTURE_FRAMERATE = "capture_framerate";

/**
 * Indexed value of
 * {@link android.media.MediaMetadataRetriever#METADATA_KEY_CD_TRACK_NUMBER MediaMetadataRetriever#METADATA_KEY_CD_TRACK_NUMBER} extracted
 * from this media item.

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_STRING Cursor#FIELD_TYPE_STRING} , and are read-only and cannot be mutated.
 */

public static final java.lang.String CD_TRACK_NUMBER = "cd_track_number";

/**
 * Indexed value of {@link android.media.MediaMetadataRetriever#METADATA_KEY_COMPILATION MediaMetadataRetriever#METADATA_KEY_COMPILATION}
 * extracted from this media item.

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_STRING Cursor#FIELD_TYPE_STRING} , and are read-only and cannot be mutated.
 */

public static final java.lang.String COMPILATION = "compilation";

/**
 * Indexed value of {@link android.media.MediaMetadataRetriever#METADATA_KEY_COMPOSER MediaMetadataRetriever#METADATA_KEY_COMPOSER}
 * extracted from this media item.

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_STRING Cursor#FIELD_TYPE_STRING} , and are read-only and cannot be mutated.
 */

public static final java.lang.String COMPOSER = "composer";

/**
 * Absolute filesystem path to the media item on disk.
 * <p>
 * Apps may use this path to do file operations. However, they should not assume that the
 * file is always available. Apps must be prepared to handle any file-based I/O errors that
 * could occur.
 * <p>
 * From Android 11 onwards, this column is read-only for apps that target
 * {@link android.os.Build.VERSION_CODES#R R} and higher. On those devices, when creating or
 * updating a uri, this column's value is not accepted. Instead, to update the
 * filesystem location of a file, use the values of the {@link #DISPLAY_NAME} and
 * {@link #RELATIVE_PATH} columns.
 * <p>
 * Though direct file operations are supported,
 * {@link android.content.ContentResolver#openFileDescriptor(android.net.Uri,java.lang.String) ContentResolver#openFileDescriptor(Uri, String)} API is recommended for better
 * performance.
 *

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_STRING Cursor#FIELD_TYPE_STRING} .
 */

public static final java.lang.String DATA = "_data";

/**
 * The time the media item was first added.

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} , and are read-only and cannot be mutated.
 */

public static final java.lang.String DATE_ADDED = "date_added";

/**
 * The time the media item should be considered expired. Typically only
 * meaningful in the context of {@link #IS_PENDING} or
 * {@link #IS_TRASHED}.
 * <p>
 * The value stored in this column is automatically calculated when
 * {@link #IS_PENDING} or {@link #IS_TRASHED} is changed. The default
 * pending expiration is typically 7 days, and the default trashed
 * expiration is typically 30 days.
 * <p>
 * Expired media items are automatically deleted once their expiration
 * time has passed, typically during during the next device idle period.

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} , and are read-only and cannot be mutated.
 */

public static final java.lang.String DATE_EXPIRES = "date_expires";

/**
 * Indexed value of {@link java.io.File#lastModified() File#lastModified()} extracted from this
 * media item.

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} , and are read-only and cannot be mutated.
 */

public static final java.lang.String DATE_MODIFIED = "date_modified";

/**
 * Indexed value of {@link android.media.MediaMetadataRetriever#METADATA_KEY_DATE MediaMetadataRetriever#METADATA_KEY_DATE} or
 * {@link android.media.ExifInterface#TAG_DATETIME_ORIGINAL ExifInterface#TAG_DATETIME_ORIGINAL} extracted from this media
 * item.
 * <p>
 * Note that images must define both
 * {@link android.media.ExifInterface#TAG_DATETIME_ORIGINAL ExifInterface#TAG_DATETIME_ORIGINAL} and
 * {@code ExifInterface#TAG_OFFSET_TIME_ORIGINAL} to reliably determine
 * this value in relation to the epoch.
 
 * <br>
 * Value is a non-negative timestamp measured as the number of
 * milliseconds since 1970-01-01T00:00:00Z.

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} , and are read-only and cannot be mutated.
 */

public static final java.lang.String DATE_TAKEN = "datetaken";

/**
 * Indexed value of {@link android.media.MediaMetadataRetriever#METADATA_KEY_DISC_NUMBER MediaMetadataRetriever#METADATA_KEY_DISC_NUMBER}
 * extracted from this media item.

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_STRING Cursor#FIELD_TYPE_STRING} , and are read-only and cannot be mutated.
 */

public static final java.lang.String DISC_NUMBER = "disc_number";

/**
 * The display name of the media item.
 * <p>
 * For example, an item stored at
 * {@code /storage/0000-0000/DCIM/Vacation/IMG1024.JPG} would have a
 * display name of {@code IMG1024.JPG}.

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_STRING Cursor#FIELD_TYPE_STRING} .
 */

public static final java.lang.String DISPLAY_NAME = "_display_name";

/**
 * The "document ID" GUID as defined by the <em>XMP Media
 * Management</em> standard, extracted from any XMP metadata contained
 * within this media item. The value is {@code null} when no metadata
 * was found.
 * <p>
 * Each "document ID" is created once for each new resource. Different
 * renditions of that resource are expected to have different IDs.

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_STRING Cursor#FIELD_TYPE_STRING} , and are read-only and cannot be mutated.
 */

public static final java.lang.String DOCUMENT_ID = "document_id";

/**
 * Indexed value of {@link android.media.MediaMetadataRetriever#METADATA_KEY_DURATION MediaMetadataRetriever#METADATA_KEY_DURATION}
 * extracted from this media item.
 
 * <br>
 * Value is a non-negative duration in milliseconds.

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} , and are read-only and cannot be mutated.
 */

public static final java.lang.String DURATION = "duration";

/**
 * Generation number at which metadata for this media item was first
 * inserted. This is useful for apps that are attempting to quickly
 * identify exactly which media items have been added since a previous
 * point in time. Generation numbers are monotonically increasing over
 * time, and can be safely arithmetically compared.
 * <p>
 * Detecting media additions using generation numbers is more robust
 * than using {@link #DATE_ADDED}, since those values may change in
 * unexpected ways when apps use {@link java.io.File#setLastModified(long) File#setLastModified(long)} or
 * when the system clock is set incorrectly.
 * <p>
 * Note that before comparing these detailed generation values, you
 * should first confirm that the overall version hasn't changed by
 * checking {@link android.provider.MediaStore#getVersion(android.content.Context,java.lang.String) MediaStore#getVersion(Context, String)}, since that
 * indicates when a more radical change has occurred. If the overall
 * version changes, you should assume that generation numbers have been
 * reset and perform a full synchronization pass.
 *
 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} , and are read-only and cannot be mutated.
 * @see android.provider.MediaStore#getGeneration(Context, String)
 */

public static final java.lang.String GENERATION_ADDED = "generation_added";

/**
 * Generation number at which metadata for this media item was last
 * changed. This is useful for apps that are attempting to quickly
 * identify exactly which media items have changed since a previous
 * point in time. Generation numbers are monotonically increasing over
 * time, and can be safely arithmetically compared.
 * <p>
 * Detecting media changes using generation numbers is more robust than
 * using {@link #DATE_MODIFIED}, since those values may change in
 * unexpected ways when apps use {@link java.io.File#setLastModified(long) File#setLastModified(long)} or
 * when the system clock is set incorrectly.
 * <p>
 * Note that before comparing these detailed generation values, you
 * should first confirm that the overall version hasn't changed by
 * checking {@link android.provider.MediaStore#getVersion(android.content.Context,java.lang.String) MediaStore#getVersion(Context, String)}, since that
 * indicates when a more radical change has occurred. If the overall
 * version changes, you should assume that generation numbers have been
 * reset and perform a full synchronization pass.
 *
 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} , and are read-only and cannot be mutated.
 * @see android.provider.MediaStore#getGeneration(Context, String)
 */

public static final java.lang.String GENERATION_MODIFIED = "generation_modified";

/**
 * Indexed value of {@link android.media.MediaMetadataRetriever#METADATA_KEY_GENRE MediaMetadataRetriever#METADATA_KEY_GENRE}
 * extracted from this media item.

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_STRING Cursor#FIELD_TYPE_STRING} , and are read-only and cannot be mutated.
 */

public static final java.lang.String GENRE = "genre";

/**
 * Indexed value of
 * {@link android.media.MediaMetadataRetriever#METADATA_KEY_VIDEO_HEIGHT MediaMetadataRetriever#METADATA_KEY_VIDEO_HEIGHT},
 * {@link android.media.MediaMetadataRetriever#METADATA_KEY_IMAGE_HEIGHT MediaMetadataRetriever#METADATA_KEY_IMAGE_HEIGHT} or
 * {@link android.media.ExifInterface#TAG_IMAGE_LENGTH ExifInterface#TAG_IMAGE_LENGTH} extracted from this media
 * item.
 * <p>
 * Type: INTEGER

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} , and are read-only and cannot be mutated.
 */

public static final java.lang.String HEIGHT = "height";

/**
 * The "instance ID" GUID as defined by the <em>XMP Media
 * Management</em> standard, extracted from any XMP metadata contained
 * within this media item. The value is {@code null} when no metadata
 * was found.
 * <p>
 * This "instance ID" changes with each save operation of a specific
 * "document ID".

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_STRING Cursor#FIELD_TYPE_STRING} , and are read-only and cannot be mutated.
 */

public static final java.lang.String INSTANCE_ID = "instance_id";

/**
 * Flag indicating if the media item has been marked as being part of
 * the {@link android.provider.MediaStore.Downloads Downloads} collection.

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} , and are read-only and cannot be mutated.
 */

public static final java.lang.String IS_DOWNLOAD = "is_download";

/**
 * Flag indicating if a media item is DRM protected.

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} .
 */

public static final java.lang.String IS_DRM = "is_drm";

/**
 * Flag indicating if the media item has been marked as being a
 * "favorite" by the user.
 *
 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} .
 * @see android.provider.MediaStore.MediaColumns#IS_FAVORITE
 * @see android.provider.MediaStore#QUERY_ARG_MATCH_FAVORITE
 * @see android.provider.MediaStore#createFavoriteRequest
 */

public static final java.lang.String IS_FAVORITE = "is_favorite";

/**
 * Flag indicating if a media item is pending, and still being inserted
 * by its owner. While this flag is set, only the owner of the item can
 * open the underlying file; requests from other apps will be rejected.
 * <p>
 * Pending items are retained either until they are published by setting
 * the field to {@code 0}, or until they expire as defined by
 * {@link #DATE_EXPIRES}.
 *
 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} .
 * @see android.provider.MediaStore#QUERY_ARG_MATCH_PENDING
 */

public static final java.lang.String IS_PENDING = "is_pending";

/**
 * Flag indicating if a media item is trashed.
 * <p>
 * Trashed items are retained until they expire as defined by
 * {@link #DATE_EXPIRES}.
 *
 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} .
 * @see android.provider.MediaStore.MediaColumns#IS_TRASHED
 * @see android.provider.MediaStore#QUERY_ARG_MATCH_TRASHED
 * @see android.provider.MediaStore#createTrashRequest
 */

public static final java.lang.String IS_TRASHED = "is_trashed";

/**
 * The MIME type of the media item.
 * <p>
 * This is typically defined based on the file extension of the media
 * item. However, it may be the value of the {@code format} attribute
 * defined by the <em>Dublin Core Media Initiative</em> standard,
 * extracted from any XMP metadata contained within this media item.
 * <p class="note">
 * Note: the {@code format} attribute may be ignored if the top-level
 * MIME type disagrees with the file extension. For example, it's
 * reasonable for an {@code image/jpeg} file to declare a {@code format}
 * of {@code image/vnd.google.panorama360+jpg}, but declaring a
 * {@code format} of {@code audio/ogg} would be ignored.
 * <p>
 * This is a read-only column that is automatically computed.

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_STRING Cursor#FIELD_TYPE_STRING} .
 */

public static final java.lang.String MIME_TYPE = "mime_type";

/**
 * Indexed value of {@link android.media.MediaMetadataRetriever#METADATA_KEY_NUM_TRACKS MediaMetadataRetriever#METADATA_KEY_NUM_TRACKS}
 * extracted from this media item.

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} , and are read-only and cannot be mutated.
 */

public static final java.lang.String NUM_TRACKS = "num_tracks";

/**
 * Indexed value of
 * {@link android.media.MediaMetadataRetriever#METADATA_KEY_VIDEO_ROTATION MediaMetadataRetriever#METADATA_KEY_VIDEO_ROTATION},
 * {@link android.media.MediaMetadataRetriever#METADATA_KEY_IMAGE_ROTATION MediaMetadataRetriever#METADATA_KEY_IMAGE_ROTATION}, or
 * {@link android.media.ExifInterface#TAG_ORIENTATION ExifInterface#TAG_ORIENTATION} extracted from this media item.
 * <p>
 * For consistency the indexed value is expressed in degrees, such as 0,
 * 90, 180, or 270.
 * <p>
 * Type: INTEGER

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} , and are read-only and cannot be mutated.
 */

public static final java.lang.String ORIENTATION = "orientation";

/**
 * The "original document ID" GUID as defined by the <em>XMP Media
 * Management</em> standard, extracted from any XMP metadata contained
 * within this media item.
 * <p>
 * This "original document ID" links a resource to its original source.
 * For example, when you save a PSD document as a JPEG, then convert the
 * JPEG to GIF format, the "original document ID" of both the JPEG and
 * GIF files is the "document ID" of the original PSD file.

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_STRING Cursor#FIELD_TYPE_STRING} , and are read-only and cannot be mutated.
 */

public static final java.lang.String ORIGINAL_DOCUMENT_ID = "original_document_id";

/**
 * Package name that contributed this media. The value may be
 * {@code NULL} if ownership cannot be reliably determined.
 * <p>
 * From Android {@link android.os.Build.VERSION_CODES#UPSIDE_DOWN_CAKE Build.VERSION_CODES#UPSIDE_DOWN_CAKE} onwards,
 * visibility and query of this field will depend on
 * <a href="/training/basics/intents/package-visibility">package visibility</a>.
 * For {@link android.content.ContentResolver#query ContentResolver#query} operation, result set will
 * be restricted to visible packages only.

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_STRING Cursor#FIELD_TYPE_STRING} , and are read-only and cannot be mutated.
 */

public static final java.lang.String OWNER_PACKAGE_NAME = "owner_package_name";

/**
 * Relative path of this media item within the storage device where it
 * is persisted. For example, an item stored at
 * {@code /storage/0000-0000/DCIM/Vacation/IMG1024.JPG} would have a
 * path of {@code DCIM/Vacation/}.
 * <p>
 * This value should only be used for organizational purposes, and you
 * should not attempt to construct or access a raw filesystem path using
 * this value. If you need to open a media item, use an API like
 * {@link android.content.ContentResolver#openFileDescriptor(android.net.Uri,java.lang.String) ContentResolver#openFileDescriptor(Uri, String)}.
 * <p>
 * When this value is set to {@code NULL} during an
 * {@link android.content.ContentResolver#insert ContentResolver#insert} operation, the newly created item will
 * be placed in a relevant default location based on the type of media
 * being inserted. For example, a {@code image/jpeg} item will be placed
 * under {@link android.os.Environment#DIRECTORY_PICTURES Environment#DIRECTORY_PICTURES}.
 * <p>
 * You can modify this column during an {@link android.content.ContentResolver#update ContentResolver#update}
 * call, which will move the underlying file on disk.
 * <p>
 * In both cases above, content must be placed under a top-level
 * directory that is relevant to the media type. For example, attempting
 * to place a {@code audio/mpeg} file under
 * {@link android.os.Environment#DIRECTORY_PICTURES Environment#DIRECTORY_PICTURES} will be rejected.

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_STRING Cursor#FIELD_TYPE_STRING} .
 */

public static final java.lang.String RELATIVE_PATH = "relative_path";

/**
 * Calculated value that combines {@link #WIDTH} and {@link #HEIGHT}
 * into a user-presentable string.

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_STRING Cursor#FIELD_TYPE_STRING} , and are read-only and cannot be mutated.
 */

public static final java.lang.String RESOLUTION = "resolution";

/**
 * Indexed value of {@link java.io.File#length() File#length()} extracted from this media
 * item.
 
 * <br>
 * Value is a non-negative number of bytes.

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} , and are read-only and cannot be mutated.
 */

public static final java.lang.String SIZE = "_size";

/**
 * Indexed value of {@link android.media.MediaMetadataRetriever#METADATA_KEY_TITLE MediaMetadataRetriever#METADATA_KEY_TITLE}
 * extracted from this media item.

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_STRING Cursor#FIELD_TYPE_STRING} , and are read-only and cannot be mutated.
 */

public static final java.lang.String TITLE = "title";

/**
 * Volume name of the specific storage device where this media item is
 * persisted. The value is typically one of the volume names returned
 * from {@link android.provider.MediaStore#getExternalVolumeNames(android.content.Context) MediaStore#getExternalVolumeNames(Context)}.
 * <p>
 * This is a read-only column that is automatically computed.

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_STRING Cursor#FIELD_TYPE_STRING} , and are read-only and cannot be mutated.
 */

public static final java.lang.String VOLUME_NAME = "volume_name";

/**
 * Indexed value of
 * {@link android.media.MediaMetadataRetriever#METADATA_KEY_VIDEO_WIDTH MediaMetadataRetriever#METADATA_KEY_VIDEO_WIDTH},
 * {@link android.media.MediaMetadataRetriever#METADATA_KEY_IMAGE_WIDTH MediaMetadataRetriever#METADATA_KEY_IMAGE_WIDTH} or
 * {@link android.media.ExifInterface#TAG_IMAGE_WIDTH ExifInterface#TAG_IMAGE_WIDTH} extracted from this media item.
 * <p>
 * Type: INTEGER

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} , and are read-only and cannot be mutated.
 */

public static final java.lang.String WIDTH = "width";

/**
 * Indexed value of {@link android.media.MediaMetadataRetriever#METADATA_KEY_WRITER MediaMetadataRetriever#METADATA_KEY_WRITER}
 * extracted from this media item.

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_STRING Cursor#FIELD_TYPE_STRING} , and are read-only and cannot be mutated.
 */

public static final java.lang.String WRITER = "writer";

/**
 * Indexed XMP metadata extracted from this media item.
 * <p>
 * The structure of this metadata is defined by the <a href=
 * "https://en.wikipedia.org/wiki/Extensible_Metadata_Platform"><em>XMP
 * Media Management</em> standard</a>, published as ISO 16684-1:2012.
 * <p>
 * This metadata is typically extracted from a
 * {@link android.media.ExifInterface#TAG_XMP ExifInterface#TAG_XMP} contained inside an image file or from
 * a {@code XMP_} box contained inside an ISO/IEC base media file format
 * (MPEG-4 Part 12).
 * <p>
 * Note that any location details are redacted from this metadata for
 * privacy reasons.

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_BLOB Cursor#FIELD_TYPE_BLOB} , and are read-only and cannot be mutated.
 */

public static final java.lang.String XMP = "xmp";

/**
 * Indexed value of {@link android.media.MediaMetadataRetriever#METADATA_KEY_YEAR MediaMetadataRetriever#METADATA_KEY_YEAR}
 * extracted from this media item.

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} , and are read-only and cannot be mutated.
 */

public static final java.lang.String YEAR = "year";
}

/**
 * Photo picker metadata columns.
 *
 * @see #ACTION_PICK_IMAGES
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class PickerMediaColumns {

PickerMediaColumns() { throw new RuntimeException("Stub!"); }

/**
 * This is identical to {@link android.provider.MediaStore.MediaColumns#DATA MediaColumns#DATA}, however, apps should not assume that the
 * file is always available because the file may be backed by a {@link android.provider.CloudMediaProvider CloudMediaProvider}
 * fetching content over a network. Therefore, apps must be prepared to handle any
 * additional file-based I/O errors that could occur as a result of network errors.
 *
 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_STRING Cursor#FIELD_TYPE_STRING} , and are read-only and cannot be mutated.
 * @see android.provider.MediaStore.MediaColumns#DATA
 */

public static final java.lang.String DATA = "_data";

/**
 * This is identical to {@link android.provider.MediaStore.MediaColumns#DATE_TAKEN MediaColumns#DATE_TAKEN}.
 *
 * <br>
 * Value is a non-negative timestamp measured as the number of
 * milliseconds since 1970-01-01T00:00:00Z.
 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} , and are read-only and cannot be mutated.
 * @see android.provider.MediaStore.MediaColumns#DATE_TAKEN
 */

public static final java.lang.String DATE_TAKEN = "datetaken";

/**
 * This is identical to {@link android.provider.MediaStore.MediaColumns#DISPLAY_NAME MediaColumns#DISPLAY_NAME}.
 *
 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_STRING Cursor#FIELD_TYPE_STRING} , and are read-only and cannot be mutated.
 * @see android.provider.MediaStore.MediaColumns#DISPLAY_NAME
 */

public static final java.lang.String DISPLAY_NAME = "_display_name";

/**
 * This is identical to {@link android.provider.MediaStore.MediaColumns#DURATION MediaColumns#DURATION}.
 *
 * <br>
 * Value is a non-negative duration in milliseconds.
 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} , and are read-only and cannot be mutated.
 * @see android.provider.MediaStore.MediaColumns#DURATION
 */

public static final java.lang.String DURATION_MILLIS = "duration";

/**
 * This is identical to {@link android.provider.MediaStore.MediaColumns#HEIGHT MediaColumns#HEIGHT}.
 *
 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} , and are read-only and cannot be mutated.
 * @see android.provider.MediaStore.MediaColumns#HEIGHT
 */

public static final java.lang.String HEIGHT = "height";

/**
 * This is identical to {@link android.provider.MediaStore.MediaColumns#MIME_TYPE MediaColumns#MIME_TYPE}.
 *
 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_STRING Cursor#FIELD_TYPE_STRING} , and are read-only and cannot be mutated.
 * @see android.provider.MediaStore.MediaColumns#MIME_TYPE
 */

public static final java.lang.String MIME_TYPE = "mime_type";

/**
 * This is identical to {@link android.provider.MediaStore.MediaColumns#ORIENTATION MediaColumns#ORIENTATION}.
 *
 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} , and are read-only and cannot be mutated.
 * @see android.provider.MediaStore.MediaColumns#ORIENTATION
 */

public static final java.lang.String ORIENTATION = "orientation";

/**
 * This is identical to {@link android.provider.MediaStore.MediaColumns#SIZE MediaColumns#SIZE}.
 *
 * <br>
 * Value is a non-negative number of bytes.
 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} , and are read-only and cannot be mutated.
 * @see android.provider.MediaStore.MediaColumns#SIZE
 */

public static final java.lang.String SIZE = "_size";

/**
 * This is identical to {@link android.provider.MediaStore.MediaColumns#WIDTH MediaColumns#WIDTH}.
 *
 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} , and are read-only and cannot be mutated.
 * @see android.provider.MediaStore.MediaColumns#WIDTH
 */

public static final java.lang.String WIDTH = "width";
}

/**
 * Collection of all media with MIME type of {@code video/*}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Video {

public Video() { throw new RuntimeException("Stub!"); }

/**
 * @deprecated all queries should be performed through
 *             {@link android.content.ContentResolver ContentResolver} directly, which offers modern
 *             features like {@link android.os.CancellationSignal CancellationSignal}.
 */

@Deprecated
public static android.database.Cursor query(android.content.ContentResolver cr, android.net.Uri uri, java.lang.String[] projection) { throw new RuntimeException("Stub!"); }

/**
 * The default sort order for this table.
 */

public static final java.lang.String DEFAULT_SORT_ORDER = "_display_name";
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Media implements android.provider.MediaStore.Video.VideoColumns {

public Media() { throw new RuntimeException("Stub!"); }

/**
 * Get the content:// style URI for the video media table on the
 * given volume.
 *
 * @param volumeName the name of the volume to get the URI for
 * @return the URI to the video media table on the given volume
 */

public static android.net.Uri getContentUri(java.lang.String volumeName) { throw new RuntimeException("Stub!"); }

/**
 * Get the content:// style URI for a single row in the videos table
 * on the given volume.
 *
 * @param volumeName the name of the volume to get the URI for
 * This value cannot be {@code null}.
 * @param id the video to get the URI for
 * @return the URI to the videos table on the given volume
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public static android.net.Uri getContentUri(@android.annotation.NonNull java.lang.String volumeName, long id) { throw new RuntimeException("Stub!"); }

/**
 * The MIME type for this table.
 */

public static final java.lang.String CONTENT_TYPE = "vnd.android.cursor.dir/video";

/**
 * The default sort order for this table
 */

public static final java.lang.String DEFAULT_SORT_ORDER = "title";

/**
 * The content:// style URI for the "primary" external storage
 * volume.
 */

public static final android.net.Uri EXTERNAL_CONTENT_URI;
static { EXTERNAL_CONTENT_URI = null; }

/**
 * The content:// style URI for the internal storage.
 */

public static final android.net.Uri INTERNAL_CONTENT_URI;
static { INTERNAL_CONTENT_URI = null; }
}

/**
 * This class provides utility methods to obtain thumbnails for various
 * {@link android.provider.MediaStore.Video Video} items.
 *
 * @deprecated Callers should migrate to using
 *             {@link android.content.ContentResolver#loadThumbnail ContentResolver#loadThumbnail}, since it offers
 *             richer control over requested thumbnail sizes and
 *             cancellation behavior.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
@Deprecated
public static class Thumbnails implements android.provider.BaseColumns {

@Deprecated
public Thumbnails() { throw new RuntimeException("Stub!"); }

/**
 * Cancel any outstanding {@link #getThumbnail} requests, causing
 * them to return by throwing a {@link android.os.OperationCanceledException OperationCanceledException}.
 * <p>
 * This method has no effect on
 * {@link android.content.ContentResolver#loadThumbnail ContentResolver#loadThumbnail} calls, since they provide
 * their own {@link android.os.CancellationSignal CancellationSignal}.
 *
 * @deprecated Callers should migrate to using
 *             {@link android.content.ContentResolver#loadThumbnail ContentResolver#loadThumbnail}, since it
 *             offers richer control over requested thumbnail sizes
 *             and cancellation behavior.
 */

@Deprecated
public static void cancelThumbnailRequest(android.content.ContentResolver cr, long origId) { throw new RuntimeException("Stub!"); }

/**
 * Return thumbnail representing a specific video item. If a
 * thumbnail doesn't exist, this method will block until it's
 * generated. Callers are responsible for their own in-memory
 * caching of returned values.
 *
 * @param videoId the video item to obtain a thumbnail for.
 * @param kind optimal thumbnail size desired.
 * @return decoded thumbnail, or {@code null} if problem was
 *         encountered.
 * @deprecated Callers should migrate to using
 *             {@link android.content.ContentResolver#loadThumbnail ContentResolver#loadThumbnail}, since it
 *             offers richer control over requested thumbnail sizes
 *             and cancellation behavior.
 */

@Deprecated
public static android.graphics.Bitmap getThumbnail(android.content.ContentResolver cr, long videoId, int kind, android.graphics.BitmapFactory.Options options) { throw new RuntimeException("Stub!"); }

/**
 * Cancel any outstanding {@link #getThumbnail} requests, causing
 * them to return by throwing a {@link android.os.OperationCanceledException OperationCanceledException}.
 * <p>
 * This method has no effect on
 * {@link android.content.ContentResolver#loadThumbnail ContentResolver#loadThumbnail} calls, since they provide
 * their own {@link android.os.CancellationSignal CancellationSignal}.
 *
 * @deprecated Callers should migrate to using
 *             {@link android.content.ContentResolver#loadThumbnail ContentResolver#loadThumbnail}, since it
 *             offers richer control over requested thumbnail sizes
 *             and cancellation behavior.
 */

@Deprecated
public static void cancelThumbnailRequest(android.content.ContentResolver cr, long videoId, long groupId) { throw new RuntimeException("Stub!"); }

/**
 * Return thumbnail representing a specific video item. If a
 * thumbnail doesn't exist, this method will block until it's
 * generated. Callers are responsible for their own in-memory
 * caching of returned values.
 *
 * @param videoId the video item to obtain a thumbnail for.
 * @param kind optimal thumbnail size desired.
 * @return decoded thumbnail, or {@code null} if problem was
 *         encountered.
 * @deprecated Callers should migrate to using
 *             {@link android.content.ContentResolver#loadThumbnail ContentResolver#loadThumbnail}, since it
 *             offers richer control over requested thumbnail sizes
 *             and cancellation behavior.
 */

@Deprecated
public static android.graphics.Bitmap getThumbnail(android.content.ContentResolver cr, long videoId, long groupId, int kind, android.graphics.BitmapFactory.Options options) { throw new RuntimeException("Stub!"); }

/**
 * Get the content:// style URI for the image media table on the
 * given volume.
 *
 * @param volumeName the name of the volume to get the URI for
 * @return the URI to the image media table on the given volume
 */

@Deprecated
public static android.net.Uri getContentUri(java.lang.String volumeName) { throw new RuntimeException("Stub!"); }

/**
 * Return the typical {@link android.util.Size Size} (in pixels) used internally when
 * the given thumbnail kind is requested.
 *
 * @deprecated Callers should migrate to using
 *             {@link android.content.ContentResolver#loadThumbnail ContentResolver#loadThumbnail}, since it
 *             offers richer control over requested thumbnail sizes
 *             and cancellation behavior.

 * @return This value cannot be {@code null}.
 */

@Deprecated
@android.annotation.NonNull
public static android.util.Size getKindSize(int kind) { throw new RuntimeException("Stub!"); }

/**
 * Path to the thumbnail file on disk.

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_STRING Cursor#FIELD_TYPE_STRING} .
 */

@Deprecated public static final java.lang.String DATA = "_data";

/**
 * The default sort order for this table
 */

@Deprecated public static final java.lang.String DEFAULT_SORT_ORDER = "video_id ASC";

/**
 * The content:// style URI for the "primary" external storage
 * volume.
 */

@Deprecated public static final android.net.Uri EXTERNAL_CONTENT_URI;
static { EXTERNAL_CONTENT_URI = null; }

@Deprecated public static final int FULL_SCREEN_KIND = 2; // 0x2

/**
 * The height of the thumbnail

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} , and are read-only and cannot be mutated.
 */

@Deprecated public static final java.lang.String HEIGHT = "height";

/**
 * The content:// style URI for the internal storage.
 */

@Deprecated public static final android.net.Uri INTERNAL_CONTENT_URI;
static { INTERNAL_CONTENT_URI = null; }

/**
 * The kind of the thumbnail

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} .
 */

@Deprecated public static final java.lang.String KIND = "kind";

@Deprecated public static final int MICRO_KIND = 3; // 0x3

@Deprecated public static final int MINI_KIND = 1; // 0x1

/**
 * The original image for the thumbnal

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} .
 */

@Deprecated public static final java.lang.String VIDEO_ID = "video_id";

/**
 * The width of the thumbnal

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} , and are read-only and cannot be mutated.
 */

@Deprecated public static final java.lang.String WIDTH = "width";
}

/**
 * Video metadata columns.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface VideoColumns extends android.provider.MediaStore.MediaColumns {

/**
 * The position within the video item at which playback should be
 * resumed.
 
 * <br>
 * Value is a non-negative duration in milliseconds.

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} .
 */

public static final java.lang.String BOOKMARK = "bookmark";

/**
 * The YouTube category of the video

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_STRING Cursor#FIELD_TYPE_STRING} .
 */

public static final java.lang.String CATEGORY = "category";

/**
 * The color range of this media file, if available.
 *
 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} , and are read-only and cannot be mutated.
 * @see android.media.MediaFormat#COLOR_RANGE_LIMITED
 * @see android.media.MediaFormat#COLOR_RANGE_FULL
 */

public static final java.lang.String COLOR_RANGE = "color_range";

/**
 * The color standard of this media file, if available.
 *
 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} , and are read-only and cannot be mutated.
 * @see android.media.MediaFormat#COLOR_STANDARD_BT709
 * @see android.media.MediaFormat#COLOR_STANDARD_BT601_PAL
 * @see android.media.MediaFormat#COLOR_STANDARD_BT601_NTSC
 * @see android.media.MediaFormat#COLOR_STANDARD_BT2020
 */

public static final java.lang.String COLOR_STANDARD = "color_standard";

/**
 * The color transfer of this media file, if available.
 *
 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} , and are read-only and cannot be mutated.
 * @see android.media.MediaFormat#COLOR_TRANSFER_LINEAR
 * @see android.media.MediaFormat#COLOR_TRANSFER_SDR_VIDEO
 * @see android.media.MediaFormat#COLOR_TRANSFER_ST2084
 * @see android.media.MediaFormat#COLOR_TRANSFER_HLG
 */

public static final java.lang.String COLOR_TRANSFER = "color_transfer";

/**
 * The description of the video recording

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_STRING Cursor#FIELD_TYPE_STRING} , and are read-only and cannot be mutated.
 */

public static final java.lang.String DESCRIPTION = "description";

/**
 * Whether the video should be published as public or private

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} .
 */

public static final java.lang.String IS_PRIVATE = "isprivate";

/**
 * The language of the video

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_STRING Cursor#FIELD_TYPE_STRING} .
 */

public static final java.lang.String LANGUAGE = "language";

/**
 * The latitude where the video was captured.
 *
 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_FLOAT Cursor#FIELD_TYPE_FLOAT} , and are read-only and cannot be mutated.
 * @deprecated location details are no longer indexed for privacy
 *             reasons, and this value is now always {@code null}.
 *             You can still manually obtain location metadata using
 *             {@link android.media.MediaMetadataRetriever#METADATA_KEY_LOCATION MediaMetadataRetriever#METADATA_KEY_LOCATION}.
 */

@Deprecated public static final java.lang.String LATITUDE = "latitude";

/**
 * The longitude where the video was captured.
 *
 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_FLOAT Cursor#FIELD_TYPE_FLOAT} , and are read-only and cannot be mutated.
 * @deprecated location details are no longer indexed for privacy
 *             reasons, and this value is now always {@code null}.
 *             You can still manually obtain location metadata using
 *             {@link android.media.MediaMetadataRetriever#METADATA_KEY_LOCATION MediaMetadataRetriever#METADATA_KEY_LOCATION}.
 */

@Deprecated public static final java.lang.String LONGITUDE = "longitude";

/**
 * The mini thumb id.
 *
 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_INTEGER Cursor#FIELD_TYPE_INTEGER} .
 * @deprecated all thumbnails should be obtained via
 *             {@link android.provider.MediaStore.Images.Thumbnails#getThumbnail MediaStore.Images.Thumbnails#getThumbnail}, as this
 *             value is no longer supported.
 */

@Deprecated public static final java.lang.String MINI_THUMB_MAGIC = "mini_thumb_magic";

/**
 * The user-added tags associated with a video

 * <br>
 * This constant represents a column name that can be used with a {@link android.content.ContentProvider} through a {@link android.content.ContentValues} or {@link android.database.Cursor} object. The values stored in this column are {@link android.database.Cursor#FIELD_TYPE_STRING Cursor#FIELD_TYPE_STRING} .
 */

public static final java.lang.String TAGS = "tags";
}

}

}

