/*
 * Copyright (C) 2007 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.provider;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class MediaStore {

public MediaStore() { throw new RuntimeException("Stub!"); }

public static int getPickImagesMaxLimit() { throw new RuntimeException("Stub!"); }

@Deprecated
@android.annotation.NonNull
public static android.net.Uri setIncludePending(@android.annotation.NonNull android.net.Uri uri) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.net.Uri setRequireOriginal(@android.annotation.NonNull android.net.Uri uri) { throw new RuntimeException("Stub!"); }

public static boolean getRequireOriginal(@android.annotation.NonNull android.net.Uri uri) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.os.ParcelFileDescriptor getOriginalMediaFormatFileDescriptor(@android.annotation.NonNull android.content.Context context, @android.annotation.NonNull android.os.ParcelFileDescriptor fileDescriptor) throws java.io.IOException { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.net.Uri rewriteToLegacy(@android.annotation.NonNull android.net.Uri uri) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.app.PendingIntent createWriteRequest(@android.annotation.NonNull android.content.ContentResolver resolver, @android.annotation.NonNull java.util.Collection<android.net.Uri> uris) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.app.PendingIntent createTrashRequest(@android.annotation.NonNull android.content.ContentResolver resolver, @android.annotation.NonNull java.util.Collection<android.net.Uri> uris, boolean value) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.app.PendingIntent createFavoriteRequest(@android.annotation.NonNull android.content.ContentResolver resolver, @android.annotation.NonNull java.util.Collection<android.net.Uri> uris, boolean value) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.app.PendingIntent createDeleteRequest(@android.annotation.NonNull android.content.ContentResolver resolver, @android.annotation.NonNull java.util.Collection<android.net.Uri> uris) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static java.util.Set<java.lang.String> getExternalVolumeNames(@android.annotation.NonNull android.content.Context context) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static java.util.Set<java.lang.String> getRecentExternalVolumeNames(@android.annotation.NonNull android.content.Context context) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static java.lang.String getVolumeName(@android.annotation.NonNull android.net.Uri uri) { throw new RuntimeException("Stub!"); }

public static android.net.Uri getMediaScannerUri() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static java.lang.String getVersion(@android.annotation.NonNull android.content.Context context) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static java.lang.String getVersion(@android.annotation.NonNull android.content.Context context, @android.annotation.NonNull java.lang.String volumeName) { throw new RuntimeException("Stub!"); }

public static long getGeneration(@android.annotation.NonNull android.content.Context context, @android.annotation.NonNull java.lang.String volumeName) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public static android.net.Uri getDocumentUri(@android.annotation.NonNull android.content.Context context, @android.annotation.NonNull android.net.Uri mediaUri) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public static android.net.Uri getMediaUri(@android.annotation.NonNull android.content.Context context, @android.annotation.NonNull android.net.Uri documentUri) { throw new RuntimeException("Stub!"); }

public static boolean isCurrentSystemGallery(@android.annotation.NonNull android.content.ContentResolver resolver, int uid, @android.annotation.NonNull java.lang.String packageName) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public static android.net.Uri getRedactedUri(@android.annotation.NonNull android.content.ContentResolver resolver, @android.annotation.NonNull android.net.Uri uri) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static java.util.List<android.net.Uri> getRedactedUri(@android.annotation.NonNull android.content.ContentResolver resolver, @android.annotation.NonNull java.util.List<android.net.Uri> uris) { throw new RuntimeException("Stub!"); }

public static void waitForIdle(@android.annotation.NonNull android.content.ContentResolver resolver) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.net.Uri scanFile(@android.annotation.NonNull android.content.ContentResolver resolver, @android.annotation.NonNull java.io.File file) { throw new RuntimeException("Stub!"); }

public static void scanVolume(@android.annotation.NonNull android.content.ContentResolver resolver, @android.annotation.NonNull java.lang.String volumeName) { throw new RuntimeException("Stub!"); }

public static boolean canManageMedia(@android.annotation.NonNull android.content.Context context) { throw new RuntimeException("Stub!"); }

public static boolean isCurrentCloudMediaProviderAuthority(@android.annotation.NonNull android.content.ContentResolver resolver, @android.annotation.NonNull java.lang.String authority) { throw new RuntimeException("Stub!"); }

public static boolean isSupportedCloudMediaProviderAuthority(@android.annotation.NonNull android.content.ContentResolver resolver, @android.annotation.NonNull java.lang.String authority) { throw new RuntimeException("Stub!"); }

public static void notifyCloudMediaChangedEvent(@android.annotation.NonNull android.content.ContentResolver resolver, @android.annotation.NonNull java.lang.String authority, @android.annotation.NonNull java.lang.String currentMediaCollectionId) throws java.lang.SecurityException { throw new RuntimeException("Stub!"); }

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String ACTION_IMAGE_CAPTURE = "android.media.action.IMAGE_CAPTURE";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String ACTION_IMAGE_CAPTURE_SECURE = "android.media.action.IMAGE_CAPTURE_SECURE";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String ACTION_PICK_IMAGES = "android.provider.action.PICK_IMAGES";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String ACTION_PICK_IMAGES_SETTINGS = "android.provider.action.PICK_IMAGES_SETTINGS";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String ACTION_REVIEW = "android.provider.action.REVIEW";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String ACTION_REVIEW_SECURE = "android.provider.action.REVIEW_SECURE";

public static final java.lang.String ACTION_USER_SELECT_IMAGES_FOR_APP = "android.provider.action.USER_SELECT_IMAGES_FOR_APP";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String ACTION_VIDEO_CAPTURE = "android.media.action.VIDEO_CAPTURE";

public static final java.lang.String AUTHORITY = "media";

public static final java.lang.String AUTHORITY_LEGACY = "media_legacy";

@android.annotation.NonNull public static final android.net.Uri AUTHORITY_LEGACY_URI;
static { AUTHORITY_LEGACY_URI = null; }

@android.annotation.NonNull public static final android.net.Uri AUTHORITY_URI;
static { AUTHORITY_URI = null; }

public static final java.lang.String EXTRA_ACCEPT_ORIGINAL_MEDIA_FORMAT = "android.provider.extra.ACCEPT_ORIGINAL_MEDIA_FORMAT";

public static final java.lang.String EXTRA_BRIGHTNESS = "android.provider.extra.BRIGHTNESS";

public static final java.lang.String EXTRA_DURATION_LIMIT = "android.intent.extra.durationLimit";

public static final java.lang.String EXTRA_FINISH_ON_COMPLETION = "android.intent.extra.finishOnCompletion";

public static final java.lang.String EXTRA_FULL_SCREEN = "android.intent.extra.fullScreen";

public static final java.lang.String EXTRA_MEDIA_ALBUM = "android.intent.extra.album";

public static final java.lang.String EXTRA_MEDIA_ARTIST = "android.intent.extra.artist";

public static final java.lang.String EXTRA_MEDIA_CAPABILITIES = "android.provider.extra.MEDIA_CAPABILITIES";

public static final java.lang.String EXTRA_MEDIA_CAPABILITIES_UID = "android.provider.extra.MEDIA_CAPABILITIES_UID";

public static final java.lang.String EXTRA_MEDIA_FOCUS = "android.intent.extra.focus";

public static final java.lang.String EXTRA_MEDIA_GENRE = "android.intent.extra.genre";

@Deprecated public static final java.lang.String EXTRA_MEDIA_PLAYLIST = "android.intent.extra.playlist";

public static final java.lang.String EXTRA_MEDIA_RADIO_CHANNEL = "android.intent.extra.radio_channel";

public static final java.lang.String EXTRA_MEDIA_TITLE = "android.intent.extra.title";

public static final java.lang.String EXTRA_OUTPUT = "output";

public static final java.lang.String EXTRA_PICK_IMAGES_MAX = "android.provider.extra.PICK_IMAGES_MAX";

public static final java.lang.String EXTRA_SCREEN_ORIENTATION = "android.intent.extra.screenOrientation";

public static final java.lang.String EXTRA_SHOW_ACTION_ICONS = "android.intent.extra.showActionIcons";

public static final java.lang.String EXTRA_SIZE_LIMIT = "android.intent.extra.sizeLimit";

public static final java.lang.String EXTRA_VIDEO_QUALITY = "android.intent.extra.videoQuality";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String INTENT_ACTION_MEDIA_PLAY_FROM_SEARCH = "android.media.action.MEDIA_PLAY_FROM_SEARCH";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String INTENT_ACTION_MEDIA_SEARCH = "android.intent.action.MEDIA_SEARCH";

@Deprecated @android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String INTENT_ACTION_MUSIC_PLAYER = "android.intent.action.MUSIC_PLAYER";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String INTENT_ACTION_STILL_IMAGE_CAMERA = "android.media.action.STILL_IMAGE_CAMERA";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String INTENT_ACTION_STILL_IMAGE_CAMERA_SECURE = "android.media.action.STILL_IMAGE_CAMERA_SECURE";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String INTENT_ACTION_TEXT_OPEN_FROM_SEARCH = "android.media.action.TEXT_OPEN_FROM_SEARCH";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String INTENT_ACTION_VIDEO_CAMERA = "android.media.action.VIDEO_CAMERA";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String INTENT_ACTION_VIDEO_PLAY_FROM_SEARCH = "android.media.action.VIDEO_PLAY_FROM_SEARCH";

public static final int MATCH_DEFAULT = 0; // 0x0

public static final int MATCH_EXCLUDE = 2; // 0x2

public static final int MATCH_INCLUDE = 1; // 0x1

public static final int MATCH_ONLY = 3; // 0x3

public static final java.lang.String MEDIA_IGNORE_FILENAME = ".nomedia";

public static final java.lang.String MEDIA_SCANNER_VOLUME = "volume";

public static final java.lang.String META_DATA_REVIEW_GALLERY_PREWARM_SERVICE = "android.media.review_gallery_prewarm_service";

public static final java.lang.String META_DATA_STILL_IMAGE_CAMERA_PREWARM_SERVICE = "android.media.still_image_camera_preview_service";

public static final java.lang.String QUERY_ARG_DEFER_SCAN = "android:query-arg-defer-scan";

public static final java.lang.String QUERY_ARG_INCLUDE_RECENTLY_UNMOUNTED_VOLUMES = "android:query-arg-recently-unmounted-volumes";

public static final java.lang.String QUERY_ARG_MATCH_FAVORITE = "android:query-arg-match-favorite";

public static final java.lang.String QUERY_ARG_MATCH_PENDING = "android:query-arg-match-pending";

public static final java.lang.String QUERY_ARG_MATCH_TRASHED = "android:query-arg-match-trashed";

public static final java.lang.String QUERY_ARG_RELATED_URI = "android:query-arg-related-uri";

public static final java.lang.String UNKNOWN_STRING = "<unknown>";

public static final java.lang.String VOLUME_EXTERNAL = "external";

public static final java.lang.String VOLUME_EXTERNAL_PRIMARY = "external_primary";

public static final java.lang.String VOLUME_INTERNAL = "internal";
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Audio {

public Audio() { throw new RuntimeException("Stub!"); }

@Deprecated
@android.annotation.Nullable
public static java.lang.String keyFor(@android.annotation.Nullable java.lang.String name) { throw new RuntimeException("Stub!"); }
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface AlbumColumns {

public static final java.lang.String ALBUM = "album";

@Deprecated public static final java.lang.String ALBUM_ART = "album_art";

public static final java.lang.String ALBUM_ID = "album_id";

@Deprecated public static final java.lang.String ALBUM_KEY = "album_key";

public static final java.lang.String ARTIST = "artist";

public static final java.lang.String ARTIST_ID = "artist_id";

@Deprecated public static final java.lang.String ARTIST_KEY = "artist_key";

public static final java.lang.String FIRST_YEAR = "minyear";

public static final java.lang.String LAST_YEAR = "maxyear";

public static final java.lang.String NUMBER_OF_SONGS = "numsongs";

public static final java.lang.String NUMBER_OF_SONGS_FOR_ARTIST = "numsongs_by_artist";
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Albums implements android.provider.BaseColumns, android.provider.MediaStore.Audio.AlbumColumns {

public Albums() { throw new RuntimeException("Stub!"); }

public static android.net.Uri getContentUri(java.lang.String volumeName) { throw new RuntimeException("Stub!"); }

public static final java.lang.String CONTENT_TYPE = "vnd.android.cursor.dir/albums";

public static final java.lang.String DEFAULT_SORT_ORDER = "album_key";

public static final java.lang.String ENTRY_CONTENT_TYPE = "vnd.android.cursor.item/album";

public static final android.net.Uri EXTERNAL_CONTENT_URI;
static { EXTERNAL_CONTENT_URI = null; }

public static final android.net.Uri INTERNAL_CONTENT_URI;
static { INTERNAL_CONTENT_URI = null; }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface ArtistColumns {

public static final java.lang.String ARTIST = "artist";

@Deprecated public static final java.lang.String ARTIST_KEY = "artist_key";

public static final java.lang.String NUMBER_OF_ALBUMS = "number_of_albums";

public static final java.lang.String NUMBER_OF_TRACKS = "number_of_tracks";
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Artists implements android.provider.BaseColumns, android.provider.MediaStore.Audio.ArtistColumns {

public Artists() { throw new RuntimeException("Stub!"); }

public static android.net.Uri getContentUri(java.lang.String volumeName) { throw new RuntimeException("Stub!"); }

public static final java.lang.String CONTENT_TYPE = "vnd.android.cursor.dir/artists";

public static final java.lang.String DEFAULT_SORT_ORDER = "artist_key";

public static final java.lang.String ENTRY_CONTENT_TYPE = "vnd.android.cursor.item/artist";

public static final android.net.Uri EXTERNAL_CONTENT_URI;
static { EXTERNAL_CONTENT_URI = null; }

public static final android.net.Uri INTERNAL_CONTENT_URI;
static { INTERNAL_CONTENT_URI = null; }
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Albums implements android.provider.BaseColumns, android.provider.MediaStore.Audio.AlbumColumns {

public Albums() { throw new RuntimeException("Stub!"); }

public static android.net.Uri getContentUri(java.lang.String volumeName, long artistId) { throw new RuntimeException("Stub!"); }
}

}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface AudioColumns extends android.provider.MediaStore.MediaColumns {

public static final java.lang.String ALBUM_ID = "album_id";

@Deprecated public static final java.lang.String ALBUM_KEY = "album_key";

public static final java.lang.String ARTIST_ID = "artist_id";

@Deprecated public static final java.lang.String ARTIST_KEY = "artist_key";

public static final java.lang.String BOOKMARK = "bookmark";

public static final java.lang.String GENRE = "genre";

public static final java.lang.String GENRE_ID = "genre_id";

@Deprecated public static final java.lang.String GENRE_KEY = "genre_key";

public static final java.lang.String IS_ALARM = "is_alarm";

public static final java.lang.String IS_AUDIOBOOK = "is_audiobook";

public static final java.lang.String IS_MUSIC = "is_music";

public static final java.lang.String IS_NOTIFICATION = "is_notification";

public static final java.lang.String IS_PODCAST = "is_podcast";

public static final java.lang.String IS_RECORDING = "is_recording";

public static final java.lang.String IS_RINGTONE = "is_ringtone";

@Deprecated public static final java.lang.String TITLE_KEY = "title_key";

public static final java.lang.String TITLE_RESOURCE_URI = "title_resource_uri";

public static final java.lang.String TRACK = "track";

public static final java.lang.String YEAR = "year";
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Genres implements android.provider.BaseColumns, android.provider.MediaStore.Audio.GenresColumns {

public Genres() { throw new RuntimeException("Stub!"); }

public static android.net.Uri getContentUri(java.lang.String volumeName) { throw new RuntimeException("Stub!"); }

public static android.net.Uri getContentUriForAudioId(java.lang.String volumeName, int audioId) { throw new RuntimeException("Stub!"); }

public static final java.lang.String CONTENT_TYPE = "vnd.android.cursor.dir/genre";

public static final java.lang.String DEFAULT_SORT_ORDER = "name";

public static final java.lang.String ENTRY_CONTENT_TYPE = "vnd.android.cursor.item/genre";

public static final android.net.Uri EXTERNAL_CONTENT_URI;
static { EXTERNAL_CONTENT_URI = null; }

public static final android.net.Uri INTERNAL_CONTENT_URI;
static { INTERNAL_CONTENT_URI = null; }
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Members implements android.provider.MediaStore.Audio.AudioColumns {

public Members() { throw new RuntimeException("Stub!"); }

public static android.net.Uri getContentUri(java.lang.String volumeName, long genreId) { throw new RuntimeException("Stub!"); }

public static final java.lang.String AUDIO_ID = "audio_id";

public static final java.lang.String CONTENT_DIRECTORY = "members";

public static final java.lang.String DEFAULT_SORT_ORDER = "title_key";

public static final java.lang.String GENRE_ID = "genre_id";
}

}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface GenresColumns {

public static final java.lang.String NAME = "name";
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Media implements android.provider.MediaStore.Audio.AudioColumns {

public Media() { throw new RuntimeException("Stub!"); }

public static android.net.Uri getContentUri(java.lang.String volumeName) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.net.Uri getContentUri(@android.annotation.NonNull java.lang.String volumeName, long id) { throw new RuntimeException("Stub!"); }

@Deprecated
@android.annotation.Nullable
public static android.net.Uri getContentUriForPath(@android.annotation.NonNull java.lang.String path) { throw new RuntimeException("Stub!"); }

public static final java.lang.String CONTENT_TYPE = "vnd.android.cursor.dir/audio";

public static final java.lang.String DEFAULT_SORT_ORDER = "title_key";

public static final java.lang.String ENTRY_CONTENT_TYPE = "vnd.android.cursor.item/audio";

public static final android.net.Uri EXTERNAL_CONTENT_URI;
static { EXTERNAL_CONTENT_URI = null; }

public static final java.lang.String EXTRA_MAX_BYTES = "android.provider.MediaStore.extra.MAX_BYTES";

public static final android.net.Uri INTERNAL_CONTENT_URI;
static { INTERNAL_CONTENT_URI = null; }

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String RECORD_SOUND_ACTION = "android.provider.MediaStore.RECORD_SOUND";
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
@Deprecated
public static final class Playlists implements android.provider.BaseColumns, android.provider.MediaStore.Audio.PlaylistsColumns {

@Deprecated
public Playlists() { throw new RuntimeException("Stub!"); }

@Deprecated
public static android.net.Uri getContentUri(java.lang.String volumeName) { throw new RuntimeException("Stub!"); }

@Deprecated public static final java.lang.String CONTENT_TYPE = "vnd.android.cursor.dir/playlist";

@Deprecated public static final java.lang.String DEFAULT_SORT_ORDER = "name";

@Deprecated public static final java.lang.String ENTRY_CONTENT_TYPE = "vnd.android.cursor.item/playlist";

@Deprecated public static final android.net.Uri EXTERNAL_CONTENT_URI;
static { EXTERNAL_CONTENT_URI = null; }

@Deprecated public static final android.net.Uri INTERNAL_CONTENT_URI;
static { INTERNAL_CONTENT_URI = null; }
@SuppressWarnings({"unchecked", "deprecation", "all"})
@Deprecated
public static final class Members implements android.provider.MediaStore.Audio.AudioColumns {

@Deprecated
public Members() { throw new RuntimeException("Stub!"); }

@Deprecated
public static android.net.Uri getContentUri(java.lang.String volumeName, long playlistId) { throw new RuntimeException("Stub!"); }

@Deprecated
public static boolean moveItem(android.content.ContentResolver res, long playlistId, int from, int to) { throw new RuntimeException("Stub!"); }

@Deprecated public static final java.lang.String AUDIO_ID = "audio_id";

@Deprecated public static final java.lang.String CONTENT_DIRECTORY = "members";

@Deprecated public static final java.lang.String DEFAULT_SORT_ORDER = "play_order";

@Deprecated public static final java.lang.String PLAYLIST_ID = "playlist_id";

@Deprecated public static final java.lang.String PLAY_ORDER = "play_order";

@Deprecated public static final java.lang.String _ID = "_id";
}

}

@SuppressWarnings({"unchecked", "deprecation", "all"})
@Deprecated
public static interface PlaylistsColumns extends android.provider.MediaStore.MediaColumns {

@Deprecated public static final java.lang.String DATA = "_data";

@Deprecated public static final java.lang.String DATE_ADDED = "date_added";

@Deprecated public static final java.lang.String DATE_MODIFIED = "date_modified";

@Deprecated public static final java.lang.String NAME = "name";
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Radio {

Radio() { throw new RuntimeException("Stub!"); }

public static final java.lang.String ENTRY_CONTENT_TYPE = "vnd.android.cursor.item/radio";
}

}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface DownloadColumns extends android.provider.MediaStore.MediaColumns {

public static final java.lang.String DOWNLOAD_URI = "download_uri";

public static final java.lang.String REFERER_URI = "referer_uri";
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Downloads implements android.provider.MediaStore.DownloadColumns {

Downloads() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.net.Uri getContentUri(@android.annotation.NonNull java.lang.String volumeName) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.net.Uri getContentUri(@android.annotation.NonNull java.lang.String volumeName, long id) { throw new RuntimeException("Stub!"); }

public static final java.lang.String CONTENT_TYPE = "vnd.android.cursor.dir/download";

@android.annotation.NonNull public static final android.net.Uri EXTERNAL_CONTENT_URI;
static { EXTERNAL_CONTENT_URI = null; }

@android.annotation.NonNull public static final android.net.Uri INTERNAL_CONTENT_URI;
static { INTERNAL_CONTENT_URI = null; }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Files {

public Files() { throw new RuntimeException("Stub!"); }

public static android.net.Uri getContentUri(java.lang.String volumeName) { throw new RuntimeException("Stub!"); }

public static android.net.Uri getContentUri(java.lang.String volumeName, long rowId) { throw new RuntimeException("Stub!"); }
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface FileColumns extends android.provider.MediaStore.MediaColumns {

public static final java.lang.String MEDIA_TYPE = "media_type";

public static final int MEDIA_TYPE_AUDIO = 2; // 0x2

public static final int MEDIA_TYPE_DOCUMENT = 6; // 0x6

public static final int MEDIA_TYPE_IMAGE = 1; // 0x1

public static final int MEDIA_TYPE_NONE = 0; // 0x0

@Deprecated public static final int MEDIA_TYPE_PLAYLIST = 4; // 0x4

public static final int MEDIA_TYPE_SUBTITLE = 5; // 0x5

public static final int MEDIA_TYPE_VIDEO = 3; // 0x3

public static final java.lang.String MIME_TYPE = "mime_type";

public static final java.lang.String PARENT = "parent";
}

}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Images {

public Images() { throw new RuntimeException("Stub!"); }
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface ImageColumns extends android.provider.MediaStore.MediaColumns {

public static final java.lang.String DESCRIPTION = "description";

public static final java.lang.String EXPOSURE_TIME = "exposure_time";

public static final java.lang.String F_NUMBER = "f_number";

public static final java.lang.String ISO = "iso";

public static final java.lang.String IS_PRIVATE = "isprivate";

@Deprecated public static final java.lang.String LATITUDE = "latitude";

@Deprecated public static final java.lang.String LONGITUDE = "longitude";

@Deprecated public static final java.lang.String MINI_THUMB_MAGIC = "mini_thumb_magic";

@Deprecated public static final java.lang.String PICASA_ID = "picasa_id";

public static final java.lang.String SCENE_CAPTURE_TYPE = "scene_capture_type";
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Media implements android.provider.MediaStore.Images.ImageColumns {

public Media() { throw new RuntimeException("Stub!"); }

@Deprecated
public static android.database.Cursor query(android.content.ContentResolver cr, android.net.Uri uri, java.lang.String[] projection) { throw new RuntimeException("Stub!"); }

@Deprecated
public static android.database.Cursor query(android.content.ContentResolver cr, android.net.Uri uri, java.lang.String[] projection, java.lang.String where, java.lang.String orderBy) { throw new RuntimeException("Stub!"); }

@Deprecated
public static android.database.Cursor query(android.content.ContentResolver cr, android.net.Uri uri, java.lang.String[] projection, java.lang.String selection, java.lang.String[] selectionArgs, java.lang.String orderBy) { throw new RuntimeException("Stub!"); }

@Deprecated
public static android.graphics.Bitmap getBitmap(android.content.ContentResolver cr, android.net.Uri url) throws java.io.FileNotFoundException, java.io.IOException { throw new RuntimeException("Stub!"); }

@Deprecated
public static java.lang.String insertImage(android.content.ContentResolver cr, java.lang.String imagePath, java.lang.String name, java.lang.String description) throws java.io.FileNotFoundException { throw new RuntimeException("Stub!"); }

@Deprecated
public static java.lang.String insertImage(android.content.ContentResolver cr, android.graphics.Bitmap source, java.lang.String title, java.lang.String description) { throw new RuntimeException("Stub!"); }

public static android.net.Uri getContentUri(java.lang.String volumeName) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.net.Uri getContentUri(@android.annotation.NonNull java.lang.String volumeName, long id) { throw new RuntimeException("Stub!"); }

public static final java.lang.String CONTENT_TYPE = "vnd.android.cursor.dir/image";

public static final java.lang.String DEFAULT_SORT_ORDER = "bucket_display_name";

public static final android.net.Uri EXTERNAL_CONTENT_URI;
static { EXTERNAL_CONTENT_URI = null; }

public static final android.net.Uri INTERNAL_CONTENT_URI;
static { INTERNAL_CONTENT_URI = null; }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
@Deprecated
public static class Thumbnails implements android.provider.BaseColumns {

@Deprecated
public Thumbnails() { throw new RuntimeException("Stub!"); }

@Deprecated
public static final android.database.Cursor query(android.content.ContentResolver cr, android.net.Uri uri, java.lang.String[] projection) { throw new RuntimeException("Stub!"); }

@Deprecated
public static final android.database.Cursor queryMiniThumbnails(android.content.ContentResolver cr, android.net.Uri uri, int kind, java.lang.String[] projection) { throw new RuntimeException("Stub!"); }

@Deprecated
public static final android.database.Cursor queryMiniThumbnail(android.content.ContentResolver cr, long origId, int kind, java.lang.String[] projection) { throw new RuntimeException("Stub!"); }

@Deprecated
public static void cancelThumbnailRequest(android.content.ContentResolver cr, long origId) { throw new RuntimeException("Stub!"); }

@Deprecated
public static android.graphics.Bitmap getThumbnail(android.content.ContentResolver cr, long imageId, int kind, android.graphics.BitmapFactory.Options options) { throw new RuntimeException("Stub!"); }

@Deprecated
public static void cancelThumbnailRequest(android.content.ContentResolver cr, long origId, long groupId) { throw new RuntimeException("Stub!"); }

@Deprecated
public static android.graphics.Bitmap getThumbnail(android.content.ContentResolver cr, long imageId, long groupId, int kind, android.graphics.BitmapFactory.Options options) { throw new RuntimeException("Stub!"); }

@Deprecated
public static android.net.Uri getContentUri(java.lang.String volumeName) { throw new RuntimeException("Stub!"); }

@Deprecated
@android.annotation.NonNull
public static android.util.Size getKindSize(int kind) { throw new RuntimeException("Stub!"); }

@Deprecated public static final java.lang.String DATA = "_data";

@Deprecated public static final java.lang.String DEFAULT_SORT_ORDER = "image_id ASC";

@Deprecated public static final android.net.Uri EXTERNAL_CONTENT_URI;
static { EXTERNAL_CONTENT_URI = null; }

@Deprecated public static final int FULL_SCREEN_KIND = 2; // 0x2

@Deprecated public static final java.lang.String HEIGHT = "height";

@Deprecated public static final java.lang.String IMAGE_ID = "image_id";

@Deprecated public static final android.net.Uri INTERNAL_CONTENT_URI;
static { INTERNAL_CONTENT_URI = null; }

@Deprecated public static final java.lang.String KIND = "kind";

@Deprecated public static final int MICRO_KIND = 3; // 0x3

@Deprecated public static final int MINI_KIND = 1; // 0x1

@Deprecated public static final java.lang.String THUMB_DATA = "thumb_data";

@Deprecated public static final java.lang.String WIDTH = "width";
}

}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface MediaColumns extends android.provider.BaseColumns {

public static final java.lang.String ALBUM = "album";

public static final java.lang.String ALBUM_ARTIST = "album_artist";

public static final java.lang.String ARTIST = "artist";

public static final java.lang.String AUTHOR = "author";

public static final java.lang.String BITRATE = "bitrate";

public static final java.lang.String BUCKET_DISPLAY_NAME = "bucket_display_name";

public static final java.lang.String BUCKET_ID = "bucket_id";

public static final java.lang.String CAPTURE_FRAMERATE = "capture_framerate";

public static final java.lang.String CD_TRACK_NUMBER = "cd_track_number";

public static final java.lang.String COMPILATION = "compilation";

public static final java.lang.String COMPOSER = "composer";

public static final java.lang.String DATA = "_data";

public static final java.lang.String DATE_ADDED = "date_added";

public static final java.lang.String DATE_EXPIRES = "date_expires";

public static final java.lang.String DATE_MODIFIED = "date_modified";

public static final java.lang.String DATE_TAKEN = "datetaken";

public static final java.lang.String DISC_NUMBER = "disc_number";

public static final java.lang.String DISPLAY_NAME = "_display_name";

public static final java.lang.String DOCUMENT_ID = "document_id";

public static final java.lang.String DURATION = "duration";

public static final java.lang.String GENERATION_ADDED = "generation_added";

public static final java.lang.String GENERATION_MODIFIED = "generation_modified";

public static final java.lang.String GENRE = "genre";

public static final java.lang.String HEIGHT = "height";

public static final java.lang.String INSTANCE_ID = "instance_id";

public static final java.lang.String IS_DOWNLOAD = "is_download";

public static final java.lang.String IS_DRM = "is_drm";

public static final java.lang.String IS_FAVORITE = "is_favorite";

public static final java.lang.String IS_PENDING = "is_pending";

public static final java.lang.String IS_TRASHED = "is_trashed";

public static final java.lang.String MIME_TYPE = "mime_type";

public static final java.lang.String NUM_TRACKS = "num_tracks";

public static final java.lang.String ORIENTATION = "orientation";

public static final java.lang.String ORIGINAL_DOCUMENT_ID = "original_document_id";

public static final java.lang.String OWNER_PACKAGE_NAME = "owner_package_name";

public static final java.lang.String RELATIVE_PATH = "relative_path";

public static final java.lang.String RESOLUTION = "resolution";

public static final java.lang.String SIZE = "_size";

public static final java.lang.String TITLE = "title";

public static final java.lang.String VOLUME_NAME = "volume_name";

public static final java.lang.String WIDTH = "width";

public static final java.lang.String WRITER = "writer";

public static final java.lang.String XMP = "xmp";

public static final java.lang.String YEAR = "year";
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class PickerMediaColumns {

PickerMediaColumns() { throw new RuntimeException("Stub!"); }

public static final java.lang.String DATA = "_data";

public static final java.lang.String DATE_TAKEN = "datetaken";

public static final java.lang.String DISPLAY_NAME = "_display_name";

public static final java.lang.String DURATION_MILLIS = "duration";

public static final java.lang.String HEIGHT = "height";

public static final java.lang.String MIME_TYPE = "mime_type";

public static final java.lang.String ORIENTATION = "orientation";

public static final java.lang.String SIZE = "_size";

public static final java.lang.String WIDTH = "width";
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Video {

public Video() { throw new RuntimeException("Stub!"); }

@Deprecated
public static android.database.Cursor query(android.content.ContentResolver cr, android.net.Uri uri, java.lang.String[] projection) { throw new RuntimeException("Stub!"); }

public static final java.lang.String DEFAULT_SORT_ORDER = "_display_name";
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Media implements android.provider.MediaStore.Video.VideoColumns {

public Media() { throw new RuntimeException("Stub!"); }

public static android.net.Uri getContentUri(java.lang.String volumeName) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.net.Uri getContentUri(@android.annotation.NonNull java.lang.String volumeName, long id) { throw new RuntimeException("Stub!"); }

public static final java.lang.String CONTENT_TYPE = "vnd.android.cursor.dir/video";

public static final java.lang.String DEFAULT_SORT_ORDER = "title";

public static final android.net.Uri EXTERNAL_CONTENT_URI;
static { EXTERNAL_CONTENT_URI = null; }

public static final android.net.Uri INTERNAL_CONTENT_URI;
static { INTERNAL_CONTENT_URI = null; }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
@Deprecated
public static class Thumbnails implements android.provider.BaseColumns {

@Deprecated
public Thumbnails() { throw new RuntimeException("Stub!"); }

@Deprecated
public static void cancelThumbnailRequest(android.content.ContentResolver cr, long origId) { throw new RuntimeException("Stub!"); }

@Deprecated
public static android.graphics.Bitmap getThumbnail(android.content.ContentResolver cr, long videoId, int kind, android.graphics.BitmapFactory.Options options) { throw new RuntimeException("Stub!"); }

@Deprecated
public static void cancelThumbnailRequest(android.content.ContentResolver cr, long videoId, long groupId) { throw new RuntimeException("Stub!"); }

@Deprecated
public static android.graphics.Bitmap getThumbnail(android.content.ContentResolver cr, long videoId, long groupId, int kind, android.graphics.BitmapFactory.Options options) { throw new RuntimeException("Stub!"); }

@Deprecated
public static android.net.Uri getContentUri(java.lang.String volumeName) { throw new RuntimeException("Stub!"); }

@Deprecated
@android.annotation.NonNull
public static android.util.Size getKindSize(int kind) { throw new RuntimeException("Stub!"); }

@Deprecated public static final java.lang.String DATA = "_data";

@Deprecated public static final java.lang.String DEFAULT_SORT_ORDER = "video_id ASC";

@Deprecated public static final android.net.Uri EXTERNAL_CONTENT_URI;
static { EXTERNAL_CONTENT_URI = null; }

@Deprecated public static final int FULL_SCREEN_KIND = 2; // 0x2

@Deprecated public static final java.lang.String HEIGHT = "height";

@Deprecated public static final android.net.Uri INTERNAL_CONTENT_URI;
static { INTERNAL_CONTENT_URI = null; }

@Deprecated public static final java.lang.String KIND = "kind";

@Deprecated public static final int MICRO_KIND = 3; // 0x3

@Deprecated public static final int MINI_KIND = 1; // 0x1

@Deprecated public static final java.lang.String VIDEO_ID = "video_id";

@Deprecated public static final java.lang.String WIDTH = "width";
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface VideoColumns extends android.provider.MediaStore.MediaColumns {

public static final java.lang.String BOOKMARK = "bookmark";

public static final java.lang.String CATEGORY = "category";

public static final java.lang.String COLOR_RANGE = "color_range";

public static final java.lang.String COLOR_STANDARD = "color_standard";

public static final java.lang.String COLOR_TRANSFER = "color_transfer";

public static final java.lang.String DESCRIPTION = "description";

public static final java.lang.String IS_PRIVATE = "isprivate";

public static final java.lang.String LANGUAGE = "language";

@Deprecated public static final java.lang.String LATITUDE = "latitude";

@Deprecated public static final java.lang.String LONGITUDE = "longitude";

@Deprecated public static final java.lang.String MINI_THUMB_MAGIC = "mini_thumb_magic";

public static final java.lang.String TAGS = "tags";
}

}

}

