/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.nfc;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class NfcOemExtension {

NfcOemExtension() { throw new RuntimeException("Stub!"); }

public void clearPreference() { throw new RuntimeException("Stub!"); }

public int forceRoutingTableCommit() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.Map<java.lang.String,java.lang.Integer> getActiveNfceeList() { throw new RuntimeException("Stub!"); }

public long getMaxPausePollingTimeoutMills() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.nfc.RoutingStatus getRoutingStatus() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.nfc.NfcRoutingTableEntry> getRoutingTable() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.nfc.T4tNdefNfcee getT4tNdefNfcee() { throw new RuntimeException("Stub!"); }

public boolean hasUserEnabledNfc() { throw new RuntimeException("Stub!"); }

public boolean isAutoChangeEnabled() { throw new RuntimeException("Stub!"); }

public boolean isTagPresent() { throw new RuntimeException("Stub!"); }

public void maybeTriggerFirmwareUpdate() { throw new RuntimeException("Stub!"); }

public void overwriteRoutingTable(int protocol, int technology, int emptyAid, int systemCode) { throw new RuntimeException("Stub!"); }

public int pausePolling(long timeoutInMs) { throw new RuntimeException("Stub!"); }

public void registerCallback(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.nfc.NfcOemExtension.Callback callback) { throw new RuntimeException("Stub!"); }

public int resumePolling() { throw new RuntimeException("Stub!"); }

public void setAutoChangeEnabled(boolean state) { throw new RuntimeException("Stub!"); }

public void setControllerAlwaysOnMode(int mode) { throw new RuntimeException("Stub!"); }

public void synchronizeScreenState() { throw new RuntimeException("Stub!"); }

public void triggerInitialization() { throw new RuntimeException("Stub!"); }

public void unregisterCallback(@android.annotation.NonNull android.nfc.NfcOemExtension.Callback callback) { throw new RuntimeException("Stub!"); }

public static final int COMMIT_ROUTING_STATUS_FAILED = 3; // 0x3

public static final int COMMIT_ROUTING_STATUS_FAILED_UPDATE_IN_PROGRESS = 6; // 0x6

public static final int COMMIT_ROUTING_STATUS_OK = 0; // 0x0

public static final int DISABLE = 0; // 0x0

public static final int ENABLE_DEFAULT = 1; // 0x1

public static final int ENABLE_EE = 3; // 0x3

public static final int ENABLE_TRANSPARENT = 2; // 0x2

public static final int HCE_ACTIVATE = 1; // 0x1

public static final int HCE_DATA_TRANSFERRED = 2; // 0x2

public static final int HCE_DEACTIVATE = 3; // 0x3

public static final int NFCEE_TECH_A = 1; // 0x1

public static final int NFCEE_TECH_B = 2; // 0x2

public static final int NFCEE_TECH_F = 4; // 0x4

public static final int NFCEE_TECH_NONE = 0; // 0x0

public static final int POLLING_STATE_CHANGE_ALREADY_IN_REQUESTED_STATE = 2; // 0x2

public static final int POLLING_STATE_CHANGE_SUCCEEDED = 1; // 0x1

public static final int STATUS_OK = 0; // 0x0

public static final int STATUS_UNKNOWN_ERROR = 1; // 0x1
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface Callback {

public void onApplyRouting(@android.annotation.NonNull java.util.function.Consumer<java.lang.Boolean> isSkipped);

public void onBootFinished(int status);

public void onBootStarted();

public void onCardEmulationActivated(boolean isActivated);

public void onDisableFinished(int status);

public void onDisableRequested(@android.annotation.NonNull java.util.function.Consumer<java.lang.Boolean> isAllowed);

public void onDisableStarted();

public void onEeListenActivated(boolean isActivated);

public void onEeUpdated();

public void onEnableFinished(int status);

public void onEnableRequested(@android.annotation.NonNull java.util.function.Consumer<java.lang.Boolean> isAllowed);

public void onEnableStarted();

public void onExtractOemPackages(@android.annotation.NonNull android.nfc.NdefMessage message, @android.annotation.NonNull java.util.function.Consumer<java.util.List<java.lang.String>> packageConsumer);

public void onGetOemAppSearchIntent(@android.annotation.NonNull java.util.List<java.lang.String> packages, @android.annotation.NonNull java.util.function.Consumer<android.content.Intent> intentConsumer);

public void onHceEventReceived(int action);

public void onLaunchHceAppChooserActivity(@android.annotation.NonNull java.lang.String selectedAid, @android.annotation.NonNull java.util.List<android.nfc.cardemulation.ApduServiceInfo> services, @android.annotation.NonNull android.content.ComponentName failedComponent, @android.annotation.NonNull java.lang.String category);

public void onLaunchHceTapAgainDialog(@android.annotation.NonNull android.nfc.cardemulation.ApduServiceInfo service, @android.annotation.NonNull java.lang.String category);

public void onLogEventNotified(@android.annotation.NonNull android.nfc.OemLogItems item);

public void onNdefMessage(@android.annotation.NonNull android.nfc.Tag tag, @android.annotation.NonNull android.nfc.NdefMessage message, @android.annotation.NonNull java.util.function.Consumer<java.lang.Boolean> hasOemExecutableContent);

public void onNdefRead(@android.annotation.NonNull java.util.function.Consumer<java.lang.Boolean> isSkipped);

public void onReaderOptionChanged(boolean enabled);

public void onRfDiscoveryStarted(boolean isDiscoveryStarted);

public void onRfFieldDetected(boolean isActive);

public void onRoutingChanged(@android.annotation.NonNull java.util.function.Consumer<java.lang.Boolean> isCommitRoutingSkipped);

public void onRoutingTableFull();

public void onStateUpdated(int state);

public void onTagConnected(boolean connected);

public void onTagDispatch(@android.annotation.NonNull java.util.function.Consumer<java.lang.Boolean> isSkipped);
}

}

