/*
 * Copyright (C) 2013 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.nfc.cardemulation;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class CardEmulation {

CardEmulation() { throw new RuntimeException("Stub!"); }

public boolean categoryAllowsForegroundPreference(java.lang.String category) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.util.List<java.lang.String> getAidsForPreferredPaymentService() { throw new RuntimeException("Stub!"); }

public java.util.List<java.lang.String> getAidsForService(android.content.ComponentName service, java.lang.String category) { throw new RuntimeException("Stub!"); }

public int getDefaultNfcSubscriptionId() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.CharSequence getDescriptionForPreferredPaymentService() { throw new RuntimeException("Stub!"); }

public static synchronized android.nfc.cardemulation.CardEmulation getInstance(android.nfc.NfcAdapter adapter) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public static android.content.ComponentName getPreferredPaymentService(@android.annotation.NonNull android.content.Context context) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getRouteDestinationForPreferredPaymentService() { throw new RuntimeException("Stub!"); }

public int getSelectionModeForCategory(java.lang.String category) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.nfc.cardemulation.ApduServiceInfo> getServices(@android.annotation.NonNull java.lang.String category, int userId) { throw new RuntimeException("Stub!"); }

public boolean isDefaultServiceForAid(android.content.ComponentName service, java.lang.String aid) { throw new RuntimeException("Stub!"); }

public boolean isDefaultServiceForCategory(android.content.ComponentName service, java.lang.String category) { throw new RuntimeException("Stub!"); }

public boolean isEuiccSupported() { throw new RuntimeException("Stub!"); }

public void overrideRoutingTable(@android.annotation.NonNull android.app.Activity activity, int protocol, int technology) { throw new RuntimeException("Stub!"); }

public void recoverRoutingTable(@android.annotation.NonNull android.app.Activity activity) { throw new RuntimeException("Stub!"); }

public boolean registerAidsForService(android.content.ComponentName service, java.lang.String category, java.util.List<java.lang.String> aids) { throw new RuntimeException("Stub!"); }

public void registerNfcEventCallback(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.nfc.cardemulation.CardEmulation.NfcEventCallback listener) { throw new RuntimeException("Stub!"); }

public boolean registerPollingLoopFilterForService(@android.annotation.NonNull android.content.ComponentName service, @android.annotation.NonNull java.lang.String pollingLoopFilter, boolean autoTransact) { throw new RuntimeException("Stub!"); }

public boolean registerPollingLoopPatternFilterForService(@android.annotation.NonNull android.content.ComponentName service, @android.annotation.NonNull java.lang.String pollingLoopPatternFilter, boolean autoTransact) { throw new RuntimeException("Stub!"); }

public boolean removeAidsForService(android.content.ComponentName service, java.lang.String category) { throw new RuntimeException("Stub!"); }

public boolean removePollingLoopFilterForService(@android.annotation.NonNull android.content.ComponentName service, @android.annotation.NonNull java.lang.String pollingLoopFilter) { throw new RuntimeException("Stub!"); }

public boolean removePollingLoopPatternFilterForService(@android.annotation.NonNull android.content.ComponentName service, @android.annotation.NonNull java.lang.String pollingLoopPatternFilter) { throw new RuntimeException("Stub!"); }

public int setDefaultNfcSubscriptionId(int subscriptionId) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public boolean setOffHostForService(@android.annotation.NonNull android.content.ComponentName service, @android.annotation.NonNull java.lang.String offHostSecureElement) { throw new RuntimeException("Stub!"); }

public boolean setPreferredService(android.app.Activity activity, android.content.ComponentName service) { throw new RuntimeException("Stub!"); }

public int setServiceEnabledForCategoryOther(@android.annotation.NonNull android.content.ComponentName service, boolean status) { throw new RuntimeException("Stub!"); }

public boolean setShouldDefaultToObserveModeForService(@android.annotation.NonNull android.content.ComponentName service, boolean enable) { throw new RuntimeException("Stub!"); }

public boolean supportsAidPrefixRegistration() { throw new RuntimeException("Stub!"); }

public void unregisterNfcEventCallback(@android.annotation.NonNull android.nfc.cardemulation.CardEmulation.NfcEventCallback listener) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public boolean unsetOffHostForService(@android.annotation.NonNull android.content.ComponentName service) { throw new RuntimeException("Stub!"); }

public boolean unsetPreferredService(android.app.Activity activity) { throw new RuntimeException("Stub!"); }

@Deprecated @android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String ACTION_CHANGE_DEFAULT = "android.nfc.cardemulation.action.ACTION_CHANGE_DEFAULT";

public static final java.lang.String CATEGORY_OTHER = "other";

public static final java.lang.String CATEGORY_PAYMENT = "payment";

public static final java.lang.String EXTRA_CATEGORY = "category";

public static final java.lang.String EXTRA_SERVICE_COMPONENT = "component";

public static final int NFC_INTERNAL_ERROR_COMMAND_TIMEOUT = 3; // 0x3

public static final int NFC_INTERNAL_ERROR_NFC_CRASH_RESTART = 1; // 0x1

public static final int NFC_INTERNAL_ERROR_NFC_HARDWARE_ERROR = 2; // 0x2

public static final int NFC_INTERNAL_ERROR_UNKNOWN = 0; // 0x0

public static final java.lang.String PROPERTY_ALLOW_SHARED_ROLE_PRIORITY = "android.nfc.cardemulation.PROPERTY_ALLOW_SHARED_ROLE_PRIORITY";

public static final int PROTOCOL_AND_TECHNOLOGY_ROUTE_DEFAULT = 3; // 0x3

public static final int PROTOCOL_AND_TECHNOLOGY_ROUTE_DH = 0; // 0x0

public static final int PROTOCOL_AND_TECHNOLOGY_ROUTE_ESE = 1; // 0x1

public static final int PROTOCOL_AND_TECHNOLOGY_ROUTE_UICC = 2; // 0x2

public static final int PROTOCOL_AND_TECHNOLOGY_ROUTE_UNSET = -1; // 0xffffffff

public static final int SELECTION_MODE_ALWAYS_ASK = 1; // 0x1

public static final int SELECTION_MODE_ASK_IF_CONFLICT = 2; // 0x2

public static final int SELECTION_MODE_PREFER_DEFAULT = 0; // 0x0

public static final int SET_SERVICE_ENABLED_STATUS_FAILURE_ALREADY_SET = 3; // 0x3

public static final int SET_SERVICE_ENABLED_STATUS_FAILURE_FEATURE_UNSUPPORTED = 1; // 0x1

public static final int SET_SERVICE_ENABLED_STATUS_FAILURE_INVALID_SERVICE = 2; // 0x2

public static final int SET_SERVICE_ENABLED_STATUS_FAILURE_UNKNOWN_ERROR = 4; // 0x4

public static final int SET_SERVICE_ENABLED_STATUS_OK = 0; // 0x0

public static final int SET_SUBSCRIPTION_ID_STATUS_FAILED_INTERNAL_ERROR = 2; // 0x2

public static final int SET_SUBSCRIPTION_ID_STATUS_FAILED_INVALID_SUBSCRIPTION_ID = 1; // 0x1

public static final int SET_SUBSCRIPTION_ID_STATUS_FAILED_NOT_SUPPORTED = 3; // 0x3

public static final int SET_SUBSCRIPTION_ID_STATUS_SUCCESS = 0; // 0x0

public static final int SET_SUBSCRIPTION_ID_STATUS_UNKNOWN = -1; // 0xffffffff
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface NfcEventCallback {

public default void onAidConflictOccurred(@android.annotation.NonNull java.lang.String aid) { throw new RuntimeException("Stub!"); }

public default void onAidNotRouted(@android.annotation.NonNull java.lang.String aid) { throw new RuntimeException("Stub!"); }

public default void onInternalErrorReported(int errorType) { throw new RuntimeException("Stub!"); }

public default void onNfcStateChanged(int state) { throw new RuntimeException("Stub!"); }

public default void onObserveModeStateChanged(boolean isEnabled) { throw new RuntimeException("Stub!"); }

public default void onPreferredServiceChanged(boolean isPreferred) { throw new RuntimeException("Stub!"); }

public default void onRemoteFieldChanged(boolean isDetected) { throw new RuntimeException("Stub!"); }
}

}

