/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.ondevicepersonalization;

import java.time.Instant;

/**
 * Data to be logged in the EVENTS table.
 *
 * Each record in the EVENTS table is associated with one row from an existing
 * {@link android.adservices.ondevicepersonalization.RequestLogRecord RequestLogRecord} in the requests table {@link android.adservices.ondevicepersonalization.RequestLogRecord#getRows() RequestLogRecord#getRows()}.
 * The purpose of the EVENTS table is to add supplemental information to logged data
 * from a prior request, e.g., logging an event when a link in a rendered WebView is
 * clicked {@code IsolatedWorker#onEvent(EventInput, android.os.OutcomeReceiver)}.
 * The contents of the EVENTS table can be
 * consumed by Federated Learning facilitated model training, or Federated Analytics facilitated
 * cross-device statistical analysis.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class EventLogRecord implements android.os.Parcelable {

EventLogRecord() { throw new RuntimeException("Stub!"); }

/**
 * Returns the timestamp of this record.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.time.Instant getTime() { throw new RuntimeException("Stub!"); }

/**
 * The index of the row in an existing {@link android.adservices.ondevicepersonalization.RequestLogRecord RequestLogRecord} that this payload should be
 * associated with.

 * @return Value is 0 or greater
 */

public int getRowIndex() { throw new RuntimeException("Stub!"); }

/**
 * The service-assigned identifier that identifies this payload. Each row in
 * {@link android.adservices.ondevicepersonalization.RequestLogRecord RequestLogRecord} can be associated with up to one event of a specified type.
 * The platform drops events if another event with the same type already exists for a row
 * in {@link android.adservices.ondevicepersonalization.RequestLogRecord RequestLogRecord}. Must be >0 and <128. This allows up to 127 events to be
 * written for each row in {@link android.adservices.ondevicepersonalization.RequestLogRecord RequestLogRecord}. If unspecified, the default is 1.

 * @return Value is between 1 and 127 inclusive
 */

public int getType() { throw new RuntimeException("Stub!"); }

/**
 * Additional data to be logged. Can be null if no additional data needs to be written as part
 * of the event, and only the occurrence of the event needs to be logged.
 */

@android.annotation.Nullable
public android.content.ContentValues getData() { throw new RuntimeException("Stub!"); }

/**
 * The existing {@link android.adservices.ondevicepersonalization.RequestLogRecord RequestLogRecord} that this payload should be associated with. In an
 * implementation of
 * {@link android.adservices.ondevicepersonalization.IsolatedWorker#onExecute(android.adservices.ondevicepersonalization.ExecuteInput,android.os.OutcomeReceiver) IsolatedWorker#onExecute(ExecuteInput, android.os.OutcomeReceiver)}, this should be
 * set to a value returned by {@link android.adservices.ondevicepersonalization.LogReader#getRequests(java.time.Instant,java.time.Instant) LogReader#getRequests(Instant, Instant)}. In an
 * implementation of {@link android.adservices.ondevicepersonalization.IsolatedWorker#onEvent(android.adservices.ondevicepersonalization.EventInput,android.os.OutcomeReceiver) IsolatedWorker#onEvent(EventInput, android.os.OutcomeReceiver)},
 * this should be set to {@code null} because the payload will be automatically associated with
 * the current {@link android.adservices.ondevicepersonalization.RequestLogRecord RequestLogRecord}.
 */

@android.annotation.Nullable
public android.adservices.ondevicepersonalization.RequestLogRecord getRequestLogRecord() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param o This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.adservices.ondevicepersonalization.EventLogRecord> CREATOR;
static { CREATOR = null; }
/**
 * A builder for {@link android.adservices.ondevicepersonalization.EventLogRecord EventLogRecord}
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * The index of the row in an existing {@link android.adservices.ondevicepersonalization.RequestLogRecord RequestLogRecord} that this payload should be
 * associated with.
 
 * @param value Value is 0 or greater
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.ondevicepersonalization.EventLogRecord.Builder setRowIndex(int value) { throw new RuntimeException("Stub!"); }

/**
 * The service-assigned identifier that identifies this payload. Each row in
 * {@link android.adservices.ondevicepersonalization.RequestLogRecord RequestLogRecord} can be associated with up to one event of a specified type.
 * The platform drops events if another event with the same type already exists for a row
 * in {@link android.adservices.ondevicepersonalization.RequestLogRecord RequestLogRecord}. Must be >0 and <128. This allows up to 127 events to be
 * written for each row in {@link android.adservices.ondevicepersonalization.RequestLogRecord RequestLogRecord}. If unspecified, the default is 1.
 
 * @param value Value is between 1 and 127 inclusive
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.ondevicepersonalization.EventLogRecord.Builder setType(int value) { throw new RuntimeException("Stub!"); }

/**
 * Additional data to be logged. Can be null if no additional data needs to be written as part
 * of the event, and only the occurrence of the event needs to be logged.

 * @param value This value may be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.ondevicepersonalization.EventLogRecord.Builder setData(@android.annotation.Nullable android.content.ContentValues value) { throw new RuntimeException("Stub!"); }

/**
 * The existing {@link android.adservices.ondevicepersonalization.RequestLogRecord RequestLogRecord} that this payload should be associated with. In an
 * implementation of
 * {@link android.adservices.ondevicepersonalization.IsolatedWorker#onExecute(android.adservices.ondevicepersonalization.ExecuteInput,android.os.OutcomeReceiver) IsolatedWorker#onExecute(ExecuteInput, android.os.OutcomeReceiver)}, this should be
 * set to a value returned by {@link android.adservices.ondevicepersonalization.LogReader#getRequests(java.time.Instant,java.time.Instant) LogReader#getRequests(Instant, Instant)}. In an
 * implementation of {@link android.adservices.ondevicepersonalization.IsolatedWorker#onEvent(android.adservices.ondevicepersonalization.EventInput,android.os.OutcomeReceiver) IsolatedWorker#onEvent(EventInput, android.os.OutcomeReceiver)},
 * this should be set to {@code null} because the payload will be automatically associated with
 * the current {@link android.adservices.ondevicepersonalization.RequestLogRecord RequestLogRecord}.

 * @param value This value may be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.ondevicepersonalization.EventLogRecord.Builder setRequestLogRecord(@android.annotation.Nullable android.adservices.ondevicepersonalization.RequestLogRecord value) { throw new RuntimeException("Stub!"); }

/**
 * Builds the instance. This builder should not be touched after calling this!
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.ondevicepersonalization.EventLogRecord build() { throw new RuntimeException("Stub!"); }
}

}

