/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.ondevicepersonalization;


/**
 * Contains all the information needed for a run of model inference. The input of {@link android.adservices.ondevicepersonalization.ModelManager#run  }.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class InferenceInput {

InferenceInput() { throw new RuntimeException("Stub!"); }

/**
 * The configuration that controls runtime interpreter behavior.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.ondevicepersonalization.InferenceInput.Params getParams() { throw new RuntimeException("Stub!"); }

/**
 * An array of input data. The inputs should be in the same order as inputs of the model.
 *
 * <p>For example, if a model takes multiple inputs:
 *
 * <pre>{@code
 * String[] input0 = {"foo", "bar"}; // string tensor shape is [2].
 * int[] input1 = new int[]{3, 2, 1}; // int tensor shape is [3].
 * Object[] inputData = {input0, input1, ...};
 * }</pre>
 *
 * For TFLite, this field is mapped to inputs of runForMultipleInputsOutputs:
 * https://www.tensorflow.org/lite/api_docs/java/org/tensorflow/lite/InterpreterApi#parameters_9

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.Object[] getInputData() { throw new RuntimeException("Stub!"); }

/**
 * The number of input examples. Adopter can set this field to run batching inference. The batch
 * size is 1 by default. The batch size should match the input data size.
 */

public int getBatchSize() { throw new RuntimeException("Stub!"); }

/**
 * The empty InferenceOutput representing the expected output structure. For TFLite, the
 * inference code will verify whether this expected output structure matches model output
 * signature.
 *
 * <p>If a model produce string tensors:
 *
 * <pre>{@code
 * String[] output = new String[3][2];  // Output tensor shape is [3, 2].
 * HashMap<Integer, Object> outputs = new HashMap<>();
 * outputs.put(0, output);
 * expectedOutputStructure = new InferenceOutput.Builder().setDataOutputs(outputs).build();
 * }</pre>

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.ondevicepersonalization.InferenceOutput getExpectedOutputStructure() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param o This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }
/** A builder for {@link android.adservices.ondevicepersonalization.InferenceInput InferenceInput} */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * Creates a new Builder.
 *
 * @param params The configuration that controls runtime interpreter behavior.
 * This value cannot be {@code null}.
 * @param inputData An array of input data. The inputs should be in the same order as inputs
 *     of the model.
 *     <p>For example, if a model takes multiple inputs:
 *     <pre>{@code
 * String[] input0 = {"foo", "bar"}; // string tensor shape is [2].
 * int[] input1 = new int[]{3, 2, 1}; // int tensor shape is [3].
 * Object[] inputData = {input0, input1, ...};
 *
 * }</pre>
 *     For TFLite, this field is mapped to inputs of runForMultipleInputsOutputs:
 *     https://www.tensorflow.org/lite/api_docs/java/org/tensorflow/lite/InterpreterApi#parameters_9
 * This value cannot be {@code null}.
 * @param expectedOutputStructure The empty InferenceOutput representing the expected output
 *     structure. For TFLite, the inference code will verify whether this expected output
 *     structure matches model output signature.
 *     <p>If a model produce string tensors:
 *     <pre>{@code
 * String[] output = new String[3][2];  // Output tensor shape is [3, 2].
 * HashMap<Integer, Object> outputs = new HashMap<>();
 * outputs.put(0, output);
 * expectedOutputStructure = new InferenceOutput.Builder().setDataOutputs(outputs).build();
 *
 * }</pre>

 * This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull android.adservices.ondevicepersonalization.InferenceInput.Params params, @android.annotation.NonNull java.lang.Object[] inputData, @android.annotation.NonNull android.adservices.ondevicepersonalization.InferenceOutput expectedOutputStructure) { throw new RuntimeException("Stub!"); }

/**
 * The configuration that controls runtime interpreter behavior.
 * @param value This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.ondevicepersonalization.InferenceInput.Builder setParams(@android.annotation.NonNull android.adservices.ondevicepersonalization.InferenceInput.Params value) { throw new RuntimeException("Stub!"); }

/**
 * An array of input data. The inputs should be in the same order as inputs of the model.
 *
 * <p>For example, if a model takes multiple inputs:
 *
 * <pre>{@code
 * String[] input0 = {"foo", "bar"}; // string tensor shape is [2].
 * int[] input1 = new int[]{3, 2, 1}; // int tensor shape is [3].
 * Object[] inputData = {input0, input1, ...};
 * }</pre>
 *
 * For TFLite, this field is mapped to inputs of runForMultipleInputsOutputs:
 * https://www.tensorflow.org/lite/api_docs/java/org/tensorflow/lite/InterpreterApi#parameters_9
 
 * @param value This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.ondevicepersonalization.InferenceInput.Builder setInputData(@android.annotation.NonNull java.lang.Object... value) { throw new RuntimeException("Stub!"); }

/**
 * The number of input examples. Adopter can set this field to run batching inference. The
 * batch size is 1 by default. The batch size should match the input data size.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.ondevicepersonalization.InferenceInput.Builder setBatchSize(int value) { throw new RuntimeException("Stub!"); }

/**
 * The empty InferenceOutput representing the expected output structure. For TFLite, the
 * inference code will verify whether this expected output structure matches model output
 * signature.
 *
 * <p>If a model produce string tensors:
 *
 * <pre>{@code
 * String[] output = new String[3][2];  // Output tensor shape is [3, 2].
 * HashMap<Integer, Object> outputs = new HashMap<>();
 * outputs.put(0, output);
 * expectedOutputStructure = new InferenceOutput.Builder().setDataOutputs(outputs).build();
 * }</pre>
 
 * @param value This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.ondevicepersonalization.InferenceInput.Builder setExpectedOutputStructure(@android.annotation.NonNull android.adservices.ondevicepersonalization.InferenceOutput value) { throw new RuntimeException("Stub!"); }

/**
 * Builds the instance. This builder should not be touched after calling this!
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.ondevicepersonalization.InferenceInput build() { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class Params {

Params() { throw new RuntimeException("Stub!"); }

/**
 * A {@link android.adservices.ondevicepersonalization.KeyValueStore KeyValueStore} where pre-trained model is stored. Only supports TFLite model
 * now.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.ondevicepersonalization.KeyValueStore getKeyValueStore() { throw new RuntimeException("Stub!"); }

/**
 * The key of the table where the corresponding value stores a pre-trained model. Only
 * supports TFLite model now.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getModelKey() { throw new RuntimeException("Stub!"); }

/**
 * The delegate to run model inference.
 * @return Value is {@link android.adservices.ondevicepersonalization.InferenceInput.Params#DELEGATE_CPU}
 */

public int getDelegateType() { throw new RuntimeException("Stub!"); }

/**
 * The type of the pre-trained model, only support tensorflow lite model now.
 * @return Value is {@link android.adservices.ondevicepersonalization.InferenceInput.Params#MODEL_TYPE_TENSORFLOW_LITE}
 */

public int getModelType() { throw new RuntimeException("Stub!"); }

/**
 * The number of threads used for intraop parallelism on CPU, must be positive number.
 * Adopters can set this field based on model architecture. The actual thread number depends
 * on system resources and other constraints.

 * @return Value is 1 or greater
 */

public int getRecommendedNumThreads() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param o This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public static final int DELEGATE_CPU = 1; // 0x1

/** The model is a tensorflow lite model. */

public static final int MODEL_TYPE_TENSORFLOW_LITE = 1; // 0x1
/** A builder for {@link android.adservices.ondevicepersonalization.InferenceInput.Params Params} */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * Creates a new Builder.
 *
 * @param keyValueStore A {@link android.adservices.ondevicepersonalization.KeyValueStore KeyValueStore} where pre-trained model is stored. Only
 *     supports TFLite model now.
 * This value cannot be {@code null}.
 * @param modelKey The key of the table where the corresponding value stores a
 *     pre-trained model. Only supports TFLite model now.

 * This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull android.adservices.ondevicepersonalization.KeyValueStore keyValueStore, @android.annotation.NonNull java.lang.String modelKey) { throw new RuntimeException("Stub!"); }

/**
 * A {@link android.adservices.ondevicepersonalization.KeyValueStore KeyValueStore} where pre-trained model is stored. Only supports TFLite model
 * now.
 
 * @param value This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.ondevicepersonalization.InferenceInput.Params.Builder setKeyValueStore(@android.annotation.NonNull android.adservices.ondevicepersonalization.KeyValueStore value) { throw new RuntimeException("Stub!"); }

/**
 * The key of the table where the corresponding value stores a pre-trained model. Only
 * supports TFLite model now.
 
 * @param value This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.ondevicepersonalization.InferenceInput.Params.Builder setModelKey(@android.annotation.NonNull java.lang.String value) { throw new RuntimeException("Stub!"); }

/**
 * The delegate to run model inference.
 * @param value Value is {@link android.adservices.ondevicepersonalization.InferenceInput.Params#DELEGATE_CPU}
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.ondevicepersonalization.InferenceInput.Params.Builder setDelegateType(int value) { throw new RuntimeException("Stub!"); }

/**
 * The type of the pre-trained model, only support tensorflow lite model now.
 * @param value Value is {@link android.adservices.ondevicepersonalization.InferenceInput.Params#MODEL_TYPE_TENSORFLOW_LITE}
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.ondevicepersonalization.InferenceInput.Params.Builder setModelType(int value) { throw new RuntimeException("Stub!"); }

/**
 * The number of threads used for intraop parallelism on CPU, must be positive number.
 * Adopters can set this field based on model architecture. The actual thread number
 * depends on system resources and other constraints.
 
 * @param value Value is 1 or greater
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.ondevicepersonalization.InferenceInput.Params.Builder setRecommendedNumThreads(int value) { throw new RuntimeException("Stub!"); }

/**
 * Builds the instance. This builder should not be touched after calling this!
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.ondevicepersonalization.InferenceInput.Params build() { throw new RuntimeException("Stub!"); }
}

}

}

