/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.ondevicepersonalization;


/**
 * Exception thrown by OnDevicePersonalization APIs.
 *
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class OnDevicePersonalizationException extends java.lang.Exception {

OnDevicePersonalizationException() { throw new RuntimeException("Stub!"); }

/**
 * Returns the error code for this exception.
 * @return Value is {@link android.adservices.ondevicepersonalization.OnDevicePersonalizationException#ERROR_ISOLATED_SERVICE_FAILED}, or {@link android.adservices.ondevicepersonalization.OnDevicePersonalizationException#ERROR_PERSONALIZATION_DISABLED}
 */

public int getErrorCode() { throw new RuntimeException("Stub!"); }

/**
 * The {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService} that was invoked failed to run.
 */

public static final int ERROR_ISOLATED_SERVICE_FAILED = 1; // 0x1

/**
 * The {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService} was not started because personalization is disabled by
 * device configuration.
 */

public static final int ERROR_PERSONALIZATION_DISABLED = 2; // 0x2
}

