/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.ondevicepersonalization;

import android.content.ContentValues;
import java.util.List;

/**
 * Contains data that will be written to the REQUESTS table at the end of a call to
 * {@link android.adservices.ondevicepersonalization.IsolatedWorker#onExecute(android.adservices.ondevicepersonalization.ExecuteInput,android.os.OutcomeReceiver) IsolatedWorker#onExecute(ExecuteInput, android.os.OutcomeReceiver)}.
 * A single {@link android.adservices.ondevicepersonalization.RequestLogRecord RequestLogRecord} is appended to the
 * REQUESTS table if it is present in the output of one of the methods in {@link android.adservices.ondevicepersonalization.IsolatedWorker IsolatedWorker}.
 * The contents of the REQUESTS table can be consumed by Federated Learning facilitated model
 * training, or Federated Analytics facilitated cross-device statistical analysis.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class RequestLogRecord implements android.os.Parcelable {

RequestLogRecord() { throw new RuntimeException("Stub!"); }

/**
 * Returns the timestamp of this record.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.time.Instant getTime() { throw new RuntimeException("Stub!"); }

/**
 * A List of rows, each containing a {@link android.content.ContentValues ContentValues}.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.content.ContentValues> getRows() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param o This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.adservices.ondevicepersonalization.RequestLogRecord> CREATOR;
static { CREATOR = null; }
/**
 * A builder for {@link android.adservices.ondevicepersonalization.RequestLogRecord RequestLogRecord}
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * A List of rows, each containing a {@link android.content.ContentValues ContentValues}.
 
 * @param value This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.ondevicepersonalization.RequestLogRecord.Builder setRows(@android.annotation.NonNull java.util.List<android.content.ContentValues> value) { throw new RuntimeException("Stub!"); }

/**
 * @see #setRows
 * @param value This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.ondevicepersonalization.RequestLogRecord.Builder addRow(@android.annotation.NonNull android.content.ContentValues value) { throw new RuntimeException("Stub!"); }

/**
 * Builds the instance. This builder should not be touched after calling this!
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.ondevicepersonalization.RequestLogRecord build() { throw new RuntimeException("Stub!"); }
}

}

