/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.ondevicepersonalization;

import android.os.PersistableBundle;

/**
 * The input data for {@link android.adservices.ondevicepersonalization.IsolatedWorker#onEvent(android.adservices.ondevicepersonalization.EventInput,android.os.OutcomeReceiver)  }.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class EventInput {

/**
 * Creates a new EventInput.
 *
 * @param requestLogRecord
 *   The {@link android.adservices.ondevicepersonalization.RequestLogRecord RequestLogRecord} that was returned as a result of
 *   {@link android.adservices.ondevicepersonalization.IsolatedWorker#onExecute(android.adservices.ondevicepersonalization.ExecuteInput,android.os.OutcomeReceiver) IsolatedWorker#onExecute(ExecuteInput, android.os.OutcomeReceiver)}.
 * This value may be {@code null}.
 * @param parameters
 *   The Event URL parameters that the service passed to {@link android.adservices.ondevicepersonalization.EventUrlProvider#createEventTrackingUrlWithResponse(android.os.PersistableBundle,byte[],java.lang.String)    }
 *   or {@link android.adservices.ondevicepersonalization.EventUrlProvider#createEventTrackingUrlWithRedirect(android.os.PersistableBundle,Uri) EventUrlProvider#createEventTrackingUrlWithRedirect(PersistableBundle, Uri)}.

 * This value cannot be {@code null}.
 */

public EventInput(@android.annotation.Nullable android.adservices.ondevicepersonalization.RequestLogRecord requestLogRecord, @android.annotation.NonNull android.os.PersistableBundle parameters) { throw new RuntimeException("Stub!"); }

/**
 * The {@link android.adservices.ondevicepersonalization.RequestLogRecord RequestLogRecord} that was returned as a result of
 * {@link android.adservices.ondevicepersonalization.IsolatedWorker#onExecute(android.adservices.ondevicepersonalization.ExecuteInput,android.os.OutcomeReceiver) IsolatedWorker#onExecute(ExecuteInput, android.os.OutcomeReceiver)}.

 * @return This value may be {@code null}.
 */

@android.annotation.Nullable
public android.adservices.ondevicepersonalization.RequestLogRecord getRequestLogRecord() { throw new RuntimeException("Stub!"); }

/**
 * The Event URL parameters that the service passed to {@link android.adservices.ondevicepersonalization.EventUrlProvider#createEventTrackingUrlWithResponse(android.os.PersistableBundle,byte[],java.lang.String)  }
 * or {@link android.adservices.ondevicepersonalization.EventUrlProvider#createEventTrackingUrlWithRedirect(android.os.PersistableBundle,Uri) EventUrlProvider#createEventTrackingUrlWithRedirect(PersistableBundle, Uri)}.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.os.PersistableBundle getParameters() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param o This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }
}

