/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.ondevicepersonalization;


/**
 * The input data for
 * {@link android.adservices.ondevicepersonalization.IsolatedWorker#onRender(android.adservices.ondevicepersonalization.RenderInput,android.os.OutcomeReceiver) IsolatedWorker#onRender(RenderInput, android.os.OutcomeReceiver)}.
 *
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class RenderInput {

/**
 * Creates a new RenderInput.
 *
 * @param width
 *   The width of the slot.
 * @param height
 *   The height of the slot.
 * @param renderingConfig
 *   A {@link android.adservices.ondevicepersonalization.RenderingConfig RenderingConfig} within an {@link android.adservices.ondevicepersonalization.ExecuteOutput ExecuteOutput} that was returned by
 *   {@link android.adservices.ondevicepersonalization.IsolatedWorker#onExecute(android.adservices.ondevicepersonalization.ExecuteInput,android.os.OutcomeReceiver) IsolatedWorker#onExecute(ExecuteInput, android.os.OutcomeReceiver)}.

 * This value may be {@code null}.
 */

public RenderInput(int width, int height, @android.annotation.Nullable android.adservices.ondevicepersonalization.RenderingConfig renderingConfig) { throw new RuntimeException("Stub!"); }

/**
 * The width of the slot.
 */

public int getWidth() { throw new RuntimeException("Stub!"); }

/**
 * The height of the slot.
 */

public int getHeight() { throw new RuntimeException("Stub!"); }

/**
 * A {@link android.adservices.ondevicepersonalization.RenderingConfig RenderingConfig} within an {@link android.adservices.ondevicepersonalization.ExecuteOutput ExecuteOutput} that was returned by
 * {@link android.adservices.ondevicepersonalization.IsolatedWorker#onExecute(android.adservices.ondevicepersonalization.ExecuteInput,android.os.OutcomeReceiver) IsolatedWorker#onExecute(ExecuteInput, android.os.OutcomeReceiver)}.

 * @return This value may be {@code null}.
 */

@android.annotation.Nullable
public android.adservices.ondevicepersonalization.RenderingConfig getRenderingConfig() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param o This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }
}

