/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.ondevicepersonalization;


/**
 * The result returned by
 * {@link android.adservices.ondevicepersonalization.IsolatedWorker#onRender(android.adservices.ondevicepersonalization.RenderInput,android.os.OutcomeReceiver) IsolatedWorker#onRender(RenderInput, android.os.OutcomeReceiver)}.
 *
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class RenderOutput {

RenderOutput() { throw new RuntimeException("Stub!"); }

/**
 * The HTML content to be rendered in a webview. If this is null, the ODP service
 * generates HTML from the data in {@link #getTemplateId()} and {@link #getTemplateParams()}
 * as described below.
 */

@android.annotation.Nullable
public java.lang.String getContent() { throw new RuntimeException("Stub!"); }

/**
 * A key in the REMOTE_DATA {@link android.adservices.ondevicepersonalization.IsolatedService#getRemoteData(android.adservices.ondevicepersonalization.RequestToken) IsolatedService#getRemoteData(RequestToken)} table that
 * points to an <a href="velocity.apache.org">Apache Velocity</a> template. This is ignored if
 * {@link #getContent()} is not null.
 */

@android.annotation.Nullable
public java.lang.String getTemplateId() { throw new RuntimeException("Stub!"); }

/**
 * The parameters to be populated in the template from {@link #getTemplateId()}. This is
 * ignored if {@link #getContent()} is not null.
 */

@android.annotation.NonNull
public android.os.PersistableBundle getTemplateParams() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param o This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }
/**
 * A builder for {@link android.adservices.ondevicepersonalization.RenderOutput RenderOutput}
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * The HTML content to be rendered in a webview. If this is null, the ODP service
 * generates HTML from the data in {@link #getTemplateId()} and {@link #getTemplateParams()}
 * as described below.

 * @param value This value may be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.ondevicepersonalization.RenderOutput.Builder setContent(@android.annotation.Nullable java.lang.String value) { throw new RuntimeException("Stub!"); }

/**
 * A key in the REMOTE_DATA {@link android.adservices.ondevicepersonalization.IsolatedService#getRemoteData(android.adservices.ondevicepersonalization.RequestToken) IsolatedService#getRemoteData(RequestToken)} table that
 * points to an <a href="velocity.apache.org">Apache Velocity</a> template. This is ignored if
 * {@link #getContent()} is not null.

 * @param value This value may be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.ondevicepersonalization.RenderOutput.Builder setTemplateId(@android.annotation.Nullable java.lang.String value) { throw new RuntimeException("Stub!"); }

/**
 * The parameters to be populated in the template from {@link #getTemplateId()}. This is
 * ignored if {@link #getContent()} is not null.

 * @param value This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.ondevicepersonalization.RenderOutput.Builder setTemplateParams(@android.annotation.NonNull android.os.PersistableBundle value) { throw new RuntimeException("Stub!"); }

/**
 * Builds the instance. This builder should not be touched after calling this!
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.ondevicepersonalization.RenderOutput build() { throw new RuntimeException("Stub!"); }
}

}

