/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.ondevicepersonalization;


/**
 * One record of {@link android.adservices.ondevicepersonalization.TrainingExamplesOutput TrainingExamplesOutput}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class TrainingExampleRecord implements android.os.Parcelable {

TrainingExampleRecord() { throw new RuntimeException("Stub!"); }

/**
 * Training example byte arrays. The format is a binary serialized <a
 * href="https://github.com/tensorflow/tensorflow/blob/master/tensorflow/core/example/example.proto">
 * tensorflow.Example</a> proto. The maximum allowed example size is 50KB.

 * @return This value may be {@code null}.
 */

@android.annotation.Nullable
public byte[] getTrainingExample() { throw new RuntimeException("Stub!"); }

/**
 * The resumption token byte arrays corresponding to training examples. The last processed
 * example's corresponding resumption token will be passed to {@link android.adservices.ondevicepersonalization.IsolatedWorker#onTrainingExamples  } to support resumption.

 * @return This value may be {@code null}.
 */

@android.annotation.Nullable
public byte[] getResumptionToken() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.adservices.ondevicepersonalization.TrainingExampleRecord> CREATOR;
static { CREATOR = null; }
/**
 * A builder for {@link android.adservices.ondevicepersonalization.TrainingExampleRecord TrainingExampleRecord}
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Training example byte arrays. The format is a binary serialized <a
 * href="https://github.com/tensorflow/tensorflow/blob/master/tensorflow/core/example/example.proto">
 * tensorflow.Example</a> proto. The maximum allowed example size is 50KB.
 
 * @param value This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.ondevicepersonalization.TrainingExampleRecord.Builder setTrainingExample(@android.annotation.Nullable byte... value) { throw new RuntimeException("Stub!"); }

/**
 * The resumption token byte arrays corresponding to training examples. The last processed
 * example's corresponding resumption token will be passed to {@link android.adservices.ondevicepersonalization.IsolatedWorker#onTrainingExamples  } to support resumption.
 
 * @param value This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.ondevicepersonalization.TrainingExampleRecord.Builder setResumptionToken(@android.annotation.Nullable byte... value) { throw new RuntimeException("Stub!"); }

/**
 * Builds the instance. This builder should not be touched after calling this!
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.ondevicepersonalization.TrainingExampleRecord build() { throw new RuntimeException("Stub!"); }
}

}

