/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.ondevicepersonalization;


/** The input data for {@link android.adservices.ondevicepersonalization.IsolatedWorker#onTrainingExamples IsolatedWorker#onTrainingExamples}. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class TrainingExamplesInput {

/**
 * Creates a new TrainingExamplesInput.
 *
 * @param populationName The name of the federated compute population. It should match the
 *     population name in {@link android.adservices.ondevicepersonalization.FederatedComputeInput#getPopulationName FederatedComputeInput#getPopulationName}.
 * This value cannot be {@code null}.
 * @param taskName The name of the task within the population. It should match task plan
 *     configured at remote federated compute server. One population may have multiple tasks.
 *     The task name can be used to uniquely identify the job.
 * This value cannot be {@code null}.
 * @param resumptionToken Token used to support the resumption of training. If client app wants
 *     to use resumption token to track what examples are already used in previous federated
 *     compute jobs, it need set {@link android.adservices.ondevicepersonalization.TrainingExampleRecord.Builder#setResumptionToken TrainingExampleRecord.Builder#setResumptionToken},
 *     OnDevicePersonalization will store it and pass it here for generating new training
 *     examples.
 * This value may be {@code null}.
 * @param collectionName The data collection name to use to create training examples.

 * This value may be {@code null}.
 */

public TrainingExamplesInput(@android.annotation.NonNull java.lang.String populationName, @android.annotation.NonNull java.lang.String taskName, @android.annotation.Nullable byte[] resumptionToken, @android.annotation.Nullable java.lang.String collectionName) { throw new RuntimeException("Stub!"); }

/**
 * The name of the federated compute population. It should match the population name in {@link android.adservices.ondevicepersonalization.FederatedComputeInput#getPopulationName  }.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getPopulationName() { throw new RuntimeException("Stub!"); }

/**
 * The name of the task within the population. It should match task plan configured at remote
 * federated compute server. One population may have multiple tasks. The task name can be used
 * to uniquely identify the job.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getTaskName() { throw new RuntimeException("Stub!"); }

/**
 * Token used to support the resumption of training. If client app wants to use resumption token
 * to track what examples are already used in previous federated compute jobs, it need set
 * {@link android.adservices.ondevicepersonalization.TrainingExampleRecord.Builder#setResumptionToken TrainingExampleRecord.Builder#setResumptionToken}, OnDevicePersonalization will store
 * it and pass it here for generating new training examples.

 * @return This value may be {@code null}.
 */

@android.annotation.Nullable
public byte[] getResumptionToken() { throw new RuntimeException("Stub!"); }

/**
 * The data collection name to use to create training examples.
 * @return This value may be {@code null}.
 */

@android.annotation.Nullable
public java.lang.String getCollectionName() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param o This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }
}

