/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.ondevicepersonalization;


/**
 * Handles scheduling federated compute jobs. See {@link android.adservices.ondevicepersonalization.IsolatedService#getFederatedComputeScheduler  }.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class FederatedComputeScheduler {

FederatedComputeScheduler() { throw new RuntimeException("Stub!"); }

/**
 * Cancels a federated compute job with input training params. In {@link android.adservices.ondevicepersonalization.IsolatedService#onRequest  }, the app can call {@link android.adservices.ondevicepersonalization.IsolatedService#getFederatedComputeScheduler  } to pass scheduler when constructing the {@link android.adservices.ondevicepersonalization.IsolatedWorker IsolatedWorker}.
 *
 * <br>
 * This method may take several seconds to complete, so it should
 * only be called from a worker thread.
 * @param input the configuration of the federated compute. It should be consistent with the
 *     federated compute server setup.

 * This value cannot be {@code null}.
 */

public void cancel(@android.annotation.NonNull android.adservices.ondevicepersonalization.FederatedComputeInput input) { throw new RuntimeException("Stub!"); }

/**
 * Schedules a federated compute job. In {@link android.adservices.ondevicepersonalization.IsolatedService#onRequest IsolatedService.onRequest}, the app can call
 * {@link android.adservices.ondevicepersonalization.IsolatedService#getFederatedComputeScheduler IsolatedService.getFederatedComputeScheduler} to pass the scheduler when constructing
 * the {@link android.adservices.ondevicepersonalization.IsolatedWorker IsolatedWorker}.
 *
 * <br>
 * This method may take several seconds to complete, so it should
 * only be called from a worker thread.
 * @param params parameters related to job scheduling.
 * This value cannot be {@code null}.
 * @param input the configuration of the federated computation. It should be consistent with the
 *     federated compute server setup.

 * This value cannot be {@code null}.
 */

public void schedule(@android.annotation.NonNull android.adservices.ondevicepersonalization.FederatedComputeScheduler.Params params, @android.annotation.NonNull android.adservices.ondevicepersonalization.FederatedComputeInput input) { throw new RuntimeException("Stub!"); }
/** The parameters related to job scheduling. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class Params {

/**
 * @param trainingInterval This value cannot be {@code null}.
 */

public Params(@android.annotation.NonNull android.adservices.ondevicepersonalization.TrainingInterval trainingInterval) { throw new RuntimeException("Stub!"); }

/**
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.ondevicepersonalization.TrainingInterval getTrainingInterval() { throw new RuntimeException("Stub!"); }
}

}

