/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.adservices.ondevicepersonalization;


/** The response of {@link android.adservices.ondevicepersonalization.OnDevicePersonalizationManager#executeInIsolatedService OnDevicePersonalizationManager.executeInIsolatedService}. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class ExecuteInIsolatedServiceResponse {

/**
 * Creates a new ExecuteInIsolatedServiceResponse.
 *
 * @param surfacePackageToken an opaque reference to content that can be displayed in a {@link
 *     android.view.SurfaceView}. This may be {@code null} if the {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService} has
 *     not generated any content to be displayed within the calling app.
 * @param bestValue an int value that was returned by the {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService} and applied
 *     noise.If {@link android.adservices.ondevicepersonalization.ExecuteInIsolatedServiceRequest ExecuteInIsolatedServiceRequest} output type is set to {@link android.adservices.ondevicepersonalization.ExecuteInIsolatedServiceRequest.OutputSpec#OUTPUT_TYPE_NULL      }, the platform ignores the
 *     data returned by {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService} and returns the default value {@link
 *     #DEFAULT_BEST_VALUE}. If {@link android.adservices.ondevicepersonalization.ExecuteInIsolatedServiceRequest ExecuteInIsolatedServiceRequest} output type is set to
 *     {@link android.adservices.ondevicepersonalization.ExecuteInIsolatedServiceRequest.OutputSpec#OUTPUT_TYPE_BEST_VALUE ExecuteInIsolatedServiceRequest.OutputSpec.OUTPUT_TYPE_BEST_VALUE}, the platform
 *     validates {@link android.adservices.ondevicepersonalization.ExecuteOutput#getBestValue ExecuteOutput.getBestValue} between 0 and {@link android.adservices.ondevicepersonalization.ExecuteInIsolatedServiceRequest.OutputSpec#getMaxIntValue      } and applies noise to result.

 * Value is DEFAULT_BEST_VALUE or greater
 */

public ExecuteInIsolatedServiceResponse(@android.annotation.Nullable android.adservices.ondevicepersonalization.SurfacePackageToken surfacePackageToken, int bestValue) { throw new RuntimeException("Stub!"); }

/**
 * Returns the int value that was returned by the {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService} and applied noise. If
 * {@link android.adservices.ondevicepersonalization.ExecuteInIsolatedServiceRequest ExecuteInIsolatedServiceRequest} output type is set to {@link android.adservices.ondevicepersonalization.ExecuteInIsolatedServiceRequest.OutputSpec#OUTPUT_TYPE_NULL  }, the platform ignores the data
 * returned by {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService} and returns the default value {@link
 * #DEFAULT_BEST_VALUE}. If {@link android.adservices.ondevicepersonalization.ExecuteInIsolatedServiceRequest ExecuteInIsolatedServiceRequest} output type is set to {@link android.adservices.ondevicepersonalization.ExecuteInIsolatedServiceRequest.OutputSpec#OUTPUT_TYPE_BEST_VALUE  }, the platform validates
 * {@link android.adservices.ondevicepersonalization.ExecuteOutput#getBestValue ExecuteOutput.getBestValue} between 0 and {@link android.adservices.ondevicepersonalization.ExecuteInIsolatedServiceRequest.OutputSpec#getMaxIntValue()  } and applies noise to result.

 * @return Value is DEFAULT_BEST_VALUE or greater
 */

public int getBestValue() { throw new RuntimeException("Stub!"); }

/**
 * Returns a {@link android.adservices.ondevicepersonalization.SurfacePackageToken SurfacePackageToken}, which is an opaque reference to content that can be
 * displayed in a {@link android.view.SurfaceView}. This may be {@code null} if the {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService} has not generated any content to be displayed within the calling app.
 */

@android.annotation.Nullable
public android.adservices.ondevicepersonalization.SurfacePackageToken getSurfacePackageToken() { throw new RuntimeException("Stub!"); }

/**
 * The default value of {@link android.adservices.ondevicepersonalization.ExecuteInIsolatedServiceResponse#getBestValue ExecuteInIsolatedServiceResponse.getBestValue} if {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService} didn't return any content.
 */

public static final int DEFAULT_BEST_VALUE = -1; // 0xffffffff
}

