/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.ondevicepersonalization;


/** The result returned by {@link android.adservices.ondevicepersonalization.ModelManager#run ModelManager.run}. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class InferenceOutput {

InferenceOutput() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param o This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * Note: use {@link android.adservices.ondevicepersonalization.InferenceOutput#getData() InferenceOutput.getData()} instead.
 *
 * <p>A map mapping output indices to multidimensional arrays of output.
 *
 * <p>For TFLite, this field is mapped to outputs of runForMultipleInputsOutputs:
 * https://www.tensorflow.org/lite/api_docs/java/org/tensorflow/lite/InterpreterApi#parameters_9

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.Map<java.lang.Integer,java.lang.Object> getDataOutputs() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }
/** A builder for {@link android.adservices.ondevicepersonalization.InferenceOutput InferenceOutput} */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * @see #setDataOutputs
 
 * @param value This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.ondevicepersonalization.InferenceOutput.Builder addDataOutput(int key, @android.annotation.NonNull java.lang.Object value) { throw new RuntimeException("Stub!"); }

/**
 * Builds the instance. This builder should not be touched after calling this!
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.ondevicepersonalization.InferenceOutput build() { throw new RuntimeException("Stub!"); }

/**
 * Note: use {@link android.adservices.ondevicepersonalization.InferenceOutput.Builder#setData(byte[]) InferenceOutput.Builder.setData(byte[])} instead.
 *
 * <p>A map mapping output indices to multidimensional arrays of output.
 *
 * <p>For TFLite, this field is mapped to outputs of runForMultipleInputsOutputs:
 * https://www.tensorflow.org/lite/api_docs/java/org/tensorflow/lite/InterpreterApi#parameters_9
 
 * @param value This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.ondevicepersonalization.InferenceOutput.Builder setDataOutputs(@android.annotation.NonNull java.util.Map<java.lang.Integer,java.lang.Object> value) { throw new RuntimeException("Stub!"); }
}

}

