/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.ondevicepersonalization;

import android.content.Intent;
import android.os.OutcomeReceiver;

/**
 * Base class for services that are started by ODP on a call to
 * {@code OnDevicePersonalizationManager#execute(ComponentName, PersistableBundle,
 * java.util.concurrent.Executor, OutcomeReceiver)}
 * and run in an <a
 * href="https://developer.android.com/guide/topics/manifest/service-element#isolated">isolated
 * process</a>. The service can produce content to be displayed in a
 * {@link android.view.SurfaceView} in a calling app and write persistent results to on-device
 * storage, which can be consumed by Federated Analytics for cross-device statistical analysis or
 * by Federated Learning for model training.
 * Client apps use {@link android.adservices.ondevicepersonalization.OnDevicePersonalizationManager OnDevicePersonalizationManager} to interact with an {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract class IsolatedService extends android.app.Service {

public IsolatedService() { throw new RuntimeException("Stub!"); }

/**
 * Returns an {@link android.adservices.ondevicepersonalization.EventUrlProvider EventUrlProvider} for the current request. The {@link android.adservices.ondevicepersonalization.EventUrlProvider EventUrlProvider}
 * provides URLs that can be embedded in HTML. When the HTML is rendered in an
 * {@link android.webkit.WebView}, the platform intercepts requests to these URLs and invokes
 * {@code IsolatedWorker#onEvent(EventInput, Consumer)}.
 *
 * @param requestToken an opaque token that identifies the current request to the service.
 * This value cannot be {@code null}.
 * @return An {@link android.adservices.ondevicepersonalization.EventUrlProvider EventUrlProvider} that returns event tracking URLs.
 * This value cannot be {@code null}.
 * @see #onRequest(RequestToken)
 */

@android.annotation.NonNull
public final android.adservices.ondevicepersonalization.EventUrlProvider getEventUrlProvider(@android.annotation.NonNull android.adservices.ondevicepersonalization.RequestToken requestToken) { throw new RuntimeException("Stub!"); }

/**
 * Returns an {@link android.adservices.ondevicepersonalization.FederatedComputeScheduler FederatedComputeScheduler} for the current request. The {@link android.adservices.ondevicepersonalization.FederatedComputeScheduler FederatedComputeScheduler} can be used to schedule and cancel federated computation jobs. The
 * federated computation includes federated learning and federated analytics jobs.
 *
 * @param requestToken an opaque token that identifies the current request to the service.
 * This value cannot be {@code null}.
 * @return An {@link android.adservices.ondevicepersonalization.FederatedComputeScheduler FederatedComputeScheduler} that returns a federated computation job
 *     scheduler.
 * This value cannot be {@code null}.
 * @see #onRequest(RequestToken)
 */

@android.annotation.NonNull
public final android.adservices.ondevicepersonalization.FederatedComputeScheduler getFederatedComputeScheduler(@android.annotation.NonNull android.adservices.ondevicepersonalization.RequestToken requestToken) { throw new RuntimeException("Stub!"); }

/**
 * Returns a Data Access Object for the LOCAL_DATA table. The LOCAL_DATA table is a persistent
 * key-value store that the service can use to store any data. The contents of this table are
 * visible only to the service running in an isolated process and cannot be sent outside the
 * device.
 *
 * @param requestToken an opaque token that identifies the current request to the service.
 * This value cannot be {@code null}.
 * @return A {@link android.adservices.ondevicepersonalization.MutableKeyValueStore MutableKeyValueStore} object that provides access to the LOCAL_DATA table.
 *     The methods in the returned {@link android.adservices.ondevicepersonalization.MutableKeyValueStore MutableKeyValueStore} are blocking operations and
 *     should be called from a worker thread and not the main thread or a binder thread.
 * This value cannot be {@code null}.
 * @see #onRequest(RequestToken)
 */

@android.annotation.NonNull
public final android.adservices.ondevicepersonalization.MutableKeyValueStore getLocalData(@android.annotation.NonNull android.adservices.ondevicepersonalization.RequestToken requestToken) { throw new RuntimeException("Stub!"); }

/**
 * Returns a DAO for the REQUESTS and EVENTS tables that provides
 * access to the rows that are readable by the IsolatedService.
 *
 * @param requestToken an opaque token that identifies the current request to the service.
 * This value cannot be {@code null}.
 * @return A {@link android.adservices.ondevicepersonalization.LogReader LogReader} object that provides access to the REQUESTS and EVENTS table.
 *     The methods in the returned {@link android.adservices.ondevicepersonalization.LogReader LogReader} are blocking operations and
 *     should be called from a worker thread and not the main thread or a binder thread.
 * This value cannot be {@code null}.
 * @see #onRequest(RequestToken)
 */

@android.annotation.NonNull
public final android.adservices.ondevicepersonalization.LogReader getLogReader(@android.annotation.NonNull android.adservices.ondevicepersonalization.RequestToken requestToken) { throw new RuntimeException("Stub!"); }

/**
 * Returns an {@link android.adservices.ondevicepersonalization.ModelManager ModelManager} for the current request. The {@link android.adservices.ondevicepersonalization.ModelManager ModelManager} can be used
 * to do model inference. It only supports Tensorflow Lite model inference now.
 *
 * @param requestToken an opaque token that identifies the current request to the service.
 * This value cannot be {@code null}.
 * @return An {@link android.adservices.ondevicepersonalization.ModelManager ModelManager} that can be used for model inference.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public final android.adservices.ondevicepersonalization.ModelManager getModelManager(@android.annotation.NonNull android.adservices.ondevicepersonalization.RequestToken requestToken) { throw new RuntimeException("Stub!"); }

/**
 * Returns a Data Access Object for the REMOTE_DATA table. The REMOTE_DATA table is a read-only
 * key-value store that contains data that is periodically downloaded from an endpoint declared
 * in the <download> tag in the ODP manifest of the service, as shown in the following example.
 *
 * <pre>{@code
 * <!-- Contents of res/xml/OdpSettings.xml -->
 * <on-device-personalization>
 * <!-- Name of the service subclass -->
 * <service "com.example.odpsample.SampleService">
 *   <!-- If this tag is present, ODP will periodically poll this URL and
 *    download content to populate REMOTE_DATA. Adopters that do not need to
 *    download content from their servers can skip this tag. -->
 *   <download-settings url="https://example.com/get" />
 * </service>
 * </on-device-personalization>
 * }</pre>
 *
 * @param requestToken an opaque token that identifies the current request to the service.
 * This value cannot be {@code null}.
 * @return A {@link android.adservices.ondevicepersonalization.KeyValueStore KeyValueStore} object that provides access to the REMOTE_DATA table. The
 *     methods in the returned {@link android.adservices.ondevicepersonalization.KeyValueStore KeyValueStore} are blocking operations and should be
 *     called from a worker thread and not the main thread or a binder thread.
 * This value cannot be {@code null}.
 * @see #onRequest(RequestToken)
 */

@android.annotation.NonNull
public final android.adservices.ondevicepersonalization.KeyValueStore getRemoteData(@android.annotation.NonNull android.adservices.ondevicepersonalization.RequestToken requestToken) { throw new RuntimeException("Stub!"); }

/**
 * Returns the platform-provided {@link android.adservices.ondevicepersonalization.UserData UserData} for the current request.
 *
 * @param requestToken an opaque token that identifies the current request to the service.
 * This value cannot be {@code null}.
 * @return A {@link android.adservices.ondevicepersonalization.UserData UserData} object.
 * This value may be {@code null}.
 * @see #onRequest(RequestToken)
 */

@android.annotation.Nullable
public final android.adservices.ondevicepersonalization.UserData getUserData(@android.annotation.NonNull android.adservices.ondevicepersonalization.RequestToken requestToken) { throw new RuntimeException("Stub!"); }

/**
 * Handles binding to the {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService}.
 *
 * @param intent The Intent that was used to bind to this service, as given to {@link
 *     android.content.Context#bindService Context.bindService}. Note that any extras that were
 *     included with the Intent at that point will <em>not</em> be seen here.
 
 * This value cannot be {@code null}.
 * @return This value may be {@code null}.
 */

@android.annotation.Nullable
public android.os.IBinder onBind(@android.annotation.NonNull android.content.Intent intent) { throw new RuntimeException("Stub!"); }

/** Creates a binder for an {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService}. */

public void onCreate() { throw new RuntimeException("Stub!"); }

/**
 * Return an instance of an {@link android.adservices.ondevicepersonalization.IsolatedWorker IsolatedWorker} that handles client requests.
 *
 * @param requestToken an opaque token that identifies the current request to the service that
 *     must be passed to service methods that depend on per-request state.
 
 * This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public abstract android.adservices.ondevicepersonalization.IsolatedWorker onRequest(@android.annotation.NonNull android.adservices.ondevicepersonalization.RequestToken requestToken);
}

