/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.ondevicepersonalization;


/**
 * Exception thrown by OnDevicePersonalization APIs.
 *
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class OnDevicePersonalizationException extends java.lang.Exception {

OnDevicePersonalizationException() { throw new RuntimeException("Stub!"); }

/**
 * Returns the error code for this exception.
 * @return Value is {@link android.adservices.ondevicepersonalization.OnDevicePersonalizationException#ERROR_ISOLATED_SERVICE_FAILED}, {@link android.adservices.ondevicepersonalization.OnDevicePersonalizationException#ERROR_PERSONALIZATION_DISABLED}, {@link android.adservices.ondevicepersonalization.OnDevicePersonalizationException#ERROR_ISOLATED_SERVICE_LOADING_FAILED}, {@link android.adservices.ondevicepersonalization.OnDevicePersonalizationException#ERROR_ISOLATED_SERVICE_MANIFEST_PARSING_FAILED}, {@link android.adservices.ondevicepersonalization.OnDevicePersonalizationException#ERROR_ISOLATED_SERVICE_TIMEOUT}, {@link android.adservices.ondevicepersonalization.OnDevicePersonalizationException#ERROR_SCHEDULE_TRAINING_FAILED}, {@link android.adservices.ondevicepersonalization.OnDevicePersonalizationException#ERROR_INVALID_TRAINING_MANIFEST}, {@link android.adservices.ondevicepersonalization.OnDevicePersonalizationException#ERROR_INFERENCE_MODEL_NOT_FOUND}, or {@link android.adservices.ondevicepersonalization.OnDevicePersonalizationException#ERROR_INFERENCE_FAILED}
 */

public int getErrorCode() { throw new RuntimeException("Stub!"); }

/** {@link android.adservices.ondevicepersonalization.ModelManager ModelManager} failed to run inference.
 *
 <p> Retrying may be successful if the issue is due to a platform internal error.
 */

public static final int ERROR_INFERENCE_FAILED = 9; // 0x9

/** Inference failed due to {@link android.adservices.ondevicepersonalization.ModelManager ModelManager} not finding the downloaded model. */

public static final int ERROR_INFERENCE_MODEL_NOT_FOUND = 8; // 0x8

/**
 * The {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService}'s call to {@link android.adservices.ondevicepersonalization.FederatedComputeScheduler#schedule FederatedComputeScheduler.schedule} failed due
 * to missing or misconfigured federated compute settings URL in the manifest.
 */

public static final int ERROR_INVALID_TRAINING_MANIFEST = 7; // 0x7

/**
 * The {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService} that was invoked failed to run.
 */

public static final int ERROR_ISOLATED_SERVICE_FAILED = 1; // 0x1

/** The ODP module was unable to load the {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService}.
 *
 * <p> Retrying may be successful for platform internal errors.
 */

public static final int ERROR_ISOLATED_SERVICE_LOADING_FAILED = 3; // 0x3

/**
 * The ODP specific manifest settings for the {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService} are either missing or
 * misconfigured.
 */

public static final int ERROR_ISOLATED_SERVICE_MANIFEST_PARSING_FAILED = 4; // 0x4

/** The {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService} was invoked but timed out before returning successfully.
 *
 * <p> This is likely due to an issue with the {@link android.adservices.ondevicepersonalization.IsolatedWorker IsolatedWorker} implementation taking too
 * long and retries are likely to fail.
 */

public static final int ERROR_ISOLATED_SERVICE_TIMEOUT = 5; // 0x5

/**
 * The {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService} was not started because personalization is disabled by
 * device configuration.
 */

public static final int ERROR_PERSONALIZATION_DISABLED = 2; // 0x2

/** The {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService}'s call to {@link android.adservices.ondevicepersonalization.FederatedComputeScheduler#schedule FederatedComputeScheduler.schedule} failed.
 *
 <p> Retrying may be successful if the issue is due to a platform internal error.
 */

public static final int ERROR_SCHEDULE_TRAINING_FAILED = 6; // 0x6
}

