/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.ondevicepersonalization;


/**
 * The input data for
 * {@link android.adservices.ondevicepersonalization.IsolatedWorker#onWebTrigger(android.adservices.ondevicepersonalization.WebTriggerInput,android.os.OutcomeReceiver) IsolatedWorker.onWebTrigger(WebTriggerInput, android.os.OutcomeReceiver)}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class WebTriggerInput {

/**
 * Creates a new WebTriggerInput.
 *
 * @param destinationUrl
 *   The destination URL (landing page) where the trigger event occurred.
 * This value cannot be {@code null}.
 * @param appPackageName
 *   The package name of the app where the trigger event occurred
 * This value cannot be {@code null}.
 * @param data
 *   Additional data returned by the server as part of the web trigger registration
 *   to be sent to the {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService}. This can be {@code null} if the server
 *   does not need to send data to the service for processing web triggers.
 */

public WebTriggerInput(@android.annotation.NonNull android.net.Uri destinationUrl, @android.annotation.NonNull java.lang.String appPackageName, @android.annotation.NonNull byte[] data) { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param o This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * The package name of the app where the trigger event occurred

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getAppPackageName() { throw new RuntimeException("Stub!"); }

/**
 * Additional data returned by the server as part of the web trigger registration
 * to be sent to the {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService}. This can be {@code null} if the server
 * does not need to send data to the service for processing web triggers.
 */

@android.annotation.NonNull
public byte[] getData() { throw new RuntimeException("Stub!"); }

/**
 * The destination URL (landing page) where the trigger event occurred.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.Uri getDestinationUrl() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }
}

