/*
 * Copyright (C) 2018 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.app.role;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class RoleManager {

RoleManager() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.content.Intent createRequestRoleIntent(@android.annotation.NonNull java.lang.String roleName) { throw new RuntimeException("Stub!"); }

public boolean isRoleAvailable(@android.annotation.NonNull java.lang.String roleName) { throw new RuntimeException("Stub!"); }

public boolean isRoleHeld(@android.annotation.NonNull java.lang.String roleName) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<java.lang.String> getRoleHolders(@android.annotation.NonNull java.lang.String roleName) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<java.lang.String> getRoleHoldersAsUser(@android.annotation.NonNull java.lang.String roleName, @android.annotation.NonNull android.os.UserHandle user) { throw new RuntimeException("Stub!"); }

public void addRoleHolderAsUser(@android.annotation.NonNull java.lang.String roleName, @android.annotation.NonNull java.lang.String packageName, int flags, @android.annotation.NonNull android.os.UserHandle user, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull java.util.function.Consumer<java.lang.Boolean> callback) { throw new RuntimeException("Stub!"); }

public void removeRoleHolderAsUser(@android.annotation.NonNull java.lang.String roleName, @android.annotation.NonNull java.lang.String packageName, int flags, @android.annotation.NonNull android.os.UserHandle user, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull java.util.function.Consumer<java.lang.Boolean> callback) { throw new RuntimeException("Stub!"); }

public void clearRoleHoldersAsUser(@android.annotation.NonNull java.lang.String roleName, int flags, @android.annotation.NonNull android.os.UserHandle user, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull java.util.function.Consumer<java.lang.Boolean> callback) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getDefaultApplication(@android.annotation.NonNull java.lang.String roleName) { throw new RuntimeException("Stub!"); }

public void setDefaultApplication(@android.annotation.NonNull java.lang.String roleName, @android.annotation.Nullable java.lang.String packageName, int flags, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull java.util.function.Consumer<java.lang.Boolean> callback) { throw new RuntimeException("Stub!"); }

public void addOnRoleHoldersChangedListenerAsUser(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.app.role.OnRoleHoldersChangedListener listener, @android.annotation.NonNull android.os.UserHandle user) { throw new RuntimeException("Stub!"); }

public void removeOnRoleHoldersChangedListenerAsUser(@android.annotation.NonNull android.app.role.OnRoleHoldersChangedListener listener, @android.annotation.NonNull android.os.UserHandle user) { throw new RuntimeException("Stub!"); }

public boolean isBypassingRoleQualification() { throw new RuntimeException("Stub!"); }

public void setBypassingRoleQualification(boolean bypassRoleQualification) { throw new RuntimeException("Stub!"); }

public boolean isRoleFallbackEnabled(@android.annotation.NonNull java.lang.String roleName) { throw new RuntimeException("Stub!"); }

public void setRoleFallbackEnabled(@android.annotation.NonNull java.lang.String roleName, boolean fallbackEnabled) { throw new RuntimeException("Stub!"); }

@Deprecated
public void setRoleNamesFromController(@android.annotation.NonNull java.util.List<java.lang.String> roleNames) { throw new RuntimeException("Stub!"); }

@Deprecated
public boolean addRoleHolderFromController(@android.annotation.NonNull java.lang.String roleName, @android.annotation.NonNull java.lang.String packageName) { throw new RuntimeException("Stub!"); }

@Deprecated
public boolean removeRoleHolderFromController(@android.annotation.NonNull java.lang.String roleName, @android.annotation.NonNull java.lang.String packageName) { throw new RuntimeException("Stub!"); }

@Deprecated
@android.annotation.NonNull
public java.util.List<java.lang.String> getHeldRolesFromController(@android.annotation.NonNull java.lang.String packageName) { throw new RuntimeException("Stub!"); }

public void isRoleVisible(@android.annotation.NonNull java.lang.String roleName, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull java.util.function.Consumer<java.lang.Boolean> callback) { throw new RuntimeException("Stub!"); }

public void isApplicationVisibleForRole(@android.annotation.NonNull java.lang.String roleName, @android.annotation.NonNull java.lang.String packageName, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull java.util.function.Consumer<java.lang.Boolean> callback) { throw new RuntimeException("Stub!"); }

public static final int MANAGE_HOLDERS_FLAG_DONT_KILL_APP = 1; // 0x1

public static final java.lang.String ROLE_ASSISTANT = "android.app.role.ASSISTANT";

public static final java.lang.String ROLE_BROWSER = "android.app.role.BROWSER";

public static final java.lang.String ROLE_CALL_REDIRECTION = "android.app.role.CALL_REDIRECTION";

public static final java.lang.String ROLE_CALL_SCREENING = "android.app.role.CALL_SCREENING";

public static final java.lang.String ROLE_DEVICE_POLICY_MANAGEMENT = "android.app.role.DEVICE_POLICY_MANAGEMENT";

public static final java.lang.String ROLE_DIALER = "android.app.role.DIALER";

public static final java.lang.String ROLE_EMERGENCY = "android.app.role.EMERGENCY";

public static final java.lang.String ROLE_FINANCED_DEVICE_KIOSK = "android.app.role.FINANCED_DEVICE_KIOSK";

public static final java.lang.String ROLE_HOME = "android.app.role.HOME";

public static final java.lang.String ROLE_NOTES = "android.app.role.NOTES";

public static final java.lang.String ROLE_SMS = "android.app.role.SMS";

public static final java.lang.String ROLE_SYSTEM_ACTIVITY_RECOGNIZER = "android.app.role.SYSTEM_ACTIVITY_RECOGNIZER";

public static final java.lang.String ROLE_SYSTEM_CALL_STREAMING = "android.app.role.SYSTEM_CALL_STREAMING";

public static final java.lang.String ROLE_SYSTEM_SUPERVISION = "android.app.role.SYSTEM_SUPERVISION";

public static final java.lang.String ROLE_SYSTEM_WELLBEING = "android.app.role.SYSTEM_WELLBEING";

public static final java.lang.String ROLE_WALLET = "android.app.role.WALLET";
}

