/*
 * Copyright (C) 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.safetycenter;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class SafetyCenterManager {

SafetyCenterManager() { throw new RuntimeException("Stub!"); }

public boolean isSafetyCenterEnabled() { throw new RuntimeException("Stub!"); }

public void setSafetySourceData(@android.annotation.NonNull java.lang.String safetySourceId, @android.annotation.Nullable android.safetycenter.SafetySourceData safetySourceData, @android.annotation.NonNull android.safetycenter.SafetyEvent safetyEvent) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.safetycenter.SafetySourceData getSafetySourceData(@android.annotation.NonNull java.lang.String safetySourceId) { throw new RuntimeException("Stub!"); }

public void reportSafetySourceError(@android.annotation.NonNull java.lang.String safetySourceId, @android.annotation.NonNull android.safetycenter.SafetySourceErrorDetails safetySourceErrorDetails) { throw new RuntimeException("Stub!"); }

public void refreshSafetySources(int refreshReason) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.safetycenter.config.SafetyCenterConfig getSafetyCenterConfig() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.safetycenter.SafetyCenterData getSafetyCenterData() { throw new RuntimeException("Stub!"); }

public void addOnSafetyCenterDataChangedListener(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.safetycenter.SafetyCenterManager.OnSafetyCenterDataChangedListener listener) { throw new RuntimeException("Stub!"); }

public void removeOnSafetyCenterDataChangedListener(@android.annotation.NonNull android.safetycenter.SafetyCenterManager.OnSafetyCenterDataChangedListener listener) { throw new RuntimeException("Stub!"); }

public void dismissSafetyCenterIssue(@android.annotation.NonNull java.lang.String safetyCenterIssueId) { throw new RuntimeException("Stub!"); }

public void executeSafetyCenterIssueAction(@android.annotation.NonNull java.lang.String safetyCenterIssueId, @android.annotation.NonNull java.lang.String safetyCenterIssueActionId) { throw new RuntimeException("Stub!"); }

public void clearAllSafetySourceDataForTests() { throw new RuntimeException("Stub!"); }

public void setSafetyCenterConfigForTests(@android.annotation.NonNull android.safetycenter.config.SafetyCenterConfig safetyCenterConfig) { throw new RuntimeException("Stub!"); }

public void clearSafetyCenterConfigForTests() { throw new RuntimeException("Stub!"); }

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_REFRESH_SAFETY_SOURCES = "android.safetycenter.action.REFRESH_SAFETY_SOURCES";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_SAFETY_CENTER_ENABLED_CHANGED = "android.safetycenter.action.SAFETY_CENTER_ENABLED_CHANGED";

public static final int EXTRA_REFRESH_REQUEST_TYPE_FETCH_FRESH_DATA = 0; // 0x0

public static final int EXTRA_REFRESH_REQUEST_TYPE_GET_DATA = 1; // 0x1

public static final java.lang.String EXTRA_REFRESH_SAFETY_SOURCES_BROADCAST_ID = "android.safetycenter.extra.REFRESH_SAFETY_SOURCES_BROADCAST_ID";

public static final java.lang.String EXTRA_REFRESH_SAFETY_SOURCES_REQUEST_TYPE = "android.safetycenter.extra.REFRESH_SAFETY_SOURCES_REQUEST_TYPE";

public static final java.lang.String EXTRA_REFRESH_SAFETY_SOURCE_IDS = "android.safetycenter.extra.REFRESH_SAFETY_SOURCE_IDS";

public static final java.lang.String EXTRA_SAFETY_SOURCE_ID = "android.safetycenter.extra.SAFETY_SOURCE_ID";

public static final java.lang.String EXTRA_SAFETY_SOURCE_ISSUE_ID = "android.safetycenter.extra.SAFETY_SOURCE_ISSUE_ID";

public static final java.lang.String EXTRA_SAFETY_SOURCE_USER_HANDLE = "android.safetycenter.extra.SAFETY_SOURCE_USER_HANDLE";

public static final int REFRESH_REASON_DEVICE_LOCALE_CHANGE = 400; // 0x190

public static final int REFRESH_REASON_DEVICE_REBOOT = 300; // 0x12c

public static final int REFRESH_REASON_OTHER = 600; // 0x258

public static final int REFRESH_REASON_PAGE_OPEN = 100; // 0x64

public static final int REFRESH_REASON_RESCAN_BUTTON_CLICK = 200; // 0xc8

public static final int REFRESH_REASON_SAFETY_CENTER_ENABLED = 500; // 0x1f4
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface OnSafetyCenterDataChangedListener {

public void onSafetyCenterDataChanged(@android.annotation.NonNull android.safetycenter.SafetyCenterData data);

public default void onError(@android.annotation.NonNull android.safetycenter.SafetyCenterErrorDetails errorDetails) { throw new RuntimeException("Stub!"); }
}

}

