/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.safetycenter;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class SafetyCenterStatus implements android.os.Parcelable {

private SafetyCenterStatus() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.CharSequence getTitle() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.CharSequence getSummary() { throw new RuntimeException("Stub!"); }

public int getSeverityLevel() { throw new RuntimeException("Stub!"); }

public int getRefreshStatus() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.safetycenter.SafetyCenterStatus> CREATOR;
static { CREATOR = null; }

public static final int OVERALL_SEVERITY_LEVEL_CRITICAL_WARNING = 1300; // 0x514

public static final int OVERALL_SEVERITY_LEVEL_OK = 1100; // 0x44c

public static final int OVERALL_SEVERITY_LEVEL_RECOMMENDATION = 1200; // 0x4b0

public static final int OVERALL_SEVERITY_LEVEL_UNKNOWN = 1000; // 0x3e8

public static final int REFRESH_STATUS_DATA_FETCH_IN_PROGRESS = 10100; // 0x2774

public static final int REFRESH_STATUS_FULL_RESCAN_IN_PROGRESS = 10200; // 0x27d8

public static final int REFRESH_STATUS_NONE = 0; // 0x0
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder(@android.annotation.NonNull java.lang.CharSequence title, @android.annotation.NonNull java.lang.CharSequence summary) { throw new RuntimeException("Stub!"); }

public Builder(@android.annotation.NonNull android.safetycenter.SafetyCenterStatus safetyCenterStatus) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.safetycenter.SafetyCenterStatus.Builder setTitle(@android.annotation.NonNull java.lang.CharSequence title) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.safetycenter.SafetyCenterStatus.Builder setSummary(@android.annotation.NonNull java.lang.CharSequence summary) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.safetycenter.SafetyCenterStatus.Builder setSeverityLevel(int severityLevel) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.safetycenter.SafetyCenterStatus.Builder setRefreshStatus(int refreshStatus) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.safetycenter.SafetyCenterStatus build() { throw new RuntimeException("Stub!"); }
}

}

