/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.ranging;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class RangingSession implements java.lang.AutoCloseable {

RangingSession() { throw new RuntimeException("Stub!"); }

public void addDeviceToRangingSession(@android.annotation.NonNull android.ranging.RangingConfig deviceRangingParams) { throw new RuntimeException("Stub!"); }

public void close() { throw new RuntimeException("Stub!"); }

public void reconfigureRangingInterval(int intervalSkipCount) { throw new RuntimeException("Stub!"); }

public void removeDeviceFromRangingSession(@android.annotation.NonNull android.ranging.RangingDevice rangingDevice) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.os.CancellationSignal start(@android.annotation.NonNull android.ranging.RangingPreference rangingPreference) { throw new RuntimeException("Stub!"); }

public void stop() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface Callback {

public void onClosed(int reason);

public void onOpenFailed(int reason);

public void onOpened();

public void onResults(@android.annotation.NonNull android.ranging.RangingDevice peer, @android.annotation.NonNull android.ranging.RangingData data);

public void onStarted(@android.annotation.NonNull android.ranging.RangingDevice peer, int technology);

public void onStopped(@android.annotation.NonNull android.ranging.RangingDevice peer, int technology);

public static final int REASON_LOCAL_REQUEST = 1; // 0x1

public static final int REASON_NO_PEERS_FOUND = 5; // 0x5

public static final int REASON_REMOTE_REQUEST = 2; // 0x2

public static final int REASON_SYSTEM_POLICY = 4; // 0x4

public static final int REASON_UNKNOWN = 0; // 0x0

public static final int REASON_UNSUPPORTED = 3; // 0x3
}

}

