/*
 * Copyright 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.uwb;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class UwbManager {

UwbManager() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.os.PersistableBundle addServiceProfile(@android.annotation.NonNull android.os.PersistableBundle parameters) { throw new RuntimeException("Stub!"); }

public long elapsedRealtimeResolutionNanos() { throw new RuntimeException("Stub!"); }

public long elapsedRealtimeResolutionNanos(@android.annotation.NonNull java.lang.String chipId) { throw new RuntimeException("Stub!"); }

public int getAdapterState() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.os.PersistableBundle getAdfCertificateInfo(@android.annotation.NonNull android.os.PersistableBundle serviceProfileBundle) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.os.PersistableBundle getAdfProvisioningAuthorities(@android.annotation.NonNull android.os.PersistableBundle serviceProfileBundle) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.os.PersistableBundle getAllServiceProfiles() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.os.PersistableBundle> getChipInfos() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String getDefaultChipId() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.os.PersistableBundle getSpecificationInfo() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.os.PersistableBundle getSpecificationInfo(@android.annotation.NonNull java.lang.String chipId) { throw new RuntimeException("Stub!"); }

public void getUwbActivityEnergyInfoAsync(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull java.util.function.Consumer<android.uwb.UwbActivityEnergyInfo> listener) { throw new RuntimeException("Stub!"); }

public boolean isUwbEnabled() { throw new RuntimeException("Stub!"); }

public boolean isUwbHwEnableRequested() { throw new RuntimeException("Stub!"); }

public boolean isUwbHwIdleTurnOffEnabled() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.os.CancellationSignal openRangingSession(@android.annotation.NonNull android.os.PersistableBundle parameters, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.uwb.RangingSession.Callback callbacks) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.os.CancellationSignal openRangingSession(@android.annotation.NonNull android.os.PersistableBundle parameters, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.uwb.RangingSession.Callback callbacks, @android.annotation.NonNull java.lang.String chipId) { throw new RuntimeException("Stub!"); }

public void provisionProfileAdfByScript(@android.annotation.NonNull android.os.PersistableBundle serviceProfileBundle, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.uwb.UwbManager.AdfProvisionStateCallback callback) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public long queryUwbsTimestampMicros() { throw new RuntimeException("Stub!"); }

public void registerAdapterStateCallback(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.uwb.UwbManager.AdapterStateCallback callback) { throw new RuntimeException("Stub!"); }

public void registerUwbOemExtensionCallback(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.uwb.UwbManager.UwbOemExtensionCallback callback) { throw new RuntimeException("Stub!"); }

public void registerUwbVendorUciCallback(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.uwb.UwbManager.UwbVendorUciCallback callback) { throw new RuntimeException("Stub!"); }

public int removeProfileAdf(@android.annotation.NonNull android.os.PersistableBundle serviceProfileBundle) { throw new RuntimeException("Stub!"); }

public int removeServiceProfile(@android.annotation.NonNull android.os.PersistableBundle parameters) { throw new RuntimeException("Stub!"); }

public void requestUwbHwEnabled(boolean enabled) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public int sendVendorUciMessage(int gid, int oid, @android.annotation.NonNull byte[] payload) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public int sendVendorUciMessage(int mt, int gid, int oid, @android.annotation.NonNull byte[] payload) { throw new RuntimeException("Stub!"); }

public void setUwbEnabled(boolean enabled) { throw new RuntimeException("Stub!"); }

public void unregisterAdapterStateCallback(@android.annotation.NonNull android.uwb.UwbManager.AdapterStateCallback callback) { throw new RuntimeException("Stub!"); }

public void unregisterUwbOemExtensionCallback(@android.annotation.NonNull android.uwb.UwbManager.UwbOemExtensionCallback callback) { throw new RuntimeException("Stub!"); }

public void unregisterUwbVendorUciCallback(@android.annotation.NonNull android.uwb.UwbManager.UwbVendorUciCallback callback) { throw new RuntimeException("Stub!"); }

public static final int MESSAGE_TYPE_COMMAND = 1; // 0x1

public static final int MESSAGE_TYPE_TEST_1 = 4; // 0x4

public static final int MESSAGE_TYPE_TEST_2 = 5; // 0x5

public static final int REMOVE_PROFILE_ADF_ERROR_INTERNAL = 2; // 0x2

public static final int REMOVE_PROFILE_ADF_ERROR_UNKNOWN_SERVICE = 1; // 0x1

public static final int REMOVE_PROFILE_ADF_SUCCESS = 0; // 0x0

public static final int REMOVE_SERVICE_PROFILE_ERROR_INTERNAL = 2; // 0x2

public static final int REMOVE_SERVICE_PROFILE_ERROR_UNKNOWN_SERVICE = 1; // 0x1

public static final int REMOVE_SERVICE_PROFILE_SUCCESS = 0; // 0x0

public static final int SEND_VENDOR_UCI_ERROR_HW = 1; // 0x1

public static final int SEND_VENDOR_UCI_ERROR_INVALID_ARGS = 3; // 0x3

public static final int SEND_VENDOR_UCI_ERROR_INVALID_GID = 4; // 0x4

public static final int SEND_VENDOR_UCI_ERROR_OFF = 2; // 0x2

public static final int SEND_VENDOR_UCI_SUCCESS = 0; // 0x0
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface AdapterStateCallback {

public void onStateChanged(int state, int reason);

public static final int STATE_CHANGED_REASON_ALL_SESSIONS_CLOSED = 1; // 0x1

public static final int STATE_CHANGED_REASON_ERROR_UNKNOWN = 4; // 0x4

public static final int STATE_CHANGED_REASON_SESSION_STARTED = 0; // 0x0

public static final int STATE_CHANGED_REASON_SYSTEM_BOOT = 3; // 0x3

public static final int STATE_CHANGED_REASON_SYSTEM_POLICY = 2; // 0x2

public static final int STATE_CHANGED_REASON_SYSTEM_REGULATION = 5; // 0x5

public static final int STATE_DISABLED = 0; // 0x0

public static final int STATE_ENABLED_ACTIVE = 2; // 0x2

public static final int STATE_ENABLED_HW_IDLE = 3; // 0x3

public static final int STATE_ENABLED_INACTIVE = 1; // 0x1
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract static class AdfProvisionStateCallback {

public AdfProvisionStateCallback() { throw new RuntimeException("Stub!"); }

public abstract void onProfileAdfsProvisionFailed(int reason, @android.annotation.NonNull android.os.PersistableBundle params);

public abstract void onProfileAdfsProvisioned(@android.annotation.NonNull android.os.PersistableBundle params);

public static final int REASON_INVALID_OID = 1; // 0x1

public static final int REASON_SE_FAILURE = 2; // 0x2

public static final int REASON_UNKNOWN = 3; // 0x3
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface UwbOemExtensionCallback {

public boolean onCheckPointedTarget(@android.annotation.NonNull android.os.PersistableBundle pointedTargetBundle);

public void onDeviceStatusNotificationReceived(@android.annotation.NonNull android.os.PersistableBundle deviceStatusBundle);

@android.annotation.NonNull
public android.uwb.RangingReport onRangingReportReceived(@android.annotation.NonNull android.uwb.RangingReport rangingReport);

@android.annotation.NonNull
public int onSessionConfigurationComplete(@android.annotation.NonNull android.os.PersistableBundle openSessionBundle);

public void onSessionStatusNotificationReceived(@android.annotation.NonNull android.os.PersistableBundle sessionStatusBundle);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface UwbVendorUciCallback {

public void onVendorUciNotification(int gid, int oid, @android.annotation.NonNull byte[] payload);

public void onVendorUciResponse(int gid, int oid, @android.annotation.NonNull byte[] payload);
}

}

