/*
 * Copyright 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.uwb;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class RangingSession implements java.lang.AutoCloseable {

RangingSession() { throw new RuntimeException("Stub!"); }

public void start(@android.annotation.NonNull android.os.PersistableBundle params) { throw new RuntimeException("Stub!"); }

public void reconfigure(@android.annotation.NonNull android.os.PersistableBundle params) { throw new RuntimeException("Stub!"); }

public void stop() { throw new RuntimeException("Stub!"); }

public void close() { throw new RuntimeException("Stub!"); }

public void addControlee(@android.annotation.NonNull android.os.PersistableBundle params) { throw new RuntimeException("Stub!"); }

public void removeControlee(@android.annotation.NonNull android.os.PersistableBundle params) { throw new RuntimeException("Stub!"); }

public void pause(@android.annotation.NonNull android.os.PersistableBundle params) { throw new RuntimeException("Stub!"); }

public void resume(@android.annotation.NonNull android.os.PersistableBundle params) { throw new RuntimeException("Stub!"); }

public void sendData(@android.annotation.NonNull android.uwb.UwbAddress remoteDeviceAddress, @android.annotation.NonNull android.os.PersistableBundle params, @android.annotation.NonNull byte[] data) { throw new RuntimeException("Stub!"); }
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface Callback {

public void onOpened(@android.annotation.NonNull android.uwb.RangingSession session);

public void onOpenFailed(int reason, @android.annotation.NonNull android.os.PersistableBundle params);

public void onStarted(@android.annotation.NonNull android.os.PersistableBundle sessionInfo);

public void onStartFailed(int reason, @android.annotation.NonNull android.os.PersistableBundle params);

public void onReconfigured(@android.annotation.NonNull android.os.PersistableBundle params);

public void onReconfigureFailed(int reason, @android.annotation.NonNull android.os.PersistableBundle params);

public void onStopped(int reason, @android.annotation.NonNull android.os.PersistableBundle parameters);

public void onStopFailed(int reason, @android.annotation.NonNull android.os.PersistableBundle params);

public void onClosed(int reason, @android.annotation.NonNull android.os.PersistableBundle parameters);

public void onReportReceived(@android.annotation.NonNull android.uwb.RangingReport rangingReport);

public default void onControleeAdded(@android.annotation.NonNull android.os.PersistableBundle parameters) { throw new RuntimeException("Stub!"); }

public default void onControleeAddFailed(int reason, @android.annotation.NonNull android.os.PersistableBundle parameters) { throw new RuntimeException("Stub!"); }

public default void onControleeRemoved(@android.annotation.NonNull android.os.PersistableBundle parameters) { throw new RuntimeException("Stub!"); }

public default void onControleeRemoveFailed(int reason, @android.annotation.NonNull android.os.PersistableBundle parameters) { throw new RuntimeException("Stub!"); }

public default void onPaused(@android.annotation.NonNull android.os.PersistableBundle parameters) { throw new RuntimeException("Stub!"); }

public default void onPauseFailed(int reason, @android.annotation.NonNull android.os.PersistableBundle parameters) { throw new RuntimeException("Stub!"); }

public default void onResumed(@android.annotation.NonNull android.os.PersistableBundle parameters) { throw new RuntimeException("Stub!"); }

public default void onResumeFailed(int reason, @android.annotation.NonNull android.os.PersistableBundle parameters) { throw new RuntimeException("Stub!"); }

public default void onDataSent(@android.annotation.NonNull android.uwb.UwbAddress remoteDeviceAddress, @android.annotation.NonNull android.os.PersistableBundle parameters) { throw new RuntimeException("Stub!"); }

public default void onDataSendFailed(@android.annotation.NonNull android.uwb.UwbAddress remoteDeviceAddress, int reason, @android.annotation.NonNull android.os.PersistableBundle parameters) { throw new RuntimeException("Stub!"); }

public default void onDataReceived(@android.annotation.NonNull android.uwb.UwbAddress remoteDeviceAddress, @android.annotation.NonNull android.os.PersistableBundle parameters, @android.annotation.NonNull byte[] data) { throw new RuntimeException("Stub!"); }

public default void onDataReceiveFailed(@android.annotation.NonNull android.uwb.UwbAddress remoteDeviceAddress, int reason, @android.annotation.NonNull android.os.PersistableBundle parameters) { throw new RuntimeException("Stub!"); }

public default void onServiceDiscovered(@android.annotation.NonNull android.os.PersistableBundle parameters) { throw new RuntimeException("Stub!"); }

public default void onServiceConnected(@android.annotation.NonNull android.os.PersistableBundle parameters) { throw new RuntimeException("Stub!"); }

public static final int CONTROLEE_FAILURE_REASON_MAX_CONTROLEE_REACHED = 0; // 0x0

public static final int DATA_FAILURE_REASON_DATA_SIZE_TOO_LARGE = 10; // 0xa

public static final int REASON_BAD_PARAMETERS = 3; // 0x3

public static final int REASON_GENERIC_ERROR = 4; // 0x4

public static final int REASON_LOCAL_REQUEST = 1; // 0x1

public static final int REASON_MAX_RR_RETRY_REACHED = 9; // 0x9

public static final int REASON_MAX_SESSIONS_REACHED = 5; // 0x5

public static final int REASON_PROTOCOL_SPECIFIC_ERROR = 7; // 0x7

public static final int REASON_REMOTE_REQUEST = 2; // 0x2

public static final int REASON_SERVICE_CONNECTION_FAILURE = 11; // 0xb

public static final int REASON_SERVICE_DISCOVERY_FAILURE = 10; // 0xa

public static final int REASON_SE_INTERACTION_FAILURE = 13; // 0xd

public static final int REASON_SE_NOT_SUPPORTED = 12; // 0xc

public static final int REASON_SYSTEM_POLICY = 6; // 0x6

public static final int REASON_UNKNOWN = 0; // 0x0
}

}

