/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.ranging.uwb;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class UwbRangingParams implements android.os.Parcelable {

UwbRangingParams() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.ranging.uwb.UwbComplexChannel getComplexChannel() { throw new RuntimeException("Stub!"); }

public int getConfigId() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.ranging.uwb.UwbAddress getDeviceAddress() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.ranging.uwb.UwbAddress getPeerAddress() { throw new RuntimeException("Stub!"); }

public int getRangingUpdateRate() { throw new RuntimeException("Stub!"); }

public int getSessionId() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public byte[] getSessionKeyInfo() { throw new RuntimeException("Stub!"); }

public int getSlotDuration() { throw new RuntimeException("Stub!"); }

public int getSubSessionId() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public byte[] getSubSessionKeyInfo() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

public static final int CONFIG_MULTICAST_DS_TWR = 2; // 0x2

public static final int CONFIG_PROVISIONED_INDIVIDUAL_MULTICAST_DS_TWR = 5; // 0x5

public static final int CONFIG_PROVISIONED_MULTICAST_DS_TWR = 4; // 0x4

public static final int CONFIG_PROVISIONED_UNICAST_DS_TWR = 3; // 0x3

public static final int CONFIG_PROVISIONED_UNICAST_DS_TWR_VERY_FAST = 6; // 0x6

public static final int CONFIG_UNICAST_DS_TWR = 1; // 0x1

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.ranging.uwb.UwbRangingParams> CREATOR;
static { CREATOR = null; }

public static final int DURATION_1_MS = 1; // 0x1

public static final int DURATION_2_MS = 2; // 0x2

public static final int SUB_SESSION_UNDEFINED = -1; // 0xffffffff
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder(int sessionId, int configId, @android.annotation.NonNull android.ranging.uwb.UwbAddress deviceAddress, @android.annotation.NonNull android.ranging.uwb.UwbAddress peerAddress) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.ranging.uwb.UwbRangingParams build() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.ranging.uwb.UwbRangingParams.Builder setComplexChannel(@android.annotation.NonNull android.ranging.uwb.UwbComplexChannel complexChannel) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.ranging.uwb.UwbRangingParams.Builder setRangingUpdateRate(int rate) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.ranging.uwb.UwbRangingParams.Builder setSessionKeyInfo(@android.annotation.NonNull byte[] sessionKeyInfo) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.ranging.uwb.UwbRangingParams.Builder setSlotDuration(int durationMs) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.ranging.uwb.UwbRangingParams.Builder setSubSessionId(int subSessionId) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.ranging.uwb.UwbRangingParams.Builder setSubSessionKeyInfo(@android.annotation.NonNull byte[] subSessionKeyInfo) { throw new RuntimeException("Stub!"); }
}

}

