/*
 * Copyright (C) 2008 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.wifi;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class WifiInfo implements android.net.TransportInfo, android.os.Parcelable {

WifiInfo() { throw new RuntimeException("Stub!"); }

public double getLostTxPacketsPerSecond() { throw new RuntimeException("Stub!"); }

public double getRetriedTxPacketsPerSecond() { throw new RuntimeException("Stub!"); }

public double getSuccessfulTxPacketsPerSecond() { throw new RuntimeException("Stub!"); }

public double getSuccessfulRxPacketsPerSecond() { throw new RuntimeException("Stub!"); }

public int getScore() { throw new RuntimeException("Stub!"); }

public java.lang.String getSSID() { throw new RuntimeException("Stub!"); }

public java.lang.String getBSSID() { throw new RuntimeException("Stub!"); }

public int getRssi() { throw new RuntimeException("Stub!"); }

public int getWifiStandard() { throw new RuntimeException("Stub!"); }

public int getLinkSpeed() { throw new RuntimeException("Stub!"); }

public int getTxLinkSpeedMbps() { throw new RuntimeException("Stub!"); }

public int getMaxSupportedTxLinkSpeedMbps() { throw new RuntimeException("Stub!"); }

public int getRxLinkSpeedMbps() { throw new RuntimeException("Stub!"); }

public int getMaxSupportedRxLinkSpeedMbps() { throw new RuntimeException("Stub!"); }

public int getFrequency() { throw new RuntimeException("Stub!"); }

public java.lang.String getMacAddress() { throw new RuntimeException("Stub!"); }

public boolean isEphemeral() { throw new RuntimeException("Stub!"); }

public boolean isTrusted() { throw new RuntimeException("Stub!"); }

public boolean isOemPaid() { throw new RuntimeException("Stub!"); }

public boolean isOemPrivate() { throw new RuntimeException("Stub!"); }

public boolean isCarrierMerged() { throw new RuntimeException("Stub!"); }

public boolean isOsuAp() { throw new RuntimeException("Stub!"); }

public boolean isPasspointAp() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getPasspointFqdn() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getPasspointProviderFriendlyName() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getRequestingPackageName() { throw new RuntimeException("Stub!"); }

public int getSubscriptionId() { throw new RuntimeException("Stub!"); }

public int getNetworkId() { throw new RuntimeException("Stub!"); }

public android.net.wifi.SupplicantState getSupplicantState() { throw new RuntimeException("Stub!"); }

@Deprecated
public int getIpAddress() { throw new RuntimeException("Stub!"); }

public boolean getHiddenSSID() { throw new RuntimeException("Stub!"); }

public static android.net.NetworkInfo.DetailedState getDetailedStateOf(android.net.wifi.SupplicantState suppState) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public static java.lang.String sanitizeSsid(@android.annotation.Nullable java.lang.String string) { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public void writeToParcel(android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.util.List<android.net.wifi.ScanResult.InformationElement> getInformationElements() { throw new RuntimeException("Stub!"); }

public boolean isPrimary() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object that) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.WifiInfo makeCopy(long redactions) { throw new RuntimeException("Stub!"); }

public long getApplicableRedactions() { throw new RuntimeException("Stub!"); }

public int getCurrentSecurityType() { throw new RuntimeException("Stub!"); }

public static final java.lang.String DEFAULT_MAC_ADDRESS = "02:00:00:00:00:00";

public static final java.lang.String FREQUENCY_UNITS = "MHz";

public static final int INVALID_RSSI = -127; // 0xffffff81

public static final java.lang.String LINK_SPEED_UNITS = "Mbps";

public static final int LINK_SPEED_UNKNOWN = -1; // 0xffffffff

public static final int SECURITY_TYPE_EAP = 3; // 0x3

public static final int SECURITY_TYPE_EAP_WPA3_ENTERPRISE = 9; // 0x9

public static final int SECURITY_TYPE_EAP_WPA3_ENTERPRISE_192_BIT = 5; // 0x5

public static final int SECURITY_TYPE_OPEN = 0; // 0x0

public static final int SECURITY_TYPE_OSEN = 10; // 0xa

public static final int SECURITY_TYPE_OWE = 6; // 0x6

public static final int SECURITY_TYPE_PASSPOINT_R1_R2 = 11; // 0xb

public static final int SECURITY_TYPE_PASSPOINT_R3 = 12; // 0xc

public static final int SECURITY_TYPE_PSK = 2; // 0x2

public static final int SECURITY_TYPE_SAE = 4; // 0x4

public static final int SECURITY_TYPE_UNKNOWN = -1; // 0xffffffff

public static final int SECURITY_TYPE_WAPI_CERT = 8; // 0x8

public static final int SECURITY_TYPE_WAPI_PSK = 7; // 0x7

public static final int SECURITY_TYPE_WEP = 1; // 0x1
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.WifiInfo.Builder setSsid(@android.annotation.NonNull byte[] ssid) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.WifiInfo.Builder setBssid(@android.annotation.NonNull java.lang.String bssid) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.WifiInfo.Builder setRssi(int rssi) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.WifiInfo.Builder setNetworkId(int networkId) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.WifiInfo.Builder setCurrentSecurityType(int securityType) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.WifiInfo build() { throw new RuntimeException("Stub!"); }
}

}

