/*
 * Copyright (C) 2019 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.wifi;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class WifiUsabilityStatsEntry implements android.os.Parcelable {

WifiUsabilityStatsEntry() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public void writeToParcel(android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

public long getTimeStampMillis() { throw new RuntimeException("Stub!"); }

public int getRssi() { throw new RuntimeException("Stub!"); }

public int getLinkSpeedMbps() { throw new RuntimeException("Stub!"); }

public long getTotalTxSuccess() { throw new RuntimeException("Stub!"); }

public long getTotalTxRetries() { throw new RuntimeException("Stub!"); }

public long getTotalTxBad() { throw new RuntimeException("Stub!"); }

public long getTotalRxSuccess() { throw new RuntimeException("Stub!"); }

public long getTotalRadioOnTimeMillis() { throw new RuntimeException("Stub!"); }

public long getTotalRadioTxTimeMillis() { throw new RuntimeException("Stub!"); }

public long getTotalRadioRxTimeMillis() { throw new RuntimeException("Stub!"); }

public long getTotalScanTimeMillis() { throw new RuntimeException("Stub!"); }

public long getTotalNanScanTimeMillis() { throw new RuntimeException("Stub!"); }

public long getTotalBackgroundScanTimeMillis() { throw new RuntimeException("Stub!"); }

public long getTotalRoamScanTimeMillis() { throw new RuntimeException("Stub!"); }

public long getTotalPnoScanTimeMillis() { throw new RuntimeException("Stub!"); }

public long getTotalHotspot2ScanTimeMillis() { throw new RuntimeException("Stub!"); }

public long getTotalCcaBusyFreqTimeMillis() { throw new RuntimeException("Stub!"); }

public long getTotalRadioOnFreqTimeMillis() { throw new RuntimeException("Stub!"); }

public long getTotalBeaconRx() { throw new RuntimeException("Stub!"); }

public int getProbeStatusSinceLastUpdate() { throw new RuntimeException("Stub!"); }

public int getProbeElapsedTimeSinceLastUpdateMillis() { throw new RuntimeException("Stub!"); }

public int getProbeMcsRateSinceLastUpdate() { throw new RuntimeException("Stub!"); }

public int getRxLinkSpeedMbps() { throw new RuntimeException("Stub!"); }

public int getTimeSliceDutyCycleInPercent() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.WifiUsabilityStatsEntry.ContentionTimeStats getContentionTimeStats(int ac) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.net.wifi.WifiUsabilityStatsEntry.RateStats> getRateStats() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.net.wifi.WifiUsabilityStatsEntry.RadioStats> getWifiLinkLayerRadioStats() { throw new RuntimeException("Stub!"); }

public int getChannelUtilizationRatio() { throw new RuntimeException("Stub!"); }

public boolean isThroughputSufficient() { throw new RuntimeException("Stub!"); }

public boolean isWifiScoringEnabled() { throw new RuntimeException("Stub!"); }

public boolean isCellularDataAvailable() { throw new RuntimeException("Stub!"); }

public int getCellularDataNetworkType() { throw new RuntimeException("Stub!"); }

public int getCellularSignalStrengthDbm() { throw new RuntimeException("Stub!"); }

public int getCellularSignalStrengthDb() { throw new RuntimeException("Stub!"); }

public boolean isSameRegisteredCell() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.net.wifi.WifiUsabilityStatsEntry> CREATOR;
static { CREATOR = null; }

public static final int NUM_WME_ACCESS_CATEGORIES = 4; // 0x4

public static final int PROBE_STATUS_FAILURE = 3; // 0x3

public static final int PROBE_STATUS_NO_PROBE = 1; // 0x1

public static final int PROBE_STATUS_SUCCESS = 2; // 0x2

public static final int PROBE_STATUS_UNKNOWN = 0; // 0x0

public static final int WIFI_BANDWIDTH_10_MHZ = 6; // 0x6

public static final int WIFI_BANDWIDTH_160_MHZ = 3; // 0x3

public static final int WIFI_BANDWIDTH_20_MHZ = 0; // 0x0

public static final int WIFI_BANDWIDTH_40_MHZ = 1; // 0x1

public static final int WIFI_BANDWIDTH_5_MHZ = 5; // 0x5

public static final int WIFI_BANDWIDTH_80P80_MHZ = 4; // 0x4

public static final int WIFI_BANDWIDTH_80_MHZ = 2; // 0x2

public static final int WIFI_BANDWIDTH_INVALID = -1; // 0xffffffff

public static final int WIFI_PREAMBLE_CCK = 1; // 0x1

public static final int WIFI_PREAMBLE_HE = 5; // 0x5

public static final int WIFI_PREAMBLE_HT = 2; // 0x2

public static final int WIFI_PREAMBLE_INVALID = -1; // 0xffffffff

public static final int WIFI_PREAMBLE_OFDM = 0; // 0x0

public static final int WIFI_PREAMBLE_VHT = 3; // 0x3

public static final int WIFI_SPATIAL_STREAMS_FOUR = 4; // 0x4

public static final int WIFI_SPATIAL_STREAMS_INVALID = -1; // 0xffffffff

public static final int WIFI_SPATIAL_STREAMS_ONE = 1; // 0x1

public static final int WIFI_SPATIAL_STREAMS_THREE = 3; // 0x3

public static final int WIFI_SPATIAL_STREAMS_TWO = 2; // 0x2

public static final int WME_ACCESS_CATEGORY_BE = 0; // 0x0

public static final int WME_ACCESS_CATEGORY_BK = 1; // 0x1

public static final int WME_ACCESS_CATEGORY_VI = 2; // 0x2

public static final int WME_ACCESS_CATEGORY_VO = 3; // 0x3
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class ContentionTimeStats implements android.os.Parcelable {

public ContentionTimeStats(long timeMin, long timeMax, long timeAvg, long numSamples) { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

public long getContentionTimeMinMicros() { throw new RuntimeException("Stub!"); }

public long getContentionTimeMaxMicros() { throw new RuntimeException("Stub!"); }

public long getContentionTimeAvgMicros() { throw new RuntimeException("Stub!"); }

public long getContentionNumSamples() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.net.wifi.WifiUsabilityStatsEntry.ContentionTimeStats> CREATOR;
static { CREATOR = null; }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class RadioStats implements android.os.Parcelable {

public RadioStats(int radioId, long onTime, long txTime, long rxTime, long onTimeScan, long onTimeNanScan, long onTimeBackgroundScan, long onTimeRoamScan, long onTimePnoScan, long onTimeHs20Scan) { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

public long getRadioId() { throw new RuntimeException("Stub!"); }

public long getTotalRadioOnTimeMillis() { throw new RuntimeException("Stub!"); }

public long getTotalRadioTxTimeMillis() { throw new RuntimeException("Stub!"); }

public long getTotalRadioRxTimeMillis() { throw new RuntimeException("Stub!"); }

public long getTotalScanTimeMillis() { throw new RuntimeException("Stub!"); }

public long getTotalNanScanTimeMillis() { throw new RuntimeException("Stub!"); }

public long getTotalBackgroundScanTimeMillis() { throw new RuntimeException("Stub!"); }

public long getTotalRoamScanTimeMillis() { throw new RuntimeException("Stub!"); }

public long getTotalPnoScanTimeMillis() { throw new RuntimeException("Stub!"); }

public long getTotalHotspot2ScanTimeMillis() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.net.wifi.WifiUsabilityStatsEntry.RadioStats> CREATOR;
static { CREATOR = null; }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class RateStats implements android.os.Parcelable {

public RateStats(int preamble, int nss, int bw, int rateMcsIdx, int bitRateInKbps, int txMpdu, int rxMpdu, int mpduLost, int retries) { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

public int getPreamble() { throw new RuntimeException("Stub!"); }

public int getNumberOfSpatialStreams() { throw new RuntimeException("Stub!"); }

public int getBandwidthInMhz() { throw new RuntimeException("Stub!"); }

public int getRateMcsIdx() { throw new RuntimeException("Stub!"); }

public int getBitRateInKbps() { throw new RuntimeException("Stub!"); }

public int getTxMpdu() { throw new RuntimeException("Stub!"); }

public int getRxMpdu() { throw new RuntimeException("Stub!"); }

public int getMpduLost() { throw new RuntimeException("Stub!"); }

public int getRetries() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.net.wifi.WifiUsabilityStatsEntry.RateStats> CREATOR;
static { CREATOR = null; }
}

}

