/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.wifi;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class WifiNetworkSelectionConfig implements android.os.Parcelable {

WifiNetworkSelectionConfig() { throw new RuntimeException("Stub!"); }

public boolean isSufficiencyCheckEnabledWhenScreenOff() { throw new RuntimeException("Stub!"); }

public boolean isSufficiencyCheckEnabledWhenScreenOn() { throw new RuntimeException("Stub!"); }

public boolean isUserConnectChoiceOverrideEnabled() { throw new RuntimeException("Stub!"); }

public boolean isLastSelectionWeightEnabled() { throw new RuntimeException("Stub!"); }

public int getAssociatedNetworkSelectionOverride() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public int[] getRssiThresholds(int band) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.util.SparseArray<java.lang.Integer> getFrequencyWeights() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object obj) { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public static final int ASSOCIATED_NETWORK_SELECTION_OVERRIDE_DISABLED = 2; // 0x2

public static final int ASSOCIATED_NETWORK_SELECTION_OVERRIDE_ENABLED = 1; // 0x1

public static final int ASSOCIATED_NETWORK_SELECTION_OVERRIDE_NONE = 0; // 0x0

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.net.wifi.WifiNetworkSelectionConfig> CREATOR;
static { CREATOR = null; }

public static final int FREQUENCY_WEIGHT_HIGH = 1; // 0x1

public static final int FREQUENCY_WEIGHT_LOW = 0; // 0x0
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

public Builder(@android.annotation.NonNull android.net.wifi.WifiNetworkSelectionConfig config) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.WifiNetworkSelectionConfig.Builder setSufficiencyCheckEnabledWhenScreenOff(boolean enabled) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.WifiNetworkSelectionConfig.Builder setSufficiencyCheckEnabledWhenScreenOn(boolean enabled) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.WifiNetworkSelectionConfig.Builder setAssociatedNetworkSelectionOverride(int override) throws java.lang.IllegalArgumentException { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.WifiNetworkSelectionConfig.Builder setUserConnectChoiceOverrideEnabled(boolean enabled) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.WifiNetworkSelectionConfig.Builder setLastSelectionWeightEnabled(boolean enabled) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.WifiNetworkSelectionConfig.Builder setRssiThresholds(int band, @android.annotation.NonNull int[] thresholds) throws java.lang.IllegalArgumentException { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.WifiNetworkSelectionConfig.Builder setFrequencyWeights(@android.annotation.NonNull android.util.SparseArray<java.lang.Integer> weights) throws java.lang.IllegalArgumentException { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.WifiNetworkSelectionConfig build() { throw new RuntimeException("Stub!"); }
}

}

