/*
 * Copyright (C) 2012 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.wifi.p2p;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class WifiP2pWfdInfo implements android.os.Parcelable {

public WifiP2pWfdInfo() { throw new RuntimeException("Stub!"); }

public WifiP2pWfdInfo(@android.annotation.Nullable android.net.wifi.p2p.WifiP2pWfdInfo source) { throw new RuntimeException("Stub!"); }

public int getDeviceInfo() { throw new RuntimeException("Stub!"); }

public int getR2DeviceInfo() { throw new RuntimeException("Stub!"); }

public boolean isEnabled() { throw new RuntimeException("Stub!"); }

public boolean isR2Supported() { throw new RuntimeException("Stub!"); }

public void setEnabled(boolean enabled) { throw new RuntimeException("Stub!"); }

public boolean setR2DeviceType(int deviceType) { throw new RuntimeException("Stub!"); }

public int getDeviceType() { throw new RuntimeException("Stub!"); }

public int getR2DeviceType() { throw new RuntimeException("Stub!"); }

public boolean setDeviceType(int deviceType) { throw new RuntimeException("Stub!"); }

public boolean isSessionAvailable() { throw new RuntimeException("Stub!"); }

public void setSessionAvailable(boolean enabled) { throw new RuntimeException("Stub!"); }

public boolean isContentProtectionSupported() { throw new RuntimeException("Stub!"); }

public void setContentProtectionSupported(boolean enabled) { throw new RuntimeException("Stub!"); }

public boolean isCoupledSinkSupportedAtSource() { throw new RuntimeException("Stub!"); }

public void setCoupledSinkSupportAtSource(boolean enabled) { throw new RuntimeException("Stub!"); }

public boolean isCoupledSinkSupportedAtSink() { throw new RuntimeException("Stub!"); }

public void setCoupledSinkSupportAtSink(boolean enabled) { throw new RuntimeException("Stub!"); }

public int getControlPort() { throw new RuntimeException("Stub!"); }

public void setControlPort(int port) { throw new RuntimeException("Stub!"); }

public void setMaxThroughput(int maxThroughput) { throw new RuntimeException("Stub!"); }

public int getMaxThroughput() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.net.wifi.p2p.WifiP2pWfdInfo> CREATOR;
static { CREATOR = null; }

public static final int DEVICE_INFO_AUDIO_ONLY_SUPPORT_AT_SOURCE = 2048; // 0x800

public static final int DEVICE_INFO_AUDIO_UNSUPPORTED_AT_PRIMARY_SINK = 1024; // 0x400

public static final int DEVICE_INFO_CONTENT_PROTECTION_SUPPORT = 256; // 0x100

public static final int DEVICE_INFO_COUPLED_SINK_SUPPORT_AT_SINK = 8; // 0x8

public static final int DEVICE_INFO_COUPLED_SINK_SUPPORT_AT_SOURCE = 4; // 0x4

public static final int DEVICE_INFO_DEVICE_TYPE_MASK = 3; // 0x3

public static final int DEVICE_INFO_PREFERRED_CONNECTIVITY_MASK = 128; // 0x80

public static final int DEVICE_INFO_SESSION_AVAILABLE_MASK = 48; // 0x30

public static final int DEVICE_INFO_TDLS_PERSISTENT_GROUP = 4096; // 0x1000

public static final int DEVICE_INFO_TDLS_PERSISTENT_GROUP_REINVOKE = 8192; // 0x2000

public static final int DEVICE_INFO_TIME_SYNCHRONIZATION_SUPPORT = 512; // 0x200

public static final int DEVICE_INFO_WFD_SERVICE_DISCOVERY_SUPPORT = 64; // 0x40

public static final int DEVICE_TYPE_PRIMARY_SINK = 1; // 0x1

public static final int DEVICE_TYPE_SECONDARY_SINK = 2; // 0x2

public static final int DEVICE_TYPE_SOURCE_OR_PRIMARY_SINK = 3; // 0x3

public static final int DEVICE_TYPE_WFD_SOURCE = 0; // 0x0

public static final int PREFERRED_CONNECTIVITY_P2P = 0; // 0x0

public static final int PREFERRED_CONNECTIVITY_TDLS = 1; // 0x1
}

