/*
 * Copyright (C) 2019 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.wifi;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class SoftApConfiguration implements android.os.Parcelable {

SoftApConfiguration() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object otherObj) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

@Deprecated
@android.annotation.Nullable
public java.lang.String getSsid() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.net.wifi.WifiSsid getWifiSsid() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.net.wifi.ScanResult.InformationElement> getVendorElements() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.net.MacAddress getBssid() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getPassphrase() { throw new RuntimeException("Stub!"); }

public boolean isHiddenSsid() { throw new RuntimeException("Stub!"); }

@Deprecated
public int getBand() { throw new RuntimeException("Stub!"); }

@Deprecated
public int getChannel() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.util.SparseIntArray getChannels() { throw new RuntimeException("Stub!"); }

public int getSecurityType() { throw new RuntimeException("Stub!"); }

public int getMaxNumberOfClients() { throw new RuntimeException("Stub!"); }

public boolean isAutoShutdownEnabled() { throw new RuntimeException("Stub!"); }

public long getShutdownTimeoutMillis() { throw new RuntimeException("Stub!"); }

public boolean isClientControlByUserEnabled() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.net.MacAddress> getBlockedClientList() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.net.MacAddress> getAllowedClientList() { throw new RuntimeException("Stub!"); }

public int getMacRandomizationSetting() { throw new RuntimeException("Stub!"); }

public boolean isBridgedModeOpportunisticShutdownEnabled() { throw new RuntimeException("Stub!"); }

public boolean isIeee80211axEnabled() { throw new RuntimeException("Stub!"); }

public boolean isIeee80211beEnabled() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public int[] getAllowedAcsChannels(int band) { throw new RuntimeException("Stub!"); }

public int getMaxChannelBandwidth() { throw new RuntimeException("Stub!"); }

public boolean isUserConfiguration() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.MacAddress getPersistentRandomizedMacAddress() { throw new RuntimeException("Stub!"); }

public long getBridgedModeOpportunisticShutdownTimeoutMillis() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.net.wifi.OuiKeyedData> getVendorData() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.net.wifi.WifiConfiguration toWifiConfiguration() { throw new RuntimeException("Stub!"); }

public static final int BAND_2GHZ = 1; // 0x1

public static final int BAND_5GHZ = 2; // 0x2

public static final int BAND_60GHZ = 8; // 0x8

public static final int BAND_6GHZ = 4; // 0x4

@Deprecated public static final int BAND_ANY = 7; // 0x7

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.net.wifi.SoftApConfiguration> CREATOR;
static { CREATOR = null; }

public static final long DEFAULT_TIMEOUT = -1L; // 0xffffffffffffffffL

public static final int RANDOMIZATION_NONE = 0; // 0x0

public static final int RANDOMIZATION_NON_PERSISTENT = 2; // 0x2

public static final int RANDOMIZATION_PERSISTENT = 1; // 0x1

public static final int SECURITY_TYPE_OPEN = 0; // 0x0

public static final int SECURITY_TYPE_WPA2_PSK = 1; // 0x1

public static final int SECURITY_TYPE_WPA3_OWE = 5; // 0x5

public static final int SECURITY_TYPE_WPA3_OWE_TRANSITION = 4; // 0x4

public static final int SECURITY_TYPE_WPA3_SAE = 3; // 0x3

public static final int SECURITY_TYPE_WPA3_SAE_TRANSITION = 2; // 0x2
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

public Builder(@android.annotation.NonNull android.net.wifi.SoftApConfiguration other) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.SoftApConfiguration build() { throw new RuntimeException("Stub!"); }

@Deprecated
@android.annotation.NonNull
public android.net.wifi.SoftApConfiguration.Builder setSsid(@android.annotation.Nullable java.lang.String ssid) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.SoftApConfiguration.Builder setWifiSsid(@android.annotation.Nullable android.net.wifi.WifiSsid wifiSsid) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.SoftApConfiguration.Builder setVendorElements(@android.annotation.NonNull java.util.List<android.net.wifi.ScanResult.InformationElement> vendorElements) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.SoftApConfiguration.Builder setBssid(@android.annotation.Nullable android.net.MacAddress bssid) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.SoftApConfiguration.Builder setPassphrase(@android.annotation.Nullable java.lang.String passphrase, int securityType) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.SoftApConfiguration.Builder setHiddenSsid(boolean hiddenSsid) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.SoftApConfiguration.Builder setBand(int band) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.SoftApConfiguration.Builder setBands(@android.annotation.NonNull int[] bands) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.SoftApConfiguration.Builder setChannel(int channel, int band) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.SoftApConfiguration.Builder setChannels(@android.annotation.NonNull android.util.SparseIntArray channels) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.SoftApConfiguration.Builder setMaxNumberOfClients(int maxNumberOfClients) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.SoftApConfiguration.Builder setAutoShutdownEnabled(boolean enable) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.SoftApConfiguration.Builder setShutdownTimeoutMillis(long timeoutMillis) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.SoftApConfiguration.Builder setClientControlByUserEnabled(boolean enabled) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.SoftApConfiguration.Builder setAllowedAcsChannels(int band, @android.annotation.NonNull int[] channels) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.SoftApConfiguration.Builder setMaxChannelBandwidth(int maxChannelBandwidth) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.SoftApConfiguration.Builder setAllowedClientList(@android.annotation.NonNull java.util.List<android.net.MacAddress> allowedClientList) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.SoftApConfiguration.Builder setBlockedClientList(@android.annotation.NonNull java.util.List<android.net.MacAddress> blockedClientList) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.SoftApConfiguration.Builder setMacRandomizationSetting(int macRandomizationSetting) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.SoftApConfiguration.Builder setBridgedModeOpportunisticShutdownEnabled(boolean enable) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.SoftApConfiguration.Builder setIeee80211axEnabled(boolean enable) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.SoftApConfiguration.Builder setIeee80211beEnabled(boolean enable) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.SoftApConfiguration.Builder setBridgedModeOpportunisticShutdownTimeoutMillis(long timeoutMillis) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.SoftApConfiguration.Builder setVendorData(@android.annotation.NonNull java.util.List<android.net.wifi.OuiKeyedData> vendorData) { throw new RuntimeException("Stub!"); }
}

}

