/*
 * Copyright (C) 2008 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.wifi;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class WifiScanner {

WifiScanner() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<java.lang.Integer> getAvailableChannels(int band) { throw new RuntimeException("Stub!"); }

public void setScanningEnabled(boolean enable) { throw new RuntimeException("Stub!"); }

public void registerScanListener(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.net.wifi.WifiScanner.ScanListener listener) { throw new RuntimeException("Stub!"); }

public void unregisterScanListener(@android.annotation.NonNull android.net.wifi.WifiScanner.ScanListener listener) { throw new RuntimeException("Stub!"); }

public boolean isScanning() { throw new RuntimeException("Stub!"); }

public void startBackgroundScan(android.net.wifi.WifiScanner.ScanSettings settings, android.net.wifi.WifiScanner.ScanListener listener) { throw new RuntimeException("Stub!"); }

@Deprecated
public void startBackgroundScan(android.net.wifi.WifiScanner.ScanSettings settings, android.net.wifi.WifiScanner.ScanListener listener, android.os.WorkSource workSource) { throw new RuntimeException("Stub!"); }

@Deprecated
public void stopBackgroundScan(android.net.wifi.WifiScanner.ScanListener listener) { throw new RuntimeException("Stub!"); }

@Deprecated
public boolean getScanResults() { throw new RuntimeException("Stub!"); }

public void startScan(android.net.wifi.WifiScanner.ScanSettings settings, android.net.wifi.WifiScanner.ScanListener listener) { throw new RuntimeException("Stub!"); }

public void startScan(android.net.wifi.WifiScanner.ScanSettings settings, android.net.wifi.WifiScanner.ScanListener listener, android.os.WorkSource workSource) { throw new RuntimeException("Stub!"); }

public void stopScan(android.net.wifi.WifiScanner.ScanListener listener) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.net.wifi.ScanResult> getSingleScanResults() { throw new RuntimeException("Stub!"); }

public void getCachedScanData(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull java.util.function.Consumer<android.net.wifi.WifiScanner.ScanData> resultsCallback) { throw new RuntimeException("Stub!"); }

@Deprecated
public void configureWifiChange(int rssiSampleSize, int lostApSampleSize, int unchangedSampleSize, int minApsBreachingThreshold, int periodInMs, android.net.wifi.WifiScanner.BssidInfo[] bssidInfos) { throw new RuntimeException("Stub!"); }

@Deprecated
public void startTrackingWifiChange(android.net.wifi.WifiScanner.WifiChangeListener listener) { throw new RuntimeException("Stub!"); }

@Deprecated
public void stopTrackingWifiChange(android.net.wifi.WifiScanner.WifiChangeListener listener) { throw new RuntimeException("Stub!"); }

@Deprecated
public void configureWifiChange(android.net.wifi.WifiScanner.WifiChangeSettings settings) { throw new RuntimeException("Stub!"); }

@Deprecated
public void startTrackingBssids(android.net.wifi.WifiScanner.BssidInfo[] bssidInfos, int apLostThreshold, android.net.wifi.WifiScanner.BssidListener listener) { throw new RuntimeException("Stub!"); }

@Deprecated
public void stopTrackingBssids(android.net.wifi.WifiScanner.BssidListener listener) { throw new RuntimeException("Stub!"); }

public static final int MAX_SCAN_PERIOD_MS = 1024000; // 0xfa000

public static final int MIN_SCAN_PERIOD_MS = 1000; // 0x3e8

public static final int REASON_ABORT = -7; // 0xfffffff9

public static final int REASON_BUSY = -6; // 0xfffffffa

public static final int REASON_DUPLICATE_REQEUST = -5; // 0xfffffffb

public static final int REASON_INVALID_ARGS = -9; // 0xfffffff7

public static final int REASON_INVALID_LISTENER = -2; // 0xfffffffe

public static final int REASON_INVALID_REQUEST = -3; // 0xfffffffd

public static final int REASON_NOT_AUTHORIZED = -4; // 0xfffffffc

public static final int REASON_NO_DEVICE = -8; // 0xfffffff8

public static final int REASON_SUCCEEDED = 0; // 0x0

public static final int REASON_TIMEOUT = -10; // 0xfffffff6

public static final int REASON_UNSPECIFIED = -1; // 0xffffffff

@Deprecated public static final int REPORT_EVENT_AFTER_BUFFER_FULL = 0; // 0x0

public static final int REPORT_EVENT_AFTER_EACH_SCAN = 1; // 0x1

public static final int REPORT_EVENT_FULL_SCAN_RESULT = 2; // 0x2

public static final int REPORT_EVENT_NO_BATCH = 4; // 0x4

public static final int SCAN_TYPE_HIGH_ACCURACY = 2; // 0x2

public static final int SCAN_TYPE_LOW_LATENCY = 0; // 0x0

public static final int SCAN_TYPE_LOW_POWER = 1; // 0x1

public static final int WIFI_BAND_24_5_6_GHZ = 11; // 0xb

public static final int WIFI_BAND_24_5_WITH_DFS_6_GHZ = 15; // 0xf

public static final int WIFI_BAND_24_GHZ = 1; // 0x1

public static final int WIFI_BAND_5_GHZ = 2; // 0x2

public static final int WIFI_BAND_5_GHZ_DFS_ONLY = 4; // 0x4

public static final int WIFI_BAND_5_GHZ_WITH_DFS = 6; // 0x6

public static final int WIFI_BAND_60_GHZ = 16; // 0x10

public static final int WIFI_BAND_6_GHZ = 8; // 0x8

public static final int WIFI_BAND_BOTH = 3; // 0x3

public static final int WIFI_BAND_BOTH_WITH_DFS = 7; // 0x7

public static final int WIFI_BAND_UNSPECIFIED = 0; // 0x0

public static final int WIFI_RNR_ENABLED = 1; // 0x1

public static final int WIFI_RNR_ENABLED_IF_WIFI_BAND_6_GHZ_SCANNED = 0; // 0x0

public static final int WIFI_RNR_NOT_NEEDED = 2; // 0x2
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface ActionListener {

public void onSuccess();

public void onFailure(int reason, java.lang.String description);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
@Deprecated
public static class BssidInfo {

@Deprecated
public BssidInfo() { throw new RuntimeException("Stub!"); }

@Deprecated public java.lang.String bssid;

@Deprecated public int frequencyHint;

@Deprecated public int high;

@Deprecated public int low;
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
@Deprecated
public static interface BssidListener extends android.net.wifi.WifiScanner.ActionListener {

@Deprecated
public void onFound(android.net.wifi.ScanResult[] results);

@Deprecated
public void onLost(android.net.wifi.ScanResult[] results);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class ChannelSpec {

public ChannelSpec(int frequency) { throw new RuntimeException("Stub!"); }

public int frequency;
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
@Deprecated
public static class HotlistSettings implements android.os.Parcelable {

@Deprecated
public HotlistSettings() { throw new RuntimeException("Stub!"); }

@Deprecated
public int describeContents() { throw new RuntimeException("Stub!"); }

@Deprecated
public void writeToParcel(android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@Deprecated public int apLostThreshold;

@Deprecated public android.net.wifi.WifiScanner.BssidInfo[] bssidInfos;
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class ParcelableScanData implements android.os.Parcelable {

public ParcelableScanData(android.net.wifi.WifiScanner.ScanData[] results) { throw new RuntimeException("Stub!"); }

public android.net.wifi.WifiScanner.ScanData[] getResults() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public void writeToParcel(android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

public android.net.wifi.WifiScanner.ScanData[] mResults;
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class ParcelableScanResults implements android.os.Parcelable {

public ParcelableScanResults(android.net.wifi.ScanResult[] results) { throw new RuntimeException("Stub!"); }

public android.net.wifi.ScanResult[] getResults() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public void writeToParcel(android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

public android.net.wifi.ScanResult[] mResults;
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class ScanData implements android.os.Parcelable {

public ScanData(int id, int flags, android.net.wifi.ScanResult[] results) { throw new RuntimeException("Stub!"); }

public ScanData(android.net.wifi.WifiScanner.ScanData s) { throw new RuntimeException("Stub!"); }

public int getId() { throw new RuntimeException("Stub!"); }

public int getFlags() { throw new RuntimeException("Stub!"); }

public int getScannedBands() { throw new RuntimeException("Stub!"); }

public android.net.wifi.ScanResult[] getResults() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public void writeToParcel(android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface ScanListener extends android.net.wifi.WifiScanner.ActionListener {

@Deprecated
public void onPeriodChanged(int periodInMs);

public void onResults(android.net.wifi.WifiScanner.ScanData[] results);

public void onFullResult(android.net.wifi.ScanResult fullScanResult);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class ScanSettings implements android.os.Parcelable {

public ScanSettings() { throw new RuntimeException("Stub!"); }

public void set6GhzPscOnlyEnabled(boolean enable) { throw new RuntimeException("Stub!"); }

public boolean is6GhzPscOnlyEnabled() { throw new RuntimeException("Stub!"); }

public void setRnrSetting(int rnrSetting) { throw new RuntimeException("Stub!"); }

public int getRnrSetting() { throw new RuntimeException("Stub!"); }

public void setVendorIes(@android.annotation.NonNull java.util.List<android.net.wifi.ScanResult.InformationElement> vendorIes) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.net.wifi.ScanResult.InformationElement> getVendorIes() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public void writeToParcel(android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.net.wifi.WifiScanner.ScanSettings> CREATOR;
static { CREATOR = null; }

public int band;

public android.net.wifi.WifiScanner.ChannelSpec[] channels;

@android.annotation.NonNull public final java.util.List<android.net.wifi.WifiScanner.ScanSettings.HiddenNetwork> hiddenNetworks;
{ hiddenNetworks = null; }

public boolean hideFromAppOps;

public boolean ignoreLocationSettings;

@Deprecated public int maxPeriodInMs;

@Deprecated public int maxScansToCache;

@Deprecated public int numBssidsPerScan;

@Deprecated public int periodInMs;

@Deprecated public int reportEvents;

@Deprecated public int stepCount;

public int type = 0; // 0x0
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class HiddenNetwork {

public HiddenNetwork(@android.annotation.NonNull java.lang.String ssid) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public final java.lang.String ssid;
{ ssid = null; }
}

}

@SuppressWarnings({"unchecked", "deprecation", "all"})
@Deprecated
public static interface WifiChangeListener extends android.net.wifi.WifiScanner.ActionListener {

@Deprecated
public void onChanging(android.net.wifi.ScanResult[] results);

@Deprecated
public void onQuiescence(android.net.wifi.ScanResult[] results);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
@Deprecated
public static class WifiChangeSettings implements android.os.Parcelable {

@Deprecated
public WifiChangeSettings() { throw new RuntimeException("Stub!"); }

@Deprecated
public int describeContents() { throw new RuntimeException("Stub!"); }

@Deprecated
public void writeToParcel(android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@Deprecated public android.net.wifi.WifiScanner.BssidInfo[] bssidInfos;

@Deprecated public int lostApSampleSize;

@Deprecated public int minApsBreachingThreshold;

@Deprecated public int periodInMs;

@Deprecated public int rssiSampleSize;

@Deprecated public int unchangedSampleSize;
}

}

