/*
 * Copyright (C) 2017 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.wifi.hotspot2;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract class ProvisioningCallback {

public ProvisioningCallback() { throw new RuntimeException("Stub!"); }

public abstract void onProvisioningFailure(int status);

public abstract void onProvisioningStatus(int status);

public abstract void onProvisioningComplete();

public static final int OSU_FAILURE_ADD_PASSPOINT_CONFIGURATION = 22; // 0x16

public static final int OSU_FAILURE_AP_CONNECTION = 1; // 0x1

public static final int OSU_FAILURE_INVALID_URL_FORMAT_FOR_OSU = 8; // 0x8

public static final int OSU_FAILURE_NO_AAA_SERVER_TRUST_ROOT_NODE = 17; // 0x11

public static final int OSU_FAILURE_NO_AAA_TRUST_ROOT_CERTIFICATE = 21; // 0x15

public static final int OSU_FAILURE_NO_OSU_ACTIVITY_FOUND = 14; // 0xe

public static final int OSU_FAILURE_NO_POLICY_SERVER_TRUST_ROOT_NODE = 19; // 0x13

public static final int OSU_FAILURE_NO_PPS_MO = 16; // 0x10

public static final int OSU_FAILURE_NO_REMEDIATION_SERVER_TRUST_ROOT_NODE = 18; // 0x12

public static final int OSU_FAILURE_OSU_PROVIDER_NOT_FOUND = 23; // 0x17

public static final int OSU_FAILURE_PROVISIONING_ABORTED = 6; // 0x6

public static final int OSU_FAILURE_PROVISIONING_NOT_AVAILABLE = 7; // 0x7

public static final int OSU_FAILURE_RETRIEVE_TRUST_ROOT_CERTIFICATES = 20; // 0x14

public static final int OSU_FAILURE_SERVER_CONNECTION = 3; // 0x3

public static final int OSU_FAILURE_SERVER_URL_INVALID = 2; // 0x2

public static final int OSU_FAILURE_SERVER_VALIDATION = 4; // 0x4

public static final int OSU_FAILURE_SERVICE_PROVIDER_VERIFICATION = 5; // 0x5

public static final int OSU_FAILURE_SOAP_MESSAGE_EXCHANGE = 11; // 0xb

public static final int OSU_FAILURE_START_REDIRECT_LISTENER = 12; // 0xc

public static final int OSU_FAILURE_TIMED_OUT_REDIRECT_LISTENER = 13; // 0xd

public static final int OSU_FAILURE_UNEXPECTED_COMMAND_TYPE = 9; // 0x9

public static final int OSU_FAILURE_UNEXPECTED_SOAP_MESSAGE_STATUS = 15; // 0xf

public static final int OSU_FAILURE_UNEXPECTED_SOAP_MESSAGE_TYPE = 10; // 0xa

public static final int OSU_STATUS_AP_CONNECTED = 2; // 0x2

public static final int OSU_STATUS_AP_CONNECTING = 1; // 0x1

public static final int OSU_STATUS_INIT_SOAP_EXCHANGE = 6; // 0x6

public static final int OSU_STATUS_REDIRECT_RESPONSE_RECEIVED = 8; // 0x8

public static final int OSU_STATUS_RETRIEVING_TRUST_ROOT_CERTS = 11; // 0xb

public static final int OSU_STATUS_SECOND_SOAP_EXCHANGE = 9; // 0x9

public static final int OSU_STATUS_SERVER_CONNECTED = 5; // 0x5

public static final int OSU_STATUS_SERVER_CONNECTING = 3; // 0x3

public static final int OSU_STATUS_SERVER_VALIDATED = 4; // 0x4

public static final int OSU_STATUS_THIRD_SOAP_EXCHANGE = 10; // 0xa

public static final int OSU_STATUS_WAITING_FOR_REDIRECT_RESPONSE = 7; // 0x7
}

