/*
 * Copyright (C) 2011 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.wifi.p2p;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class WifiP2pManager {

WifiP2pManager() { throw new RuntimeException("Stub!"); }

public void registerWifiP2pListener(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.net.wifi.p2p.WifiP2pManager.WifiP2pListener listener) { throw new RuntimeException("Stub!"); }

public void unregisterWifiP2pListener(@android.annotation.NonNull android.net.wifi.p2p.WifiP2pManager.WifiP2pListener listener) { throw new RuntimeException("Stub!"); }

public android.net.wifi.p2p.WifiP2pManager.Channel initialize(android.content.Context srcContext, android.os.Looper srcLooper, android.net.wifi.p2p.WifiP2pManager.ChannelListener listener) { throw new RuntimeException("Stub!"); }

public void discoverPeers(android.net.wifi.p2p.WifiP2pManager.Channel channel, android.net.wifi.p2p.WifiP2pManager.ActionListener listener) { throw new RuntimeException("Stub!"); }

public void discoverPeersOnSocialChannels(@android.annotation.NonNull android.net.wifi.p2p.WifiP2pManager.Channel channel, @android.annotation.Nullable android.net.wifi.p2p.WifiP2pManager.ActionListener listener) { throw new RuntimeException("Stub!"); }

public void discoverPeersOnSpecificFrequency(@android.annotation.NonNull android.net.wifi.p2p.WifiP2pManager.Channel channel, int frequencyMhz, @android.annotation.Nullable android.net.wifi.p2p.WifiP2pManager.ActionListener listener) { throw new RuntimeException("Stub!"); }

public void startPeerDiscovery(@android.annotation.NonNull android.net.wifi.p2p.WifiP2pManager.Channel channel, @android.annotation.NonNull android.net.wifi.p2p.WifiP2pDiscoveryConfig config, @android.annotation.Nullable android.net.wifi.p2p.WifiP2pManager.ActionListener listener) { throw new RuntimeException("Stub!"); }

public void stopPeerDiscovery(android.net.wifi.p2p.WifiP2pManager.Channel channel, android.net.wifi.p2p.WifiP2pManager.ActionListener listener) { throw new RuntimeException("Stub!"); }

public void connect(android.net.wifi.p2p.WifiP2pManager.Channel channel, android.net.wifi.p2p.WifiP2pConfig config, android.net.wifi.p2p.WifiP2pManager.ActionListener listener) { throw new RuntimeException("Stub!"); }

public void cancelConnect(android.net.wifi.p2p.WifiP2pManager.Channel channel, android.net.wifi.p2p.WifiP2pManager.ActionListener listener) { throw new RuntimeException("Stub!"); }

public void createGroup(android.net.wifi.p2p.WifiP2pManager.Channel channel, android.net.wifi.p2p.WifiP2pManager.ActionListener listener) { throw new RuntimeException("Stub!"); }

public void createGroup(@android.annotation.NonNull android.net.wifi.p2p.WifiP2pManager.Channel channel, @android.annotation.Nullable android.net.wifi.p2p.WifiP2pConfig config, @android.annotation.Nullable android.net.wifi.p2p.WifiP2pManager.ActionListener listener) { throw new RuntimeException("Stub!"); }

public void removeGroup(android.net.wifi.p2p.WifiP2pManager.Channel channel, android.net.wifi.p2p.WifiP2pManager.ActionListener listener) { throw new RuntimeException("Stub!"); }

public void startListening(@android.annotation.NonNull android.net.wifi.p2p.WifiP2pManager.Channel channel, @android.annotation.Nullable android.net.wifi.p2p.WifiP2pManager.ActionListener listener) { throw new RuntimeException("Stub!"); }

public void startListening(@android.annotation.NonNull android.net.wifi.p2p.WifiP2pManager.Channel channel, @android.annotation.NonNull android.net.wifi.p2p.WifiP2pExtListenParams params, @android.annotation.Nullable android.net.wifi.p2p.WifiP2pManager.ActionListener listener) { throw new RuntimeException("Stub!"); }

public void stopListening(@android.annotation.NonNull android.net.wifi.p2p.WifiP2pManager.Channel channel, @android.annotation.Nullable android.net.wifi.p2p.WifiP2pManager.ActionListener listener) { throw new RuntimeException("Stub!"); }

public void setWifiP2pChannels(@android.annotation.NonNull android.net.wifi.p2p.WifiP2pManager.Channel channel, int listeningChannel, int operatingChannel, @android.annotation.Nullable android.net.wifi.p2p.WifiP2pManager.ActionListener listener) { throw new RuntimeException("Stub!"); }

public void addLocalService(android.net.wifi.p2p.WifiP2pManager.Channel channel, android.net.wifi.p2p.nsd.WifiP2pServiceInfo servInfo, android.net.wifi.p2p.WifiP2pManager.ActionListener listener) { throw new RuntimeException("Stub!"); }

public void removeLocalService(android.net.wifi.p2p.WifiP2pManager.Channel channel, android.net.wifi.p2p.nsd.WifiP2pServiceInfo servInfo, android.net.wifi.p2p.WifiP2pManager.ActionListener listener) { throw new RuntimeException("Stub!"); }

public void clearLocalServices(android.net.wifi.p2p.WifiP2pManager.Channel channel, android.net.wifi.p2p.WifiP2pManager.ActionListener listener) { throw new RuntimeException("Stub!"); }

public void setServiceResponseListener(android.net.wifi.p2p.WifiP2pManager.Channel channel, android.net.wifi.p2p.WifiP2pManager.ServiceResponseListener listener) { throw new RuntimeException("Stub!"); }

public void setDnsSdResponseListeners(android.net.wifi.p2p.WifiP2pManager.Channel channel, android.net.wifi.p2p.WifiP2pManager.DnsSdServiceResponseListener servListener, android.net.wifi.p2p.WifiP2pManager.DnsSdTxtRecordListener txtListener) { throw new RuntimeException("Stub!"); }

public void setUpnpServiceResponseListener(android.net.wifi.p2p.WifiP2pManager.Channel channel, android.net.wifi.p2p.WifiP2pManager.UpnpServiceResponseListener listener) { throw new RuntimeException("Stub!"); }

public void discoverServices(android.net.wifi.p2p.WifiP2pManager.Channel channel, android.net.wifi.p2p.WifiP2pManager.ActionListener listener) { throw new RuntimeException("Stub!"); }

public void addServiceRequest(android.net.wifi.p2p.WifiP2pManager.Channel channel, android.net.wifi.p2p.nsd.WifiP2pServiceRequest req, android.net.wifi.p2p.WifiP2pManager.ActionListener listener) { throw new RuntimeException("Stub!"); }

public void removeServiceRequest(android.net.wifi.p2p.WifiP2pManager.Channel channel, android.net.wifi.p2p.nsd.WifiP2pServiceRequest req, android.net.wifi.p2p.WifiP2pManager.ActionListener listener) { throw new RuntimeException("Stub!"); }

public void clearServiceRequests(android.net.wifi.p2p.WifiP2pManager.Channel channel, android.net.wifi.p2p.WifiP2pManager.ActionListener listener) { throw new RuntimeException("Stub!"); }

public void requestPeers(android.net.wifi.p2p.WifiP2pManager.Channel channel, android.net.wifi.p2p.WifiP2pManager.PeerListListener listener) { throw new RuntimeException("Stub!"); }

public void requestConnectionInfo(android.net.wifi.p2p.WifiP2pManager.Channel channel, android.net.wifi.p2p.WifiP2pManager.ConnectionInfoListener listener) { throw new RuntimeException("Stub!"); }

public void requestGroupInfo(android.net.wifi.p2p.WifiP2pManager.Channel channel, android.net.wifi.p2p.WifiP2pManager.GroupInfoListener listener) { throw new RuntimeException("Stub!"); }

public void setDeviceName(@android.annotation.NonNull android.net.wifi.p2p.WifiP2pManager.Channel channel, @android.annotation.NonNull java.lang.String devName, @android.annotation.Nullable android.net.wifi.p2p.WifiP2pManager.ActionListener listener) { throw new RuntimeException("Stub!"); }

public void setWfdInfo(@android.annotation.NonNull android.net.wifi.p2p.WifiP2pManager.Channel channel, @android.annotation.NonNull android.net.wifi.p2p.WifiP2pWfdInfo wfdInfo, @android.annotation.Nullable android.net.wifi.p2p.WifiP2pManager.ActionListener listener) { throw new RuntimeException("Stub!"); }

public void removeClient(@android.annotation.NonNull android.net.wifi.p2p.WifiP2pManager.Channel channel, @android.annotation.NonNull android.net.MacAddress peerAddress, @android.annotation.Nullable android.net.wifi.p2p.WifiP2pManager.ActionListener listener) { throw new RuntimeException("Stub!"); }

public void deletePersistentGroup(@android.annotation.NonNull android.net.wifi.p2p.WifiP2pManager.Channel channel, int netId, @android.annotation.Nullable android.net.wifi.p2p.WifiP2pManager.ActionListener listener) { throw new RuntimeException("Stub!"); }

public void requestPersistentGroupInfo(@android.annotation.NonNull android.net.wifi.p2p.WifiP2pManager.Channel channel, @android.annotation.Nullable android.net.wifi.p2p.WifiP2pManager.PersistentGroupInfoListener listener) { throw new RuntimeException("Stub!"); }

public void setMiracastMode(int mode) { throw new RuntimeException("Stub!"); }

public boolean isSetVendorElementsSupported() { throw new RuntimeException("Stub!"); }

public boolean isChannelConstrainedDiscoverySupported() { throw new RuntimeException("Stub!"); }

public boolean isGroupClientRemovalSupported() { throw new RuntimeException("Stub!"); }

public boolean isGroupOwnerIPv6LinkLocalAddressProvided() { throw new RuntimeException("Stub!"); }

public void factoryReset(@android.annotation.NonNull android.net.wifi.p2p.WifiP2pManager.Channel c, @android.annotation.Nullable android.net.wifi.p2p.WifiP2pManager.ActionListener listener) { throw new RuntimeException("Stub!"); }

public void requestP2pState(@android.annotation.NonNull android.net.wifi.p2p.WifiP2pManager.Channel c, @android.annotation.NonNull android.net.wifi.p2p.WifiP2pManager.P2pStateListener listener) { throw new RuntimeException("Stub!"); }

public void requestDiscoveryState(@android.annotation.NonNull android.net.wifi.p2p.WifiP2pManager.Channel c, @android.annotation.NonNull android.net.wifi.p2p.WifiP2pManager.DiscoveryStateListener listener) { throw new RuntimeException("Stub!"); }

public void getListenState(@android.annotation.NonNull android.net.wifi.p2p.WifiP2pManager.Channel c, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull java.util.function.Consumer<java.lang.Integer> resultsCallback) { throw new RuntimeException("Stub!"); }

public void requestNetworkInfo(@android.annotation.NonNull android.net.wifi.p2p.WifiP2pManager.Channel c, @android.annotation.NonNull android.net.wifi.p2p.WifiP2pManager.NetworkInfoListener listener) { throw new RuntimeException("Stub!"); }

public void requestDeviceInfo(@android.annotation.NonNull android.net.wifi.p2p.WifiP2pManager.Channel c, @android.annotation.NonNull android.net.wifi.p2p.WifiP2pManager.DeviceInfoListener listener) { throw new RuntimeException("Stub!"); }

public void addExternalApprover(@android.annotation.NonNull android.net.wifi.p2p.WifiP2pManager.Channel c, @android.annotation.NonNull android.net.MacAddress deviceAddress, @android.annotation.NonNull android.net.wifi.p2p.WifiP2pManager.ExternalApproverRequestListener listener) { throw new RuntimeException("Stub!"); }

public void removeExternalApprover(@android.annotation.NonNull android.net.wifi.p2p.WifiP2pManager.Channel c, @android.annotation.NonNull android.net.MacAddress deviceAddress, @android.annotation.Nullable android.net.wifi.p2p.WifiP2pManager.ActionListener listener) { throw new RuntimeException("Stub!"); }

public void setConnectionRequestResult(@android.annotation.NonNull android.net.wifi.p2p.WifiP2pManager.Channel c, @android.annotation.NonNull android.net.MacAddress deviceAddress, int result, @android.annotation.Nullable android.net.wifi.p2p.WifiP2pManager.ActionListener listener) { throw new RuntimeException("Stub!"); }

public void setConnectionRequestResult(@android.annotation.NonNull android.net.wifi.p2p.WifiP2pManager.Channel c, @android.annotation.NonNull android.net.MacAddress deviceAddress, int result, @android.annotation.Nullable java.lang.String pin, @android.annotation.Nullable android.net.wifi.p2p.WifiP2pManager.ActionListener listener) { throw new RuntimeException("Stub!"); }

public void setVendorElements(@android.annotation.NonNull android.net.wifi.p2p.WifiP2pManager.Channel c, @android.annotation.NonNull java.util.List<android.net.wifi.ScanResult.InformationElement> vendorElements, @android.annotation.Nullable android.net.wifi.p2p.WifiP2pManager.ActionListener listener) { throw new RuntimeException("Stub!"); }

public static int getP2pMaxAllowedVendorElementsLengthBytes() { throw new RuntimeException("Stub!"); }

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_WIFI_P2P_LISTEN_STATE_CHANGED = "android.net.wifi.p2p.action.WIFI_P2P_LISTEN_STATE_CHANGED";

public static final java.lang.String ACTION_WIFI_P2P_PERSISTENT_GROUPS_CHANGED = "android.net.wifi.p2p.action.WIFI_P2P_PERSISTENT_GROUPS_CHANGED";

public static final java.lang.String ACTION_WIFI_P2P_REQUEST_RESPONSE_CHANGED = "android.net.wifi.p2p.action.WIFI_P2P_REQUEST_RESPONSE_CHANGED";

public static final int BUSY = 2; // 0x2

public static final int CONNECTION_REQUEST_ACCEPT = 0; // 0x0

public static final int CONNECTION_REQUEST_DEFER_SHOW_PIN_TO_SERVICE = 3; // 0x3

public static final int CONNECTION_REQUEST_DEFER_TO_SERVICE = 2; // 0x2

public static final int CONNECTION_REQUEST_REJECT = 1; // 0x1

public static final int ERROR = 0; // 0x0

public static final java.lang.String EXTRA_DISCOVERY_STATE = "discoveryState";

public static final java.lang.String EXTRA_LISTEN_STATE = "android.net.wifi.p2p.extra.LISTEN_STATE";

public static final java.lang.String EXTRA_NETWORK_INFO = "networkInfo";

public static final java.lang.String EXTRA_P2P_DEVICE_LIST = "wifiP2pDeviceList";

public static final java.lang.String EXTRA_REQUEST_CONFIG = "android.net.wifi.p2p.extra.REQUEST_CONFIG";

public static final java.lang.String EXTRA_REQUEST_RESPONSE = "android.net.wifi.p2p.extra.REQUEST_RESPONSE";

public static final java.lang.String EXTRA_WIFI_P2P_DEVICE = "wifiP2pDevice";

public static final java.lang.String EXTRA_WIFI_P2P_GROUP = "p2pGroupInfo";

public static final java.lang.String EXTRA_WIFI_P2P_INFO = "wifiP2pInfo";

public static final java.lang.String EXTRA_WIFI_STATE = "wifi_p2p_state";

public static final int GROUP_CREATION_FAILURE_REASON_CONNECTION_CANCELLED = 0; // 0x0

public static final int GROUP_CREATION_FAILURE_REASON_GROUP_REMOVED = 4; // 0x4

public static final int GROUP_CREATION_FAILURE_REASON_INVITATION_FAILED = 5; // 0x5

public static final int GROUP_CREATION_FAILURE_REASON_PROVISION_DISCOVERY_FAILED = 3; // 0x3

public static final int GROUP_CREATION_FAILURE_REASON_TIMED_OUT = 1; // 0x1

public static final int GROUP_CREATION_FAILURE_REASON_USER_REJECTED = 2; // 0x2

public static final int MIRACAST_DISABLED = 0; // 0x0

public static final int MIRACAST_SINK = 2; // 0x2

public static final int MIRACAST_SOURCE = 1; // 0x1

public static final int NO_SERVICE_REQUESTS = 3; // 0x3

public static final int P2P_UNSUPPORTED = 1; // 0x1

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String WIFI_P2P_CONNECTION_CHANGED_ACTION = "android.net.wifi.p2p.CONNECTION_STATE_CHANGE";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String WIFI_P2P_DISCOVERY_CHANGED_ACTION = "android.net.wifi.p2p.DISCOVERY_STATE_CHANGE";

public static final int WIFI_P2P_DISCOVERY_STARTED = 2; // 0x2

public static final int WIFI_P2P_DISCOVERY_STOPPED = 1; // 0x1

public static final int WIFI_P2P_LISTEN_STARTED = 2; // 0x2

public static final int WIFI_P2P_LISTEN_STOPPED = 1; // 0x1

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String WIFI_P2P_PEERS_CHANGED_ACTION = "android.net.wifi.p2p.PEERS_CHANGED";

public static final int WIFI_P2P_SCAN_FULL = 0; // 0x0

public static final int WIFI_P2P_SCAN_SINGLE_FREQ = 2; // 0x2

public static final int WIFI_P2P_SCAN_SOCIAL = 1; // 0x1

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String WIFI_P2P_STATE_CHANGED_ACTION = "android.net.wifi.p2p.STATE_CHANGED";

public static final int WIFI_P2P_STATE_DISABLED = 1; // 0x1

public static final int WIFI_P2P_STATE_ENABLED = 2; // 0x2

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String WIFI_P2P_THIS_DEVICE_CHANGED_ACTION = "android.net.wifi.p2p.THIS_DEVICE_CHANGED";
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface ActionListener {

public void onSuccess();

public void onFailure(int reason);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class Channel implements java.lang.AutoCloseable {

Channel() { throw new RuntimeException("Stub!"); }

public void close() { throw new RuntimeException("Stub!"); }

protected void finalize() throws java.lang.Throwable { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface ChannelListener {

public void onChannelDisconnected();
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface ConnectionInfoListener {

public void onConnectionInfoAvailable(android.net.wifi.p2p.WifiP2pInfo info);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface DeviceInfoListener {

public void onDeviceInfoAvailable(@android.annotation.Nullable android.net.wifi.p2p.WifiP2pDevice wifiP2pDevice);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface DiscoveryStateListener {

public void onDiscoveryStateAvailable(int state);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface DnsSdServiceResponseListener {

public void onDnsSdServiceAvailable(java.lang.String instanceName, java.lang.String registrationType, android.net.wifi.p2p.WifiP2pDevice srcDevice);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface DnsSdTxtRecordListener {

public void onDnsSdTxtRecordAvailable(java.lang.String fullDomainName, java.util.Map<java.lang.String,java.lang.String> txtRecordMap, android.net.wifi.p2p.WifiP2pDevice srcDevice);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface ExternalApproverRequestListener {

public void onAttached(@android.annotation.NonNull android.net.MacAddress deviceAddress);

public void onDetached(@android.annotation.NonNull android.net.MacAddress deviceAddress, int reason);

public void onConnectionRequested(int requestType, @android.annotation.NonNull android.net.wifi.p2p.WifiP2pConfig config, @android.annotation.NonNull android.net.wifi.p2p.WifiP2pDevice device);

public void onPinGenerated(@android.annotation.NonNull android.net.MacAddress deviceAddress, @android.annotation.NonNull java.lang.String pin);

public static final int APPROVER_DETACH_REASON_CLOSE = 3; // 0x3

public static final int APPROVER_DETACH_REASON_FAILURE = 1; // 0x1

public static final int APPROVER_DETACH_REASON_REMOVE = 0; // 0x0

public static final int APPROVER_DETACH_REASON_REPLACE = 2; // 0x2

public static final int REQUEST_TYPE_INVITATION = 1; // 0x1

public static final int REQUEST_TYPE_JOIN = 2; // 0x2

public static final int REQUEST_TYPE_NEGOTIATION = 0; // 0x0
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface GroupInfoListener {

public void onGroupInfoAvailable(android.net.wifi.p2p.WifiP2pGroup group);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface NetworkInfoListener {

public void onNetworkInfoAvailable(@android.annotation.NonNull android.net.NetworkInfo networkInfo);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface P2pStateListener {

public void onP2pStateAvailable(int state);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface PeerListListener {

public void onPeersAvailable(android.net.wifi.p2p.WifiP2pDeviceList peers);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface PersistentGroupInfoListener {

public void onPersistentGroupInfoAvailable(@android.annotation.NonNull android.net.wifi.p2p.WifiP2pGroupList groups);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface ServiceResponseListener {

public void onServiceAvailable(int protocolType, byte[] responseData, android.net.wifi.p2p.WifiP2pDevice srcDevice);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface UpnpServiceResponseListener {

public void onUpnpServiceAvailable(java.util.List<java.lang.String> uniqueServiceNames, android.net.wifi.p2p.WifiP2pDevice srcDevice);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface WifiP2pListener {

public default void onP2pStateChanged(int state) { throw new RuntimeException("Stub!"); }

public default void onDiscoveryStateChanged(int state) { throw new RuntimeException("Stub!"); }

public default void onListenStateChanged(int state) { throw new RuntimeException("Stub!"); }

public default void onDeviceConfigurationChanged(@android.annotation.Nullable android.net.wifi.p2p.WifiP2pDevice p2pDevice) { throw new RuntimeException("Stub!"); }

public default void onPeerListChanged(@android.annotation.NonNull android.net.wifi.p2p.WifiP2pDeviceList p2pDeviceList) { throw new RuntimeException("Stub!"); }

public default void onPersistentGroupsChanged(@android.annotation.NonNull android.net.wifi.p2p.WifiP2pGroupList p2pGroupList) { throw new RuntimeException("Stub!"); }

public default void onGroupCreating() { throw new RuntimeException("Stub!"); }

public default void onGroupNegotiationRejectedByUser() { throw new RuntimeException("Stub!"); }

public default void onGroupCreationFailed(int reason) { throw new RuntimeException("Stub!"); }

public default void onGroupCreated(@android.annotation.NonNull android.net.wifi.p2p.WifiP2pInfo p2pInfo, @android.annotation.NonNull android.net.wifi.p2p.WifiP2pGroup p2pGroup) { throw new RuntimeException("Stub!"); }

public default void onPeerClientJoined(@android.annotation.NonNull android.net.wifi.p2p.WifiP2pInfo p2pInfo, @android.annotation.NonNull android.net.wifi.p2p.WifiP2pGroup p2pGroup) { throw new RuntimeException("Stub!"); }

public default void onPeerClientDisconnected(@android.annotation.NonNull android.net.wifi.p2p.WifiP2pInfo p2pInfo, @android.annotation.NonNull android.net.wifi.p2p.WifiP2pGroup p2pGroup) { throw new RuntimeException("Stub!"); }

public default void onFrequencyChanged(@android.annotation.NonNull android.net.wifi.p2p.WifiP2pInfo p2pInfo, @android.annotation.NonNull android.net.wifi.p2p.WifiP2pGroup p2pGroup) { throw new RuntimeException("Stub!"); }

public default void onGroupRemoved() { throw new RuntimeException("Stub!"); }
}

}

