/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.net.wifi;


/**
 * Options for blocking a network through
 * {@link android.net.wifi.WifiManager#disallowCurrentSuggestedNetwork(android.net.wifi.BlockingOption) WifiManager.disallowCurrentSuggestedNetwork(BlockingOption)}
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class BlockingOption implements android.os.Parcelable {

BlockingOption() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object obj) { throw new RuntimeException("Stub!"); }

/**
 * Get the blocking time which is set by {@link android.net.wifi.BlockingOption.Builder#Builder(int) Builder.Builder(int)}
 * @return Blocking time in seconds
 */

public int getBlockingTimeSeconds() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * Return whether or not a single BSSID is being blocked, which is set by
 * {@link android.net.wifi.BlockingOption.Builder#setBlockingBssidOnly(boolean) Builder.setBlockingBssidOnly(boolean)}
 * @return True for blocking single BSSID, false otherwise.
 */

public boolean isBlockingBssidOnly() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.net.wifi.BlockingOption> CREATOR;
static { CREATOR = null; }
/**
 * Builder used to create {@link android.net.wifi.BlockingOption BlockingOption} objects.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * Create a {@link android.net.wifi.BlockingOption.Builder Builder} with blocking time for the network
 *
 * @param blockingTimeSec Time period to block the network in seconds
 * Value is between 1 and 86400 inclusive
 * @throws java.lang.IllegalArgumentException if input is invalid.
 */

public Builder(int blockingTimeSec) { throw new RuntimeException("Stub!"); }

/**
 * Create a BlockingOption object for use in
 * {@link android.net.wifi.WifiManager#disallowCurrentSuggestedNetwork(android.net.wifi.BlockingOption) WifiManager.disallowCurrentSuggestedNetwork(BlockingOption)}.
 */

@android.annotation.NonNull
public android.net.wifi.BlockingOption build() { throw new RuntimeException("Stub!"); }

/**
 * Set to configure blocking the whole network or a single BSSID. By default, the whole
 * network will be blocked.
 * @param bssidOnly True for a single BSSID, otherwise the whole network will be blocked
 * @return Instance of {@link android.net.wifi.BlockingOption.Builder Builder} to enable chaining of the builder method.
 */

@android.annotation.NonNull
public android.net.wifi.BlockingOption.Builder setBlockingBssidOnly(boolean bssidOnly) { throw new RuntimeException("Stub!"); }
}

}

